/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.shell;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.arl.fjage.GroovyExtensions;
import org.arl.fjage.Platform;
import org.arl.fjage.shell.GroovyScriptEngine;

public class GroovyBoot {
    private static final String loggingProperties = "logging.properties";

    public static void main(String[] args) {
        Logger log = null;
        ArrayList<Logger> loggers = new ArrayList<Logger>();
        try {
            GroovyExtensions.enable();
            if (System.getProperty("java.util.logging.config.file") == null && System.getProperty("java.util.logging.config.class") == null) {
                InputStream logprop = GroovyBoot.class.getResourceAsStream(loggingProperties);
                if (logprop == null) {
                    throw new FileNotFoundException("res://org/arl/fjage/shell/logging.properties not found");
                }
                LogManager.getLogManager().readConfiguration(logprop);
            }
            log = Logger.getLogger(GroovyBoot.class.getName());
            log.info("fjage Build: " + Platform.getBuildVersion());
            GroovyScriptEngine engine = new GroovyScriptEngine();
            ArrayList<String> arglist = new ArrayList<String>();
            for (String a : args) {
                if (a.equals("-debug")) {
                    log.info("Setting root logger level to ALL");
                    Logger logger = Logger.getLogger("");
                    logger.setLevel(Level.ALL);
                    loggers.add(logger);
                    continue;
                }
                if (a.startsWith("-debug:")) {
                    String lname = a.substring(7);
                    log.info("Setting logger " + lname + " level to ALL");
                    Logger logger = Logger.getLogger(lname);
                    logger.setLevel(Level.ALL);
                    loggers.add(logger);
                    continue;
                }
                if (a.startsWith("-arg:")) {
                    arglist.add(a.substring(5));
                    continue;
                }
                if (!a.endsWith(".groovy") && !a.startsWith("cls://")) {
                    a = a + ".groovy";
                }
                log.info("Running " + a);
                if (a.startsWith("res:/")) {
                    InputStream inp = GroovyBoot.class.getResourceAsStream(a.substring(5));
                    if (inp == null) {
                        throw new FileNotFoundException(a + " not found");
                    }
                    engine.exec(new InputStreamReader(inp), a, arglist);
                    if (arglist.size() <= 0) continue;
                    arglist = new ArrayList();
                    continue;
                }
                if (a.startsWith("cls://")) {
                    Class<?> cls = Class.forName(a.substring(6));
                    engine.exec(cls, arglist);
                    continue;
                }
                engine.exec(new File(a), arglist);
                if (arglist.size() <= 0) continue;
                arglist = new ArrayList();
            }
            engine.shutdown();
        }
        catch (Throwable ex) {
            if (log == null) {
                ex.printStackTrace(System.err);
            }
            log.severe(ex.toString());
        }
    }
}

