/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.shell;

import groovy.lang.Binding;
import groovy.lang.Closure;
import groovy.lang.GroovyClassLoader;
import groovy.lang.GroovyShell;
import groovy.lang.MissingMethodException;
import groovy.lang.Script;
import groovy.transform.ThreadInterrupt;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.arl.fjage.Message;
import org.arl.fjage.Performative;
import org.arl.fjage.shell.BaseGroovyScript;
import org.arl.fjage.shell.ConcurrentBinding;
import org.arl.fjage.shell.Documentation;
import org.arl.fjage.shell.ScriptEngine;
import org.arl.fjage.shell.Shell;
import org.arl.fjage.shell.ShellExtension;
import org.codehaus.groovy.GroovyBugError;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.MultipleCompilationErrorsException;
import org.codehaus.groovy.control.customizers.ASTTransformationCustomizer;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;

public class GroovyScriptEngine
implements ScriptEngine {
    private final int MAX_RESULT_LEN = 8192;
    private final int RESULT_SNIPPET_LEN = 32;
    private GroovyShell groovy;
    private Binding binding;
    private ImportCustomizer imports;
    private Shell out = null;
    private Thread busy = null;
    private Documentation doc = new Documentation();
    private BlockingInput input = new BlockingInput();
    private Logger log = Logger.getLogger(this.getClass().getName());

    public GroovyScriptEngine() {
        this.binding = new ConcurrentBinding();
        GroovyClassLoader gcl = new GroovyClassLoader(this.getClass().getClassLoader());
        this.init(gcl);
    }

    public GroovyScriptEngine(GroovyClassLoader gcl) {
        this.binding = new ConcurrentBinding();
        this.init(gcl);
    }

    public GroovyScriptEngine(ClassLoader cl) {
        this.binding = new ConcurrentBinding();
        GroovyClassLoader gcl = new GroovyClassLoader(cl);
        this.init(gcl);
    }

    private void init(GroovyClassLoader gcl) {
        CompilerConfiguration compiler = new CompilerConfiguration();
        compiler.setScriptBaseClass(BaseGroovyScript.class.getName());
        this.imports = new ImportCustomizer();
        this.binding.setVariable("__input__", (Object)this.input);
        this.binding.setVariable("rsp", null);
        this.binding.setVariable("ntf", null);
        compiler.addCompilationCustomizers(new CompilationCustomizer[]{this.imports});
        compiler.addCompilationCustomizers(new CompilationCustomizer[]{new ASTTransformationCustomizer(ThreadInterrupt.class)});
        this.groovy = new GroovyShell((ClassLoader)gcl, this.binding, compiler);
        this.binding.setVariable("__groovy__", (Object)this.groovy);
        this.binding.setVariable("__doc__", (Object)this.doc);
        this.groovy.evaluate("__init__()");
    }

    @Override
    public void bind(Shell shell) {
        this.out = shell;
        this.binding.setVariable("__out__", (Object)this.out);
    }

    @Override
    public String getPrompt(boolean cont) {
        return cont ? "- " : "> ";
    }

    @Override
    public boolean isComplete(String cmd) {
        if (cmd == null || cmd.trim().length() == 0) {
            return true;
        }
        try {
            this.groovy.parse(cmd);
            return true;
        }
        catch (MultipleCompilationErrorsException ex) {
            String s = ex.getMessage();
            if (s == null) {
                return true;
            }
            if (s.contains("unexpected token")) {
                return false;
            }
            return !s.contains("expecting");
        }
        catch (Throwable ex) {
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(String cmd1) {
        if (this.isBusy()) {
            return false;
        }
        GroovyScriptEngine groovyScriptEngine = this;
        synchronized (groovyScriptEngine) {
            boolean bl;
            try {
                this.busy = Thread.currentThread();
                String cmd = cmd1.trim();
                if (cmd.startsWith("help ")) {
                    cmd = "help '" + cmd.substring(5) + "'";
                } else if (cmd.startsWith("import ")) {
                    cmd = "export '" + cmd.substring(7) + "'";
                }
                this.log.fine("EVAL: " + cmd);
                Object rv = null;
                try {
                    if (this.binding.hasVariable(cmd)) {
                        rv = this.binding.getVariable(cmd);
                        if (rv instanceof Closure) {
                            Closure cl = (Closure)rv;
                            try {
                                this.binding.setVariable("out", (Object)this.out);
                                rv = cl.call();
                            }
                            catch (MissingMethodException missingMethodException) {}
                        }
                    } else {
                        this.binding.setVariable("out", (Object)this.out);
                        this.binding.setVariable("script", null);
                        this.binding.setVariable("args", null);
                        rv = this.groovy.evaluate(cmd);
                    }
                }
                catch (Throwable ex) {
                    this.error(ex);
                }
                finally {
                    this.binding.setVariable("out", null);
                    this.binding.setVariable("ans", rv);
                }
                if (rv != null && !cmd.endsWith(";")) {
                    this.println(rv instanceof Message ? rv : this.groovy.evaluate("ans.toString()"));
                }
                bl = true;
            }
            catch (RejectedExecutionException ex) {
                boolean bl2;
                try {
                    bl2 = false;
                }
                catch (Throwable throwable) {
                    Thread.interrupted();
                    this.busy = null;
                    throw throwable;
                }
                Thread.interrupted();
                this.busy = null;
                return bl2;
            }
            Thread.interrupted();
            this.busy = null;
            return bl;
        }
    }

    @Override
    public boolean exec(File script) {
        return this.exec(script, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(File script, List<String> args) {
        if (this.isBusy()) {
            return false;
        }
        try {
            this.log.fine("RUN: " + script.getAbsolutePath());
            try {
                this.binding.setVariable("out", (Object)this.out);
                this.binding.setVariable("script", (Object)script.getAbsoluteFile());
                this.binding.setVariable("args", null);
                this.groovy.getClassLoader().clearCache();
                this.groovy.run(script, (List)(args != null ? args : new ArrayList()));
            }
            catch (Throwable ex) {
                this.error(ex);
            }
            finally {
                this.binding.setVariable("out", null);
                this.binding.setVariable("script", null);
            }
            return true;
        }
        catch (RejectedExecutionException ex) {
            return false;
        }
    }

    @Override
    public boolean exec(Class<?> script) {
        return this.exec(script, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean exec(Class<?> script, List<String> args) {
        if (ShellExtension.class.isAssignableFrom(script)) {
            this.log.fine("LOAD: " + script.getName());
            this.importClasses("static " + script.getName() + ".*");
            try {
                Method m2 = script.getMethod("__init__", ScriptEngine.class);
                m2.invoke(null, this);
            }
            catch (NoSuchMethodException m2) {
            }
            catch (Throwable ex) {
                this.error(ex);
            }
            try {
                Field m3 = script.getField("__doc__");
                this.doc.add((String)m3.get(null));
                return true;
            }
            catch (NoSuchFieldException m3) {
                return true;
            }
            catch (Throwable ex) {
                this.error(ex);
            }
            return true;
        }
        GroovyScriptEngine groovyScriptEngine = this;
        synchronized (groovyScriptEngine) {
            try {
                if (this.isBusy()) {
                    boolean bl = false;
                    return bl;
                }
                this.busy = Thread.currentThread();
                this.log.fine("RUN: " + script.getName());
                try {
                    this.binding.setVariable("out", (Object)this.out);
                    this.binding.setVariable("script", (Object)script.getName());
                    this.binding.setVariable("args", args);
                    Script gs = (Script)script.newInstance();
                    gs.setBinding(this.binding);
                    gs.run();
                }
                catch (Throwable ex) {
                    this.error(ex);
                }
                finally {
                    this.binding.setVariable("out", null);
                    this.binding.setVariable("script", null);
                }
                boolean ex = true;
                return ex;
            }
            catch (RejectedExecutionException ex2) {
                boolean bl = false;
                return bl;
            }
            finally {
                Thread.interrupted();
                this.busy = null;
            }
        }
    }

    @Override
    public boolean exec(Reader reader, String name) {
        return this.exec(reader, name, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exec(Reader reader, String name, List<String> args) {
        if (this.isBusy()) {
            return false;
        }
        GroovyScriptEngine groovyScriptEngine = this;
        synchronized (groovyScriptEngine) {
            try {
                this.busy = Thread.currentThread();
                this.log.fine("RUN: " + name);
                try {
                    this.binding.setVariable("out", (Object)this.out);
                    this.binding.setVariable("script", (Object)name);
                    this.binding.setVariable("args", null);
                    this.groovy.getClassLoader().clearCache();
                    this.groovy.run(reader, name, (List)(args != null ? args : new ArrayList()));
                }
                catch (Throwable ex) {
                    this.error(ex);
                }
                finally {
                    this.binding.setVariable("out", null);
                    this.binding.setVariable("script", null);
                }
                boolean ex = true;
            }
            catch (RejectedExecutionException ex) {
                boolean bl;
                try {
                    bl = false;
                }
                catch (Throwable throwable) {
                    Thread.interrupted();
                    this.busy = null;
                    throw throwable;
                }
                Thread.interrupted();
                this.busy = null;
                return bl;
            }
            Thread.interrupted();
            this.busy = null;
            return ex;
        }
    }

    @Override
    public boolean isBusy() {
        return this.busy != null;
    }

    @Override
    public void abort() {
        try {
            this.busy.interrupt();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public void setVariable(String name, Object value) {
        this.binding.setVariable(name, value);
    }

    @Override
    public Object getVariable(String name) {
        try {
            return this.binding.getVariable(name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void importClasses(String clazz) {
        if (clazz.startsWith("static ")) {
            if ((clazz = clazz.substring(7).trim()).endsWith(".*")) {
                this.imports.addStaticStars(new String[]{clazz.substring(0, clazz.length() - 2)});
            } else {
                int n = clazz.lastIndexOf(46);
                if (n < 0) {
                    return;
                }
                this.imports.addStaticImport(clazz.substring(0, n), clazz.substring(n + 1));
            }
        } else if (clazz.endsWith(".*")) {
            this.imports.addStarImports(new String[]{clazz.substring(0, clazz.length() - 2)});
        } else {
            this.imports.addImports(new String[]{clazz});
        }
    }

    @Override
    public void shutdown() {
        this.abort();
    }

    @Override
    public void deliver(Message msg) {
        if (msg.getPerformative() == Performative.INFORM || msg.getInReplyTo() == null) {
            this.binding.setVariable("ntf", (Object)msg);
        } else {
            this.binding.setVariable("rsp", (Object)msg);
        }
        if (this.out != null) {
            this.out.notify(msg.getSender().getName() + " >> " + msg.toString());
        }
    }

    @Override
    public boolean offer(String s) {
        return this.input.put(s);
    }

    @Override
    public String input() throws InterruptedException {
        return this.input.get();
    }

    private void println(Object s) {
        String str = s.toString();
        int n = str.length();
        if (n > 8192) {
            str = str.substring(0, 32) + " <<snip>> " + str.substring(n - 32);
        }
        this.log.fine("RESULT: " + str);
        if (this.out != null) {
            this.out.println(s instanceof Message ? s : str);
        }
    }

    private void error(Throwable ex) {
        if (ex instanceof GroovyBugError) {
            ex = this.resolveGroovyBug(ex);
        }
        if (this.out != null) {
            this.out.error(ex);
        } else {
            this.log.log(Level.WARNING, "Groovy execution failed", ex);
        }
    }

    private Throwable resolveGroovyBug(Throwable ex) {
        String s = ex.toString();
        if (s.contains("BUG! exception in phase 'semantic analysis'")) {
            int ndx1 = s.indexOf("The lookup for ");
            int ndx2 = s.indexOf(" caused a failed compilaton");
            if (ndx1 >= 0 && ndx2 >= ndx1) {
                String offendingClass = s.substring(ndx1 + 15, ndx2);
                String offendingGroovyScript = offendingClass.replace(".", "/") + ".groovy";
                try {
                    InputStream in = this.groovy.getClassLoader().getResourceAsStream(offendingGroovyScript);
                    if (in != null) {
                        this.groovy.parse((Reader)new InputStreamReader(in), offendingGroovyScript);
                    }
                }
                catch (Throwable ex1) {
                    ex = ex1;
                }
            }
        }
        return ex;
    }

    class BlockingInput {
        private int waiting = 0;
        private String input = null;

        BlockingInput() {
        }

        synchronized String get() throws InterruptedException {
            try {
                ++this.waiting;
                while (this.input == null) {
                    this.wait();
                }
            }
            finally {
                --this.waiting;
            }
            String s = this.input;
            this.input = null;
            return s;
        }

        synchronized boolean put(String s) {
            if (this.waiting == 0) {
                return false;
            }
            this.input = s;
            this.notify();
            return true;
        }

        synchronized boolean isWaiting() {
            return this.waiting > 0;
        }
    }
}

