/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.shell;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.arl.fjage.Agent;
import org.arl.fjage.CyclicBehavior;
import org.arl.fjage.GenericMessage;
import org.arl.fjage.Message;
import org.arl.fjage.MessageBehavior;
import org.arl.fjage.MessageListener;
import org.arl.fjage.OneShotBehavior;
import org.arl.fjage.Performative;
import org.arl.fjage.Platform;
import org.arl.fjage.TickerBehavior;
import org.arl.fjage.param.ParameterMessageBehavior;
import org.arl.fjage.shell.GetFileReq;
import org.arl.fjage.shell.GetFileRsp;
import org.arl.fjage.shell.PutFileReq;
import org.arl.fjage.shell.ScriptEngine;
import org.arl.fjage.shell.Services;
import org.arl.fjage.shell.Shell;
import org.arl.fjage.shell.ShellExecReq;
import org.arl.fjage.shell.ShellParam;

public class ShellAgent
extends Agent {
    public static final String ABORT = ".abort";
    protected Shell shell;
    protected Thread consoleThread = null;
    protected ScriptEngine engine;
    protected Callable<Void> exec = null;
    protected CyclicBehavior executor = null;
    protected List<MessageListener> listeners = new ArrayList<MessageListener>();
    protected List<InitScript> initScripts = new ArrayList<InitScript>();
    protected Map<String, InputStreamCacheEntry> isCache = new HashMap<String, InputStreamCacheEntry>();
    protected boolean quit = false;
    protected boolean ephemeral = false;
    protected boolean enabled = true;

    public ShellAgent(ScriptEngine engine) {
        this.shell = null;
        this.engine = engine;
        if (engine != null) {
            engine.setVariable("__agent__", this);
            engine.setVariable("__script_engine__", engine);
        }
    }

    public ShellAgent(ScriptEngine engine, boolean ephemeral) {
        this.shell = null;
        this.ephemeral = ephemeral;
        this.engine = engine;
        if (engine != null) {
            engine.setVariable("__agent__", this);
            engine.setVariable("__script_engine__", engine);
        }
    }

    public ShellAgent(Shell shell, ScriptEngine engine) {
        this.shell = shell;
        this.engine = engine;
        this.ignoreExceptions = true;
        if (shell != null) {
            shell.init(engine);
        }
        if (engine != null) {
            engine.bind(shell);
            engine.setVariable("__agent__", this);
            engine.setVariable("__shell__", shell);
            engine.setVariable("__script_engine__", engine);
        }
        this.addInitrc("cls://org.arl.fjage.shell.ShellDoc");
    }

    @Override
    public void init() {
        this.log.info("Agent " + this.getName() + " init");
        if (!this.ephemeral) {
            this.register(Services.SHELL);
            this.setYieldDuringReceive(true);
        }
        this.add(new ParameterMessageBehavior(new Class[]{ShellParam.class}));
        this.executor = new CyclicBehavior(){

            @Override
            public synchronized void action() {
                if (ShellAgent.this.exec != null) {
                    try {
                        ShellAgent.this.exec.call();
                    }
                    catch (Throwable ex) {
                        this.log.warning("Exec failure: " + ex.toString());
                    }
                    ShellAgent.this.exec = null;
                }
                this.block();
            }
        };
        this.add(this.executor);
        if (this.shell != null) {
            this.consoleThread = new Thread(this.getName() + ":console"){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    String s = null;
                    long backoff = 0L;
                    while (!ShellAgent.this.quit) {
                        if (!ShellAgent.this.enabled) {
                            try {
                                Thread.sleep(100L);
                            }
                            catch (InterruptedException ex) {
                                this.interrupt();
                            }
                            continue;
                        }
                        String prompt1 = null;
                        String prompt2 = null;
                        if (ShellAgent.this.engine != null) {
                            prompt1 = ShellAgent.this.engine.getPrompt(false);
                            prompt2 = ShellAgent.this.engine.getPrompt(true);
                        }
                        if (s != null) {
                            try {
                                if (backoff > 0L) {
                                    Thread.sleep(backoff);
                                }
                            }
                            catch (InterruptedException ex) {
                                this.interrupt();
                            }
                            if (backoff == 0L) {
                                backoff = 1L;
                            } else if (backoff < 256L) {
                                backoff *= 2L;
                            }
                        }
                        if ((s = ShellAgent.this.shell.readLine(prompt1, prompt2, s)) == null) {
                            ShellAgent.this.shutdownPlatform();
                            break;
                        }
                        if (s.equals("\u0003")) {
                            boolean aborted = true;
                            if (ShellAgent.this.engine != null && ShellAgent.this.engine.isBusy()) {
                                ShellAgent.this.engine.abort();
                                aborted = true;
                            }
                            CyclicBehavior cyclicBehavior = ShellAgent.this.executor;
                            synchronized (cyclicBehavior) {
                                if (ShellAgent.this.exec != null) {
                                    ShellAgent.this.exec = null;
                                    aborted = true;
                                }
                            }
                            if (aborted) {
                                ShellAgent.this.log.fine("ABORT");
                            }
                            s = null;
                            continue;
                        }
                        if (ShellAgent.this.engine == null) {
                            s = null;
                            continue;
                        }
                        if (ShellAgent.this.exec == null && !ShellAgent.this.engine.isBusy() && ShellAgent.this.enabled) {
                            backoff = 0L;
                            String cmd = s.trim();
                            String p1 = prompt1 == null ? "" : prompt1;
                            String p2 = prompt2 == null ? "\n" : "\n" + prompt2;
                            s = null;
                            if (cmd.length() <= 0) continue;
                            CyclicBehavior cyclicBehavior = ShellAgent.this.executor;
                            synchronized (cyclicBehavior) {
                                ShellAgent.this.exec = () -> {
                                    ShellAgent.this.log.fine("> " + cmd);
                                    ShellAgent.this.shell.input(p1 + cmd.replaceAll("\n", p2));
                                    try {
                                        ShellAgent.this.engine.exec(cmd);
                                    }
                                    catch (Throwable ex) {
                                        ShellAgent.this.log.warning("Exec failure: " + ex.toString());
                                    }
                                    return null;
                                };
                                ShellAgent.this.executor.restart();
                                continue;
                            }
                        }
                        if (!ShellAgent.this.engine.offer(s)) continue;
                        s = null;
                    }
                }
            };
            this.consoleThread.setDaemon(true);
        }
        if (!this.ephemeral) {
            this.add(new MessageBehavior(){

                @Override
                public void onReceive(Message msg) {
                    if (msg instanceof ShellExecReq) {
                        ShellAgent.this.handleExecReq((ShellExecReq)msg);
                    } else if (msg instanceof GetFileReq) {
                        ShellAgent.this.handleGetFileReq((GetFileReq)msg);
                    } else if (msg instanceof PutFileReq) {
                        ShellAgent.this.handlePutFileReq((PutFileReq)msg);
                    } else if (msg.getPerformative() == Performative.REQUEST) {
                        ShellAgent.this.send(new Message(msg, Performative.NOT_UNDERSTOOD));
                    } else {
                        this.log.fine(msg.getSender() + " > " + msg.toString());
                        for (MessageListener ml : ShellAgent.this.listeners) {
                            try {
                                if (!ml.onReceive(msg)) continue;
                                return;
                            }
                            catch (Throwable ex) {
                                this.log.warning("MessageListener: " + ex.toString());
                            }
                        }
                        if (ShellAgent.this.engine != null) {
                            ShellAgent.this.engine.deliver(msg);
                        }
                    }
                }
            });
        }
        this.add(new OneShotBehavior(){

            @Override
            public void action() {
                try {
                    for (InitScript script : ShellAgent.this.initScripts) {
                        if (script.file != null) {
                            ShellAgent.this.engine.exec(script.file);
                            continue;
                        }
                        if (script.reader != null) {
                            ShellAgent.this.engine.exec(script.reader, script.name);
                            continue;
                        }
                        if (script.cls == null) continue;
                        ShellAgent.this.engine.exec(script.cls);
                    }
                }
                catch (Throwable ex) {
                    this.log.warning("Init script failure: " + ex.toString());
                }
                if (ShellAgent.this.ephemeral) {
                    ShellAgent.this.stop();
                } else if (ShellAgent.this.consoleThread != null) {
                    ShellAgent.this.consoleThread.start();
                }
            }
        });
        this.add(new TickerBehavior(60000L){

            @Override
            public void onTick() {
                long t = ShellAgent.this.currentTimeMillis() - 60000L;
                Iterator<Map.Entry<String, InputStreamCacheEntry>> it = ShellAgent.this.isCache.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, InputStreamCacheEntry> pair = it.next();
                    if (pair.getValue().lastUsed >= t) continue;
                    try {
                        pair.getValue().is.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    it.remove();
                }
            }
        });
    }

    @Override
    public void shutdown() {
        this.log.info("Agent " + this.getName() + " shutdown");
        this.quit = true;
        if (this.consoleThread != null) {
            this.consoleThread.interrupt();
        }
        if (this.engine != null) {
            this.engine.shutdown();
        }
        if (this.shell != null) {
            this.shell.shutdown();
        }
    }

    public void setInitrc(String script) {
        this.initScripts.clear();
        this.addInitrc(script);
    }

    public void setInitrc(File script) {
        this.initScripts.clear();
        this.addInitrc(script);
    }

    public void setInitrc(String name, Reader reader) {
        this.initScripts.clear();
        this.addInitrc(name, reader);
    }

    public void addInitrc(String script) {
        if (script.startsWith("res:/")) {
            InputStream inp = this.getClass().getResourceAsStream(script.substring(5));
            if (inp == null) {
                this.log.warning(script + " not found");
                return;
            }
            this.addInitrc(script, new InputStreamReader(inp));
        } else if (script.startsWith("cls://")) {
            try {
                this.initScripts.add(new InitScript(Class.forName(script.substring(6))));
            }
            catch (ClassNotFoundException ex) {
                this.log.warning(script + " not found");
            }
        } else {
            this.initScripts.add(new InitScript(new File(script)));
        }
    }

    public void addInitrc(File script) {
        this.initScripts.add(new InitScript(script));
    }

    public void addInitrc(String name, Reader reader) {
        this.initScripts.add(new InitScript(name, reader));
    }

    public void addMessageListener(MessageListener ml) {
        this.listeners.add(ml);
    }

    public void removeMessageListener(MessageListener ml) {
        this.listeners.remove(ml);
    }

    public void clearMessageListeners() {
        this.listeners.clear();
    }

    public void enable(boolean b) {
        this.enabled = b;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getLanguage() {
        if (this.engine == null) {
            return null;
        }
        String lang = this.engine.getClass().getSimpleName();
        if (lang.endsWith("ScriptEngine")) {
            lang = lang.substring(0, lang.length() - "ScriptEngine".length());
        }
        return lang;
    }

    public String getTitle() {
        return this.getName();
    }

    public String getDescription() {
        StringBuffer sb = new StringBuffer();
        if (this.shell != null) {
            sb.append("Interactive ");
        } else if (this.ephemeral) {
            sb.append("Ephemeral ");
        } else {
            sb.append("Non-interactive ");
        }
        String lang = this.getLanguage();
        if (lang != null) {
            sb.append(lang + " ");
        }
        sb.append("shell");
        if (!this.enabled) {
            sb.append(" (disabled)");
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        if (this.shell == null || this.engine == null) {
            return super.toString();
        }
        return super.toString() + ": " + this.shell.toString() + " [" + this.engine.getClass().getSimpleName() + "]";
    }

    private void shutdownPlatform() {
        Platform platform = this.getPlatform();
        if (platform != null) {
            platform.shutdown();
        }
        this.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleExecReq(final ShellExecReq req) {
        Message rsp;
        if (this.engine == null || this.engine.isBusy()) {
            rsp = new Message(req, Performative.REFUSE);
        } else if (req.isScript()) {
            boolean ok = false;
            final File file = req.getScriptFile();
            CyclicBehavior cyclicBehavior = this.executor;
            synchronized (cyclicBehavior) {
                if (this.exec == null && file != null && file.exists()) {
                    ok = true;
                    this.exec = new Callable<Void>(){

                        @Override
                        public Void call() {
                            ShellAgent.this.log.fine("run " + file.getName());
                            ShellAgent.this.engine.exec(file, req.getScriptArgs());
                            return null;
                        }
                    };
                    this.executor.restart();
                }
            }
            rsp = ok ? new Message(req, Performative.AGREE) : new Message(req, Performative.REFUSE);
        } else {
            String cmd = req.getCommand();
            if (cmd != null && cmd.equals(ABORT)) {
                this.engine.abort();
                rsp = new Message(req, Performative.AGREE);
            } else {
                boolean ok = false;
                if (cmd != null) {
                    ok = this.engine.exec(cmd);
                }
                if (ok) {
                    Object ans;
                    Object object = ans = req.getAns() ? this.engine.getVariable("ans") : null;
                    if (ans == null) {
                        rsp = new Message(req, Performative.AGREE);
                    } else {
                        rsp = new GenericMessage(req, Performative.AGREE);
                        ((GenericMessage)rsp).put("ans", ans);
                    }
                } else {
                    rsp = new Message(req, Performative.REFUSE);
                }
            }
        }
        this.send(rsp);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleGetFileReq(GetFileReq req) {
        String filename = req.getFilename();
        if (filename == null) {
            this.send(new Message(req, Performative.REFUSE));
            return;
        }
        if (filename.endsWith("/") || filename.endsWith(File.separator)) {
            filename = filename.substring(0, filename.length() - 1);
        }
        File f = new File(filename);
        GetFileRsp rsp = null;
        InputStream is = null;
        try {
            if (f.isDirectory()) {
                File[] files = f.listFiles();
                StringBuilder sb = new StringBuilder();
                if (files != null) {
                    for (File file : files) {
                        sb.append(file.getName());
                        if (file.isDirectory()) {
                            sb.append('/');
                        }
                        sb.append('\t');
                        sb.append(file.length());
                        sb.append('\t');
                        sb.append(file.lastModified());
                        sb.append('\n');
                    }
                }
                rsp = new GetFileRsp(req);
                rsp.setDirectory(true);
                rsp.setContents(sb.toString().getBytes());
            } else if (f.canRead()) {
                int numRead;
                long ofs = req.getOffset();
                long len = req.getLength();
                long length = f.length();
                if (ofs > length) {
                    this.send(new Message(req, Performative.REFUSE));
                    return;
                }
                if (len <= 0L) {
                    len = length - ofs;
                } else if (ofs + len > length) {
                    len = length - ofs;
                }
                if (len > Integer.MAX_VALUE) {
                    throw new IOException("File is too large!");
                }
                byte[] bytes = new byte[(int)len];
                InputStreamCacheEntry isce = this.isCache.get(filename);
                if (isce != null) {
                    if (isce.pos == ofs) {
                        isce.lastUsed = this.currentTimeMillis();
                        isce.pos += len;
                        is = isce.is;
                    } else {
                        isce.is.close();
                        this.isCache.remove(filename);
                    }
                }
                int offset = 0;
                if (is == null) {
                    is = new FileInputStream(f);
                    if (ofs > 0L) {
                        is.skip(ofs);
                    } else if (ofs < 0L) {
                        is.skip(length - ofs);
                    }
                }
                while (offset < bytes.length && (numRead = is.read(bytes, offset, bytes.length - offset)) >= 0) {
                    offset += numRead;
                }
                if (offset < bytes.length) {
                    throw new IOException("File read incomplete!");
                }
                rsp = new GetFileRsp(req);
                rsp.setOffset(ofs);
                rsp.setContents(bytes);
                if (ofs != 0L) {
                    if (!this.isCache.containsKey(filename)) {
                        this.isCache.put(filename, new InputStreamCacheEntry(is, ofs + (long)bytes.length));
                    }
                    is = null;
                }
            }
        }
        catch (IOException ex) {
            this.log.warning(ex.toString());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
                this.isCache.remove(filename);
            }
        }
        if (rsp != null) {
            this.send(rsp);
        } else {
            this.send(new Message(req, Performative.FAILURE));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handlePutFileReq(PutFileReq req) {
        String filename = req.getFilename();
        if (filename == null) {
            this.send(new Message(req, Performative.REFUSE));
            return;
        }
        byte[] contents = req.getContents();
        File f = new File(filename);
        Message rsp = null;
        Closeable os = null;
        long ofs = req.getOffset();
        try {
            boolean fileIsDir;
            boolean bl = fileIsDir = filename.endsWith("/") || filename.endsWith(File.separator);
            if (fileIsDir) {
                if (ofs == 0L) {
                    if (contents == null) {
                        Path pathToBeDeleted = Paths.get(filename, new String[0]);
                        Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
                        rsp = new Message(req, Performative.AGREE);
                    } else if (!f.exists()) {
                        rsp = new Message(req, f.mkdir() ? Performative.AGREE : Performative.FAILURE);
                    }
                }
            } else if (contents == null && ofs == 0L) {
                if (f.delete()) {
                    rsp = new Message(req, Performative.AGREE);
                }
            } else if (contents == null) {
                os = new RandomAccessFile(f, "rw");
                ((RandomAccessFile)os).setLength(ofs);
                rsp = new Message(req, Performative.AGREE);
            } else {
                if (ofs == f.length()) {
                    os = new FileOutputStream(f, ofs != 0L);
                    ((FileOutputStream)os).write(contents);
                    ((FileOutputStream)os).flush();
                    ((FileOutputStream)os).getFD().sync();
                } else {
                    os = new RandomAccessFile(f, "rw");
                    if (ofs >= 0L) {
                        ((RandomAccessFile)os).setLength(ofs + (long)contents.length);
                    }
                    if (ofs > 0L) {
                        ((RandomAccessFile)os).skipBytes((int)ofs);
                    } else if (ofs < 0L) {
                        ((RandomAccessFile)os).skipBytes((int)(f.length() + ofs));
                    }
                    ((RandomAccessFile)os).write(contents);
                    ((RandomAccessFile)os).getFD().sync();
                }
                rsp = new Message(req, Performative.AGREE);
            }
        }
        catch (IOException ex) {
            this.log.warning(ex.toString());
        }
        finally {
            if (os != null) {
                try {
                    os.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (rsp == null) {
            rsp = new Message(req, Performative.FAILURE);
        }
        this.send(rsp);
    }

    protected class InputStreamCacheEntry {
        InputStream is;
        long lastUsed;
        long pos;

        InputStreamCacheEntry(InputStream is, long pos) {
            this.is = is;
            this.pos = pos;
            this.lastUsed = ShellAgent.this.currentTimeMillis();
        }
    }

    protected class InitScript {
        String name;
        File file;
        Reader reader;
        Class<?> cls;

        InitScript(File file) {
            this.name = null;
            this.file = file;
            this.reader = null;
        }

        InitScript(String name, Reader reader) {
            this.name = name;
            this.file = null;
            this.reader = reader;
        }

        InitScript(Class<?> cls) {
            this.cls = cls;
        }
    }
}

