/*
 * Decompiled with CFR 0.152.
 */
package org.arl.fjage.shell;

import groovy.lang.GroovyObject;
import groovy.lang.MetaClass;
import groovy.transform.Generated;
import groovy.transform.Internal;
import org.arl.fjage.shell.ScriptEngine;
import org.arl.fjage.shell.ShellExtension;
import org.codehaus.groovy.reflection.ClassInfo;
import org.codehaus.groovy.runtime.ScriptBytecodeAdapter;

public class ShellDoc
implements ShellExtension,
GroovyObject {
    public static final String __doc__ = "\n# shell - basic shell commands\n\n## help - provide help on a specified topic\n\nUsage:\n  help [topic]\n\nExamples:\n  help                            // get help index\n  help shell                      // get help on 'shell'\n  help('shell')                   // alternative syntax\n\n## ps - list all the agents\n## services - list all services provided by agents\n## who - display list of variables in workspace\n## shutdown - shutdown the local platform\n\n## run - run a Groovy script\n\nScripts are stored in a folder defined by the 'scripts' variable in the\nworkspace. If no such variable is defined, they are in the current folder.\n\nExamples:\n  run 'myscript'                   // run a script called myscript.groovy\n  myscript                         // alternative syntax for running myscript\n  run 'res://myscript.groovy'      // run a script from resources (in jar)\n  run 'cls://myscript'             // run a precompiled script from class\n\n## println - display message on console\n\nUsage:\n  println output, [type]\n\nExamples:\n  println 'hello there!'\n  println 'that failed!', org.arl.fjage.shell.OutputType.ERROR\n\n## href - make a clickable URL (on terminals that support URLs)\n\nUsage:\n  href(url)\n  href(url, text)\n\nExamples:\n  println href('http://www.google.com')\n  println href('http://www.google.com', 'Search...')\n\n## delay - delay execution by the specified number of milliseconds\n\nExample:\n  delay 1000                      // delay for 1000 ms\n\n## logLevel - set loglevel (optionally for a named logger)\n\nUsage:\n  logLevel [name],level\n\nExamples:\n  logLevel INFO                  // set loglevel to INFO\n  logLevel 'org.arl', ALL        // set loglevel for logger org.arl to ALL\n\n## subscribe - subscribe to notifications from a named topic\n\nExamples:\n  subscribe topic('MyTopic')     // subscribe to notifications from MyTopic\n  subscribe agent('abc')         // subscribe to notifications from agent abc\n\n## unsubscribe - unsubscribe from notifications for a named topic\n\nExamples:\n  unsubscribe topic('MyTopic')   // unsubscribe notifications from MyTopic\n  unsubscribe agent('abc')       // unsubscribe notifications from agent abc\n\n## export - add specified package/classes to list of default imports\n\nExamples:\n  export 'org.arl.fjage.*'            // import package org.arl.fjage\n  export 'mypackage.MyClass'          // import class mypackage.MyClass\n\nAt the shell prompt (but not in a script), export can be abbreviated\nto import. For example:\n  import org.arl.fjage.*             // import package org.arl.fjage\n\n## agent - return an agent id for the named agent\n\nUsage:\n  agent(name)\n\nExample:\n  a = agent('shell')\n\n## agentForService - find an agent id providing the specified service\n\nExamples:\n  a = agentForService Services.SHELL  // find agents providing shell service\n\n## agentsForService - get a list of all agent ids providing a service\n\nExamples:\n  a = agentsForService Services.SHELL // list all agents providing a service\n\n## send - send the given message\n\nExamples:\n  send new Message(agent('shell'))    // send a message to agent shell\n\n## request - send the given request and wait for a response\n\nUsage:\n  request req,[timeout]\n\nExamples:\n  rsp = request req     // send req and wait for response for default timeout\n  rsp = request req,100 // send req and wait for response for 100 ms\n\n## receive - wait for a message\n\nUsage:\n  receive [filter], [timeout]\n  receive [msg], [timeout]\n\nExamples:\n  msg = receive                     // get any message with default timeout\n  msg = receive 100                 // get any message within 100 ms\n  msg = receive req                 // get a response message for request req\n  msg = receive A                   // get message that of class A\n  msg = receive { it instanceof A } // get message that of class A\n  msg = receive req                 // get message response to req\n\n## input - get user input\n\nUsage:\n  input [prompt], [hide]\n\nExamples:\n  name = input('What is your name?')  // prompt user and get input\n  secret = input('Secret?', true)     // hide input after entering\n";
    private static /* synthetic */ ClassInfo $staticClassInfo;
    public static transient /* synthetic */ boolean __$stMC;
    private transient /* synthetic */ MetaClass metaClass;
    private static /* synthetic */ ClassInfo $staticClassInfo$;

    @Generated
    public ShellDoc() {
        MetaClass metaClass;
        this.metaClass = metaClass = this.$getStaticMetaClass();
    }

    public static void __init__(ScriptEngine engine) {
        engine.importClasses("org.arl.fjage.*");
        engine.importClasses("org.arl.fjage.shell.*");
    }

    protected /* synthetic */ MetaClass $getStaticMetaClass() {
        if (this.getClass() != ShellDoc.class) {
            return ScriptBytecodeAdapter.initMetaClass((Object)this);
        }
        ClassInfo classInfo = $staticClassInfo;
        if (classInfo == null) {
            $staticClassInfo = classInfo = ClassInfo.getClassInfo(this.getClass());
        }
        return classInfo.getMetaClass();
    }

    @Generated
    @Internal
    public /* synthetic */ MetaClass getMetaClass() {
        MetaClass metaClass = this.metaClass;
        if (metaClass != null) {
            return metaClass;
        }
        this.metaClass = this.$getStaticMetaClass();
        return this.metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ void setMetaClass(MetaClass metaClass) {
        this.metaClass = metaClass;
    }

    @Generated
    @Internal
    public /* synthetic */ Object invokeMethod(String string, Object object) {
        return this.getMetaClass().invokeMethod((Object)this, string, object);
    }

    @Generated
    @Internal
    public /* synthetic */ Object getProperty(String string) {
        return this.getMetaClass().getProperty((Object)this, string);
    }

    @Generated
    @Internal
    public /* synthetic */ void setProperty(String string, Object object) {
        this.getMetaClass().setProperty((Object)this, string, object);
    }
}

