/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protobuf.dynamic;

import com.github.os72.protobuf.dynamic.EnumDefinition;
import com.github.os72.protobuf.dynamic.MessageDefinition;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.DynamicMessage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;

public class DynamicSchema {
    private DescriptorProtos.FileDescriptorSet mFileDescSet;
    private Map<String, Descriptors.Descriptor> mMsgDescriptorMap = new HashMap<String, Descriptors.Descriptor>();
    private Map<String, Descriptors.EnumDescriptor> mEnumDescriptorMap = new HashMap<String, Descriptors.EnumDescriptor>();
    private Map<String, String> mFullNameMap = new TreeMap<String, String>();

    public static Builder newBuilder() {
        return new Builder();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DynamicSchema parseFrom(InputStream schemaDescIn) throws Descriptors.DescriptorValidationException, IOException {
        try {
            int len;
            byte[] buf = new byte[4096];
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            while ((len = schemaDescIn.read(buf)) > 0) {
                baos.write(buf, 0, len);
            }
            DynamicSchema dynamicSchema = DynamicSchema.parseFrom(baos.toByteArray());
            return dynamicSchema;
        }
        finally {
            schemaDescIn.close();
        }
    }

    public static DynamicSchema parseFrom(byte[] schemaDescBuf) throws Descriptors.DescriptorValidationException, IOException {
        return new DynamicSchema(DescriptorProtos.FileDescriptorSet.parseFrom((byte[])schemaDescBuf));
    }

    public DynamicMessage.Builder newMessageBuilder(String msgTypeName) {
        Descriptors.Descriptor msgType = this.mMsgDescriptorMap.get(msgTypeName);
        if (msgType == null) {
            return null;
        }
        return DynamicMessage.newBuilder((Descriptors.Descriptor)msgType);
    }

    public Descriptors.Descriptor getMessageDescriptor(String msgTypeName) {
        return this.mMsgDescriptorMap.get(msgTypeName);
    }

    public Descriptors.EnumValueDescriptor getEnumValue(String enumTypeName, String enumName) {
        Descriptors.EnumDescriptor enumType = this.mEnumDescriptorMap.get(enumTypeName);
        if (enumType == null) {
            return null;
        }
        return enumType.findValueByName(enumName);
    }

    public Descriptors.EnumValueDescriptor getEnumValue(String enumTypeName, int enumNumber) {
        Descriptors.EnumDescriptor enumType = this.mEnumDescriptorMap.get(enumTypeName);
        if (enumType == null) {
            return null;
        }
        return enumType.findValueByNumber(enumNumber);
    }

    public byte[] toByteArray() {
        return this.mFileDescSet.toByteArray();
    }

    public String toString() {
        TreeSet<String> msgTypes = new TreeSet<String>(this.mMsgDescriptorMap.keySet());
        TreeSet<String> enumTypes = new TreeSet<String>(this.mEnumDescriptorMap.keySet());
        return "types: " + msgTypes + " enums: " + enumTypes + "\n" + this.mFullNameMap + "\n" + this.mFileDescSet;
    }

    private DynamicSchema(DescriptorProtos.FileDescriptorSet fileDescSet) throws Descriptors.DescriptorValidationException {
        this.mFileDescSet = fileDescSet;
        for (DescriptorProtos.FileDescriptorProto fileDescProto : fileDescSet.getFileList()) {
            Descriptors.FileDescriptor fileDesc = Descriptors.FileDescriptor.buildFrom((DescriptorProtos.FileDescriptorProto)fileDescProto, (Descriptors.FileDescriptor[])new Descriptors.FileDescriptor[0]);
            for (Descriptors.Descriptor msgType : fileDesc.getMessageTypes()) {
                this.addMessageType(msgType, null);
            }
        }
    }

    private void addMessageType(Descriptors.Descriptor msgType, String scope) {
        this.mFullNameMap.put(msgType.getName(), msgType.getFullName());
        String msgTypeName = scope == null ? msgType.getName() : scope + "." + msgType.getName();
        this.mMsgDescriptorMap.put(msgTypeName, msgType);
        for (Descriptors.Descriptor nestedType : msgType.getNestedTypes()) {
            this.addMessageType(nestedType, msgTypeName);
        }
        for (Descriptors.EnumDescriptor enumType : msgType.getEnumTypes()) {
            this.addEnumType(enumType, msgTypeName);
        }
    }

    private void addEnumType(Descriptors.EnumDescriptor enumType, String scope) {
        String enumTypeName = scope == null ? enumType.getName() : scope + "." + enumType.getName();
        this.mEnumDescriptorMap.put(enumTypeName, enumType);
    }

    public static class Builder {
        private DescriptorProtos.FileDescriptorProto.Builder mFileDescProtoBuilder = DescriptorProtos.FileDescriptorProto.newBuilder();
        private DescriptorProtos.FileDescriptorSet.Builder mFileDescSetBuilder = DescriptorProtos.FileDescriptorSet.newBuilder();

        public DynamicSchema build() throws Descriptors.DescriptorValidationException {
            DescriptorProtos.FileDescriptorSet.Builder fileDescSetBuilder = DescriptorProtos.FileDescriptorSet.newBuilder();
            fileDescSetBuilder.addFile(this.mFileDescProtoBuilder.build());
            fileDescSetBuilder.mergeFrom(this.mFileDescSetBuilder.build());
            return new DynamicSchema(fileDescSetBuilder.build());
        }

        public Builder setName(String name) {
            this.mFileDescProtoBuilder.setName(name);
            return this;
        }

        public Builder setPackage(String name) {
            this.mFileDescProtoBuilder.setPackage(name);
            return this;
        }

        public Builder addMessageDefinition(MessageDefinition msgDef) {
            this.mFileDescProtoBuilder.addMessageType(msgDef.getMessageType());
            return this;
        }

        public Builder addEnumDefinition(EnumDefinition enumDef) {
            this.mFileDescProtoBuilder.addEnumType(enumDef.getEnumType());
            return this;
        }

        public Builder addSchema(DynamicSchema schema) {
            this.mFileDescSetBuilder.mergeFrom(schema.mFileDescSet);
            return this;
        }

        private Builder() {
        }
    }
}

