/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar.maven;

import com.github.os72.protocjar.Protoc;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.util.FileUtils;
import org.sonatype.plexus.build.incremental.BuildContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProtocJarMojo
extends AbstractMojo {
    private static final String DEFAULT_INPUT_DIR = "/src/main/protobuf/".replace('/', File.separatorChar);
    private MavenProject project;
    private BuildContext buildContext;
    private File[] inputDirectories;
    private File[] includeDirectories;
    private boolean cleanOutputFolder;
    private String addSources;
    private File outputDirectory;
    private String extension;
    private String protocCommand;

    public void execute() throws MojoExecutionException {
        if (this.project.getPackaging() != null && "pom".equals(this.project.getPackaging().toLowerCase())) {
            this.getLog().info((CharSequence)"Skipping 'pom' packaged project");
            return;
        }
        this.addSources = this.addSources.toLowerCase().trim();
        if ("true".equals(this.addSources)) {
            this.addSources = "main";
        }
        if (this.outputDirectory == null) {
            String subdir = "generated-" + ("test".equals(this.addSources) ? "test-" : "") + "sources";
            this.outputDirectory = new File(this.project.getBuild().getDirectory() + File.separator + subdir + File.separator);
        }
        this.performProtoCompilation();
    }

    private void performProtoCompilation() throws MojoExecutionException {
        if (this.includeDirectories != null && this.includeDirectories.length > 0) {
            this.getLog().info((CharSequence)"Include directories:");
            for (File include : this.includeDirectories) {
                this.getLog().info((CharSequence)("    " + include));
            }
        }
        this.getLog().info((CharSequence)"Input directories:");
        for (File input : this.inputDirectories) {
            this.getLog().info((CharSequence)("    " + input));
        }
        if (this.includeDirectories == null || this.inputDirectories.length == 0) {
            File inputDir = new File(this.project.getBasedir().getAbsolutePath() + DEFAULT_INPUT_DIR);
            this.getLog().info((CharSequence)("    " + inputDir + " (using default)"));
            this.inputDirectories = new File[]{inputDir};
        }
        this.getLog().info((CharSequence)("Output directory: " + this.outputDirectory));
        File f = this.outputDirectory;
        if (!f.exists()) {
            this.getLog().info((CharSequence)(f + " does not exist. Creating..."));
            f.mkdirs();
        }
        if (this.cleanOutputFolder) {
            try {
                this.getLog().info((CharSequence)("Cleaning " + f));
                FileUtils.cleanDirectory((File)f);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        FileFilter fileFilter = new FileFilter(this.extension);
        for (File input : this.inputDirectories) {
            if (input == null) continue;
            if (input.exists() && input.isDirectory()) {
                File[] files;
                for (File file : files = input.listFiles(fileFilter)) {
                    if (this.cleanOutputFolder || this.buildContext.hasDelta(file.getPath())) {
                        this.processFile(file, this.outputDirectory);
                        continue;
                    }
                    this.getLog().info((CharSequence)("Not changed " + file));
                }
                continue;
            }
            if (input.exists()) {
                this.getLog().warn((CharSequence)(input + " is not a directory"));
                continue;
            }
            this.getLog().warn((CharSequence)(input + " does not exist"));
        }
        boolean mainAddSources = "main".endsWith(this.addSources);
        boolean testAddSources = "test".endsWith(this.addSources);
        if (mainAddSources) {
            this.getLog().info((CharSequence)"Adding generated classes to classpath");
            this.project.addCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (testAddSources) {
            this.getLog().info((CharSequence)"Adding generated classes to test classpath");
            this.project.addTestCompileSourceRoot(this.outputDirectory.getAbsolutePath());
        }
        if (mainAddSources || testAddSources) {
            this.buildContext.refresh(this.outputDirectory);
        }
    }

    private void processFile(File file, File outputDir) throws MojoExecutionException {
        this.getLog().info((CharSequence)("    Processing " + file.getName()));
        Collection<String> cmd = this.buildCommand(file, outputDir);
        try {
            int ret = 0;
            ret = this.protocCommand == null ? Protoc.runProtoc(cmd.toArray(new String[0])) : Protoc.runProtoc(this.protocCommand, cmd.toArray(new String[0]));
            if (ret != 0) {
                throw new MojoExecutionException("protoc-jar failed for " + file + ". Exit code " + ret);
            }
        }
        catch (InterruptedException e) {
            throw new MojoExecutionException("Interrupted", (Exception)e);
        }
        catch (IOException e) {
            throw new MojoExecutionException("Unable to execute protoc-jar for " + file, (Exception)e);
        }
    }

    private Collection<String> buildCommand(File file, File outputDir) throws MojoExecutionException {
        LinkedList<String> cmd = new LinkedList<String>();
        this.populateIncludes(cmd);
        cmd.add("-I" + file.getParentFile().getAbsolutePath());
        cmd.add("--java_out=" + outputDir);
        cmd.add(file.toString());
        return cmd;
    }

    private void populateIncludes(Collection<String> args) throws MojoExecutionException {
        for (File include : this.includeDirectories) {
            if (!include.exists()) {
                throw new MojoExecutionException("Include path '" + include.getPath() + "' does not exist");
            }
            if (!include.isDirectory()) {
                throw new MojoExecutionException("Include path '" + include.getPath() + "' is not a directory");
            }
            args.add("-I" + include.getPath());
        }
    }

    class FileFilter
    implements FilenameFilter {
        String extension;

        public FileFilter(String extension) {
            this.extension = extension;
        }

        public boolean accept(File dir, String name) {
            return name.endsWith(this.extension);
        }
    }
}

