/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;

public class Protoc {
    static final String sProtocFilePath = "bin_241";

    public static void main(String[] args) {
        try {
            Protoc.runProtoc(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int runProtoc(String[] args) throws IOException, InterruptedException {
        Protoc.log("protoc version: 241, detected platform: " + Protoc.getPlatform());
        File protocTemp = Protoc.extractProtoc();
        int exitCode = Protoc.runProtoc(protocTemp.getAbsolutePath(), args);
        protocTemp.delete();
        return exitCode;
    }

    public static int runProtoc(String cmd, String[] args) throws IOException, InterruptedException {
        ArrayList<String> protocCmd = new ArrayList<String>();
        protocCmd.add(cmd);
        protocCmd.addAll(Arrays.asList(args));
        ProcessBuilder pb = new ProcessBuilder(protocCmd);
        Protoc.log("executing: " + protocCmd);
        Process protoc = pb.start();
        new Thread(new StreamCopier(protoc.getInputStream(), System.out)).start();
        new Thread(new StreamCopier(protoc.getErrorStream(), System.err)).start();
        int exitCode = protoc.waitFor();
        return exitCode;
    }

    static File extractProtoc() throws IOException {
        String resourcePath = null;
        String filePath = null;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osName.startsWith("win")) {
            filePath = "bin_241/win32/protoc.exe";
        } else if (osName.startsWith("linux") && osArch.contains("64")) {
            filePath = "bin_241/linux/protoc";
        } else if (osName.startsWith("mac") && osArch.contains("64")) {
            filePath = "bin_241/mac/protoc";
        } else {
            throw new IOException("Unsupported platform: " + Protoc.getPlatform());
        }
        resourcePath = "/" + filePath;
        Class<Protoc> clazz = Protoc.class;
        InputStream is = clazz.getResourceAsStream(resourcePath);
        if (is == null) {
            is = new FileInputStream(filePath);
        }
        File temp = File.createTempFile("protoc", ".exe");
        temp.setExecutable(true);
        FileOutputStream os = new FileOutputStream(temp);
        Protoc.streamCopy(is, os);
        is.close();
        os.close();
        return temp;
    }

    static void streamCopy(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
    }

    static String getPlatform() {
        return System.getProperty("os.name").toLowerCase() + "/" + System.getProperty("os.arch").toLowerCase();
    }

    static void log(String msg) {
        System.out.println("protoc-jar: " + msg);
    }

    static class StreamCopier
    implements Runnable {
        private InputStream mIn;
        private OutputStream mOut;

        public StreamCopier(InputStream in, OutputStream out) {
            this.mIn = in;
            this.mOut = out;
        }

        public void run() {
            try {
                Protoc.streamCopy(this.mIn, this.mOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

