/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protoc {
    static Map<String, String> sVersionMap = new HashMap<String, String>();

    public static void main(String[] args) {
        try {
            int exitCode = Protoc.runProtoc(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int runProtoc(String[] args) throws IOException, InterruptedException {
        String protocVersion = "300";
        ArrayList<String> argList = new ArrayList<String>();
        for (String arg : args) {
            String v = sVersionMap.get(arg);
            if (v != null) {
                protocVersion = v;
                continue;
            }
            argList.add(arg);
        }
        Protoc.log("protoc version: " + protocVersion + ", detected platform: " + Protoc.getPlatform());
        File protocTemp = Protoc.extractProtoc(protocVersion);
        int exitCode = Protoc.runProtoc(protocTemp.getAbsolutePath(), argList);
        protocTemp.delete();
        return exitCode;
    }

    public static int runProtoc(String cmd, String[] args) throws IOException, InterruptedException {
        return Protoc.runProtoc(cmd, Arrays.asList(args));
    }

    public static int runProtoc(String cmd, List<String> argList) throws IOException, InterruptedException {
        ArrayList<String> protocCmd = new ArrayList<String>();
        protocCmd.add(cmd);
        protocCmd.addAll(argList);
        ProcessBuilder pb = new ProcessBuilder(protocCmd);
        Protoc.log("executing: " + protocCmd);
        Process protoc = pb.start();
        new Thread(new StreamCopier(protoc.getInputStream(), System.out)).start();
        new Thread(new StreamCopier(protoc.getErrorStream(), System.err)).start();
        int exitCode = protoc.waitFor();
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static File extractProtoc(String protocVersion) throws IOException {
        String protocFilePath = "bin_" + protocVersion;
        String resourcePath = null;
        String filePath = null;
        String osName = System.getProperty("os.name").toLowerCase();
        String osArch = System.getProperty("os.arch").toLowerCase();
        if (osName.startsWith("win")) {
            filePath = protocFilePath + "/win32/protoc.exe";
        } else if (osName.startsWith("linux") && osArch.contains("64")) {
            filePath = protocFilePath + "/linux/protoc";
        } else if (osName.startsWith("mac") && osArch.contains("64")) {
            filePath = protocFilePath + "/mac/protoc";
        } else {
            throw new IOException("Unsupported platform: " + Protoc.getPlatform());
        }
        resourcePath = "/" + filePath;
        FileOutputStream os = null;
        InputStream is = Protoc.class.getResourceAsStream(resourcePath);
        if (is == null) {
            is = new FileInputStream(filePath);
        }
        try {
            File temp = File.createTempFile("protoc", ".exe");
            temp.setExecutable(true);
            temp.deleteOnExit();
            os = new FileOutputStream(temp);
            Protoc.streamCopy(is, os);
            File file = temp;
            return file;
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
    }

    static void streamCopy(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
    }

    static String getPlatform() {
        return System.getProperty("os.name").toLowerCase() + "/" + System.getProperty("os.arch").toLowerCase();
    }

    static void log(String msg) {
        System.out.println("protoc-jar: " + msg);
    }

    static {
        sVersionMap.put("-v3.0.0", "300");
        sVersionMap.put("-v2.6.1", "261");
        sVersionMap.put("-v2.5.0", "250");
        sVersionMap.put("-v2.4.1", "241");
        sVersionMap.put("-v300", "300");
        sVersionMap.put("-v261", "261");
        sVersionMap.put("-v250", "250");
        sVersionMap.put("-v241", "241");
    }

    static class StreamCopier
    implements Runnable {
        private InputStream mIn;
        private OutputStream mOut;

        public StreamCopier(InputStream in, OutputStream out) {
            this.mIn = in;
            this.mOut = out;
        }

        public void run() {
            try {
                Protoc.streamCopy(this.mIn, this.mOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

