/*
 * Decompiled with CFR 0.152.
 */
package com.github.os72.protocjar;

import com.github.os72.protocjar.PlatformDetector;
import com.github.os72.protocjar.ProtocVersion;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Protoc {
    static String[] sStdTypesProto2 = new String[]{"include/google/protobuf/descriptor.proto"};
    static String[] sStdTypesProto3 = new String[]{"include/google/protobuf/any.proto", "include/google/protobuf/api.proto", "include/google/protobuf/descriptor.proto", "include/google/protobuf/duration.proto", "include/google/protobuf/empty.proto", "include/google/protobuf/field_mask.proto", "include/google/protobuf/source_context.proto", "include/google/protobuf/struct.proto", "include/google/protobuf/timestamp.proto", "include/google/protobuf/type.proto", "include/google/protobuf/wrappers.proto"};
    static Map<String, String[]> sStdTypesMap = new HashMap<String, String[]>();

    public static void main(String[] args) {
        try {
            int exitCode = Protoc.runProtoc(args);
            System.exit(exitCode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static int runProtoc(String[] args) throws IOException, InterruptedException {
        ProtocVersion protocVersion = ProtocVersion.PROTOC_VERSION;
        boolean includeStdTypes = false;
        for (String arg : args) {
            ProtocVersion v = Protoc.getVersion(arg);
            if (v != null) {
                protocVersion = v;
            }
            if (!arg.equals("--include_std_types")) continue;
            includeStdTypes = true;
        }
        File protocTemp = Protoc.extractProtoc(protocVersion, includeStdTypes);
        int exitCode = Protoc.runProtoc(protocTemp.getAbsolutePath(), Arrays.asList(args));
        protocTemp.delete();
        return exitCode;
    }

    public static int runProtoc(String cmd, String[] args) throws IOException, InterruptedException {
        return Protoc.runProtoc(cmd, Arrays.asList(args));
    }

    public static int runProtoc(String cmd, List<String> argList) throws IOException, InterruptedException {
        ProtocVersion protocVersion = ProtocVersion.PROTOC_VERSION;
        String javaShadedOutDir = null;
        ArrayList<String> protocCmd = new ArrayList<String>();
        protocCmd.add(cmd);
        for (String arg : argList) {
            if (arg.startsWith("--java_shaded_out=")) {
                javaShadedOutDir = arg.split("--java_shaded_out=")[1];
                protocCmd.add("--java_out=" + javaShadedOutDir);
                continue;
            }
            if (arg.equals("--include_std_types")) {
                File stdTypeDir = new File(new File(cmd).getParentFile().getParentFile(), "include");
                protocCmd.add("-I" + stdTypeDir.getAbsolutePath());
                continue;
            }
            ProtocVersion v = Protoc.getVersion(arg);
            if (v != null) {
                protocVersion = v;
                continue;
            }
            protocCmd.add(arg);
        }
        Process protoc = null;
        int numTries = 1;
        while (protoc == null) {
            try {
                Protoc.log("executing: " + protocCmd);
                ProcessBuilder pb = new ProcessBuilder(protocCmd);
                protoc = pb.start();
            }
            catch (IOException ioe) {
                if (numTries++ >= 3) {
                    throw ioe;
                }
                Protoc.log("caught exception, retrying: " + ioe);
                Thread.sleep(1000L);
            }
        }
        new Thread(new StreamCopier(protoc.getInputStream(), System.out)).start();
        new Thread(new StreamCopier(protoc.getErrorStream(), System.err)).start();
        int exitCode = protoc.waitFor();
        if (javaShadedOutDir != null) {
            Protoc.log("shading (version " + protocVersion + "): " + javaShadedOutDir);
            Protoc.doShading(new File(javaShadedOutDir), protocVersion.mVersion);
        }
        return exitCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void doShading(File dir, String version) throws IOException {
        if (dir.listFiles() == null) {
            return;
        }
        for (File file : dir.listFiles()) {
            if (file.isDirectory()) {
                Protoc.doShading(file, version);
                continue;
            }
            if (!file.getName().endsWith(".java")) continue;
            File tmpFile = null;
            PrintWriter pw = null;
            BufferedReader br = null;
            FileInputStream is = null;
            FileOutputStream os = null;
            try {
                String line;
                tmpFile = File.createTempFile(file.getName(), null);
                pw = new PrintWriter(tmpFile);
                br = new BufferedReader(new FileReader(file));
                while ((line = br.readLine()) != null) {
                    pw.println(line.replace("com.google.protobuf", "com.github.os72.protobuf" + version));
                }
                pw.close();
                br.close();
                if (!file.delete()) {
                    Protoc.log("Failed to delete: " + file.getName());
                }
                is = new FileInputStream(tmpFile);
                os = new FileOutputStream(file);
                Protoc.streamCopy(is, os);
            }
            finally {
                if (br != null) {
                    try {
                        br.close();
                    }
                    catch (Exception e) {}
                }
                if (pw != null) {
                    try {
                        pw.close();
                    }
                    catch (Exception e) {}
                }
                if (is != null) {
                    try {
                        is.close();
                    }
                    catch (Exception e) {}
                }
                if (os != null) {
                    try {
                        os.close();
                    }
                    catch (Exception e) {}
                }
                if (tmpFile != null) {
                    tmpFile.delete();
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static File extractProtoc(ProtocVersion protocVersion) throws IOException {
        Protoc.log("protoc version: " + protocVersion + ", detected platform: " + Protoc.getPlatform());
        String srcFilePath = null;
        if (protocVersion.mArtifact == null) {
            String binVersionDir = "bin_" + protocVersion;
            String osName = System.getProperty("os.name").toLowerCase();
            String osArch = System.getProperty("os.arch").toLowerCase();
            if (osName.startsWith("win")) {
                srcFilePath = binVersionDir + "/win32/protoc.exe";
            } else if (osName.startsWith("linux") && osArch.contains("64")) {
                srcFilePath = binVersionDir + "/linux/protoc";
            } else {
                if (!osName.startsWith("mac") || !osArch.contains("64")) throw new IOException("Unsupported platform: " + Protoc.getPlatform());
                srcFilePath = binVersionDir + "/mac/protoc";
            }
        } else {
            srcFilePath = Protoc.downloadProtoc(protocVersion).getAbsolutePath();
        }
        File tmpDir = File.createTempFile("protocjar", "");
        tmpDir.delete();
        tmpDir.mkdirs();
        tmpDir.deleteOnExit();
        File binDir = new File(tmpDir, "bin");
        binDir.mkdirs();
        binDir.deleteOnExit();
        File protocTemp = new File(binDir, "protoc.exe");
        Protoc.populateFile(srcFilePath, protocTemp);
        protocTemp.setExecutable(true);
        protocTemp.deleteOnExit();
        return protocTemp;
    }

    public static File extractProtoc(ProtocVersion protocVersion, boolean includeStdTypes) throws IOException {
        String[] stdTypes;
        File protocTemp = Protoc.extractProtoc(protocVersion);
        if (!includeStdTypes) {
            return protocTemp;
        }
        File tmpDir = protocTemp.getParentFile().getParentFile();
        File tmpDirProtos = new File(tmpDir, "include/google/protobuf");
        tmpDirProtos.mkdirs();
        tmpDirProtos.getParentFile().getParentFile().deleteOnExit();
        tmpDirProtos.getParentFile().deleteOnExit();
        tmpDirProtos.deleteOnExit();
        String majorProtoVersion = String.valueOf(protocVersion.mVersion.charAt(0));
        String srcPathPrefix = String.format("proto%s/", majorProtoVersion);
        for (String srcFilePath : stdTypes = sStdTypesMap.get(majorProtoVersion)) {
            File tmpFile = new File(tmpDir, srcFilePath);
            Protoc.populateFile(srcPathPrefix + srcFilePath, tmpFile);
            tmpFile.deleteOnExit();
        }
        return protocTemp;
    }

    public static File downloadProtoc(ProtocVersion protocVersion) throws IOException {
        Properties detectorProps = new Properties();
        new PlatformDetector().detect(detectorProps, null);
        String platform = detectorProps.getProperty("os.detected.classifier");
        String exeName = protocVersion.mGroup.replace(".", "/") + "/" + protocVersion.mArtifact + "/" + protocVersion.mVersion + "/" + protocVersion.mArtifact + "-" + protocVersion.mVersion + "-" + platform + ".exe";
        File tmpFile = File.createTempFile("protocjar", ".exe");
        File exeFile = new File(tmpFile.getParentFile(), "protocjar.webcache/" + exeName);
        exeFile.getParentFile().mkdirs();
        if (!exeFile.exists()) {
            URL exeUrl = new URL("http://central.maven.org/maven2/" + exeName);
            Protoc.log("downloading: " + exeUrl);
            InputStream is = null;
            FileOutputStream os = null;
            try {
                is = exeUrl.openStream();
                os = new FileOutputStream(tmpFile);
                Protoc.streamCopy(is, os);
                is.close();
                os.close();
                tmpFile.renameTo(exeFile);
            }
            catch (IOException e) {
                tmpFile.delete();
                throw e;
            }
            finally {
                if (is != null) {
                    is.close();
                }
                if (os != null) {
                    os.close();
                }
            }
        }
        Protoc.log("cached: " + exeFile);
        return exeFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File populateFile(String srcFilePath, File destFile) throws IOException {
        String resourcePath = "/" + srcFilePath;
        FileOutputStream os = null;
        InputStream is = Protoc.class.getResourceAsStream(resourcePath);
        if (is == null) {
            is = new FileInputStream(srcFilePath);
        }
        try {
            os = new FileOutputStream(destFile);
            Protoc.streamCopy(is, os);
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (os != null) {
                os.close();
            }
        }
        return destFile;
    }

    public static void streamCopy(InputStream in, OutputStream out) throws IOException {
        int read = 0;
        byte[] buf = new byte[4096];
        while ((read = in.read(buf)) > 0) {
            out.write(buf, 0, read);
        }
    }

    static ProtocVersion getVersion(String spec) {
        return ProtocVersion.getVersion(spec);
    }

    static String getPlatform() {
        return System.getProperty("os.name").toLowerCase() + "/" + System.getProperty("os.arch").toLowerCase();
    }

    static void log(String msg) {
        System.out.println("protoc-jar: " + msg);
    }

    static {
        sStdTypesMap.put("2", sStdTypesProto2);
        sStdTypesMap.put("3", sStdTypesProto3);
    }

    static class StreamCopier
    implements Runnable {
        private InputStream mIn;
        private OutputStream mOut;

        public StreamCopier(InputStream in, OutputStream out) {
            this.mIn = in;
            this.mOut = out;
        }

        public void run() {
            try {
                Protoc.streamCopy(this.mIn, this.mOut);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

