/*
 * Decompiled with CFR 0.152.
 */
package oscana.s2n.seasar;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import nablarch.core.db.statement.sqlconvertor.SqlConvertorSupport;
import nablarch.core.util.StringUtil;
import oscana.s2n.seasar.extension.sql.SemicolonNotAllowedRuntimeException;

public class LiteralReplacementSyntaxConverter
extends SqlConvertorSupport {
    private static final Pattern PATTERN = Pattern.compile("\\/\\*\\$(.+?)\\*\\/", 32);

    public String convert(String sql, Object obj) {
        List<String> sqlKeyList = this.getSqlKey(sql);
        if (sqlKeyList == null || sqlKeyList.size() < 1) {
            return sql;
        }
        String actualSql = sql;
        for (String sqlKey : sqlKeyList) {
            String paramKey = sqlKey.substring(3, sqlKey.length() - 2);
            Object bindValue = this.getBindValue(obj, paramKey);
            String value = "";
            if (bindValue == null) {
                value = " 1 = 1 ";
            } else if (StringUtil.isNullOrEmpty((String)bindValue.toString().trim())) {
                value = " 1 = 1 ";
            } else {
                value = bindValue.toString();
                if (value.contains(";")) {
                    throw new SemicolonNotAllowedRuntimeException();
                }
            }
            actualSql = actualSql.replace(sqlKey, value);
        }
        return actualSql;
    }

    private List<String> getSqlKey(String sql) {
        Matcher m = PATTERN.matcher(sql);
        m.reset();
        ArrayList<String> sqlKeyList = new ArrayList<String>();
        while (m.find()) {
            sqlKeyList.add(m.group());
        }
        return sqlKeyList;
    }
}

