/*
 * Decompiled with CFR 0.152.
 */
package oscana.s2n.seasar.framework.beans.util;

import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import nablarch.core.beans.BeanUtil;
import nablarch.core.beans.ConversionUtil;
import nablarch.core.beans.CopyOptions;
import nablarch.core.log.Logger;
import nablarch.core.log.LoggerManager;
import nablarch.core.util.StringUtil;
import oscana.s2n.seasar.framework.beans.util.BeanMap;

public abstract class AbstractCopy<S extends AbstractCopy<S>> {
    private static final Logger LOGGER = LoggerManager.get(BeanUtil.class);
    protected static final String[] EMPTY_STRING_ARRAY = new String[0];
    protected CopyOptions copyOptions = CopyOptions.options().build();
    protected String[] includePropertyNames = EMPTY_STRING_ARRAY;
    protected String[] excludePropertyNames = EMPTY_STRING_ARRAY;
    protected boolean excludesNull = false;
    protected boolean excludesWhitespace = false;
    protected String[] whiteSpacePropertyNames = EMPTY_STRING_ARRAY;
    protected String[] prefixPropertyNames = EMPTY_STRING_ARRAY;
    protected String[] nestBeanPropertyNames = EMPTY_STRING_ARRAY;
    protected Map<String, Object> restorePropertyMap = new HashMap<String, Object>();
    protected String propertyDelimiter = ",";
    protected String prefix;
    protected String beanMapExchange;
    protected char beanDelimiter = (char)36;
    protected char mapDelimiter = (char)46;

    protected String[] toStringArray(CharSequence[] charSequenceArray) {
        int length = charSequenceArray.length;
        String[] stringArray = new String[length];
        for (int index = 0; index < length; ++index) {
            stringArray[index] = charSequenceArray[index].toString();
        }
        return stringArray;
    }

    public S includes(CharSequence ... propertyNames) {
        this.includePropertyNames = this.toStringArray(propertyNames);
        return (S)this;
    }

    public S excludes(CharSequence ... propertyNames) {
        this.excludePropertyNames = this.toStringArray(propertyNames);
        return (S)this;
    }

    public S excludesNull() {
        this.excludesNull = true;
        return (S)this;
    }

    public S excludesWhitespace() {
        this.excludesWhitespace = true;
        return (S)this;
    }

    public S prefix(CharSequence prefix) {
        this.prefix = prefix.toString();
        return (S)this;
    }

    public S beanDelimiter(char beanDelimiter) {
        this.beanDelimiter = beanDelimiter;
        return (S)this;
    }

    public S mapDelimiter(char mapDelimiter) {
        this.mapDelimiter = mapDelimiter;
        return (S)this;
    }

    protected boolean isTargetProperty(String name) {
        if (this.prefix != null && !name.startsWith(this.prefix)) {
            return false;
        }
        if (this.includePropertyNames.length > 0) {
            for (String s : this.includePropertyNames) {
                if (!s.equals(name)) continue;
                for (String s2 : this.excludePropertyNames) {
                    if (!s2.equals(name)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if (this.excludePropertyNames.length > 0) {
            for (String s : this.excludePropertyNames) {
                if (!s.equals(name)) continue;
                return false;
            }
            return true;
        }
        return true;
    }

    private void getWhitespaceProperties(Object obj) {
        StringBuilder whiteSpacePropertyName = new StringBuilder();
        if (obj instanceof Map) {
            Map mapObj = (Map)obj;
            for (String propertyName : mapObj.keySet()) {
                Object value = mapObj.get(propertyName);
                if (!(value instanceof String) || ((String)value).trim().length() != 0) continue;
                if (whiteSpacePropertyName.length() > 0) {
                    whiteSpacePropertyName.append(this.propertyDelimiter);
                }
                whiteSpacePropertyName.append(propertyName);
            }
        } else {
            PropertyDescriptor[] srcPds;
            for (PropertyDescriptor pd : srcPds = BeanUtil.getPropertyDescriptors(obj.getClass())) {
                Method getter = pd.getReadMethod();
                if (getter == null) continue;
                try {
                    Object val = getter.invoke(obj, new Object[0]);
                    if (((String)val).trim().length() != 0) continue;
                    String propertyName = pd.getName();
                    if (whiteSpacePropertyName.length() > 0) {
                        whiteSpacePropertyName.append(this.propertyDelimiter);
                    }
                    whiteSpacePropertyName.append(propertyName);
                }
                catch (Exception e) {
                    LOGGER.logDebug("An error occurred while reading to the property :" + pd.getName(), new Object[0]);
                }
            }
        }
        this.whiteSpacePropertyNames = whiteSpacePropertyName.toString().split(this.propertyDelimiter);
    }

    private void buildCopyOptions() {
        CopyOptions.Builder copyOptionBuilder = CopyOptions.options();
        if (this.excludesNull) {
            copyOptionBuilder = copyOptionBuilder.excludesNull();
        }
        copyOptionBuilder = !StringUtil.isNullOrEmpty((String[])this.prefixPropertyNames) ? copyOptionBuilder.includes(this.prefixPropertyNames) : copyOptionBuilder.includes(this.includePropertyNames);
        copyOptionBuilder = copyOptionBuilder.excludes(this.excludePropertyNames).excludes(this.whiteSpacePropertyNames).excludes(this.prefixPropertyNames).excludes(this.nestBeanPropertyNames);
        this.copyOptions = copyOptionBuilder.build();
    }

    private void backProperty(Object src) {
        StringBuilder nestBeanPropertyName = new StringBuilder();
        StringBuilder prefixPropertyName = new StringBuilder();
        if (src instanceof Map) {
            Map mapObj = (Map)src;
            for (String propertyName : mapObj.keySet()) {
                Object val = mapObj.get(propertyName);
                if (val == null) continue;
                Class<?> propertyType = val.getClass();
                if (this.prefix != null && propertyName.startsWith(this.prefix)) {
                    if (prefixPropertyName.length() > 0) {
                        prefixPropertyName.append(this.propertyDelimiter);
                    }
                    prefixPropertyName.append(propertyName);
                    this.restorePropertyMap.put(propertyName, val);
                    continue;
                }
                if (this.prefix != null || !this.isTargetProperty(propertyName) || propertyType.isPrimitive() || Number.class.isAssignableFrom(propertyType) || Date.class.isAssignableFrom(propertyType) || Boolean.class.isAssignableFrom(propertyType) || String.class.equals(propertyType) || Calendar.class.isAssignableFrom(propertyType)) continue;
                if (nestBeanPropertyName.length() > 0) {
                    nestBeanPropertyName.append(this.propertyDelimiter);
                }
                nestBeanPropertyName.append(propertyName);
                this.restorePropertyMap.put(propertyName, val);
            }
        } else {
            PropertyDescriptor[] srcPds;
            for (PropertyDescriptor pd : srcPds = BeanUtil.getPropertyDescriptors(src.getClass())) {
                Object val;
                Method getter;
                String propertyName = pd.getName();
                Class<?> propertyType = pd.getPropertyType();
                if (this.prefix != null && propertyName.startsWith(this.prefix)) {
                    if (prefixPropertyName.length() > 0) {
                        prefixPropertyName.append(this.propertyDelimiter);
                    }
                    prefixPropertyName.append(propertyName);
                    getter = pd.getReadMethod();
                    if (getter == null) continue;
                    try {
                        val = getter.invoke(src, new Object[0]);
                        this.restorePropertyMap.put(propertyName, val);
                    }
                    catch (Exception e) {
                        LOGGER.logDebug("An error occurred while reading to the property :" + pd.getName(), new Object[0]);
                    }
                    continue;
                }
                if (this.prefix != null || !this.isTargetProperty(propertyName) || propertyType.isPrimitive() || Number.class.isAssignableFrom(propertyType) || Date.class.isAssignableFrom(propertyType) || Boolean.class.isAssignableFrom(propertyType) || String.class.equals(propertyType) || Calendar.class.isAssignableFrom(propertyType)) continue;
                if (nestBeanPropertyName.length() > 0) {
                    nestBeanPropertyName.append(this.propertyDelimiter);
                }
                nestBeanPropertyName.append(propertyName);
                getter = pd.getReadMethod();
                if (getter == null) continue;
                try {
                    val = getter.invoke(src, new Object[0]);
                    this.restorePropertyMap.put(propertyName, val);
                }
                catch (Exception e) {
                    LOGGER.logDebug("An error occurred while reading to the property :" + pd.getName(), new Object[0]);
                }
            }
        }
        this.prefixPropertyNames = prefixPropertyName.toString().split(this.propertyDelimiter);
        this.nestBeanPropertyNames = nestBeanPropertyName.toString().split(this.propertyDelimiter);
    }

    private void afterCopyForRestoreProperty(Object dest) {
        if (this.excludePropertyNames.length != 0) {
            for (int i = 0; i < this.excludePropertyNames.length; ++i) {
                this.restorePropertyMap.remove(this.excludePropertyNames[i]);
            }
        }
        for (String restorePropertyName : this.restorePropertyMap.keySet()) {
            String destPropertyName = "BeanToMap".equals(this.beanMapExchange) ? this.trimPrefix(restorePropertyName.replace(this.beanDelimiter, this.mapDelimiter)) : ("MapToBean".equals(this.beanMapExchange) ? this.trimPrefix(restorePropertyName.replace(this.mapDelimiter, this.beanDelimiter)) : this.trimPrefix(restorePropertyName));
            Object value = this.restorePropertyMap.get(restorePropertyName);
            if (this.excludesNull && null == value || value instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0) continue;
            if (dest instanceof Map) {
                Map mapObj = (Map)dest;
                mapObj.put(destPropertyName, value);
                continue;
            }
            try {
                BeanUtil.setProperty((Object)dest, (String)destPropertyName, (Object)value);
            }
            catch (Exception e) {}
        }
    }

    private void afterCopyForMap(Map src, Map dest) {
        for (String srcPropertyName : src.keySet()) {
            Object value = src.get(srcPropertyName);
            srcPropertyName = this.trimPrefix(srcPropertyName.replace(this.beanDelimiter, this.mapDelimiter));
            dest.put(srcPropertyName, value);
        }
    }

    protected void copyBeanToBean(Object src, Object dest) {
        if (this.excludesWhitespace) {
            this.getWhitespaceProperties(src);
        }
        this.backProperty(src);
        this.buildCopyOptions();
        BeanUtil.copy((Object)src, (Object)dest, (CopyOptions)this.copyOptions);
        this.afterCopyForRestoreProperty(dest);
    }

    protected void copyBeanToMap(Object src, Map dest) {
        this.beanMapExchange = "BeanToMap";
        if (this.excludesWhitespace) {
            this.getWhitespaceProperties(src);
        }
        this.backProperty(src);
        if (this.excludesNull) {
            PropertyDescriptor[] srcPds;
            StringBuilder excludePropertyName = new StringBuilder();
            for (PropertyDescriptor pd : srcPds = BeanUtil.getPropertyDescriptors(src.getClass())) {
                String propertyName = pd.getName();
                Method getter = pd.getReadMethod();
                if (getter == null) continue;
                try {
                    Object val = getter.invoke(src, new Object[0]);
                    if (val != null) continue;
                    excludePropertyName.append(propertyName);
                    excludePropertyName.append(this.propertyDelimiter);
                }
                catch (Exception e) {
                    LOGGER.logDebug("An error occurred while reading to the property :" + pd.getName(), new Object[0]);
                }
            }
            this.excludePropertyNames = excludePropertyName.toString().split(this.propertyDelimiter);
        }
        this.buildCopyOptions();
        this.afterCopyForMap(BeanUtil.createMapAndCopy((Object)src, (CopyOptions)this.copyOptions), dest);
        this.afterCopyForRestoreProperty(dest);
    }

    protected void copyMapToBean(Map<String, ?> src, Object dest) {
        this.beanMapExchange = "MapToBean";
        if (this.excludesWhitespace) {
            this.getWhitespaceProperties(src);
        }
        this.backProperty(src);
        if (this.excludesNull) {
            StringBuilder excludePropertyName = new StringBuilder();
            for (String srcPropertyName : src.keySet()) {
                Object value = src.get(srcPropertyName);
                if (value != null) continue;
                excludePropertyName.append(srcPropertyName);
                excludePropertyName.append(this.propertyDelimiter);
            }
            this.excludePropertyNames = excludePropertyName.toString().split(this.propertyDelimiter);
        }
        this.buildCopyOptions();
        BeanUtil.copy(dest.getClass(), (Object)dest, src, (CopyOptions)this.copyOptions);
        this.afterCopyForRestoreProperty(dest);
    }

    protected void copyMapToMap(Map<String, Object> src, Map<String, Object> dest) {
        this.buildCopyOptions();
        for (String srcPropertyName : src.keySet()) {
            if (!this.isTargetProperty(srcPropertyName)) continue;
            String destPropertyName = this.trimPrefix(srcPropertyName);
            Object value = src.get(srcPropertyName);
            if (value instanceof String && this.excludesWhitespace && ((String)value).trim().length() == 0 || value == null && this.excludesNull) continue;
            if (value != null) {
                value = ConversionUtil.convert(value.getClass(), (Object)value);
            }
            dest.put(destPropertyName, value);
        }
    }

    protected <T> T createAndCopyBeanToBean(Object src, Class<T> destClass) {
        if (this.excludesWhitespace) {
            this.getWhitespaceProperties(src);
        }
        this.backProperty(src);
        this.buildCopyOptions();
        Object dest = BeanUtil.createAndCopy(destClass, (Object)src, (CopyOptions)this.copyOptions);
        this.afterCopyForRestoreProperty(dest);
        return (T)dest;
    }

    protected <T> T createAndCopyBeanToMap(Object src, Class<T> destClass) {
        this.beanMapExchange = "BeanToMap";
        if (this.excludesWhitespace) {
            this.getWhitespaceProperties(src);
        }
        this.backProperty(src);
        if (this.excludesNull) {
            PropertyDescriptor[] srcPds;
            StringBuilder excludePropertyName = new StringBuilder();
            for (PropertyDescriptor pd : srcPds = BeanUtil.getPropertyDescriptors(src.getClass())) {
                String propertyName = pd.getName();
                Method getter = pd.getReadMethod();
                if (getter == null) continue;
                try {
                    Object val = getter.invoke(src, new Object[0]);
                    if (val != null) continue;
                    excludePropertyName.append(propertyName);
                    excludePropertyName.append(this.propertyDelimiter);
                }
                catch (Exception e) {
                    LOGGER.logDebug("An error occurred while reading to the property :" + pd.getName(), new Object[0]);
                }
            }
            this.excludePropertyNames = excludePropertyName.toString().split(this.propertyDelimiter);
        }
        this.buildCopyOptions();
        HashMap dest = BeanMap.class.isAssignableFrom(destClass) ? new BeanMap() : new HashMap();
        Map srcMap = BeanUtil.createMapAndCopy((Object)src, (CopyOptions)this.copyOptions);
        this.afterCopyForMap(srcMap, dest);
        this.afterCopyForRestoreProperty(dest);
        return (T)dest;
    }

    protected <T> T createAndCopyMapToMap(Map<String, Object> src, Class<T> destClass) {
        HashMap dest = BeanMap.class.isAssignableFrom(destClass) ? new BeanMap() : new HashMap();
        this.copyMapToMap(src, dest);
        return (T)dest;
    }

    protected <T> T createAndcopyMapToBean(Map<String, ?> src, Class<T> destClass) {
        this.beanMapExchange = "MapToBean";
        if (this.excludesWhitespace) {
            this.getWhitespaceProperties(src);
        }
        this.backProperty(src);
        if (this.excludesNull) {
            StringBuilder excludePropertyName = new StringBuilder();
            for (String srcPropertyName : src.keySet()) {
                Object value = src.get(srcPropertyName);
                if (value != null) continue;
                excludePropertyName.append(srcPropertyName);
                excludePropertyName.append(this.propertyDelimiter);
            }
            this.excludePropertyNames = excludePropertyName.toString().split(this.propertyDelimiter);
        }
        this.buildCopyOptions();
        Object dest = BeanUtil.createAndCopy(destClass, src, (CopyOptions)this.copyOptions);
        this.afterCopyForRestoreProperty(dest);
        return (T)dest;
    }

    protected String trimPrefix(String propertyName) {
        if (this.prefix == null) {
            return propertyName;
        }
        if (!propertyName.startsWith(this.prefix)) {
            return propertyName;
        }
        return propertyName.substring(this.prefix.length());
    }
}

