/*
 * Decompiled with CFR 0.152.
 */
package oscana.s2n.seasar.framework.convention.impl;

import oscana.s2n.seasar.framework.convention.PersistenceConvention;
import oscana.s2n.seasar.framework.util.StringUtil;

public class PersistenceConventionImpl
implements PersistenceConvention {
    private String ignoreTablePrefix;
    private boolean noNameConversion = false;

    @Override
    public String fromTableNameToEntityName(String tableName) {
        if (tableName == null) {
            throw new NullPointerException("tableName");
        }
        if (this.noNameConversion) {
            return tableName;
        }
        return StringUtil.camelize(StringUtil.trimPrefix(tableName, this.ignoreTablePrefix));
    }

    @Override
    public String fromEntityNameToTableName(String entityName) {
        if (entityName == null) {
            throw new NullPointerException("entityName");
        }
        if (this.noNameConversion) {
            return entityName;
        }
        String tableName = StringUtil.decamelize(entityName);
        if (this.ignoreTablePrefix != null) {
            tableName = this.ignoreTablePrefix + tableName;
        }
        return tableName;
    }

    @Override
    public String fromColumnNameToPropertyName(String columnName) {
        if (columnName == null) {
            throw new NullPointerException("columnName");
        }
        if (this.noNameConversion) {
            return columnName;
        }
        return StringUtil.decapitalize(StringUtil.camelize(columnName));
    }

    @Override
    public String fromPropertyNameToColumnName(String propertyName) {
        if (propertyName == null) {
            throw new NullPointerException("propertyName");
        }
        if (this.noNameConversion) {
            return propertyName;
        }
        return StringUtil.decamelize(propertyName);
    }

    public String getIgnoreTablePrefix() {
        return this.ignoreTablePrefix;
    }

    public void setIgnoreTablePrefix(String ignoreTablePrefix) {
        this.ignoreTablePrefix = ignoreTablePrefix;
    }

    public boolean isNoNameConversion() {
        return this.noNameConversion;
    }

    public void setNoNameConversion(boolean noNameConversion) {
        this.noNameConversion = noNameConversion;
    }
}

