/*
 * Decompiled with CFR 0.152.
 */
package oscana.s2n.seasar.framework.util;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class FieldUtil {
    protected FieldUtil() {
    }

    public static Object get(Field field, Object target) {
        try {
            return field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(field.getDeclaringClass().getName(), ex);
        }
    }

    public static int getInt(Field field) {
        return FieldUtil.getInt(field, null);
    }

    public static int getInt(Field field, Object target) {
        try {
            return field.getInt(target);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(field.getDeclaringClass().getName(), ex);
        }
    }

    public static String getString(Field field) {
        return FieldUtil.getString(field, null);
    }

    public static String getString(Field field, Object target) {
        try {
            return (String)field.get(target);
        }
        catch (IllegalAccessException ex) {
            throw new RuntimeException(field.getDeclaringClass().getName(), ex);
        }
    }

    public static void set(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (Exception e) {
            throw new RuntimeException(field.getDeclaringClass().getName(), e);
        }
    }

    public static boolean isInstanceField(Field field) {
        int mod = field.getModifiers();
        return !Modifier.isStatic(mod) && !Modifier.isFinal(mod);
    }

    public static boolean isPublicField(Field field) {
        int mod = field.getModifiers();
        return Modifier.isPublic(mod);
    }
}

