/*
 * Decompiled with CFR 0.152.
 */
package oscana.s2n.seasar.framework.util;

import java.lang.reflect.Method;

public class MethodUtil {
    private static final Method IS_BRIDGE_METHOD = MethodUtil.getIsBridgeMethod();
    private static final Method IS_SYNTHETIC_METHOD = MethodUtil.getIsSyntheticMethod();

    protected MethodUtil() {
    }

    public static Object invoke(Method method, Object target, Object[] args) {
        try {
            return method.invoke(target, args);
        }
        catch (Exception e) {
            throw new RuntimeException(method.getDeclaringClass().getName(), e);
        }
    }

    public static boolean isSyntheticMethod(Method method) {
        if (IS_SYNTHETIC_METHOD == null) {
            return false;
        }
        return (Boolean)MethodUtil.invoke(IS_SYNTHETIC_METHOD, method, null);
    }

    public static boolean isBridgeMethod(Method method) {
        if (IS_BRIDGE_METHOD == null) {
            return false;
        }
        return (Boolean)MethodUtil.invoke(IS_BRIDGE_METHOD, method, null);
    }

    private static Method getIsBridgeMethod() {
        try {
            return Method.class.getMethod("isBridge", new Class[]{null});
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }

    private static Method getIsSyntheticMethod() {
        try {
            return Method.class.getMethod("isSynthetic", new Class[]{null});
        }
        catch (NoSuchMethodException e) {
            return null;
        }
    }
}

