/*
 * Decompiled with CFR 0.152.
 */
package oscana.s2n.seasar.framework.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import oscana.s2n.seasar.framework.exception.IORuntimeException;

public class ResourceUtil {
    protected ResourceUtil() {
    }

    public static String getResourcePath(String path, String extension) {
        if (extension == null) {
            return path;
        }
        extension = "." + extension;
        if (path.endsWith(extension)) {
            return path;
        }
        return path.replace('.', '/') + extension;
    }

    public static URL getResource(String path, String extension) {
        URL url = ResourceUtil.getResourceNoException(path, extension);
        if (url != null) {
            return url;
        }
        throw new RuntimeException(ResourceUtil.getResourcePath(path, extension));
    }

    public static URL getResourceNoException(String path, String extension) {
        return ResourceUtil.getResourceNoException(path, extension, Thread.currentThread().getContextClassLoader());
    }

    public static URL getResourceNoException(String path, String extension, ClassLoader loader) {
        if (path == null || loader == null) {
            return null;
        }
        path = ResourceUtil.getResourcePath(path, extension);
        return loader.getResource(path);
    }

    public static InputStream getResourceAsStream(String path) {
        return ResourceUtil.getResourceAsStream(path, null);
    }

    public static InputStream getResourceAsStream(String path, String extension) {
        URL url = ResourceUtil.getResource(path, extension);
        return ResourceUtil.openStream(url);
    }

    private static InputStream openStream(URL url) {
        try {
            URLConnection connection = url.openConnection();
            connection.setUseCaches(false);
            return connection.getInputStream();
        }
        catch (IOException e) {
            throw new IORuntimeException(e);
        }
    }
}

