/*
 * Decompiled with CFR 0.152.
 */
package oscana.s2n.seasar.framework.util.tiger;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public abstract class ReflectionUtil {
    protected ReflectionUtil() {
    }

    public static <T> Class<T> forName(String className) {
        return ReflectionUtil.forName(className, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> forName(String className, ClassLoader loader) {
        try {
            return Class.forName(className, true, loader);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> Class<T> forNameNoException(String className) {
        return ReflectionUtil.forNameNoException(className, Thread.currentThread().getContextClassLoader());
    }

    public static <T> Class<T> forNameNoException(String className, ClassLoader loader) {
        try {
            return Class.forName(className, true, loader);
        }
        catch (Throwable ignore) {
            return null;
        }
    }

    public static <T> Constructor<T> getConstructor(Class<T> clazz, Class<?> ... argTypes) {
        try {
            return clazz.getConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(clazz.getName() + argTypes, e);
        }
    }

    public static <T> Constructor<T> getDeclaredConstructor(Class<T> clazz, Class<?> ... argTypes) {
        try {
            return clazz.getDeclaredConstructor(argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(clazz.getName() + argTypes, e);
        }
    }

    public static Field getField(Class<?> clazz, String name) {
        try {
            return clazz.getField(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(clazz.getName() + name, e);
        }
    }

    public static Field getDeclaredField(Class<?> clazz, String name) {
        try {
            return clazz.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            throw new RuntimeException(clazz.getName() + name, e);
        }
    }

    public static Method getMethod(Class<?> clazz, String name, Class<?> ... argTypes) {
        try {
            return clazz.getMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(clazz.getName() + name + argTypes, e);
        }
    }

    public static Method getDeclaredMethod(Class<?> clazz, String name, Class<?> ... argTypes) {
        try {
            return clazz.getDeclaredMethod(name, argTypes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(clazz.getName() + name + argTypes, e);
        }
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(clazz.getName(), e);
        }
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw new RuntimeException(constructor.getDeclaringClass().getName(), e);
        }
    }

    public static <T> T getValue(Field field, Object target) {
        try {
            return (T)field.get(target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(field.getDeclaringClass().getName(), e);
        }
    }

    public static <T> T getStaticValue(Field field) {
        return ReflectionUtil.getValue(field, null);
    }

    public static void setValue(Field field, Object target, Object value) {
        try {
            field.set(target, value);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(field.getDeclaringClass().getName(), e);
        }
    }

    public static void setStaticValue(Field field, Object value) {
        ReflectionUtil.setValue(field, null, value);
    }

    public static <T> T invoke(Method method, Object target, Object ... args) {
        try {
            return (T)method.invoke(target, args);
        }
        catch (Exception e) {
            throw new RuntimeException(method.getDeclaringClass().getName(), e);
        }
    }

    public static <T> T invokeStatic(Method method, Object ... args) {
        return ReflectionUtil.invoke(method, null, args);
    }
}

