/*
 * Decompiled with CFR 0.152.
 */
package oscana.s2n.seasar.struts.util;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.servlet.http.HttpServletResponse;
import nablarch.fw.dicontainer.nablarch.Containers;
import nablarch.fw.web.HttpResponse;
import oscana.s2n.common.web.download.S2NStreamResponse;
import oscana.s2n.handler.HttpResourceHolder;
import oscana.s2n.seasar.struts.util.RequestUtil;

public final class ResponseUtil {
    private ResponseUtil() {
    }

    public static HttpServletResponse getResponse() {
        HttpResourceHolder resource = (HttpResourceHolder)Containers.get().getComponent(HttpResourceHolder.class);
        return resource.getHttpServletResponse();
    }

    public static void download(String fileName, byte[] data) {
        S2NStreamResponse response = new S2NStreamResponse((InputStream)new ByteArrayInputStream(data));
        response.setContentType("application/octet-stream");
        response.setContentDisposition(fileName);
        HttpResourceHolder resource = (HttpResourceHolder)Containers.get().getComponent(HttpResourceHolder.class);
        resource.setForcedNextResponse((HttpResponse)response);
    }

    public static void download(String fileName, InputStream in) {
        S2NStreamResponse response = new S2NStreamResponse(in);
        response.setContentType("application/octet-stream");
        response.setContentDisposition(fileName);
        HttpResourceHolder resource = (HttpResourceHolder)Containers.get().getComponent(HttpResourceHolder.class);
        resource.setForcedNextResponse((HttpResponse)response);
    }

    public static void download(String fileName, InputStream in, int length) {
        HttpServletResponse response = ResponseUtil.getResponse();
        response.setContentLength(length);
        ResponseUtil.download(fileName, in);
    }

    public static void write(String text) {
        ResponseUtil.write(text, null, null);
    }

    public static void write(String text, String contentType) {
        ResponseUtil.write(text, contentType, null);
    }

    public static void write(String text, String contentType, String encoding) {
        if (contentType == null) {
            contentType = "text/plain";
        }
        if (encoding == null && (encoding = RequestUtil.getRequest().getCharacterEncoding()) == null) {
            encoding = "UTF-8";
        }
        HttpResponse outPutRes = new HttpResponse();
        outPutRes.setContentType(contentType + "; charset=" + encoding);
        outPutRes.write((CharSequence)text);
        HttpResourceHolder resource = (HttpResourceHolder)Containers.get().getComponent(HttpResourceHolder.class);
        resource.setForcedNextResponse(outPutRes);
    }
}

