/*
 * Decompiled with CFR 0.152.
 */
package com.github.oscerd.finnhub.client;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.github.oscerd.finnhub.client.Endpoint;
import com.github.oscerd.finnhub.model.Candle;
import com.github.oscerd.finnhub.model.CompanyProfile;
import com.github.oscerd.finnhub.model.EnrichedSymbol;
import com.github.oscerd.finnhub.model.Exchange;
import com.github.oscerd.finnhub.model.Quote;
import com.github.oscerd.finnhub.model.SymbolLookup;
import java.io.IOException;
import java.util.List;
import org.apache.http.HttpEntity;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;

public class FinnhubClient {
    private CloseableHttpClient httpClient = HttpClients.createDefault();
    private String token;
    private ObjectMapper objectMapper;

    public FinnhubClient() {
    }

    public FinnhubClient(String token) {
        this.token = token;
        this.objectMapper = new ObjectMapper();
    }

    public FinnhubClient(String token, ObjectMapper objectMapper) {
        this.token = token;
        this.objectMapper = objectMapper;
    }

    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public void setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CloseableHttpClient getHttpClient() {
        return this.httpClient;
    }

    public void setHttpClient(CloseableHttpClient httpClient) {
        this.httpClient = httpClient;
    }

    public Quote getQuote(String symbol) throws ClientProtocolException, IOException {
        HttpGet get = new HttpGet(Endpoint.QUOTE.url() + "?token=" + this.token + "&symbol=" + symbol);
        String result = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        return (Quote)this.objectMapper.readValue(result, Quote.class);
    }

    public Candle getCandle(String symbol, String resolution, long startEpoch, long endEpoch) throws IOException {
        HttpGet get = new HttpGet(Endpoint.CANDLE.url() + "?token=" + this.token + "&symbol=" + symbol.toUpperCase() + "&resolution=" + resolution + "&from=" + startEpoch + "&to=" + endEpoch);
        String result = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        return (Candle)this.objectMapper.readValue(result, Candle.class);
    }

    public CompanyProfile getCompanyProfile(String symbol) throws ClientProtocolException, IOException {
        HttpGet get = new HttpGet(Endpoint.COMPANY_PROFILE.url() + "?token=" + this.token + "&symbol=" + symbol);
        String result = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        return (CompanyProfile)this.objectMapper.readValue(result, CompanyProfile.class);
    }

    public List<EnrichedSymbol> getSymbols(String exchange) throws ClientProtocolException, IOException {
        HttpGet get = new HttpGet(Endpoint.SYMBOL.url() + "?token=" + this.token + "&exchange=" + Exchange.valueOf(exchange).code());
        String result = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        return (List)this.objectMapper.readValue(result, (TypeReference)new TypeReference<List<EnrichedSymbol>>(){});
    }

    public SymbolLookup searchSymbol(String query) throws ClientProtocolException, IOException {
        HttpGet get = new HttpGet(Endpoint.SYMBOL_LOOKUP.url() + "?token=" + this.token + "&q=" + query);
        String result = null;
        try (CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)get);){
            result = EntityUtils.toString((HttpEntity)response.getEntity());
        }
        return (SymbolLookup)this.objectMapper.readValue(result, SymbolLookup.class);
    }

    public static class Builder {
        private final FinnhubClient client = new FinnhubClient();

        public Builder token(String token) {
            this.client.setToken(token);
            return this;
        }

        public Builder to(CloseableHttpClient httpClient) {
            this.client.setHttpClient(httpClient);
            return this;
        }

        public Builder mapper(ObjectMapper mapper) {
            this.client.setObjectMapper(mapper);
            return this;
        }

        public FinnhubClient build() {
            if (this.client.getObjectMapper() == null) {
                this.client.setObjectMapper(new ObjectMapper());
            }
            return this.client;
        }
    }
}

