/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.BaseModel;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.OntologyManagerImpl;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.config.OntWriterConfiguration;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalModel;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLPrimitive;

public class ModelConfig
implements InternalConfig,
Serializable {
    private static final long serialVersionUID = 3681978037818003272L;
    protected OntLoaderConfiguration readConf;
    protected OntWriterConfiguration writerConf;
    protected OntologyManagerImpl manager;

    public ModelConfig(OntologyManagerImpl m) {
        this.manager = Objects.requireNonNull(m);
    }

    public InternalModel createInternalModel(Graph graph) {
        return BaseModel.createInternalModel(graph, this.getPersonality(), this, this.manager.getOWLDataFactory(), this.getManagerCaches());
    }

    public OntologyManager getManager() {
        return this.manager;
    }

    public OntologyManagerImpl setManager(OntologyManagerImpl other) {
        OntologyManagerImpl res = this.manager;
        this.manager = other;
        return res;
    }

    public void setLoaderConf(OntLoaderConfiguration conf) {
        if (Objects.equals(this.getLoaderConfig(), conf)) {
            return;
        }
        this.readConf = conf;
    }

    public boolean useManagerConfig() {
        return this.readConf == null;
    }

    public OntLoaderConfiguration getLoaderConfig() {
        return this.readConf == null ? this.manager.getOntologyLoaderConfiguration() : this.readConf;
    }

    public OntWriterConfiguration getWriterConfig() {
        return this.writerConf == null ? this.manager.getOntologyWriterConfiguration() : this.writerConf;
    }

    public Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> getManagerCaches() {
        HashMap<Class<IRI>, InternalCache<String, IRI>> res = new HashMap<Class<IRI>, InternalCache<String, IRI>>();
        res.put(IRI.class, this.manager.iris.asCache());
        return Collections.unmodifiableMap(res);
    }

    public OntPersonality getPersonality() {
        return this.getLoaderConfig().getPersonality();
    }

    @Override
    public boolean isLoadAnnotationAxioms() {
        return this.getLoaderConfig().isLoadAnnotationAxioms();
    }

    @Override
    public boolean isAllowBulkAnnotationAssertions() {
        return this.getLoaderConfig().isAllowBulkAnnotationAssertions();
    }

    @Override
    public boolean isIgnoreAnnotationAxiomOverlaps() {
        return this.getLoaderConfig().isIgnoreAnnotationAxiomOverlaps();
    }

    @Override
    public boolean isAllowReadDeclarations() {
        return this.getLoaderConfig().isAllowReadDeclarations();
    }

    @Override
    public boolean isSplitAxiomAnnotations() {
        return this.getLoaderConfig().isSplitAxiomAnnotations();
    }

    @Override
    public boolean isIgnoreAxiomsReadErrors() {
        return this.getLoaderConfig().isIgnoreAxiomsReadErrors();
    }

    @Override
    public int getLoadNodesCacheSize() {
        return this.getLoaderConfig().getLoadNodesCacheSize();
    }

    @Override
    public int getLoadObjectsCacheSize() {
        return this.getLoaderConfig().getLoadObjectsCacheSize();
    }

    @Override
    public int getModelCacheLevel() {
        return this.getLoaderConfig().getModelCacheLevel();
    }

    @Override
    public boolean parallel() {
        return this.manager.isConcurrent();
    }

    public boolean hasChanges(OntLoaderConfiguration other) {
        return ModelConfig.hasChanges(this.getLoaderConfig(), other);
    }

    public static boolean hasChanges(OntLoaderConfiguration left, OntLoaderConfiguration right) {
        if (left == null && right != null) {
            return true;
        }
        if (left != null && right == null) {
            return true;
        }
        if (left == right) {
            return false;
        }
        Stream<Function> fields = Stream.of(OntLoaderConfiguration::isLoadAnnotationAxioms, OntLoaderConfiguration::isAllowBulkAnnotationAssertions, OntLoaderConfiguration::isIgnoreAnnotationAxiomOverlaps, OntLoaderConfiguration::isAllowReadDeclarations, OntLoaderConfiguration::isSplitAxiomAnnotations, OntLoaderConfiguration::isIgnoreAxiomsReadErrors, OntLoaderConfiguration::getLoadNodesCacheSize, OntLoaderConfiguration::getLoadObjectsCacheSize, OntLoaderConfiguration::getModelCacheLevel);
        return fields.anyMatch(c -> c.apply(left) != c.apply(right));
    }
}

