/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.BaseModel;
import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.HasAdapter;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.ModelConfig;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyCreator;
import com.github.owlcs.ontapi.OntologyFactory;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.OntologyManagerImpl;
import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.config.OntWriterConfiguration;
import com.github.owlcs.ontapi.internal.InternalConfig;
import java.util.Objects;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;
import org.semanticweb.owlapi.model.OntologyConfigurator;

public class OWLAdapter
implements HasAdapter.Adapter {
    private static OWLAdapter instance = new OWLAdapter();

    public static OWLAdapter get() {
        return instance;
    }

    public static void set(OWLAdapter adapter) {
        instance = Objects.requireNonNull(adapter, "Null adapter");
    }

    @Override
    public OntologyManager asONT(OWLOntologyManager manager) {
        try {
            return (OntologyManager)OntApiException.notNull(manager);
        }
        catch (ClassCastException c) {
            throw new OntApiException.IllegalState("Wrong Ontology Manager", c);
        }
    }

    public DataFactory asONT(OWLDataFactory factory) {
        try {
            return (DataFactory)OntApiException.notNull(factory);
        }
        catch (ClassCastException c) {
            throw new OntApiException.IllegalState("Wrong Ontology Data Factory", c);
        }
    }

    public OntConfig asONT(OntologyConfigurator conf) {
        return conf instanceof OntConfig ? (OntConfig)conf : OntConfig.copy(conf);
    }

    @Override
    public OntLoaderConfiguration asONT(OWLOntologyLoaderConfiguration conf) {
        return conf instanceof OntLoaderConfiguration ? (OntLoaderConfiguration)conf : new OntLoaderConfiguration(conf);
    }

    public OntWriterConfiguration asONT(OWLOntologyWriterConfiguration conf) {
        return conf instanceof OntWriterConfiguration ? (OntWriterConfiguration)conf : new OntWriterConfiguration(conf);
    }

    @Override
    public ID asONT(OWLOntologyID id) {
        return ID.asONT(id);
    }

    public OWLOntologyFactory.OWLOntologyCreationHandler asHandler(OWLOntologyManager m) {
        return this.asIMPL(m);
    }

    public OntologyManagerImpl asIMPL(OWLOntologyManager manager) {
        try {
            return (OntologyManagerImpl)OntApiException.notNull(manager);
        }
        catch (ClassCastException c) {
            throw new OntApiException.IllegalState("Wrong Ontology Manager Impl", c);
        }
    }

    public Ontology asONT(OWLOntology ont) {
        return (Ontology)ont;
    }

    public OntologyFactory.Builder asBuilder(OntologyCreator creator) {
        return (OntologyFactory.Builder)creator;
    }

    public OntologyFactory asONT(OWLOntologyFactory factory) {
        try {
            return (OntologyFactory)OntApiException.notNull(factory);
        }
        catch (ClassCastException c) {
            throw new OntApiException.IllegalState("Unexpected factory instance: " + factory, c);
        }
    }

    public BaseModel asBaseModel(Ontology ont) {
        return (BaseModel)((Object)ont);
    }

    public ModelConfig asModelConfig(InternalConfig conf) {
        return (ModelConfig)conf;
    }
}

