/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.RWLockedOntology;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.semanticweb.owlapi.io.OWLOntologyDocumentTarget;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.ChangeDetails;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitor;
import org.semanticweb.owlapi.model.OWLNamedObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLObjectVisitorEx;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyStorageException;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.ChangeApplied;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;

@ParametersAreNonnullByDefault
public class OWLOntologyWrapper
extends RWLockedOntology {
    protected final OWLOntology delegate;

    public OWLOntologyWrapper(OWLOntology delegate, ReadWriteLock lock) {
        super(lock);
        this.delegate = Objects.requireNonNull(delegate, "Null delegate");
    }

    public int hashCode() {
        return this.withReadLockToObject(this.delegate::hashCode);
    }

    public boolean equals(@Nullable Object obj) {
        return this.withReadLockToObject(() -> {
            if (obj == this) {
                return true;
            }
            return this.delegate.equals(obj instanceof OWLOntologyWrapper ? ((OWLOntologyWrapper)obj).delegate : obj);
        });
    }

    public String toString() {
        return this.withReadLockToObject(this.delegate::toString);
    }

    public int compareTo(OWLObject o) {
        return this.withReadLockToObject(() -> this.delegate.compareTo((Object)o));
    }

    public void accept(OWLNamedObjectVisitor visitor) {
        this.delegate.accept(visitor);
    }

    public <O> O accept(OWLNamedObjectVisitorEx<O> visitor) {
        return (O)this.delegate.accept(visitor);
    }

    public void accept(OWLObjectVisitor visitor) {
        this.delegate.accept(visitor);
    }

    public <O> O accept(OWLObjectVisitorEx<O> visitor) {
        return (O)this.delegate.accept(visitor);
    }

    public OWLOntologyManager getOWLOntologyManager() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).getOWLOntologyManager());
    }

    public void setOWLOntologyManager(@Nullable OWLOntologyManager manager) {
        this.withWriteLock(() -> this.delegate.setOWLOntologyManager(manager));
    }

    public OWLOntologyID getOntologyID() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).getOntologyID());
    }

    public boolean isAnonymous() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).isAnonymous());
    }

    public boolean isEmpty() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).isEmpty());
    }

    public Stream<IRI> directImportsDocuments() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).directImportsDocuments());
    }

    public Stream<OWLOntology> directImports() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).directImports());
    }

    public Stream<OWLOntology> imports() {
        return this.withReadLockToObject(() -> this.getOWLOntologyManager().imports((OWLOntology)this));
    }

    public Stream<OWLOntology> importsClosure() {
        return this.withReadLockToObject(() -> this.getOWLOntologyManager().importsClosure((OWLOntology)this));
    }

    public Stream<OWLClassAxiom> generalClassAxioms() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).generalClassAxioms());
    }

    public Stream<OWLEntity> signature() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).signature());
    }

    public boolean isDeclared(OWLEntity entity) {
        return this.withReadLockToObject(() -> this.delegate.isDeclared(entity));
    }

    public boolean containsEntityInSignature(OWLEntity entity) {
        return this.withReadLockToObject(() -> this.delegate.containsEntityInSignature(entity));
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        return this.withReadLockToObject(() -> this.delegate.containsEntitiesOfTypeInSignature(type));
    }

    public Stream<OWLAxiom> axioms() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).axioms());
    }

    public Stream<OWLLogicalAxiom> logicalAxioms() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).logicalAxioms());
    }

    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> type) {
        return this.withReadLockToObject(() -> this.delegate.axioms(type));
    }

    public boolean containsAxiom(OWLAxiom axiom) {
        return this.withReadLockToObject(() -> this.delegate.containsAxiom(axiom));
    }

    public int getAxiomCount() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).getAxiomCount());
    }

    public int getLogicalAxiomCount() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).getLogicalAxiomCount());
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> type) {
        return this.withReadLockToObject(() -> this.delegate.getAxiomCount(type));
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        return this.withReadLockToObject(() -> this.delegate.containsAxiomIgnoreAnnotations(axiom));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom) {
        return this.withReadLockToObject(() -> this.delegate.axiomsIgnoreAnnotations(axiom));
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive primitive) {
        return this.withReadLockToObject(() -> this.delegate.referencingAxioms(primitive));
    }

    public Stream<OWLClassAxiom> axioms(OWLClass clazz) {
        return this.withReadLockToObject(() -> this.delegate.axioms(clazz));
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.axioms(property));
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property) {
        return this.withReadLockToObject(() -> this.delegate.axioms(property));
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual) {
        return this.withReadLockToObject(() -> this.delegate.axioms(individual));
    }

    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property) {
        return this.withReadLockToObject(() -> this.delegate.axioms(property));
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype) {
        return this.withReadLockToObject(() -> this.delegate.axioms(datatype));
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).referencedAnonymousIndividuals());
    }

    public boolean containsDatatypeInSignature(IRI iri) {
        return this.withReadLockToObject(() -> this.delegate.containsDatatypeInSignature(iri));
    }

    public boolean containsEntityInSignature(IRI iri) {
        return this.withReadLockToObject(() -> this.delegate.containsEntityInSignature(iri));
    }

    public boolean containsClassInSignature(IRI iri) {
        return this.withReadLockToObject(() -> this.delegate.containsClassInSignature(iri));
    }

    public boolean containsObjectPropertyInSignature(IRI iri) {
        return this.withReadLockToObject(() -> this.delegate.containsObjectPropertyInSignature(iri));
    }

    public boolean containsDataPropertyInSignature(IRI iri) {
        return this.withReadLockToObject(() -> this.delegate.containsDataPropertyInSignature(iri));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        return this.withReadLockToObject(() -> this.delegate.containsAnnotationPropertyInSignature(iri));
    }

    public boolean containsIndividualInSignature(IRI iri) {
        return this.withReadLockToObject(() -> this.delegate.containsIndividualInSignature(iri));
    }

    public Set<IRI> getPunnedIRIs(Imports imports) {
        return this.withReadLockToObject(() -> this.delegate.getPunnedIRIs(imports));
    }

    public boolean containsReference(OWLEntity entity) {
        return this.withReadLockToObject(() -> this.delegate.containsReference(entity));
    }

    public Stream<OWLEntity> entitiesInSignature(IRI iri) {
        return this.withReadLockToObject(() -> this.delegate.entitiesInSignature(iri));
    }

    public boolean contains(OWLAxiomSearchFilter filter, Object o) {
        return this.withReadLockToObject(() -> this.delegate.contains(filter, o));
    }

    public Stream<OWLAnnotationPropertyDomainAxiom> annotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        return this.withReadLockToObject(() -> this.delegate.annotationPropertyDomainAxioms(property));
    }

    public Stream<OWLAnnotationPropertyRangeAxiom> annotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        return this.withReadLockToObject(() -> this.delegate.annotationPropertyRangeAxioms(property));
    }

    public Stream<OWLImportsDeclaration> importsDeclarations() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).importsDeclarations());
    }

    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key) {
        return this.withReadLockToObject(() -> this.delegate.axioms(filter, key));
    }

    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, Class<? extends OWLObject> explicitType, OWLObject entity, Navigation navigation) {
        return this.withReadLockToObject(() -> this.delegate.axioms(type, explicitType, entity, navigation));
    }

    public Stream<OWLSubAnnotationPropertyOfAxiom> subAnnotationPropertyOfAxioms(OWLAnnotationProperty property) {
        return this.withReadLockToObject(() -> this.delegate.subAnnotationPropertyOfAxioms(property));
    }

    public Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype datatype) {
        return this.withReadLockToObject(() -> this.delegate.datatypeDefinitions(datatype));
    }

    public Stream<OWLDisjointObjectPropertiesAxiom> disjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.disjointObjectPropertiesAxioms(property));
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).objectPropertiesInSignature());
    }

    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity) {
        return this.withReadLockToObject(() -> this.delegate.annotationAssertionAxioms(entity));
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).annotationPropertiesInSignature());
    }

    public Stream<OWLAnnotation> annotations() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).annotations());
    }

    public Stream<OWLAnnotation> annotations(OWLAnnotationProperty p) {
        return this.withReadLockToObject(() -> this.delegate.annotations(p));
    }

    public Stream<OWLAnnotation> annotations(Predicate<OWLAnnotation> p) {
        return this.withReadLockToObject(() -> this.delegate.annotations(p));
    }

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).anonymousIndividuals());
    }

    public Stream<OWLAsymmetricObjectPropertyAxiom> asymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.asymmetricObjectPropertyAxioms(property));
    }

    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, OWLObject entity, Navigation navigation) {
        return this.withReadLockToObject(() -> this.delegate.axioms(type, entity, navigation));
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLClassExpression ce) {
        return this.withReadLockToObject(() -> this.delegate.classAssertionAxioms(ce));
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLIndividual individual) {
        return this.withReadLockToObject(() -> this.delegate.classAssertionAxioms(individual));
    }

    public Stream<OWLClass> classesInSignature() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).classesInSignature());
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).dataPropertiesInSignature());
    }

    public Stream<OWLDataPropertyAssertionAxiom> dataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLockToObject(() -> this.delegate.dataPropertyAssertionAxioms(individual));
    }

    public Stream<OWLDataPropertyDomainAxiom> dataPropertyDomainAxioms(OWLDataProperty property) {
        return this.withReadLockToObject(() -> this.delegate.dataPropertyDomainAxioms(property));
    }

    public Stream<OWLDataPropertyRangeAxiom> dataPropertyRangeAxioms(OWLDataProperty property) {
        return this.withReadLockToObject(() -> this.delegate.dataPropertyRangeAxioms(property));
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSubProperty(OWLDataProperty property) {
        return this.withReadLockToObject(() -> this.delegate.dataSubPropertyAxiomsForSubProperty(property));
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.dataSubPropertyAxiomsForSuperProperty(property));
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).datatypesInSignature());
    }

    public Stream<OWLDeclarationAxiom> declarationAxioms(OWLEntity subject) {
        return this.withReadLockToObject(() -> this.delegate.declarationAxioms(subject));
    }

    public Stream<OWLDifferentIndividualsAxiom> differentIndividualAxioms(OWLIndividual individual) {
        return this.withReadLockToObject(() -> this.delegate.differentIndividualAxioms(individual));
    }

    public Stream<OWLDisjointClassesAxiom> disjointClassesAxioms(OWLClass clazz) {
        return this.withReadLockToObject(() -> this.delegate.disjointClassesAxioms(clazz));
    }

    public Stream<OWLDisjointDataPropertiesAxiom> disjointDataPropertiesAxioms(OWLDataProperty property) {
        return this.withReadLockToObject(() -> this.delegate.disjointDataPropertiesAxioms(property));
    }

    public Stream<OWLDisjointUnionAxiom> disjointUnionAxioms(OWLClass clazz) {
        return this.withReadLockToObject(() -> this.delegate.disjointUnionAxioms(clazz));
    }

    public Stream<OWLEquivalentClassesAxiom> equivalentClassesAxioms(OWLClass clazz) {
        return this.withReadLockToObject(() -> this.delegate.equivalentClassesAxioms(clazz));
    }

    public Stream<OWLEquivalentDataPropertiesAxiom> equivalentDataPropertiesAxioms(OWLDataProperty property) {
        return this.withReadLockToObject(() -> this.delegate.equivalentDataPropertiesAxioms(property));
    }

    public Stream<OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.equivalentObjectPropertiesAxioms(property));
    }

    public Stream<OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.functionalDataPropertyAxioms(property));
    }

    public Stream<OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.functionalObjectPropertyAxioms(property));
    }

    public Stream<OWLHasKeyAxiom> hasKeyAxioms(OWLClass clazz) {
        return this.withReadLockToObject(() -> this.delegate.hasKeyAxioms(clazz));
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).individualsInSignature());
    }

    public Stream<OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.inverseFunctionalObjectPropertyAxioms(property));
    }

    public Stream<OWLInverseObjectPropertiesAxiom> inverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.inverseObjectPropertyAxioms(property));
    }

    public Stream<OWLIrreflexiveObjectPropertyAxiom> irreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.irreflexiveObjectPropertyAxioms(property));
    }

    public Stream<OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLockToObject(() -> this.delegate.negativeDataPropertyAssertionAxioms(individual));
    }

    public Stream<OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLockToObject(() -> this.delegate.negativeObjectPropertyAssertionAxioms(individual));
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).nestedClassExpressions());
    }

    public Stream<OWLObjectPropertyAssertionAxiom> objectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.withReadLockToObject(() -> this.delegate.objectPropertyAssertionAxioms(individual));
    }

    public Stream<OWLObjectPropertyDomainAxiom> objectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.objectPropertyDomainAxioms(property));
    }

    public Stream<OWLObjectPropertyRangeAxiom> objectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.objectPropertyRangeAxioms(property));
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.objectSubPropertyAxiomsForSubProperty(property));
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.objectSubPropertyAxiomsForSuperProperty(property));
    }

    public Stream<OWLReflexiveObjectPropertyAxiom> reflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.reflexiveObjectPropertyAxioms(property));
    }

    public Stream<OWLSameIndividualAxiom> sameIndividualAxioms(OWLIndividual individual) {
        return this.withReadLockToObject(() -> this.delegate.sameIndividualAxioms(individual));
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSubClass(OWLClass clazz) {
        return this.withReadLockToObject(() -> this.delegate.subClassAxiomsForSubClass(clazz));
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSuperClass(OWLClass clazz) {
        return this.withReadLockToObject(() -> this.delegate.subClassAxiomsForSuperClass(clazz));
    }

    public Stream<OWLSymmetricObjectPropertyAxiom> symmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.symmetricObjectPropertyAxioms(property));
    }

    public Stream<OWLTransitiveObjectPropertyAxiom> transitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.withReadLockToObject(() -> this.delegate.transitiveObjectPropertyAxioms(property));
    }

    public void saveOntology() throws OWLOntologyStorageException {
        this.withReadLock(() -> ((OWLOntology)this.delegate).saveOntology());
    }

    public void saveOntology(IRI iri) throws OWLOntologyStorageException {
        this.withReadLock(() -> this.delegate.saveOntology(iri));
    }

    public void saveOntology(OutputStream stream) throws OWLOntologyStorageException {
        this.withReadLock(() -> this.delegate.saveOntology(stream));
    }

    public void saveOntology(OWLDocumentFormat format) throws OWLOntologyStorageException {
        this.withReadLock(() -> this.delegate.saveOntology(format));
    }

    public void saveOntology(OWLDocumentFormat format, IRI iri) throws OWLOntologyStorageException {
        this.withReadLock(() -> this.delegate.saveOntology(format, iri));
    }

    public void saveOntology(OWLDocumentFormat format, OutputStream stream) throws OWLOntologyStorageException {
        this.withReadLock(() -> this.delegate.saveOntology(format, stream));
    }

    public void saveOntology(OWLOntologyDocumentTarget target) throws OWLOntologyStorageException {
        this.withReadLock(() -> this.delegate.saveOntology(target));
    }

    public void saveOntology(OWLDocumentFormat format, OWLOntologyDocumentTarget target) throws OWLOntologyStorageException {
        this.withReadLock(() -> this.delegate.saveOntology(format, target));
    }

    @Nullable
    public OWLDocumentFormat getFormat() {
        return this.withReadLockToObject(() -> ((OWLOntology)this.delegate).getFormat());
    }

    public ChangeApplied applyDirectChange(OWLOntologyChange change) {
        return this.withWriteLockToObject(() -> this.delegate.applyDirectChange(change));
    }

    public ChangeApplied applyChange(OWLOntologyChange change) {
        return this.withWriteLockToObject(() -> this.delegate.applyChange(change));
    }

    public ChangeDetails applyChangesAndGetDetails(List<? extends OWLOntologyChange> changes) {
        return this.withWriteLockToObject(() -> this.delegate.applyChangesAndGetDetails(changes));
    }

    public ChangeApplied addAxiom(OWLAxiom axiom) {
        return this.withWriteLockToObject(() -> this.delegate.addAxiom(axiom));
    }

    public ChangeApplied addAxioms(Collection<? extends OWLAxiom> axioms) {
        return this.withWriteLockToObject(() -> this.delegate.addAxioms(axioms));
    }

    public ChangeApplied addAxioms(OWLAxiom ... axioms) {
        return this.withWriteLockToObject(() -> this.delegate.addAxioms(axioms));
    }

    public ChangeApplied add(OWLAxiom axiom) {
        return this.withWriteLockToObject(() -> this.delegate.add(axiom));
    }

    public ChangeApplied add(Collection<? extends OWLAxiom> axioms) {
        return this.withWriteLockToObject(() -> this.delegate.add(axioms));
    }

    public ChangeApplied add(OWLAxiom ... axioms) {
        return this.withWriteLockToObject(() -> this.delegate.add(axioms));
    }

    public ChangeApplied removeAxiom(OWLAxiom axiom) {
        return this.withWriteLockToObject(() -> this.delegate.removeAxiom(axiom));
    }

    public ChangeApplied removeAxioms(Collection<? extends OWLAxiom> axioms) {
        return this.withWriteLockToObject(() -> this.delegate.removeAxioms(axioms));
    }

    public ChangeApplied removeAxioms(OWLAxiom ... axioms) {
        return this.withWriteLockToObject(() -> this.delegate.removeAxioms(axioms));
    }

    public ChangeApplied remove(OWLAxiom axiom) {
        return this.withWriteLockToObject(() -> this.delegate.remove(axiom));
    }

    public ChangeApplied remove(Collection<? extends OWLAxiom> axioms) {
        return this.withWriteLockToObject(() -> this.delegate.remove(axioms));
    }

    public ChangeApplied remove(OWLAxiom ... axioms) {
        return this.withWriteLockToObject(() -> this.delegate.remove(axioms));
    }
}

