/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.BaseModel;
import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.ModelConfig;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntFormat;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.internal.InternalModel;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.owlapi.OWLObjectImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.jena.graph.Graph;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasImportsClosure;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationObject;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomCollection;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;

@ParametersAreNonnullByDefault
public abstract class OntBaseModelImpl
implements OWLOntology,
BaseModel {
    public static final OntFormat DEFAULT_SERIALIZATION_FORMAT = OntFormat.RDF_THRIFT;
    private static final long serialVersionUID = 7605836729147058594L;
    protected transient InternalModel base;
    protected transient ModelConfig config;
    protected int hashCode;

    protected OntBaseModelImpl(Graph graph, ModelConfig conf) {
        this.config = Objects.requireNonNull(conf);
        this.base = conf.createInternalModel(Objects.requireNonNull(graph));
    }

    @Override
    public InternalModel getBase() {
        return this.base;
    }

    @Override
    public void setBase(InternalModel m) {
        this.base = Objects.requireNonNull(m);
    }

    @Override
    public ModelConfig getConfig() {
        return this.config;
    }

    @Override
    public void setConfig(ModelConfig conf) {
        this.config = Objects.requireNonNull(conf);
    }

    public OntologyManager getOWLOntologyManager() {
        return this.getConfig().getManager();
    }

    public DataFactory getDataFactory() {
        return this.getOWLOntologyManager().getOWLDataFactory();
    }

    public void setOWLOntologyManager(@Nullable OWLOntologyManager manager) {
        throw new OntApiException.Unsupported("Misuse: attempt to set new manager: " + manager);
    }

    public ID getOntologyID() {
        return this.base.getOntologyID();
    }

    protected void setOntologyID(OWLOntologyID id) {
        this.base.setOntologyID(id);
        this.hashCode = 0;
    }

    public boolean isAnonymous() {
        return this.base.getID().isAnon();
    }

    public boolean isEmpty() {
        return this.base.isOntologyEmpty();
    }

    public Stream<OWLAnnotation> annotations() {
        return this.base.listOWLAnnotations();
    }

    public Stream<OWLOntology> imports() {
        return this.getOWLOntologyManager().imports(this);
    }

    public Stream<OWLImportsDeclaration> importsDeclarations() {
        return this.base.listOWLImportDeclarations();
    }

    public Stream<IRI> directImportsDocuments() {
        return this.importsDeclarations().map(OWLImportsDeclaration::getIRI);
    }

    public Stream<OWLOntology> directImports() {
        return this.getOWLOntologyManager().directImports(this);
    }

    public Stream<OWLOntology> importsClosure() {
        return this.getOWLOntologyManager().importsClosure(this);
    }

    public Stream<OWLClass> classesInSignature() {
        return this.base.listOWLClasses();
    }

    public Stream<OWLClassExpression> nestedClassExpressions() {
        return this.base.listOWLClassExpressions();
    }

    public Stream<OWLAnonymousIndividual> anonymousIndividuals() {
        return this.base.listOWLAnonymousIndividuals();
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals() {
        return this.anonymousIndividuals();
    }

    public Stream<OWLNamedIndividual> individualsInSignature() {
        return this.base.listOWLNamedIndividuals();
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature() {
        return this.base.listOWLDataProperties();
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature() {
        return this.base.listOWLObjectProperties();
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature() {
        return this.base.listOWLAnnotationProperties();
    }

    public Stream<OWLDatatype> datatypesInSignature() {
        return this.base.listOWLDatatypes();
    }

    public Stream<OWLEntity> signature() {
        return Stream.of(this.classesInSignature(), this.objectPropertiesInSignature(), this.dataPropertiesInSignature(), this.individualsInSignature(), this.datatypesInSignature(), this.annotationPropertiesInSignature()).flatMap(Function.identity());
    }

    public Stream<OWLEntity> entitiesInSignature(@Nullable IRI iri) {
        return this.base.listOWLEntities(iri);
    }

    public Set<IRI> getPunnedIRIs(Imports imports) {
        return this.base.listPunningIRIs(Imports.INCLUDED == imports).collect(Collectors.toSet());
    }

    public boolean isDeclared(OWLEntity entity) {
        return this.base.containsOWLDeclaration(entity);
    }

    public boolean containsReference(OWLEntity entity) {
        return this.referencingAxioms((OWLPrimitive)entity).findFirst().isPresent();
    }

    public boolean containsClassInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLClass(iri));
    }

    public boolean containsObjectPropertyInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLObjectProperty(iri));
    }

    public boolean containsDataPropertyInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLDataProperty(iri));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLAnnotationProperty(iri));
    }

    public boolean containsDatatypeInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLDatatype(iri));
    }

    public boolean containsIndividualInSignature(IRI iri) {
        return this.base.containsOWLEntity(this.getDataFactory().getOWLNamedIndividual(iri));
    }

    public boolean containsEntityInSignature(IRI iri) {
        return this.containsClassInSignature(iri) || this.containsObjectPropertyInSignature(iri) || this.containsDataPropertyInSignature(iri) || this.containsIndividualInSignature(iri) || this.containsDatatypeInSignature(iri) || this.containsAnnotationPropertyInSignature(iri);
    }

    public boolean containsEntityInSignature(OWLEntity entity) {
        if (entity.isOWLClass()) {
            return this.containsClassInSignature(entity.getIRI());
        }
        if (entity.isOWLDatatype()) {
            return this.containsDatatypeInSignature(entity.getIRI());
        }
        if (entity.isOWLNamedIndividual()) {
            return this.containsIndividualInSignature(entity.getIRI());
        }
        if (entity.isOWLAnnotationProperty()) {
            return this.containsAnnotationPropertyInSignature(entity.getIRI());
        }
        if (entity.isOWLObjectProperty()) {
            return this.containsObjectPropertyInSignature(entity.getIRI());
        }
        if (entity.isOWLDataProperty()) {
            return this.containsDataPropertyInSignature(entity.getIRI());
        }
        throw new OntApiException.IllegalArgument("Unsupported entity: " + entity);
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type) {
        if (EntityType.CLASS.equals(type)) {
            return this.classesInSignature().findFirst().isPresent();
        }
        if (EntityType.DATA_PROPERTY.equals(type)) {
            return this.dataPropertiesInSignature().findFirst().isPresent();
        }
        if (EntityType.OBJECT_PROPERTY.equals(type)) {
            return this.objectPropertiesInSignature().findFirst().isPresent();
        }
        if (EntityType.ANNOTATION_PROPERTY.equals(type)) {
            return this.annotationPropertiesInSignature().findFirst().isPresent();
        }
        if (EntityType.DATATYPE.equals(type)) {
            return this.datatypesInSignature().findFirst().isPresent();
        }
        if (EntityType.NAMED_INDIVIDUAL.equals(type)) {
            return this.individualsInSignature().findFirst().isPresent();
        }
        throw new IllegalArgumentException("Entity type " + type + " is not valid for entity presence check");
    }

    public Stream<OWLAxiom> axioms() {
        return this.base.listOWLAxioms();
    }

    public <T extends OWLAxiom> Stream<T> axioms(AxiomType<T> axiomType) {
        return this.base.listOWLAxioms(axiomType);
    }

    public Stream<OWLClassAxiom> axioms(OWLClass clazz) {
        Stream subClassOf = this.base.listOWLSubClassOfAxiomsBySubject(clazz);
        Stream disjointUnion = this.base.listOWLDisjointUnionAxioms(clazz);
        Stream disjoint = this.base.listOWLDisjointClassesAxioms(clazz);
        Stream equivalent = this.base.listOWLEquivalentClassesAxioms(clazz);
        return Stream.of(subClassOf, disjointUnion, disjoint, equivalent).flatMap(Function.identity());
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property) {
        Stream subPropertyOf = this.base.listOWLSubObjectPropertyOfAxiomsBySubject(property);
        Stream nary = Stream.of(this.base.listOWLEquivalentObjectPropertiesAxioms(property), this.base.listOWLDisjointObjectPropertiesAxioms(property), this.base.listOWLInverseObjectPropertiesAxioms(property)).flatMap(Function.identity());
        Stream unary = Stream.of(this.base.listOWLObjectPropertyDomainAxioms(property), this.base.listOWLObjectPropertyRangeAxioms(property), this.base.listOWLTransitiveObjectPropertyAxioms(property), this.base.listOWLIrreflexiveObjectPropertyAxioms(property), this.base.listOWLReflexiveObjectPropertyAxioms(property), this.base.listOWLSymmetricObjectPropertyAxioms(property), this.base.listOWLAsymmetricObjectPropertyAxioms(property), this.base.listOWLFunctionalObjectPropertyAxioms(property), this.base.listOWLInverseFunctionalObjectPropertyAxioms(property)).flatMap(Function.identity());
        return Stream.of(subPropertyOf, nary, unary).flatMap(Function.identity());
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property) {
        Stream subPropertyOf = this.base.listOWLSubDataPropertyOfAxiomsBySubject(property);
        Stream nary = Stream.of(this.base.listOWLEquivalentDataPropertiesAxioms(property), this.base.listOWLDisjointDataPropertiesAxioms(property)).flatMap(Function.identity());
        Stream unary = Stream.of(this.base.listOWLDataPropertyDomainAxioms(property), this.base.listOWLDataPropertyRangeAxioms(property), this.base.listOWLFunctionalDataPropertyAxioms(property)).flatMap(Function.identity());
        return Stream.of(subPropertyOf, nary, unary).flatMap(Function.identity());
    }

    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property) {
        return Stream.of(this.base.listOWLSubAnnotationPropertyOfAxiomsBySubject(property), this.base.listOWLAnnotationPropertyDomainAxioms(property), this.base.listOWLAnnotationPropertyRangeAxioms(property)).flatMap(Function.identity());
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual) {
        Stream classAssertion = this.base.listOWLClassAssertionAxioms(individual);
        Stream nary = Stream.concat(this.base.listOWLSameIndividualAxioms(individual), this.base.listOWLDifferentIndividualsAxioms(individual));
        Stream propertyAssertion = Stream.of(this.base.listOWLObjectPropertyAssertionAxioms(individual), this.base.listOWLDataPropertyAssertionAxioms(individual), this.base.listOWLNegativeObjectPropertyAssertionAxioms(individual), this.base.listOWLNegativeDataPropertyAssertionAxioms(individual)).flatMap(Function.identity());
        return Stream.of(classAssertion, nary, propertyAssertion).flatMap(Function.identity());
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype) {
        return this.base.listOWLDatatypeDefinitionAxioms(datatype);
    }

    public <A extends OWLAxiom> Stream<A> axioms(OWLAxiomSearchFilter filter, Object key) {
        return this.base.listOWLAxioms(filter.getAxiomTypes()).filter(a -> filter.pass(a, key)).map(x -> x);
    }

    public <A extends OWLAxiom> Stream<A> axioms(Class<A> type, @Nullable Class<? extends OWLObject> view, OWLObject object, @Nullable Navigation position) {
        return this.axioms(type, object, Navigation.IN_SUB_POSITION == position);
    }

    public <A extends OWLAxiom> Stream<A> axioms(Class<A> type, OWLObject object, boolean sub) {
        if (OWLDeclarationAxiom.class.equals(type) && object instanceof OWLEntity) {
            return this.base.listOWLDeclarationAxioms((OWLEntity)object);
        }
        if (object instanceof OWLClassExpression) {
            return this.axiomsByClassExpression(type, (OWLClassExpression)object, sub);
        }
        if (object instanceof OWLDataRange) {
            return this.axiomsByDataRange(type, (OWLDataRange)object, sub);
        }
        if (object instanceof OWLIndividual) {
            return this.axiomsByIndividual(type, (OWLIndividual)object, sub);
        }
        if (object instanceof OWLObjectPropertyExpression) {
            return this.axiomsByObjectProperty(type, (OWLObjectPropertyExpression)object, sub);
        }
        if (object instanceof OWLDataProperty) {
            return this.axiomsByDataProperty(type, (OWLDataProperty)object, sub);
        }
        if (object instanceof OWLAnnotationProperty) {
            return this.axiomsByAnnotationProperty(type, (OWLAnnotationProperty)object, sub);
        }
        if (OWLAnnotationAssertionAxiom.class.equals(type)) {
            if (object instanceof OWLAnnotationSubject) {
                return this.base.listOWLAnnotationAssertionAxioms((OWLAnnotationSubject)object);
            }
            if (object instanceof OWLAnnotationObject) {
                return this.base.listOWLAxioms(OWLAnnotationAssertionAxiom.class).filter(a -> object.equals(a.getValue()));
            }
        }
        throw new OntApiException.IllegalArgument();
    }

    private Stream<? extends OWLAxiom> axiomsByClassExpression(Class<? extends OWLAxiom> type, OWLClassExpression clazz, boolean subject) throws ClassCastException {
        if (OWLSubClassOfAxiom.class.equals(type)) {
            if (clazz.isOWLClass()) {
                return subject ? this.base.listOWLSubClassOfAxiomsBySubject(clazz.asOWLClass()) : this.base.listOWLSubClassOfAxiomsByObject(clazz.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> clazz.equals(subject ? a.getSubClass() : a.getSuperClass()));
        }
        if (OWLEquivalentClassesAxiom.class.equals(type)) {
            if (clazz.isOWLClass()) {
                return this.base.listOWLEquivalentClassesAxioms(clazz.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLEquivalentClassesAxiom.class).filter(a -> a.contains(clazz));
        }
        if (OWLDisjointClassesAxiom.class.equals(type)) {
            if (clazz.isOWLClass()) {
                return this.base.listOWLDisjointClassesAxioms(clazz.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLDisjointClassesAxiom.class).filter(a -> a.contains(clazz));
        }
        if (OWLDisjointUnionAxiom.class.equals(type)) {
            if (subject) {
                return this.base.listOWLDisjointUnionAxioms(clazz.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLDisjointUnionAxiom.class).filter(a -> a.classExpressions().anyMatch(clazz::equals));
        }
        if (OWLHasKeyAxiom.class.equals(type)) {
            if (clazz.isOWLClass()) {
                return this.base.listOWLHasKeyAxioms(clazz.asOWLClass());
            }
            return this.base.listOWLAxioms(OWLHasKeyAxiom.class).filter(x -> x.getClassExpression().equals(clazz));
        }
        if (OWLClassAssertionAxiom.class.equals(type)) {
            return this.base.listOWLClassAssertionAxioms(clazz);
        }
        return this.base.listOWLAxioms(type, (OWLObject)clazz);
    }

    private Stream<? extends OWLAxiom> axiomsByDataRange(Class<? extends OWLAxiom> type, OWLDataRange range, boolean subject) throws ClassCastException {
        if (OWLDatatypeDefinitionAxiom.class.equals(type)) {
            if (subject) {
                return this.base.listOWLDatatypeDefinitionAxioms(range.asOWLDatatype());
            }
            return this.base.listOWLAxioms(OWLDatatypeDefinitionAxiom.class).filter(x -> x.getDataRange().equals(range));
        }
        return this.base.listOWLAxioms(type, (OWLObject)range);
    }

    private Stream<? extends OWLAxiom> axiomsByIndividual(Class<? extends OWLAxiom> type, OWLIndividual individual, boolean subject) {
        if (OWLClassAssertionAxiom.class.equals(type)) {
            return this.base.listOWLClassAssertionAxioms(individual);
        }
        if (OWLSameIndividualAxiom.class.equals(type)) {
            return this.base.listOWLSameIndividualAxioms(individual);
        }
        if (OWLDifferentIndividualsAxiom.class.equals(type)) {
            return this.base.listOWLDifferentIndividualsAxioms(individual);
        }
        if (OWLObjectPropertyAssertionAxiom.class.equals(type)) {
            if (subject) {
                return this.base.listOWLObjectPropertyAssertionAxioms(individual);
            }
            return this.base.listOWLAxioms(OWLObjectPropertyAssertionAxiom.class).filter(x -> ((OWLIndividual)x.getObject()).equals(individual));
        }
        if (OWLNegativeObjectPropertyAssertionAxiom.class.equals(type)) {
            if (subject) {
                return this.base.listOWLNegativeObjectPropertyAssertionAxioms(individual);
            }
            return this.base.listOWLAxioms(OWLNegativeObjectPropertyAssertionAxiom.class).filter(x -> ((OWLIndividual)x.getObject()).equals(individual));
        }
        if (OWLDataPropertyAssertionAxiom.class.equals(type)) {
            return this.base.listOWLDataPropertyAssertionAxioms(individual);
        }
        if (OWLNegativeDataPropertyAssertionAxiom.class.equals(type)) {
            return this.base.listOWLNegativeDataPropertyAssertionAxioms(individual);
        }
        return this.base.listOWLAxioms(type, (OWLObject)individual);
    }

    private Stream<? extends OWLAxiom> axiomsByObjectProperty(Class<? extends OWLAxiom> type, OWLObjectPropertyExpression property, boolean subject) {
        if (OWLSubObjectPropertyOfAxiom.class.equals(type)) {
            return subject ? this.base.listOWLSubObjectPropertyOfAxiomsBySubject(property) : this.base.listOWLSubObjectPropertyOfAxiomsByObject(property);
        }
        if (OWLEquivalentObjectPropertiesAxiom.class.equals(type)) {
            return this.base.listOWLEquivalentObjectPropertiesAxioms(property);
        }
        if (OWLDisjointObjectPropertiesAxiom.class.equals(type)) {
            return this.base.listOWLDisjointObjectPropertiesAxioms(property);
        }
        if (OWLInverseObjectPropertiesAxiom.class.equals(type)) {
            return this.base.listOWLInverseObjectPropertiesAxioms(property);
        }
        if (OWLObjectPropertyDomainAxiom.class.equals(type)) {
            return this.base.listOWLObjectPropertyDomainAxioms(property);
        }
        if (OWLObjectPropertyRangeAxiom.class.equals(type)) {
            return this.base.listOWLObjectPropertyRangeAxioms(property);
        }
        if (OWLTransitiveObjectPropertyAxiom.class.equals(type)) {
            return this.base.listOWLTransitiveObjectPropertyAxioms(property);
        }
        if (OWLFunctionalObjectPropertyAxiom.class.equals(type)) {
            return this.base.listOWLFunctionalObjectPropertyAxioms(property);
        }
        if (OWLInverseFunctionalObjectPropertyAxiom.class.equals(type)) {
            return this.base.listOWLInverseFunctionalObjectPropertyAxioms(property);
        }
        if (OWLSymmetricObjectPropertyAxiom.class.equals(type)) {
            return this.base.listOWLSymmetricObjectPropertyAxioms(property);
        }
        if (OWLAsymmetricObjectPropertyAxiom.class.equals(type)) {
            return this.base.listOWLAsymmetricObjectPropertyAxioms(property);
        }
        if (OWLReflexiveObjectPropertyAxiom.class.equals(type)) {
            return this.base.listOWLReflexiveObjectPropertyAxioms(property);
        }
        if (OWLIrreflexiveObjectPropertyAxiom.class.equals(type)) {
            return this.base.listOWLIrreflexiveObjectPropertyAxioms(property);
        }
        return this.base.listOWLAxioms(type, (OWLObject)property);
    }

    private Stream<? extends OWLAxiom> axiomsByDataProperty(Class<? extends OWLAxiom> type, OWLDataProperty property, boolean subject) {
        if (OWLSubDataPropertyOfAxiom.class.equals(type)) {
            return subject ? this.base.listOWLSubDataPropertyOfAxiomsBySubject(property) : this.base.listOWLSubDataPropertyOfAxiomsByObject(property);
        }
        if (OWLEquivalentDataPropertiesAxiom.class.equals(type)) {
            return this.base.listOWLEquivalentDataPropertiesAxioms(property);
        }
        if (OWLDisjointDataPropertiesAxiom.class.equals(type)) {
            return this.base.listOWLDisjointDataPropertiesAxioms(property);
        }
        if (OWLDataPropertyDomainAxiom.class.equals(type)) {
            return this.base.listOWLDataPropertyDomainAxioms(property);
        }
        if (OWLDataPropertyRangeAxiom.class.equals(type)) {
            return this.base.listOWLDataPropertyRangeAxioms(property);
        }
        if (OWLFunctionalDataPropertyAxiom.class.equals(type)) {
            return this.base.listOWLFunctionalDataPropertyAxioms(property);
        }
        return this.base.listOWLAxioms(type, (OWLObject)property);
    }

    private Stream<? extends OWLAxiom> axiomsByAnnotationProperty(Class<? extends OWLAxiom> type, OWLAnnotationProperty property, boolean subject) {
        if (OWLSubAnnotationPropertyOfAxiom.class.equals(type)) {
            return subject ? this.base.listOWLSubAnnotationPropertyOfAxiomsBySubject(property) : this.base.listOWLSubAnnotationPropertyOfAxiomsByObject(property);
        }
        if (OWLAnnotationPropertyDomainAxiom.class.equals(type)) {
            return this.base.listOWLAnnotationPropertyDomainAxioms(property);
        }
        if (OWLAnnotationPropertyRangeAxiom.class.equals(type)) {
            return this.base.listOWLAnnotationPropertyRangeAxioms(property);
        }
        return this.base.listOWLAxioms(type, (OWLObject)property);
    }

    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        return AxiomType.TBoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        return AxiomType.ABoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        return AxiomType.RBoxAxiomTypes.stream().flatMap(t -> this.axioms((AxiomType)t, imports));
    }

    public Stream<OWLLogicalAxiom> logicalAxioms() {
        return this.base.listOWLLogicalAxioms();
    }

    public Stream<OWLClassAxiom> generalClassAxioms() {
        Stream<OWLSubClassOfAxiom> subClassOfAxioms = this.base.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> a.getSubClass().isAnonymous());
        Stream<OWLNaryClassAxiom> naryClassAxioms = Stream.of(OWLEquivalentClassesAxiom.class, OWLDisjointClassesAxiom.class).flatMap(x$0 -> this.base.listOWLAxioms((Class)x$0)).filter(a -> a.classExpressions().allMatch(IsAnonymous::isAnonymous));
        return Stream.concat(subClassOfAxioms, naryClassAxioms);
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom) {
        return this.axioms(axiom.getAxiomType()).map(OWLAxiom.class::cast).filter(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive primitive) {
        return this.base.listOWLAxioms(primitive);
    }

    public Stream<OWLSubAnnotationPropertyOfAxiom> subAnnotationPropertyOfAxioms(OWLAnnotationProperty property) {
        return this.base.listOWLSubAnnotationPropertyOfAxiomsBySubject(property);
    }

    public Stream<OWLAnnotationPropertyDomainAxiom> annotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        return this.base.listOWLAnnotationPropertyDomainAxioms(property);
    }

    public Stream<OWLAnnotationPropertyRangeAxiom> annotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        return this.base.listOWLAnnotationPropertyRangeAxioms(property);
    }

    public Stream<OWLDatatypeDefinitionAxiom> datatypeDefinitions(OWLDatatype datatype) {
        return this.base.listOWLDatatypeDefinitionAxioms(datatype);
    }

    public int getAxiomCount() {
        return (int)this.base.getOWLAxiomCount();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType) {
        return (int)this.axioms(axiomType).count();
    }

    public int getLogicalAxiomCount() {
        return (int)this.logicalAxioms().count();
    }

    public boolean containsAxiom(OWLAxiom axiom) {
        return this.base.contains(axiom);
    }

    public boolean containsAxiomIgnoreAnnotations(OWLAxiom axiom) {
        return this.containsAxiom(axiom) || this.axioms(axiom.getAxiomType()).anyMatch(ax -> ax.equalsIgnoreAnnotations(axiom));
    }

    public boolean contains(OWLAxiomSearchFilter filter, Object key) {
        return this.base.listOWLAxioms(filter.getAxiomTypes()).anyMatch(a -> filter.pass(a, key));
    }

    public boolean containsClassInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsClassInSignature(iri));
    }

    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsObjectPropertyInSignature(iri));
    }

    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsDataPropertyInSignature(iri));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsAnnotationPropertyInSignature(iri));
    }

    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsDatatypeInSignature(iri));
    }

    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.containsIndividualInSignature(iri));
    }

    public boolean containsAxiom(OWLAxiom axiom, Imports imports, AxiomAnnotations ignoreAnnotations) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> ignoreAnnotations.contains(o, axiom));
    }

    public boolean contains(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        return imports.stream((HasImportsClosure)this).anyMatch(o -> o.contains(filter, key));
    }

    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        if (Imports.EXCLUDED == imports) {
            return this.axioms(filter, key);
        }
        return imports.stream((HasImportsClosure)this).flatMap(o -> o.axioms(filter, key));
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom, Imports imports) {
        if (Imports.EXCLUDED == imports) {
            return this.axiomsIgnoreAnnotations(axiom);
        }
        return imports.stream((HasImportsClosure)this).flatMap(o -> o.axiomsIgnoreAnnotations(axiom));
    }

    public int getAxiomCount(Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(OWLAxiomCollection::getAxiomCount).sum();
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> axiomType, Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(o -> o.getAxiomCount(axiomType)).sum();
    }

    public int getLogicalAxiomCount(Imports imports) {
        return imports.stream((HasImportsClosure)this).mapToInt(OWLAxiomCollection::getLogicalAxiomCount).sum();
    }

    public Stream<OWLDeclarationAxiom> declarationAxioms(OWLEntity subject) {
        return this.base.listOWLDeclarationAxioms(subject);
    }

    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity) {
        return this.base.listOWLAnnotationAssertionAxioms(entity);
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSubClass(OWLClass clazz) {
        return this.base.listOWLSubClassOfAxiomsBySubject(clazz);
    }

    public Stream<OWLSubClassOfAxiom> subClassAxiomsForSuperClass(OWLClass clazz) {
        return this.base.listOWLSubClassOfAxiomsByObject(clazz);
    }

    public Stream<OWLEquivalentClassesAxiom> equivalentClassesAxioms(OWLClass clazz) {
        return this.base.listOWLEquivalentClassesAxioms(clazz);
    }

    public Stream<OWLDisjointClassesAxiom> disjointClassesAxioms(OWLClass clazz) {
        return this.base.listOWLDisjointClassesAxioms(clazz);
    }

    public Stream<OWLDisjointUnionAxiom> disjointUnionAxioms(OWLClass clazz) {
        return this.base.listOWLDisjointUnionAxioms(clazz);
    }

    public Stream<OWLHasKeyAxiom> hasKeyAxioms(OWLClass clazz) {
        return this.base.listOWLHasKeyAxioms(clazz);
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLClassExpression clazz) {
        return this.base.listOWLClassAssertionAxioms(clazz);
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        return this.base.listOWLSubObjectPropertyOfAxiomsBySubject(property);
    }

    public Stream<OWLSubObjectPropertyOfAxiom> objectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        return this.base.listOWLSubObjectPropertyOfAxiomsByObject(property);
    }

    public Stream<OWLObjectPropertyDomainAxiom> objectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLObjectPropertyDomainAxioms(property);
    }

    public Stream<OWLObjectPropertyRangeAxiom> objectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLObjectPropertyRangeAxioms(property);
    }

    public Stream<OWLInverseObjectPropertiesAxiom> inverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLInverseObjectPropertiesAxioms(property);
    }

    public Stream<OWLEquivalentObjectPropertiesAxiom> equivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLEquivalentObjectPropertiesAxioms(property);
    }

    public Stream<OWLDisjointObjectPropertiesAxiom> disjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLDisjointObjectPropertiesAxioms(property);
    }

    public Stream<OWLFunctionalObjectPropertyAxiom> functionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLFunctionalObjectPropertyAxioms(property);
    }

    public Stream<OWLInverseFunctionalObjectPropertyAxiom> inverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLInverseFunctionalObjectPropertyAxioms(property);
    }

    public Stream<OWLSymmetricObjectPropertyAxiom> symmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLSymmetricObjectPropertyAxioms(property);
    }

    public Stream<OWLAsymmetricObjectPropertyAxiom> asymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLAsymmetricObjectPropertyAxioms(property);
    }

    public Stream<OWLReflexiveObjectPropertyAxiom> reflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLReflexiveObjectPropertyAxioms(property);
    }

    public Stream<OWLIrreflexiveObjectPropertyAxiom> irreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLIrreflexiveObjectPropertyAxioms(property);
    }

    public Stream<OWLTransitiveObjectPropertyAxiom> transitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.base.listOWLTransitiveObjectPropertyAxioms(property);
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSubProperty(OWLDataProperty property) {
        return this.base.listOWLSubDataPropertyOfAxiomsBySubject(property);
    }

    public Stream<OWLSubDataPropertyOfAxiom> dataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        return this.base.listOWLSubDataPropertyOfAxiomsByObject((OWLDataProperty)property);
    }

    public Stream<OWLDataPropertyDomainAxiom> dataPropertyDomainAxioms(OWLDataProperty property) {
        return this.base.listOWLDataPropertyDomainAxioms(property);
    }

    public Stream<OWLDataPropertyRangeAxiom> dataPropertyRangeAxioms(OWLDataProperty property) {
        return this.base.listOWLDataPropertyRangeAxioms(property);
    }

    public Stream<OWLEquivalentDataPropertiesAxiom> equivalentDataPropertiesAxioms(OWLDataProperty property) {
        return this.base.listOWLEquivalentDataPropertiesAxioms(property);
    }

    public Stream<OWLDisjointDataPropertiesAxiom> disjointDataPropertiesAxioms(OWLDataProperty property) {
        return this.base.listOWLDisjointDataPropertiesAxioms(property);
    }

    public Stream<OWLFunctionalDataPropertyAxiom> functionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        return this.base.listOWLFunctionalDataPropertyAxioms((OWLDataProperty)property);
    }

    public Stream<OWLDataPropertyAssertionAxiom> dataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.base.listOWLDataPropertyAssertionAxioms(individual);
    }

    public Stream<OWLObjectPropertyAssertionAxiom> objectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.base.listOWLObjectPropertyAssertionAxioms(individual);
    }

    public Stream<OWLNegativeObjectPropertyAssertionAxiom> negativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.base.listOWLNegativeObjectPropertyAssertionAxioms(individual);
    }

    public Stream<OWLNegativeDataPropertyAssertionAxiom> negativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.base.listOWLNegativeDataPropertyAssertionAxioms(individual);
    }

    public Stream<OWLClassAssertionAxiom> classAssertionAxioms(OWLIndividual individual) {
        return this.base.listOWLClassAssertionAxioms(individual);
    }

    public Stream<OWLSameIndividualAxiom> sameIndividualAxioms(OWLIndividual individual) {
        return this.base.listOWLSameIndividualAxioms(individual);
    }

    public Stream<OWLDifferentIndividualsAxiom> differentIndividualAxioms(OWLIndividual individual) {
        return this.base.listOWLDifferentIndividualsAxioms(individual);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        GraphMem base = new GraphMem();
        RDFDataMgr.read((Graph)base, (InputStream)in, (Lang)DEFAULT_SERIALIZATION_FORMAT.getLang());
        this.setBase(BaseModel.createInternalModel((Graph)base));
    }

    private void writeObject(ObjectOutputStream out) throws IOException, OntApiException {
        Graph g = this.base.getBaseGraph();
        if (!(g instanceof GraphMem)) {
            throw new OntApiException(this.getOntologyID() + ":: Serialization is not supported for " + g.getClass());
        }
        out.defaultWriteObject();
        RDFDataMgr.write((OutputStream)out, (Graph)g, (Lang)DEFAULT_SERIALIZATION_FORMAT.getLang());
    }

    public String toString() {
        return String.format("Ontology(%s)", this.getOntologyID());
    }

    public int hashCode() {
        return this.hashCode == 0 ? (this.hashCode = this.initHashCode()) : this.hashCode;
    }

    public int compareTo(@Nullable OWLObject o) {
        return OWLObjectImpl.DEFAULT_COMPARATOR.compare((OWLObject)this, Objects.requireNonNull(o));
    }

    public boolean equals(@Nullable Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Ontology)) {
            return false;
        }
        OntModel right = ((Ontology)obj).asGraphModel();
        InternalModel left = this.getBase();
        return left.getID().sameAs(right.getID());
    }
}

