/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.OWLLangRegistry;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.jena.OntModelFactory;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFParserRegistry;
import org.apache.jena.riot.RDFWriterRegistry;
import org.semanticweb.owlapi.formats.AbstractRDFPrefixDocumentFormat;
import org.semanticweb.owlapi.formats.PrefixDocumentFormat;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.PrefixManager;

public enum OntFormat {
    TURTLE("Turtle", "ttl", Arrays.asList(Lang.TURTLE, Lang.TTL, Lang.N3), Arrays.asList(OWLLangRegistry.LangKey.TURTLE, OWLLangRegistry.LangKey.RIOTURTLE, OWLLangRegistry.LangKey.N3)),
    RDF_XML("RDF/XML", "rdf", Collections.singletonList(Lang.RDFXML), Arrays.asList(OWLLangRegistry.LangKey.RDFXML, OWLLangRegistry.LangKey.RIORDFXML)),
    RDF_JSON("RDF/JSON", "rj", Lang.RDFJSON, OWLLangRegistry.LangKey.RDFJSON),
    JSON_LD("JSON-LD", "jsonld", Lang.JSONLD, OWLLangRegistry.LangKey.RDFJSONLD),
    NTRIPLES("N-Triples", "nt", Arrays.asList(Lang.NTRIPLES, Lang.NT), Collections.singletonList(OWLLangRegistry.LangKey.NTRIPLES)),
    NQUADS("N-Quads", "nq", Arrays.asList(Lang.NQUADS, Lang.NQ), Collections.singletonList(OWLLangRegistry.LangKey.NQUADS)),
    TRIG("TriG", "trig", Lang.TRIG, OWLLangRegistry.LangKey.TRIG),
    TRIX("TriX", "trix", Lang.TRIX, OWLLangRegistry.LangKey.TRIX),
    RDF_THRIFT("RDF-THRIFT", "trdf", Lang.RDFTHRIFT, null),
    CSV("CSV", "csv", Lang.CSV, null),
    TSV("TSV", "tsv", Lang.TSV, null),
    OWL_XML("OWL/XML", "owl", null, OWLLangRegistry.LangKey.OWLXML),
    MANCHESTER_SYNTAX("ManchesterSyntax", "omn", null, OWLLangRegistry.LangKey.MANCHESTERSYNTAX),
    FUNCTIONAL_SYNTAX("FunctionalSyntax", "fss", null, OWLLangRegistry.LangKey.FUNCTIONALSYNTAX),
    BINARY_RDF("BinaryRDF", "brf", null, OWLLangRegistry.LangKey.BINARYRDF),
    RDFA("RDFA", "xhtml", null, OWLLangRegistry.LangKey.RDFA),
    OBO("OBO", "obo", null, OWLLangRegistry.LangKey.OBO),
    KRSS("KRSS", "krss", null, OWLLangRegistry.LangKey.KRSS),
    KRSS2("KRSS2", "krss2", null, OWLLangRegistry.LangKey.KRSS2),
    DL("DL", "dl", null, OWLLangRegistry.LangKey.DLSYNTAX),
    DL_HTML("DL/HTML", "html", null, OWLLangRegistry.LangKey.DLSYNTAXHTML),
    LATEX("LATEX", "tex", null, OWLLangRegistry.LangKey.LATEX);

    private final String id;
    private final String ext;
    private final List<Lang> jenaLangs;
    private final List<OWLLangRegistry.LangKey> owlTypes;

    private OntFormat(String id, String ext, List<Lang> jena, List<OWLLangRegistry.LangKey> owl) {
        this.id = OntApiException.notNull(id, "Id is required.");
        this.ext = ext;
        this.jenaLangs = Collections.unmodifiableList(jena);
        this.owlTypes = Collections.unmodifiableList(owl);
    }

    private OntFormat(String id, String ext, Lang jena, OWLLangRegistry.LangKey owl) {
        this(id, ext, jena == null ? Collections.emptyList() : Collections.singletonList(jena), owl == null ? Collections.emptyList() : Collections.singletonList(owl));
    }

    public String getID() {
        return this.id;
    }

    public String getExt() {
        return this.ext;
    }

    @Nullable
    public Lang getLang() {
        return this.jenaLangs.size() == 0 ? null : this.jenaLangs.get(0);
    }

    public Stream<Lang> jenaLangs() {
        return this.jenaLangs.stream();
    }

    public OWLLangRegistry.OWLLang getOWLLang() {
        return this.owlLangs().min(Comparator.comparingInt(OntFormat::computeOrder)).orElse(null);
    }

    private static int computeOrder(OWLLangRegistry.OWLLang d) {
        int res = 1;
        if (d.isWritable()) {
            --res;
        }
        if (d.isReadable()) {
            --res;
        }
        return res;
    }

    public Stream<OWLLangRegistry.LangKey> owlKeys() {
        return this.owlTypes.stream();
    }

    public Stream<OWLLangRegistry.OWLLang> owlLangs() {
        return this.owlKeys().map(k -> OWLLangRegistry.getLang(k.getKey())).filter(Optional::isPresent).map(Optional::get);
    }

    public OWLDocumentFormat createOwlFormat() {
        OWLDocumentFormat res = this.newOWLFormat();
        if (res.isPrefixOWLDocumentFormat()) {
            PrefixDocumentFormat pm = res.asPrefixOWLDocumentFormat();
            OntModelFactory.STANDARD.getNsPrefixMap().forEach((arg_0, arg_1) -> ((PrefixManager)pm).setPrefix(arg_0, arg_1));
        }
        return res;
    }

    OWLDocumentFormat newOWLFormat() {
        OWLLangRegistry.OWLLang lang = this.getOWLLang();
        if (lang == null) {
            return new SimpleDocumentFormat();
        }
        OWLDocumentFormat res = lang.getFormatFactory().get();
        if (res.isPrefixOWLDocumentFormat()) {
            res.asPrefixOWLDocumentFormat().clear();
        }
        return res;
    }

    public boolean isSupported() {
        return this.isWriteSupported() && this.isReadSupported() && this.isNoneOf(OBO, DL, KRSS2);
    }

    public boolean isReadSupported() {
        return this.jenaLangs().anyMatch(RDFParserRegistry::isRegistered) || this.owlLangs().anyMatch(OWLLangRegistry.OWLLang::isReadable);
    }

    public boolean isWriteSupported() {
        return this.jenaLangs().anyMatch(RDFWriterRegistry::contains) || this.owlLangs().anyMatch(OWLLangRegistry.OWLLang::isWritable);
    }

    public boolean isJena() {
        return !this.jenaLangs.isEmpty();
    }

    public boolean isOWL() {
        return !this.owlTypes.isEmpty();
    }

    public boolean isJenaOnly() {
        return this.isJena() && !this.isOWL();
    }

    public boolean isOWLOnly() {
        return this.isOWL() && !this.isJena();
    }

    public boolean isXML() {
        return this.isOneOf(RDF_XML, OWL_XML);
    }

    public boolean isJSON() {
        return this.isOneOf(RDF_JSON, JSON_LD);
    }

    private boolean isOneOf(OntFormat ... formats) {
        return Arrays.asList(formats).contains((Object)this);
    }

    private boolean isNoneOf(OntFormat ... formats) {
        return Stream.of(formats).noneMatch(this::equals);
    }

    public static Stream<OntFormat> formats() {
        return Stream.of(OntFormat.values());
    }

    public static OntFormat get(OWLDocumentFormat format) {
        Class<?> type = OntApiException.notNull(format, "Null OWL Document Format specified.").getClass();
        OntFormat res = null;
        if (!SimpleDocumentFormat.class.equals(type)) {
            res = OntFormat.get(type);
        }
        return res != null ? res : OntFormat.get(format.getKey());
    }

    public static OntFormat get(Class<? extends OWLDocumentFormat> type) {
        String key = OntApiException.notNull(type, "Null owl-document-format class specified.").getName();
        for (OntFormat f : OntFormat.values()) {
            if (!f.owlKeys().map(OWLLangRegistry.LangKey::getKey).anyMatch(key::equals)) continue;
            return f;
        }
        return null;
    }

    public static OntFormat get(Lang lang) {
        OntApiException.notNull(lang, "Null jena-language specified.");
        for (OntFormat r : OntFormat.values()) {
            if (!r.jenaLangs().anyMatch(arg_0 -> ((Lang)lang).equals(arg_0))) continue;
            return r;
        }
        return null;
    }

    public static OntFormat get(String id) {
        OntApiException.notNull(id, "Null ont-format id specified.");
        for (OntFormat r : OntFormat.values()) {
            if (!Objects.equals(r.id, id)) continue;
            return r;
        }
        return null;
    }

    public class SimpleDocumentFormat
    extends AbstractRDFPrefixDocumentFormat {
        public String getKey() {
            return OntFormat.this.id;
        }
    }
}

