/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntFormat;
import com.github.owlcs.ontapi.OntologyFactoryImpl;
import com.github.owlcs.ontapi.OntologyMetaData;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.jena.impl.OntIDImpl;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.Models;
import com.github.owlcs.ontapi.transforms.GraphStats;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.input.ReaderInputStream;
import org.apache.jena.enhanced.EnhGraph;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.NodeFactory;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.impl.ModelCom;
import org.apache.jena.riot.Lang;
import org.apache.jena.riot.RDFDataMgr;
import org.apache.jena.riot.RDFLanguages;
import org.apache.jena.shared.PrefixMapping;
import org.semanticweb.owlapi.io.DocumentSources;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyInputSourceException;
import org.semanticweb.owlapi.io.OWLOntologyLoaderMetaData;
import org.semanticweb.owlapi.io.RDFLiteral;
import org.semanticweb.owlapi.io.RDFNode;
import org.semanticweb.owlapi.io.RDFResource;
import org.semanticweb.owlapi.io.RDFResourceBlankNode;
import org.semanticweb.owlapi.io.RDFResourceIRI;
import org.semanticweb.owlapi.io.RDFTriple;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDocumentFormat;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.PrefixManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntGraphUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntModel.class);
    public static final String TEXT_PLAIN_REQUEST_TYPE = ", text/plain; q=0.1";
    public static final String LAST_REQUEST_TYPE = ", */*; q=0.09";
    public static final String DEFAULT_REQUEST = "application/rdf+xml, application/xml; q=0.7, text/xml; q=0.6, text/plain; q=0.1, */*; q=0.09";

    public static ID getOntologyID(Graph graph) throws OntApiException {
        Graph base = Graphs.getBase(graph);
        Node res = Graphs.ontologyNode(base).orElseGet(() -> NodeFactory.createBlankNode((String)OntGraphUtils.toString(graph)));
        return new ID(new OntIDImpl(res, (EnhGraph)new ModelCom(base)));
    }

    public static Map<ID, Graph> toGraphMap(Graph graph) throws OntApiException {
        LinkedHashMap<ID, Graph> res = new LinkedHashMap<ID, Graph>();
        ID id = OntGraphUtils.getOntologyID(graph);
        OntGraphUtils.assembleMap(id, graph, res);
        return res;
    }

    private static void assembleMap(ID id, Graph graph, Map<ID, Graph> res) {
        Set<String> imports = Graphs.getImports(graph);
        if (imports.isEmpty()) {
            OntGraphUtils.put(id, graph, res);
            return;
        }
        OntGraphUtils.put(id, Graphs.getBase(graph), res);
        Iterator graphs = Graphs.subGraphs(graph).iterator();
        while (graphs.hasNext()) {
            Graph g = (Graph)graphs.next();
            ID i = OntGraphUtils.getOntologyID(g);
            String uri = ((IRI)i.getVersionIRI().orElse(i.getOntologyIRI().orElseThrow(() -> new OntApiException("Anonymous sub graph found: " + i + ". Only the top-level graph is allowed to be anonymous")))).getIRIString();
            if (!imports.contains(uri)) {
                throw new OntApiException("Can't find " + i + " in the imports: " + imports);
            }
            OntGraphUtils.assembleMap(i, g, res);
        }
    }

    private static void put(ID id, Graph graph, Map<ID, Graph> map) {
        Graph prev = map.get(id);
        if (prev != null) {
            if (prev.isIsomorphicWith(graph)) {
                return;
            }
            throw new OntApiException("Duplicate sub graph: " + id);
        }
        map.put(id, graph);
    }

    public static PrefixMapping prefixMapping(PrefixManager pm) {
        PrefixMapping res = PrefixMapping.Factory.create();
        Models.setNsPrefixes(res, pm.getPrefixName2PrefixMap());
        return res;
    }

    public static RDFTriple triple(Triple triple) {
        Object subject = triple.getSubject().isURI() ? OntGraphUtils.uri(triple.getSubject()) : OntGraphUtils.blank(triple.getSubject());
        RDFResourceIRI predicate = OntGraphUtils.uri(triple.getPredicate());
        Object object = triple.getObject().isURI() ? OntGraphUtils.uri(triple.getObject()) : (triple.getObject().isLiteral() ? OntGraphUtils.literal(triple.getObject()) : OntGraphUtils.blank(triple.getObject()));
        return new RDFTriple((RDFResource)subject, predicate, (RDFNode)object);
    }

    public static RDFResourceBlankNode blank(Node node) throws IllegalArgumentException {
        if (!Objects.requireNonNull(node, "Null node").isBlank()) {
            throw new IllegalArgumentException("Not a blank node: " + node);
        }
        return new RDFResourceBlankNode(IRI.create((String)node.getBlankNodeId().getLabelString()), false, false, false);
    }

    public static RDFResourceIRI uri(Node node) throws IllegalArgumentException {
        if (!Objects.requireNonNull(node, "Null node").isURI()) {
            throw new IllegalArgumentException("Not an uri node: " + node);
        }
        return new RDFResourceIRI(IRI.create((String)node.getURI()));
    }

    public static RDFLiteral literal(Node node) throws IllegalArgumentException {
        if (!Objects.requireNonNull(node, "Null node").isLiteral()) {
            throw new IllegalArgumentException("Not a literal node: " + node);
        }
        return new RDFLiteral(node.getLiteralLexicalForm(), node.getLiteralLanguage(), IRI.create((String)node.getLiteralDatatypeURI()));
    }

    protected static OWLOntologyLoaderMetaData makeParserMetaData(Graph graph, GraphStats stats) {
        if (stats == null) {
            return OntologyMetaData.createParserMetaData(graph);
        }
        if (Graphs.getBase(graph) != stats.getGraph()) {
            throw new IllegalArgumentException("Incompatible graphs: " + Graphs.getName(graph) + " != " + Graphs.getName(stats.getGraph()));
        }
        return OntologyMetaData.createParserMetaData(stats);
    }

    public static OntFormat readGraph(Graph graph, OWLOntologyDocumentSource source, OntLoaderConfiguration conf) throws OWLOntologyCreationException {
        OntFormat res;
        IRI iri = OntApiException.notNull(source, "Null document source.").getDocumentIRI();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Read graph from <{}>.", (Object)iri);
        }
        if ((res = OntGraphUtils.read(graph, source, s -> s.getInputStream().orElse(null))) != null) {
            return res;
        }
        res = OntGraphUtils.read(graph, source, s -> OntGraphUtils.asInputStream(s.getReader().orElse(null)));
        if (res != null) {
            return res;
        }
        if (conf.getSupportedSchemes().stream().noneMatch(s -> s.same(iri))) {
            throw new OntologyFactoryImpl.ConfigMismatchException("Not allowed scheme: " + iri);
        }
        String header = source.getAcceptHeaders().orElse(DEFAULT_REQUEST);
        return OntGraphUtils.read(graph, source, s -> (InputStream)DocumentSources.getInputStream((IRI)iri, (OWLOntologyLoaderConfiguration)conf, (String)header).orElseThrow(() -> new OWLOntologyInputSourceException("Can't get input-stream from " + iri)));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static OntFormat read(Graph graph, OWLOntologyDocumentSource source, OntInputSupplier supplier) throws OWLOntologyCreationException {
        IRI iri = source.getDocumentIRI();
        OntologyFactoryImpl.UnsupportedFormatException cause = new OntologyFactoryImpl.UnsupportedFormatException(String.format("Can't read %s %s.", source.getClass().getSimpleName(), iri));
        Iterator<OntFormat> iterator = OntGraphUtils.getSupportedFormats(source).iterator();
        while (iterator.hasNext()) {
            OntFormat format = iterator.next();
            if (format.isOWLOnly()) {
                cause.addSuppressed((Throwable)((Object)new OntologyFactoryImpl.UnsupportedFormatException("Not supported by jena.").putFormat(format).putSource(iri)));
                continue;
            }
            Lang lang = format.getLang();
            try (InputStream is = supplier.open(source);){
                if (is == null) {
                    OntFormat ontFormat2 = null;
                    return ontFormat2;
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("try <{}>", (Object)lang);
                }
                RDFDataMgr.read((Graph)graph, (InputStream)is, (String)iri.toString(), (Lang)lang);
                OntFormat ontFormat = format;
                return ontFormat;
            }
            catch (IOException | OWLOntologyInputSourceException e) {
                throw new OWLOntologyCreationException(source.getClass().getSimpleName() + ": can't open or close input stream from " + iri, e);
            }
            catch (RuntimeException e) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("<{}> failed: '{}'", (Object)lang, (Object)e.getMessage());
                }
                cause.addSuppressed((Throwable)((Object)new OntologyFactoryImpl.UnsupportedFormatException(e).putSource(iri).putFormat(format)));
            }
        }
        throw cause;
    }

    public static Set<OntFormat> getSupportedFormats(OWLOntologyDocumentSource source) throws OntologyFactoryImpl.UnsupportedFormatException {
        LinkedHashSet<OntFormat> res = new LinkedHashSet<OntFormat>();
        if (source.getFormat().isPresent()) {
            OntFormat f = OntFormat.get((OWLDocumentFormat)source.getFormat().get());
            if (f == null || !f.isReadSupported()) {
                throw new OntologyFactoryImpl.UnsupportedFormatException("Format " + source.getFormat().get() + " is not supported.");
            }
            res.add(f);
            return res;
        }
        OntFormat first = OntGraphUtils.guessFormat(source);
        if (first != null) {
            res.add(first);
        }
        OntFormat.formats().filter(OntFormat::isReadSupported).forEach(res::add);
        return res;
    }

    public static OntFormat guessFormat(OWLOntologyDocumentSource source) {
        Optional mime = OntApiException.notNull(source, "Null document source.").getMIMEType();
        Lang lang = mime.isPresent() ? RDFLanguages.contentTypeToLang((String)((String)mime.get())) : RDFLanguages.filenameToLang((String)source.getDocumentIRI().getIRIString());
        return lang == null ? null : OntFormat.get(lang);
    }

    protected static InputStream asInputStream(Reader reader) {
        if (reader == null) {
            return null;
        }
        Charset charset = reader instanceof InputStreamReader ? Charset.forName(((InputStreamReader)reader).getEncoding()) : StandardCharsets.UTF_8;
        return new ReaderInputStream(reader, charset, 8192);
    }

    public static String toString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.getClass().getName() + "@" + Integer.toHexString(o.hashCode());
    }

    @FunctionalInterface
    protected static interface OntInputSupplier {
        public InputStream open(OWLOntologyDocumentSource var1) throws OWLOntologyInputSourceException;
    }
}

