/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.DataFactoryImpl;
import com.github.owlcs.ontapi.ModelConfig;
import com.github.owlcs.ontapi.NoOpReadWriteLock;
import com.github.owlcs.ontapi.OWLFactoryWrapper;
import com.github.owlcs.ontapi.OWLLangRegistry;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OntologyBuilderImpl;
import com.github.owlcs.ontapi.OntologyFactory;
import com.github.owlcs.ontapi.OntologyLoaderImpl;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.OntologyManagerImpl;
import com.github.owlcs.ontapi.ReflectionUtils;
import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.config.OntSettings;
import com.github.owlcs.ontapi.jena.OntModelFactory;
import com.google.common.collect.LinkedListMultimap;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.OWLOntologyManagerFactory;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;

public class OntManagers
implements OWLOntologyManagerFactory {
    public static final ONTAPIProfile DEFAULT_PROFILE;
    private static OWLOntologyManagerFactory managerFactory;

    public static DataFactory getDataFactory() {
        return DEFAULT_PROFILE.createDataFactory();
    }

    public static OntologyManager createManager() {
        return DEFAULT_PROFILE.createManager(false);
    }

    public static OntologyManager createConcurrentManager() {
        return DEFAULT_PROFILE.createManager(true);
    }

    public static OntologyManager createDirectManager() {
        return new DirectProfile().createManager(false);
    }

    public static OWLOntologyManager createOWLAPIImplManager() throws OntApiException {
        return new OWLAPIImplProfile().createManager(false);
    }

    public static OWLOntologyManager createConcurrentOWLAPIImplManager() throws OntApiException {
        return new OWLAPIImplProfile().createManager(true);
    }

    public static OWLOntologyManagerFactory getFactory() {
        return managerFactory;
    }

    public static void setFactory(OWLOntologyManagerFactory factory) {
        managerFactory = OntApiException.notNull(factory, "Null manager factory is given.");
    }

    public OWLOntologyManager get() {
        return managerFactory.get();
    }

    @Deprecated
    public static OntologyManager createONT() {
        return OntManagers.createManager();
    }

    @Deprecated
    public static OntologyManager createConcurrentONT() {
        return OntManagers.createConcurrentManager();
    }

    @Deprecated
    public static OWLOntologyManager createOWL() {
        return OntManagers.createOWLAPIImplManager();
    }

    @Deprecated
    public static OWLOntologyManager createConcurrentOWL() {
        return OntManagers.createConcurrentOWLAPIImplManager();
    }

    @Deprecated
    public static Profile createOWLProfile() throws OntApiException {
        final OWLAPIImplProfile res = new OWLAPIImplProfile();
        return new Profile(){

            @Override
            public OWLOntologyManager createManager(boolean concurrency) {
                return res.createManager(concurrency);
            }

            @Override
            public OWLDataFactory createDataFactory() {
                return res.createDataFactory();
            }
        };
    }

    static {
        OntModelFactory.init();
        DEFAULT_PROFILE = new ONTAPIProfile();
        managerFactory = (OWLOntologyManagerFactory & Serializable)() -> DEFAULT_PROFILE.createManager(false);
    }

    public static class OWLAPIImplProfile
    implements CreationProfile {
        private final Class<OWLOntologyManager> managerClass = ReflectionUtils.getClass(OWLOntologyManager.class, "uk.ac.manchester.cs.owl.owlapi.OWLOntologyManagerImpl");

        public OWLOntologyBuilder createOWLOntologyBuilder(ReadWriteLock lock) throws OntApiException {
            OWLOntologyBuilder res = ReflectionUtils.newInstance(OWLOntologyBuilder.class, "uk.ac.manchester.cs.owl.owlapi.concurrent.NonConcurrentOWLOntologyBuilder", LinkedListMultimap.create());
            if (!NoOpReadWriteLock.isConcurrent(lock)) {
                return res;
            }
            LinkedListMultimap concurrentParams = LinkedListMultimap.create();
            concurrentParams.put(OWLOntologyBuilder.class, (Object)res);
            concurrentParams.put(ReadWriteLock.class, (Object)lock);
            return ReflectionUtils.newInstance(OWLOntologyBuilder.class, "uk.ac.manchester.cs.owl.owlapi.concurrent.ConcurrentOWLOntologyBuilder", concurrentParams);
        }

        public OWLOntology createOWLOntologyImpl(OWLOntologyManager manager, OWLOntologyID id) {
            LinkedListMultimap params = LinkedListMultimap.create();
            params.put(OWLOntologyManager.class, (Object)manager);
            params.put(OWLOntologyID.class, (Object)id);
            return ReflectionUtils.newInstance(OWLOntology.class, "uk.ac.manchester.cs.owl.owlapi.OWLOntologyImpl", params);
        }

        @Override
        public OWLOntologyManager createManager(boolean concurrency) {
            ReadWriteLock lock = concurrency ? new ReentrantReadWriteLock() : NoOpReadWriteLock.NO_OP_RW_LOCK;
            OWLDataFactory dataFactory = this.createDataFactory();
            OWLOntologyFactory loadFactory = this.createOntologyFactory(this.createOWLOntologyBuilder(lock));
            OWLOntologyManager res = this.createManager(dataFactory, lock);
            Set storers = OWLLangRegistry.storerFactories().collect(Collectors.toSet());
            Set parsers = OWLLangRegistry.parserFactories().collect(Collectors.toSet());
            res.getOntologyStorers().set(storers);
            res.getOntologyParsers().set(parsers);
            res.getOntologyFactories().add((Serializable)loadFactory);
            return res;
        }

        public OWLOntologyManager createManager(OWLDataFactory dataFactory, ReadWriteLock lock) {
            Constructor<OWLOntologyManager> constructor;
            try {
                constructor = this.managerClass.getConstructor(OWLDataFactory.class, ReadWriteLock.class);
            }
            catch (NoSuchMethodException e) {
                throw new OntApiException(this.managerClass.getName() + ": can't find constructor", e);
            }
            try {
                return constructor.newInstance(dataFactory, lock);
            }
            catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
                throw new OntApiException(this.managerClass.getName() + ": can't create new instance", e);
            }
        }

        @Override
        public OWLDataFactory createDataFactory() {
            return ReflectionUtils.newInstance(OWLDataFactory.class, "uk.ac.manchester.cs.owl.owlapi.OWLDataFactoryImpl", LinkedListMultimap.create());
        }

        public OWLOntologyFactory createOntologyFactory(OWLOntologyBuilder builder) {
            LinkedListMultimap params = LinkedListMultimap.create();
            params.put(OWLOntologyBuilder.class, (Object)builder);
            return ReflectionUtils.newInstance(OWLOntologyFactory.class, "uk.ac.manchester.cs.owl.owlapi.OWLOntologyFactoryImpl", params);
        }
    }

    static abstract class BaseCreationProfile
    implements CreationProfile {
        public static final DataFactory DEFAULT_DATA_FACTORY = new DataFactoryImpl();

        BaseCreationProfile() {
        }

        abstract OntologyManager createManager(DataFactory var1, OntologyFactory var2, ReadWriteLock var3);

        @Override
        public OntologyManager createManager(boolean concurrency) {
            OntologyManager res = this.createManager(this.createDataFactory(), concurrency ? new ReentrantReadWriteLock() : NoOpReadWriteLock.NO_OP_RW_LOCK);
            this.initParsers(res);
            this.initStorers(res);
            return res;
        }

        public OntologyManager createManager(DataFactory dataFactory, ReadWriteLock lock) {
            return this.createManager(dataFactory, this.createOntologyFactory(), lock);
        }

        void initParsers(OWLOntologyManager res) {
            res.getOntologyParsers().set(OWLLangRegistry.parserFactories().collect(Collectors.toSet()));
        }

        void initStorers(OWLOntologyManager res) {
            res.getOntologyStorers().set(OWLLangRegistry.storerFactories().collect(Collectors.toSet()));
        }

        @Override
        public DataFactory createDataFactory() {
            return DEFAULT_DATA_FACTORY;
        }

        public OntologyFactory.Builder createOntologyBuilder() {
            return new OntologyBuilderImpl();
        }

        public OntologyFactory.Loader createOntologyLoader() {
            return new OntologyLoaderImpl(new OWLFactoryWrapper());
        }

        public OntologyFactory createOntologyFactory() {
            return this.createOntologyFactory(this.createOntologyBuilder());
        }

        public OntologyFactory createOntologyFactory(OntologyFactory.Builder builder) {
            return this.createOntologyFactory(builder, this.createOntologyLoader());
        }

        public OntologyFactory createOntologyFactory(OntologyFactory.Builder builder, OntologyFactory.Loader loader) {
            return loader.asOntologyFactory(builder);
        }
    }

    static class DirectProfile
    extends BaseCreationProfile {
        DirectProfile() {
        }

        @Override
        public OntologyManager createManager(DataFactory dataFactory, OntologyFactory factory, ReadWriteLock lock) {
            OntConfig config = ((OntConfig)new OntConfig().setModelCacheLevel(22, false)).lockProperty(OntSettings.ONT_API_LOAD_CONF_CACHE_MODEL);
            OntologyManagerImpl res = new OntologyManagerImpl(dataFactory, lock, config, PriorityCollectionSorting.NEVER){

                @Override
                public void setOntologyConfigurator(OntologyConfigurator conf) {
                    throw new OntApiException.ModificationDenied("Changing manager's configuration is denied in the direct mode");
                }

                @Override
                public ModelConfig createModelConfig() {
                    return new ModelConfig(this){

                        @Override
                        public void setLoaderConf(OntLoaderConfiguration conf) {
                            if (conf.getModelCacheLevel() != 0) {
                                throw new OntApiException.ModificationDenied("The given loader configuration is not suitable for the direct mode");
                            }
                            super.setLoaderConf(conf);
                        }
                    };
                }
            };
            res.getOntologyFactories().add(this.createOntologyFactory());
            return res;
        }
    }

    public static class ONTAPIProfile
    extends BaseCreationProfile {
        @Override
        public OntologyManager createManager(DataFactory dataFactory, OntologyFactory factory, ReadWriteLock lock) {
            return new OntologyManagerImpl(dataFactory, factory, lock);
        }
    }

    static interface CreationProfile {
        public OWLOntologyManager createManager(boolean var1);

        public OWLDataFactory createDataFactory();

        @Deprecated
        default public OWLOntologyManager create(boolean concurrent) {
            return this.createManager(concurrent);
        }

        @Deprecated
        default public OWLDataFactory dataFactory() {
            return this.createDataFactory();
        }
    }

    @Deprecated
    public static interface Profile
    extends CreationProfile {
    }
}

