/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.HasAdapter;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.Ontology;
import com.github.owlcs.ontapi.OntologyCreator;
import com.github.owlcs.ontapi.OntologyLoader;
import com.github.owlcs.ontapi.OntologyManager;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import java.io.Serializable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLOntologyBuilder;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyFactory;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyManager;

@ParametersAreNonnullByDefault
public interface OntologyFactory
extends OWLOntologyFactory,
HasAdapter {
    public Builder getBuilder();

    public Loader getLoader();

    public void includeOntology(OntologyManager var1, Ontology var2);

    default public Ontology createOntology(OntologyManager manager, ID id) throws OntApiException {
        Ontology res = this.getBuilder().createOntology(id, manager, manager.getOntologyLoaderConfiguration());
        this.includeOntology(manager, res);
        return res;
    }

    default public Ontology loadOntology(OntologyManager manager, OWLOntologyDocumentSource source, OntLoaderConfiguration config) throws OWLOntologyCreationException, OntApiException {
        return this.getLoader().loadOntology(this.getBuilder(), manager, source, config);
    }

    default public boolean canCreateFromDocumentIRI(IRI iri) {
        return true;
    }

    default public boolean canAttemptLoading(OWLOntologyDocumentSource source) {
        return true;
    }

    default public Ontology createOWLOntology(OWLOntologyManager manager, OWLOntologyID id, IRI documentIRI, OWLOntologyFactory.OWLOntologyCreationHandler handler) {
        HasAdapter.Adapter adapter = this.getAdapter();
        return this.createOntology(adapter.asONT(manager), adapter.asONT(id));
    }

    default public Ontology loadOWLOntology(OWLOntologyManager manager, OWLOntologyDocumentSource source, OWLOntologyFactory.OWLOntologyCreationHandler handler, OWLOntologyLoaderConfiguration config) throws OWLOntologyCreationException {
        HasAdapter.Adapter adapter = this.getAdapter();
        return this.loadOntology(adapter.asONT(manager), source, adapter.asONT(config));
    }

    public static interface Loader
    extends OntologyLoader,
    HasAdapter,
    Serializable {
        public OntologyFactory asOntologyFactory(OntologyCreator var1);
    }

    public static interface Builder
    extends OntologyCreator,
    HasAdapter,
    OWLOntologyBuilder {
        default public Ontology createOWLOntology(OWLOntologyManager manager, OWLOntologyID id) {
            HasAdapter.Adapter adapter = this.getAdapter();
            return this.createOntology(adapter.asONT(id), adapter.asONT(manager), adapter.asONT(manager.getOntologyLoaderConfiguration()));
        }
    }
}

