/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLObject;

public class OwlObjects {
    public static <O extends OWLObject> Stream<O> parseComponents(Class<? extends O> type, HasComponents structure) {
        return structure.componentsWithoutAnnotations().flatMap(o -> OwlObjects.toStream(type, o));
    }

    public static <O extends OWLObject> Stream<O> parseAnnotations(Class<? extends O> type, HasAnnotations structure) {
        return structure.annotations().flatMap(o -> OwlObjects.toStream(type, o));
    }

    public static <O extends OWLObject, A extends HasComponents> Stream<O> objects(Class<? extends O> type, A container) {
        Stream<? extends O> res = OwlObjects.parseComponents(type, container);
        if (container instanceof HasAnnotations) {
            res = Stream.concat(res, OwlObjects.parseAnnotations(type, (HasAnnotations)container));
        }
        return res;
    }

    public static <A extends HasComponents> Stream<IRI> iris(A container) {
        return Stream.concat(OwlObjects.objects(IRI.class, container), OwlObjects.objects(OWLObject.class, container).map(o -> o instanceof HasIRI ? ((HasIRI)o).getIRI() : null).filter(Objects::nonNull));
    }

    private static <O extends OWLObject> Stream<O> toStream(Class<? extends O> type, Object o) {
        if (type.isInstance(o)) {
            return Stream.of(type.cast(o));
        }
        if (o instanceof HasComponents) {
            if (o instanceof HasAnnotations) {
                return OwlObjects.objects(type, (HasComponents)((HasAnnotations)((HasComponents)o)));
            }
            return OwlObjects.parseComponents(type, (HasComponents)o);
        }
        if (o instanceof HasAnnotations) {
            return OwlObjects.parseAnnotations(type, (HasAnnotations)o);
        }
        Stream stream = null;
        if (o instanceof Stream) {
            stream = (Stream)o;
        } else if (o instanceof Collection) {
            stream = ((Collection)o).stream();
        }
        if (stream != null) {
            return stream.flatMap(x -> OwlObjects.toStream(type, x));
        }
        return Stream.empty();
    }
}

