/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.NoOpReadWriteLock;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.semanticweb.owlapi.util.PriorityCollection;

public class RWLockedCollection<E extends Serializable>
extends PriorityCollection<E> {
    protected final ReadWriteLock lock;

    public RWLockedCollection(ReadWriteLock lock) {
        this(lock, PriorityCollectionSorting.NEVER);
    }

    public RWLockedCollection(ReadWriteLock lock, PriorityCollectionSorting sorting) {
        super(sorting);
        this.lock = NoOpReadWriteLock.nonNull(lock);
    }

    public boolean isEmpty() {
        this.lock.readLock().lock();
        try {
            boolean bl = super.isEmpty();
            return bl;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public int size() {
        this.lock.readLock().lock();
        try {
            int n = super.size();
            return n;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public void set(@Nonnull Iterable<E> iterable) {
        this.lock.writeLock().lock();
        try {
            this.onAdd((E)iterable);
            this.setIterable(iterable);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void set(Set<E> set) {
        this.lock.writeLock().lock();
        try {
            this.onAdd((E)set);
            super.set(set);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @SafeVarargs
    public final void set(E ... array) {
        this.lock.writeLock().lock();
        try {
            this.onAdd((E)array);
            this.setIterable(Arrays.asList(array));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @SafeVarargs
    public final void add(E ... array) {
        this.lock.writeLock().lock();
        try {
            this.onAdd((E)array);
            this.addIterable(Arrays.asList(array));
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void add(Iterable<E> iterable) {
        this.lock.writeLock().lock();
        try {
            this.onAdd((E)iterable);
            this.addIterable(iterable);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void add(@Nonnull E e) {
        this.lock.writeLock().lock();
        try {
            this.onAdd(e);
            super.add(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @SafeVarargs
    public final void remove(E ... array) {
        this.lock.writeLock().lock();
        try {
            this.onDelete((E)Arrays.asList(array));
            super.remove(array);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void remove(@Nonnull E c) {
        this.lock.writeLock().lock();
        try {
            this.onDelete(c);
            super.remove(c);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public void clear() {
        this.lock.writeLock().lock();
        try {
            super.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public Stream<E> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    @Nonnull
    public Iterator<E> iterator() {
        return this.copyIterable().iterator();
    }

    public Spliterator<E> spliterator() {
        return this.copyIterable().spliterator();
    }

    public PriorityCollection<E> getByMIMEType(String mimeType) {
        this.lock.readLock().lock();
        try {
            PriorityCollection priorityCollection = super.getByMIMEType(mimeType);
            return priorityCollection;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    public String toString() {
        this.lock.readLock().lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected List<E> copyIterable() {
        this.lock.readLock().lock();
        try {
            ArrayList res = new ArrayList();
            super.iterator().forEachRemaining(res::add);
            ArrayList arrayList = res;
            return arrayList;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected void setIterable(Iterable<E> iterable) {
        super.set(iterable);
    }

    protected void addIterable(Iterable<E> iterable) {
        super.add(iterable);
    }

    @SafeVarargs
    protected final void onAdd(E ... array) {
        this.onAdd((E)Arrays.asList(array));
    }

    protected void onAdd(Iterable<E> iterable) {
        iterable.forEach(this::onAdd);
    }

    protected void onAdd(E e) {
    }

    protected void onDelete(Iterable<E> iterable) {
        iterable.forEach(this::onDelete);
    }

    protected void onDelete(E e) {
    }
}

