/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi;

import com.github.owlcs.ontapi.NoOpReadWriteLock;
import com.github.owlcs.ontapi.OntApiException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.EntityType;
import org.semanticweb.owlapi.model.HasAnnotationPropertiesInSignature;
import org.semanticweb.owlapi.model.HasAxioms;
import org.semanticweb.owlapi.model.HasClassesInSignature;
import org.semanticweb.owlapi.model.HasDataPropertiesInSignature;
import org.semanticweb.owlapi.model.HasDatatypesInSignature;
import org.semanticweb.owlapi.model.HasIndividualsInSignature;
import org.semanticweb.owlapi.model.HasLogicalAxioms;
import org.semanticweb.owlapi.model.HasObjectPropertiesInSignature;
import org.semanticweb.owlapi.model.HasSignature;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLAxiomCollection;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLIndividualAxiom;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLMutableOntology;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSignature;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.parameters.AxiomAnnotations;
import org.semanticweb.owlapi.model.parameters.Imports;
import org.semanticweb.owlapi.model.parameters.Navigation;
import org.semanticweb.owlapi.util.OWLAxiomSearchFilter;

@ParametersAreNonnullByDefault
public abstract class RWLockedOntology
implements OWLMutableOntology {
    protected final ReadWriteLock lock;

    public RWLockedOntology(@Nullable ReadWriteLock lock) {
        this.lock = NoOpReadWriteLock.nonNull(lock);
    }

    private static <X> Set<X> toSet(Stream<X> s) {
        return s.collect(Collectors.toCollection(LinkedHashSet::new));
    }

    private static <X> List<X> toList(Stream<X> s) {
        return s.collect(Collectors.toList());
    }

    public ReadWriteLock getLock() {
        return this.lock;
    }

    public void setLock(ReadWriteLock lock) {
        throw new OntApiException.Unsupported("Misuse: attempt to change locking.");
    }

    public boolean isConcurrent() {
        return NoOpReadWriteLock.isConcurrent(this.lock);
    }

    protected <X> X withReadLockToObject(Supplier<X> op) {
        this.lock.readLock().lock();
        try {
            X x = op.get();
            return x;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected <T extends Throwable> void withReadLock(WithThrowable<T> op) throws T {
        this.lock.readLock().lock();
        try {
            op.apply();
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    protected <X> X withWriteLockToObject(Supplier<X> op) {
        this.lock.writeLock().lock();
        try {
            X x = op.get();
            return x;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected <T extends Throwable> void withWriteLock(WithThrowable<T> op) throws T {
        this.lock.writeLock().lock();
        try {
            op.apply();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    protected <X> Set<X> toSet(Supplier<Stream<X>> sop) {
        return this.withReadLockToObject(() -> RWLockedOntology.toSet((Stream)sop.get()));
    }

    protected <X> Stream<X> withImportsToStream(Imports imports, Function<OWLOntology, Stream<X>> map) {
        return this.withReadLockToObject(() -> {
            if (Imports.EXCLUDED.equals((Object)imports)) {
                return (Stream)map.apply((OWLOntology)this);
            }
            return this.importsClosure().flatMap(map);
        });
    }

    protected long withImportsToLong(Imports imports, ToLongFunction<OWLOntology> map) {
        return this.withReadLockToObject(() -> {
            if (Imports.EXCLUDED.equals((Object)imports)) {
                return map.applyAsLong((OWLOntology)this);
            }
            return this.importsClosure().mapToLong(map).sum();
        });
    }

    protected boolean withImportsToBoolean(Imports imports, Predicate<OWLOntology> test) {
        return this.withReadLockToObject(() -> {
            if (Imports.EXCLUDED.equals((Object)imports)) {
                return test.test((OWLOntology)this);
            }
            return this.importsClosure().anyMatch(test);
        });
    }

    public Stream<OWLAxiom> axioms(Imports imports) {
        return this.withImportsToStream(imports, HasAxioms::axioms);
    }

    public <R extends OWLAxiom> Stream<R> axioms(AxiomType<R> type, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(type));
    }

    public Stream<OWLLogicalAxiom> logicalAxioms(Imports imports) {
        return this.withImportsToStream(imports, HasLogicalAxioms::logicalAxioms);
    }

    public Stream<OWLAxiom> axiomsIgnoreAnnotations(OWLAxiom axiom, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axiomsIgnoreAnnotations(axiom));
    }

    public Stream<OWLAxiom> referencingAxioms(OWLPrimitive primitive, Imports imports) {
        return this.withImportsToStream(imports, x -> x.referencingAxioms(primitive));
    }

    public Stream<OWLClassAxiom> axioms(OWLClass clazz, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(clazz));
    }

    public Stream<OWLDatatypeDefinitionAxiom> axioms(OWLDatatype datatype, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(datatype));
    }

    public Stream<OWLIndividualAxiom> axioms(OWLIndividual individual, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(individual));
    }

    public Stream<OWLAnnotationAxiom> axioms(OWLAnnotationProperty property, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(property));
    }

    public Stream<OWLObjectPropertyAxiom> axioms(OWLObjectPropertyExpression property, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(property));
    }

    public Stream<OWLDataPropertyAxiom> axioms(OWLDataProperty property, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(property));
    }

    public Stream<OWLAxiom> tboxAxioms(Imports imports) {
        return this.axioms(imports, AxiomType.TBoxAxiomTypes);
    }

    public Stream<OWLAxiom> aboxAxioms(Imports imports) {
        return this.axioms(imports, AxiomType.ABoxAxiomTypes);
    }

    public Stream<OWLAxiom> rboxAxioms(Imports imports) {
        return this.axioms(imports, AxiomType.RBoxAxiomTypes);
    }

    protected Stream<OWLAxiom> axioms(Imports imports, Set<AxiomType<?>> types) {
        return this.withImportsToStream(imports, x -> types.stream().flatMap(arg_0 -> ((OWLOntology)x).axioms(arg_0)));
    }

    public Stream<OWLEntity> signature(Imports imports) {
        return this.withImportsToStream(imports, HasSignature::signature);
    }

    public Stream<OWLClass> classesInSignature(Imports imports) {
        return this.withImportsToStream(imports, HasClassesInSignature::classesInSignature);
    }

    public Stream<OWLDatatype> datatypesInSignature(Imports imports) {
        return this.withImportsToStream(imports, HasDatatypesInSignature::datatypesInSignature);
    }

    public Stream<OWLNamedIndividual> individualsInSignature(Imports imports) {
        return this.withImportsToStream(imports, HasIndividualsInSignature::individualsInSignature);
    }

    public Stream<OWLObjectProperty> objectPropertiesInSignature(Imports imports) {
        return this.withImportsToStream(imports, HasObjectPropertiesInSignature::objectPropertiesInSignature);
    }

    public Stream<OWLDataProperty> dataPropertiesInSignature(Imports imports) {
        return this.withImportsToStream(imports, HasDataPropertiesInSignature::dataPropertiesInSignature);
    }

    public Stream<OWLAnnotationProperty> annotationPropertiesInSignature(Imports imports) {
        return this.withImportsToStream(imports, HasAnnotationPropertiesInSignature::annotationPropertiesInSignature);
    }

    public Stream<OWLAnonymousIndividual> referencedAnonymousIndividuals(Imports imports) {
        return this.withImportsToStream(imports, OWLSignature::referencedAnonymousIndividuals);
    }

    public Stream<OWLEntity> entitiesInSignature(IRI iri, Imports imports) {
        return this.withImportsToStream(imports, x -> x.entitiesInSignature(iri));
    }

    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, OWLObject object, Imports imports, Navigation navigation) {
        return this.withImportsToStream(imports, x -> x.axioms(type, object, navigation));
    }

    public <T extends OWLAxiom> Stream<T> axioms(OWLAxiomSearchFilter filter, Object key, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(filter, key));
    }

    public <T extends OWLAxiom> Stream<T> axioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject object, Imports imports, Navigation navigation) {
        return this.withImportsToStream(imports, x -> x.axioms(type, explicitClass, object, navigation));
    }

    public Stream<OWLAnnotationAssertionAxiom> annotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        return this.withImportsToStream(imports, x -> x.axioms(OWLAnnotationAssertionAxiom.class, OWLAnnotationSubject.class, (OWLObject)entity, Navigation.IN_SUB_POSITION));
    }

    public boolean isDeclared(OWLEntity entity, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.isDeclared(entity));
    }

    public boolean containsAxiom(OWLAxiom axiom, Imports imports, AxiomAnnotations annotations) {
        return this.withImportsToBoolean(imports, x -> annotations.contains(x, axiom));
    }

    public boolean containsEntitiesOfTypeInSignature(EntityType<?> type, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsEntitiesOfTypeInSignature(type));
    }

    public int getAxiomCount(Imports imports) {
        return (int)this.withImportsToLong(imports, OWLAxiomCollection::getAxiomCount);
    }

    public <T extends OWLAxiom> int getAxiomCount(AxiomType<T> type, Imports imports) {
        return (int)this.withImportsToLong(imports, x -> x.getAxiomCount(type));
    }

    public int getLogicalAxiomCount(Imports imports) {
        return (int)this.withImportsToLong(imports, OWLAxiomCollection::getLogicalAxiomCount);
    }

    public List<OWLAnnotation> annotationsAsList() {
        return this.withReadLockToObject(() -> RWLockedOntology.toList(this.annotations()));
    }

    public Set<IRI> getDirectImportsDocuments() {
        return this.toSet(() -> ((RWLockedOntology)this).directImportsDocuments());
    }

    public Set<OWLOntology> getDirectImports() {
        return this.toSet(() -> ((RWLockedOntology)this).directImports());
    }

    public Set<OWLOntology> getImports() {
        return this.toSet(() -> ((RWLockedOntology)this).imports());
    }

    public Set<OWLOntology> getImportsClosure() {
        return this.toSet(() -> ((RWLockedOntology)this).importsClosure());
    }

    public Set<OWLImportsDeclaration> getImportsDeclarations() {
        return this.toSet(() -> ((RWLockedOntology)this).importsDeclarations());
    }

    public Set<OWLClassAxiom> getGeneralClassAxioms() {
        return this.toSet(() -> ((RWLockedOntology)this).generalClassAxioms());
    }

    public Set<OWLEntity> getSignature() {
        return this.toSet(() -> ((RWLockedOntology)this).signature());
    }

    public Set<OWLClassExpression> getNestedClassExpressions() {
        return this.toSet(() -> ((RWLockedOntology)this).nestedClassExpressions());
    }

    public Set<OWLAnonymousIndividual> getAnonymousIndividuals() {
        return this.toSet(() -> ((RWLockedOntology)this).anonymousIndividuals());
    }

    public Set<OWLClass> getClassesInSignature() {
        return this.toSet(() -> ((RWLockedOntology)this).classesInSignature());
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature() {
        return this.toSet(() -> ((RWLockedOntology)this).objectPropertiesInSignature());
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature() {
        return this.toSet(() -> ((RWLockedOntology)this).dataPropertiesInSignature());
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature() {
        return this.toSet(() -> ((RWLockedOntology)this).individualsInSignature());
    }

    public Set<OWLDatatype> getDatatypesInSignature() {
        return this.toSet(() -> ((RWLockedOntology)this).datatypesInSignature());
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature() {
        return this.toSet(() -> ((RWLockedOntology)this).annotationPropertiesInSignature());
    }

    public Set<OWLAnnotation> getAnnotations() {
        return this.toSet(() -> ((RWLockedOntology)this).annotations());
    }

    public Set<OWLAxiom> getAxioms() {
        return this.toSet(() -> ((RWLockedOntology)this).axioms());
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms() {
        return this.toSet(() -> ((RWLockedOntology)this).logicalAxioms());
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals() {
        return this.toSet(() -> ((RWLockedOntology)this).referencedAnonymousIndividuals());
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri) {
        return this.toSet(() -> this.entitiesInSignature(iri));
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom) {
        return this.toSet(() -> this.axiomsIgnoreAnnotations(axiom));
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive primitive) {
        return this.toSet(() -> this.referencingAxioms(primitive));
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass clazz) {
        return this.toSet(() -> this.axioms(clazz));
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.axioms(property));
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property) {
        return this.toSet(() -> this.axioms(property));
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual) {
        return this.toSet(() -> this.axioms(individual));
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property) {
        return this.toSet(() -> this.axioms(property));
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype) {
        return this.toSet(() -> this.axioms(datatype));
    }

    public Set<OWLDeclarationAxiom> getDeclarationAxioms(OWLEntity entity) {
        return this.toSet(() -> this.declarationAxioms(entity));
    }

    public Set<OWLSubAnnotationPropertyOfAxiom> getSubAnnotationPropertyOfAxioms(OWLAnnotationProperty property) {
        return this.toSet(() -> this.subAnnotationPropertyOfAxioms(property));
    }

    public Set<OWLAnnotationPropertyDomainAxiom> getAnnotationPropertyDomainAxioms(OWLAnnotationProperty property) {
        return this.toSet(() -> this.annotationPropertyDomainAxioms(property));
    }

    public Set<OWLAnnotationPropertyRangeAxiom> getAnnotationPropertyRangeAxioms(OWLAnnotationProperty property) {
        return this.toSet(() -> this.annotationPropertyRangeAxioms(property));
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject subject) {
        return this.toSet(() -> this.annotationAssertionAxioms(subject));
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSubClass(OWLClass clazz) {
        return this.toSet(() -> this.subClassAxiomsForSubClass(clazz));
    }

    public Set<OWLSubClassOfAxiom> getSubClassAxiomsForSuperClass(OWLClass clazz) {
        return this.toSet(() -> this.subClassAxiomsForSuperClass(clazz));
    }

    public Set<OWLEquivalentClassesAxiom> getEquivalentClassesAxioms(OWLClass clazz) {
        return this.toSet(() -> this.equivalentClassesAxioms(clazz));
    }

    public Set<OWLDisjointClassesAxiom> getDisjointClassesAxioms(OWLClass clazz) {
        return this.toSet(() -> this.disjointClassesAxioms(clazz));
    }

    public Set<OWLDisjointUnionAxiom> getDisjointUnionAxioms(OWLClass clazz) {
        return this.toSet(() -> this.disjointUnionAxioms(clazz));
    }

    public Set<OWLHasKeyAxiom> getHasKeyAxioms(OWLClass clazz) {
        return this.toSet(() -> this.hasKeyAxioms(clazz));
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSubProperty(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.objectSubPropertyAxiomsForSubProperty(property));
    }

    public Set<OWLSubObjectPropertyOfAxiom> getObjectSubPropertyAxiomsForSuperProperty(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.objectSubPropertyAxiomsForSuperProperty(property));
    }

    public Set<OWLObjectPropertyDomainAxiom> getObjectPropertyDomainAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.objectPropertyDomainAxioms(property));
    }

    public Set<OWLObjectPropertyRangeAxiom> getObjectPropertyRangeAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.objectPropertyRangeAxioms(property));
    }

    public Set<OWLInverseObjectPropertiesAxiom> getInverseObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.inverseObjectPropertyAxioms(property));
    }

    public Set<OWLEquivalentObjectPropertiesAxiom> getEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.equivalentObjectPropertiesAxioms(property));
    }

    public Set<OWLDisjointObjectPropertiesAxiom> getDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.disjointObjectPropertiesAxioms(property));
    }

    public Set<OWLFunctionalObjectPropertyAxiom> getFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.functionalObjectPropertyAxioms(property));
    }

    public Set<OWLInverseFunctionalObjectPropertyAxiom> getInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.inverseFunctionalObjectPropertyAxioms(property));
    }

    public Set<OWLSymmetricObjectPropertyAxiom> getSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.symmetricObjectPropertyAxioms(property));
    }

    public Set<OWLAsymmetricObjectPropertyAxiom> getAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.asymmetricObjectPropertyAxioms(property));
    }

    public Set<OWLReflexiveObjectPropertyAxiom> getReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.reflexiveObjectPropertyAxioms(property));
    }

    public Set<OWLIrreflexiveObjectPropertyAxiom> getIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.irreflexiveObjectPropertyAxioms(property));
    }

    public Set<OWLTransitiveObjectPropertyAxiom> getTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression property) {
        return this.toSet(() -> this.transitiveObjectPropertyAxioms(property));
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSubProperty(OWLDataProperty property) {
        return this.toSet(() -> this.dataSubPropertyAxiomsForSubProperty(property));
    }

    public Set<OWLSubDataPropertyOfAxiom> getDataSubPropertyAxiomsForSuperProperty(OWLDataPropertyExpression property) {
        return this.toSet(() -> this.dataSubPropertyAxiomsForSuperProperty(property));
    }

    public Set<OWLDataPropertyDomainAxiom> getDataPropertyDomainAxioms(OWLDataProperty property) {
        return this.toSet(() -> this.dataPropertyDomainAxioms(property));
    }

    public Set<OWLDataPropertyRangeAxiom> getDataPropertyRangeAxioms(OWLDataProperty property) {
        return this.toSet(() -> this.dataPropertyRangeAxioms(property));
    }

    public Set<OWLEquivalentDataPropertiesAxiom> getEquivalentDataPropertiesAxioms(OWLDataProperty property) {
        return this.toSet(() -> this.equivalentDataPropertiesAxioms(property));
    }

    public Set<OWLDisjointDataPropertiesAxiom> getDisjointDataPropertiesAxioms(OWLDataProperty property) {
        return this.toSet(() -> this.disjointDataPropertiesAxioms(property));
    }

    public Set<OWLFunctionalDataPropertyAxiom> getFunctionalDataPropertyAxioms(OWLDataPropertyExpression property) {
        return this.toSet(() -> this.functionalDataPropertyAxioms(property));
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLIndividual individual) {
        return this.toSet(() -> this.classAssertionAxioms(individual));
    }

    public Set<OWLClassAssertionAxiom> getClassAssertionAxioms(OWLClassExpression clazz) {
        return this.toSet(() -> this.classAssertionAxioms(clazz));
    }

    public Set<OWLDataPropertyAssertionAxiom> getDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.toSet(() -> this.dataPropertyAssertionAxioms(individual));
    }

    public Set<OWLObjectPropertyAssertionAxiom> getObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.toSet(() -> this.objectPropertyAssertionAxioms(individual));
    }

    public Set<OWLNegativeObjectPropertyAssertionAxiom> getNegativeObjectPropertyAssertionAxioms(OWLIndividual individual) {
        return this.toSet(() -> this.negativeObjectPropertyAssertionAxioms(individual));
    }

    public Set<OWLNegativeDataPropertyAssertionAxiom> getNegativeDataPropertyAssertionAxioms(OWLIndividual individual) {
        return this.toSet(() -> this.negativeDataPropertyAssertionAxioms(individual));
    }

    public Set<OWLSameIndividualAxiom> getSameIndividualAxioms(OWLIndividual individual) {
        return this.toSet(() -> this.sameIndividualAxioms(individual));
    }

    public Set<OWLDifferentIndividualsAxiom> getDifferentIndividualAxioms(OWLIndividual individual) {
        return this.toSet(() -> this.differentIndividualAxioms(individual));
    }

    public Set<OWLDatatypeDefinitionAxiom> getDatatypeDefinitions(OWLDatatype datatype) {
        return this.toSet(() -> this.datatypeDefinitions(datatype));
    }

    public Set<OWLAnnotation> getAnnotations(OWLAnnotationProperty property) {
        return this.toSet(() -> ((RWLockedOntology)this).annotations());
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> type) {
        return this.toSet(() -> this.axioms(type));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, Class<? extends OWLObject> classType, OWLObject entity, Navigation navigation) {
        return this.toSet(() -> this.axioms(type, classType, entity, navigation));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, OWLObject entity, Navigation navigation) {
        return this.toSet(() -> this.axioms(type, entity, navigation));
    }

    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter filter, Object key) {
        return this.toSet(() -> this.axioms(filter, key));
    }

    public Set<OWLAxiom> getAxioms(Imports imports) {
        return this.toSet(() -> this.axioms(imports));
    }

    public Set<OWLLogicalAxiom> getLogicalAxioms(Imports imports) {
        return this.toSet(() -> this.logicalAxioms(imports));
    }

    public Set<OWLEntity> getSignature(Imports imports) {
        return this.toSet(() -> this.signature(imports));
    }

    public Set<OWLAxiom> getTBoxAxioms(Imports imports) {
        return this.toSet(() -> this.tboxAxioms(imports));
    }

    public Set<OWLAxiom> getABoxAxioms(Imports imports) {
        return this.toSet(() -> this.aboxAxioms(imports));
    }

    public Set<OWLAxiom> getRBoxAxioms(Imports imports) {
        return this.toSet(() -> this.rboxAxioms(imports));
    }

    public Set<OWLClass> getClassesInSignature(Imports imports) {
        return this.toSet(() -> this.classesInSignature(imports));
    }

    public Set<OWLDatatype> getDatatypesInSignature(Imports imports) {
        return this.toSet(() -> this.datatypesInSignature(imports));
    }

    public Set<OWLNamedIndividual> getIndividualsInSignature(Imports imports) {
        return this.toSet(() -> this.individualsInSignature(imports));
    }

    public Set<OWLObjectProperty> getObjectPropertiesInSignature(Imports imports) {
        return this.toSet(() -> this.objectPropertiesInSignature(imports));
    }

    public Set<OWLDataProperty> getDataPropertiesInSignature(Imports imports) {
        return this.toSet(() -> this.dataPropertiesInSignature(imports));
    }

    public Set<OWLAnnotationProperty> getAnnotationPropertiesInSignature(Imports imports) {
        return this.toSet(() -> this.annotationPropertiesInSignature(imports));
    }

    public Set<OWLAnonymousIndividual> getReferencedAnonymousIndividuals(Imports imports) {
        return this.toSet(() -> this.referencedAnonymousIndividuals(imports));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(AxiomType<T> type, Imports imports) {
        return this.toSet(() -> this.axioms(type, imports));
    }

    public Set<OWLAxiom> getAxiomsIgnoreAnnotations(OWLAxiom axiom, Imports imports) {
        return this.toSet(() -> this.axiomsIgnoreAnnotations(axiom, imports));
    }

    public Set<OWLAxiom> getReferencingAxioms(OWLPrimitive primitive, Imports imports) {
        return this.toSet(() -> this.referencingAxioms(primitive, imports));
    }

    public Set<OWLClassAxiom> getAxioms(OWLClass clazz, Imports imports) {
        return this.toSet(() -> this.axioms(clazz, imports));
    }

    public Set<OWLObjectPropertyAxiom> getAxioms(OWLObjectPropertyExpression property, Imports imports) {
        return this.toSet(() -> this.axioms(property, imports));
    }

    public Set<OWLDataPropertyAxiom> getAxioms(OWLDataProperty property, Imports imports) {
        return this.toSet(() -> this.axioms(property, imports));
    }

    public Set<OWLIndividualAxiom> getAxioms(OWLIndividual individual, Imports imports) {
        return this.toSet(() -> this.axioms(individual, imports));
    }

    public Set<OWLAnnotationAxiom> getAxioms(OWLAnnotationProperty property, Imports imports) {
        return this.toSet(() -> this.axioms(property, imports));
    }

    public Set<OWLDatatypeDefinitionAxiom> getAxioms(OWLDatatype datatype, Imports imports) {
        return this.toSet(() -> this.axioms(datatype, imports));
    }

    public Set<OWLEntity> getEntitiesInSignature(IRI iri, Imports imports) {
        return this.toSet(() -> this.entitiesInSignature(iri, imports));
    }

    public Set<OWLAnnotationAssertionAxiom> getAnnotationAssertionAxioms(OWLAnnotationSubject entity, Imports imports) {
        return this.toSet(() -> this.annotationAssertionAxioms(entity, imports));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, OWLObject object, Imports imports, Navigation navigation) {
        return this.toSet(() -> this.axioms(type, object, imports, navigation));
    }

    public <T extends OWLAxiom> Collection<T> filterAxioms(OWLAxiomSearchFilter filter, Object o, Imports imports) {
        return this.toSet(() -> this.axioms(filter, o, imports));
    }

    public <T extends OWLAxiom> Set<T> getAxioms(Class<T> type, Class<? extends OWLObject> explicitClass, OWLObject object, Imports imports, Navigation navigation) {
        return this.toSet(() -> this.axioms(type, explicitClass, object, imports, navigation));
    }

    public boolean contains(OWLAxiomSearchFilter filter, Object o, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.contains(filter, o));
    }

    public boolean containsReference(OWLEntity entity, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsReference(entity));
    }

    public boolean containsEntityInSignature(OWLEntity entity, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsEntityInSignature(entity));
    }

    public boolean containsEntityInSignature(IRI iri, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsEntityInSignature(iri));
    }

    public boolean containsClassInSignature(IRI iri, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsClassInSignature(iri));
    }

    public boolean containsObjectPropertyInSignature(IRI iri, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsObjectPropertyInSignature(iri));
    }

    public boolean containsDataPropertyInSignature(IRI iri, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsDataPropertyInSignature(iri));
    }

    public boolean containsAnnotationPropertyInSignature(IRI iri, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsAnnotationPropertyInSignature(iri));
    }

    public boolean containsDatatypeInSignature(IRI iri, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsDatatypeInSignature(iri));
    }

    public boolean containsIndividualInSignature(IRI iri, Imports imports) {
        return this.withImportsToBoolean(imports, x -> x.containsIndividualInSignature(iri));
    }

    @FunctionalInterface
    protected static interface WithThrowable<T extends Throwable> {
        public void apply() throws T;
    }
}

