/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.config;

import com.github.owlcs.ontapi.NoOpReadWriteLock;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsControl;
import com.github.owlcs.ontapi.config.CacheControl;
import com.github.owlcs.ontapi.config.LoadControl;
import com.github.owlcs.ontapi.config.LoadSettings;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import com.github.owlcs.ontapi.config.OntSettings;
import com.github.owlcs.ontapi.config.OntWriterConfiguration;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.transforms.GraphTransformers;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.OntologyConfigurator;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntConfig
extends OntologyConfigurator
implements LoadControl<OntConfig>,
CacheControl<OntConfig>,
AxiomsControl<OntConfig> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntConfig.class);
    private static final long serialVersionUID = 656765031127374396L;
    protected final Map<OntSettings, Object> data = new EnumMap<OntSettings, Object>(OntSettings.class);
    protected final Set<OntSettings> forbidden = EnumSet.noneOf(OntSettings.class);
    private transient OntLoaderConfiguration loader;
    private transient OntWriterConfiguration writer;

    public static OntConfig createConfig(ReadWriteLock lock) {
        return OntConfig.withLock(new OntConfig(), lock);
    }

    public static OntConfig withLock(OntConfig conf, ReadWriteLock lock) {
        if (conf instanceof Concurrent) {
            conf = ((Concurrent)conf).delegate;
        }
        if (NoOpReadWriteLock.isConcurrent(lock)) {
            return conf;
        }
        return new Concurrent(conf, lock);
    }

    public static OntConfig copy(OntologyConfigurator from) {
        return new OntConfig().putAll(from);
    }

    protected static Map<OntSettings, Object> serializableOnly(Map<OntSettings, Object> data) {
        EnumMap<OntSettings, Object> res = new EnumMap<OntSettings, Object>(OntSettings.class);
        data.forEach((k, v) -> {
            if (v instanceof Serializable) {
                res.put((OntSettings)((Object)k), v);
            }
        });
        return res;
    }

    protected static Set<IRI> ignoredImports(OntologyConfigurator owl) {
        try {
            Field field = owl.getClass().getDeclaredField("ignoredImports");
            field.setAccessible(true);
            return (Set)field.get(owl);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new OntApiException("Can't get OntologyConfigurator#ignoredImports.", e);
        }
    }

    static <N extends Integer> N requirePositive(N n, Object message) {
        if (n.intValue() > 0) {
            return n;
        }
        throw new IllegalArgumentException(message + " must be positive: " + n);
    }

    static <N extends Integer> N requireNonNegative(N n, Object message) {
        if (n.intValue() >= 0) {
            return n;
        }
        throw new IllegalArgumentException(message + " must be non-negative: " + n);
    }

    static Map<OntSettings, Object> loadMap(Map<OntSettings, Object> map, OntSettings ... keys) {
        if (map.size() != keys.length) {
            for (OntSettings k : keys) {
                map.computeIfAbsent(k, OntSettings::getDefaultValue);
            }
        }
        return map;
    }

    public OntConfig lockProperty(OntSettings ... keys) {
        this.forbidden.addAll(Arrays.asList(keys));
        return this;
    }

    public OntConfig putAll(OntologyConfigurator from) {
        if (from == null) {
            return this;
        }
        if (from instanceof OntConfig) {
            Map<OntSettings, Object> tmp = from instanceof Concurrent ? ((Concurrent)from).delegate.data : ((OntConfig)from).data;
            tmp.forEach(this::put);
            return this;
        }
        this.put(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS, new ArrayList<IRI>(OntConfig.ignoredImports(from)));
        this.put(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION, from.shouldAcceptHTTPCompression());
        this.put(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT, from.getConnectionTimeout());
        this.put(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS, from.shouldFollowRedirects());
        this.put(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS, from.shouldLoadAnnotations());
        this.put(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY, from.getMissingImportHandlingStrategy());
        this.put(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY, from.getMissingOntologyHeaderStrategy());
        this.put(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES, from.shouldReportStackTraces());
        this.put(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT, from.getRetriesToAttempt());
        this.put(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION, from.shouldParseWithStrictConfiguration());
        this.put(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN, from.shouldTreatDublinCoreAsBuiltin());
        this.put(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING, from.getPriorityCollectionSorting());
        this.put(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS, from.getBannedParsers());
        this.put(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS, from.shouldSaveIds());
        this.put(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS, from.shouldRemapIds());
        this.put(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES, from.shouldUseNamespaceEntities());
        this.put(OntSettings.OWL_API_WRITE_CONF_INDENTING, from.shouldIndent());
        this.put(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER, from.shouldUseLabelsAsBanner());
        this.put(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED, from.shouldUseBanners());
        this.put(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE, from.getIndentSize());
        return this;
    }

    protected <X> X get(OntSettings key) {
        return (X)this.data.computeIfAbsent(key, x -> key.getDefaultValue());
    }

    protected OntConfig put(OntSettings key, Object value) {
        if (this.forbidden.contains((Object)key)) {
            throw new OntApiException.ModificationDenied("Changing property=" + (Object)((Object)key) + " is forbidden.");
        }
        if (Objects.requireNonNull(value).equals(this.data.put(key, value))) {
            return this;
        }
        this.loader = null;
        this.writer = null;
        return this;
    }

    protected OntConfig putPositive(OntSettings k, int v) {
        return this.put(k, OntConfig.requirePositive(v, (Object)k));
    }

    protected OntConfig putNonNegative(OntSettings k, int v) {
        return this.put(k, OntConfig.requireNonNegative(v, (Object)k));
    }

    @Override
    public OntPersonality getPersonality() {
        return (OntPersonality)this.get(OntSettings.ONT_API_LOAD_CONF_PERSONALITY_MODE);
    }

    @Override
    public OntConfig setPersonality(OntPersonality p) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_PERSONALITY_MODE, p);
    }

    @Override
    public GraphTransformers getGraphTransformers() {
        return (GraphTransformers)this.get(OntSettings.ONT_API_LOAD_CONF_TRANSFORMERS);
    }

    @Override
    public OntConfig setGraphTransformers(GraphTransformers t) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_TRANSFORMERS, t);
    }

    public int getManagerIRIsCacheSize() {
        return (Integer)this.get(OntSettings.ONT_API_MANAGER_CACHE_IRIS);
    }

    protected OntConfig setManagerIRIsCacheSize(int size) {
        return this.put(OntSettings.ONT_API_MANAGER_CACHE_IRIS, size);
    }

    @Override
    public int getLoadNodesCacheSize() {
        return (Integer)this.get(OntSettings.ONT_API_LOAD_CONF_CACHE_NODES);
    }

    @Override
    public OntConfig setLoadNodesCacheSize(int size) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_CACHE_NODES, size);
    }

    @Override
    public int getLoadObjectsCacheSize() {
        return (Integer)this.get(OntSettings.ONT_API_LOAD_CONF_CACHE_OBJECTS);
    }

    @Override
    public OntConfig setLoadObjectsCacheSize(int size) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_CACHE_OBJECTS, size);
    }

    @Override
    public int getModelCacheLevel() {
        return (Integer)this.get(OntSettings.ONT_API_LOAD_CONF_CACHE_MODEL);
    }

    @Override
    public OntConfig setModelCacheLevel(int level) {
        return this.putNonNegative(OntSettings.ONT_API_LOAD_CONF_CACHE_MODEL, level);
    }

    public List<LoadSettings.Scheme> getSupportedSchemes() {
        return (List)this.get(OntSettings.ONT_API_LOAD_CONF_SUPPORTED_SCHEMES);
    }

    @Override
    public OntConfig setSupportedSchemes(List<LoadSettings.Scheme> schemes) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_SUPPORTED_SCHEMES, Collections.unmodifiableList(schemes));
    }

    @Override
    public OntConfig disableWebAccess() {
        return this.setSupportedSchemes(Collections.singletonList(DefaultScheme.FILE));
    }

    @Override
    public boolean isPerformTransformation() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS);
    }

    @Override
    public OntConfig setPerformTransformation(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS, b);
    }

    @Override
    public boolean isProcessImports() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_PROCESS_IMPORTS);
    }

    @Override
    public OntConfig setProcessImports(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_PROCESS_IMPORTS, b);
    }

    @Override
    public boolean isAllowBulkAnnotationAssertions() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS);
    }

    @Override
    public OntConfig setAllowBulkAnnotationAssertions(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS, b);
    }

    @Override
    public boolean isAllowReadDeclarations() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS);
    }

    @Override
    public OntConfig setAllowReadDeclarations(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS, b);
    }

    @Override
    public boolean isIgnoreAnnotationAxiomOverlaps() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS);
    }

    @Override
    public OntConfig setIgnoreAnnotationAxiomOverlaps(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS, b);
    }

    @Override
    public boolean isUseOWLParsersToLoad() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD);
    }

    @Override
    public OntConfig setUseOWLParsersToLoad(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD, b);
    }

    @Override
    public boolean isIgnoreAxiomsReadErrors() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS);
    }

    @Override
    public OntConfig setIgnoreAxiomsReadErrors(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS, b);
    }

    @Override
    public boolean isSplitAxiomAnnotations() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS);
    }

    @Override
    public OntConfig setSplitAxiomAnnotations(boolean b) {
        return this.put(OntSettings.ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS, b);
    }

    public boolean isControlImports() {
        return (Boolean)this.get(OntSettings.ONT_API_WRITE_CONF_CONTROL_IMPORTS);
    }

    public OntConfig setControlImports(boolean b) {
        return this.put(OntSettings.ONT_API_WRITE_CONF_CONTROL_IMPORTS, b);
    }

    public boolean shouldLoadAnnotations() {
        return this.isLoadAnnotationAxioms();
    }

    @Override
    public boolean isLoadAnnotationAxioms() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS);
    }

    @Override
    public OntConfig setLoadAnnotationAxioms(boolean b) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS, b);
    }

    public OntConfig withEntityExpansionLimit(@Nonnull String s) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT, s);
    }

    public String getEntityExpansionLimit() {
        return (String)this.get(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT);
    }

    public OntConfig withBannedParsers(@Nonnull String parsers) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS, parsers);
    }

    public String getBannedParsers() {
        return (String)this.get(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS);
    }

    public PriorityCollectionSorting getPriorityCollectionSorting() {
        return (PriorityCollectionSorting)this.get(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING);
    }

    public OntConfig setPriorityCollectionSorting(@Nonnull PriorityCollectionSorting sorting) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING, sorting);
    }

    protected List<String> getIgnoredImports() {
        return new ArrayList<String>((Collection)this.get(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS));
    }

    protected OntConfig putIgnoredImports(List<String> imports) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS, Collections.unmodifiableList(imports));
    }

    public OntConfig addIgnoredImport(@Nonnull IRI iri) {
        List<String> list = this.getIgnoredImports();
        if (list.contains(iri.getIRIString())) {
            return this;
        }
        list.add(iri.getIRIString());
        return this.putIgnoredImports(list);
    }

    public OntConfig clearIgnoredImports() {
        List<String> list = this.getIgnoredImports();
        if (list.isEmpty()) {
            return this;
        }
        return this.putIgnoredImports(new ArrayList<String>());
    }

    public OntConfig removeIgnoredImport(@Nonnull IRI iri) {
        List<String> list = this.getIgnoredImports();
        if (!list.contains(iri.getIRIString())) {
            return this;
        }
        list.remove(iri.getIRIString());
        return this.putIgnoredImports(list);
    }

    public OntConfig setAcceptingHTTPCompression(boolean b) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION, b);
    }

    public boolean shouldAcceptHTTPCompression() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION);
    }

    public int getConnectionTimeout() {
        return (Integer)this.get(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT);
    }

    public OntConfig setConnectionTimeout(int t) {
        return this.putPositive(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT, t);
    }

    public OntConfig setFollowRedirects(boolean b) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS, b);
    }

    public boolean shouldFollowRedirects() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS);
    }

    public MissingImportHandlingStrategy getMissingImportHandlingStrategy() {
        return (MissingImportHandlingStrategy)this.get(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY);
    }

    public OntConfig setMissingImportHandlingStrategy(@Nonnull MissingImportHandlingStrategy strategy) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY, strategy);
    }

    public MissingOntologyHeaderStrategy getMissingOntologyHeaderStrategy() {
        return (MissingOntologyHeaderStrategy)this.get(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY);
    }

    public OntConfig setMissingOntologyHeaderStrategy(@Nonnull MissingOntologyHeaderStrategy strategy) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY, strategy);
    }

    public OntConfig setReportStackTraces(boolean b) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES, b);
    }

    public boolean shouldReportStackTraces() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES);
    }

    public int getRetriesToAttempt() {
        return (Integer)this.get(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT);
    }

    public OntConfig setRetriesToAttempt(int retries) {
        return this.putPositive(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT, retries);
    }

    public OntConfig setStrict(boolean strict) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION, strict);
    }

    public boolean shouldParseWithStrictConfiguration() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION);
    }

    public OntConfig setTreatDublinCoreAsBuiltIn(boolean value) {
        return this.put(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN, value);
    }

    public boolean shouldTreatDublinCoreAsBuiltin() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN);
    }

    public OntConfig withSaveIdsForAllAnonymousIndividuals(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS, b);
    }

    public boolean shouldSaveIds() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS);
    }

    public OntConfig withRemapAllAnonymousIndividualsIds(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS, b);
    }

    public boolean shouldRemapIds() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS);
    }

    public OntConfig withUseNamespaceEntities(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES, b);
    }

    public boolean shouldUseNamespaceEntities() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES);
    }

    public OntConfig withIndenting(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_INDENTING, b);
    }

    public boolean shouldIndent() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_INDENTING);
    }

    public OntConfig withIndentSize(int indent) {
        return this.putPositive(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE, indent);
    }

    public int getIndentSize() {
        return (Integer)this.get(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE);
    }

    public OntConfig withLabelsAsBanner(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER, b);
    }

    public boolean shouldUseLabelsAsBanner() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER);
    }

    public OntConfig withBannersEnabled(boolean b) {
        return this.put(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED, b);
    }

    public boolean shouldUseBanners() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED);
    }

    public boolean shouldRepairIllegalPunnings() {
        LOGGER.warn("ONT-API does not support RepairIllegalPunnings");
        return true;
    }

    public OntConfig withRepairIllegalPunnings(boolean b) {
        LOGGER.warn("ONT-API does not support RepairIllegalPunnings");
        return this;
    }

    public OntLoaderConfiguration buildLoaderConfiguration() {
        if (this.loader != null) {
            return this.loader;
        }
        OntLoaderConfiguration res = new OntLoaderConfiguration();
        for (OntSettings s : OntSettings.LOAD_CONFIG_KEYS) {
            res.data.put(s, this.get(s));
        }
        this.loader = res;
        return this.loader;
    }

    public OntWriterConfiguration buildWriterConfiguration() {
        if (this.writer != null) {
            return this.writer;
        }
        OntWriterConfiguration res = new OntWriterConfiguration();
        for (OntSettings s : OntSettings.WRITE_CONFIG_KEYS) {
            res.data.put(s, this.get(s));
        }
        this.writer = res;
        return this.writer;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OntConfig)) {
            return false;
        }
        OntConfig that = (OntConfig)o;
        return Objects.equals(this.asMap(), that.asMap());
    }

    public int hashCode() {
        return Objects.hash(this.asMap());
    }

    protected Map<OntSettings, Object> asMap() {
        return OntConfig.loadMap(this.data, OntSettings.values());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(OntConfig.serializableOnly(this.data));
        out.writeObject(this.forbidden);
    }

    public static class Concurrent
    extends OntConfig {
        private static final long serialVersionUID = 5910609264963651991L;
        protected final ReadWriteLock lock;
        protected final OntConfig delegate;

        protected Concurrent(OntConfig from, ReadWriteLock lock) {
            this.delegate = Objects.requireNonNull(from);
            this.lock = NoOpReadWriteLock.nonNull(lock);
        }

        @Override
        protected Map<OntSettings, Object> asMap() {
            return this.delegate.asMap();
        }

        @Override
        public OntConfig putAll(OntologyConfigurator from) {
            this.lock.writeLock().lock();
            try {
                this.delegate.putAll(from);
                Concurrent concurrent = this;
                return concurrent;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        protected <X> X get(OntSettings key) {
            this.lock.readLock().lock();
            try {
                Object x = this.delegate.get(key);
                return x;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected Concurrent put(OntSettings key, Object value) {
            this.lock.writeLock().lock();
            try {
                this.delegate.put(key, value);
                Concurrent concurrent = this;
                return concurrent;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public OntLoaderConfiguration buildLoaderConfiguration() {
            this.lock.readLock().lock();
            try {
                OntLoaderConfiguration ontLoaderConfiguration = this.delegate.buildLoaderConfiguration();
                return ontLoaderConfiguration;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public OntWriterConfiguration buildWriterConfiguration() {
            this.lock.readLock().lock();
            try {
                OntWriterConfiguration ontWriterConfiguration = this.delegate.buildWriterConfiguration();
                return ontWriterConfiguration;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public OntConfig addIgnoredImport(@Nonnull IRI iri) {
            this.lock.writeLock().lock();
            try {
                this.delegate.addIgnoredImport(iri);
                Concurrent concurrent = this;
                return concurrent;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public OntConfig clearIgnoredImports() {
            this.lock.writeLock().lock();
            try {
                this.delegate.clearIgnoredImports();
                Concurrent concurrent = this;
                return concurrent;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public OntConfig removeIgnoredImport(@Nonnull IRI iri) {
            this.lock.writeLock().lock();
            try {
                this.delegate.removeIgnoredImport(iri);
                Concurrent concurrent = this;
                return concurrent;
            }
            finally {
                this.lock.writeLock().unlock();
            }
        }

        @Override
        public boolean equals(Object o) {
            this.lock.readLock().lock();
            try {
                if (o instanceof Concurrent) {
                    o = ((Concurrent)o).delegate;
                }
                boolean bl = this.delegate.equals(o);
                return bl;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }

        @Override
        public int hashCode() {
            this.lock.readLock().lock();
            try {
                int n = this.delegate.hashCode();
                return n;
            }
            finally {
                this.lock.readLock().unlock();
            }
        }
    }

    public static enum DefaultScheme implements LoadSettings.Scheme
    {
        HTTP,
        HTTPS,
        FTP,
        FILE;

        private final String value = this.name().toLowerCase();

        public static Stream<DefaultScheme> all() {
            return Stream.of(DefaultScheme.values());
        }

        @Override
        public String key() {
            return this.value;
        }
    }
}

