/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.config;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsControl;
import com.github.owlcs.ontapi.config.CacheControl;
import com.github.owlcs.ontapi.config.LoadControl;
import com.github.owlcs.ontapi.config.LoadSettings;
import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.config.OntSettings;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.transforms.GraphTransformers;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.MissingOntologyHeaderStrategy;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.PriorityCollectionSorting;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OntLoaderConfiguration
extends OWLOntologyLoaderConfiguration
implements LoadControl<OntLoaderConfiguration>,
CacheControl<OntLoaderConfiguration>,
AxiomsControl<OntLoaderConfiguration> {
    private static final Logger LOGGER = LoggerFactory.getLogger(OntLoaderConfiguration.class);
    private static final long serialVersionUID = 1599596390911768315L;
    protected final Map<OntSettings, Object> data = new EnumMap<OntSettings, Object>(OntSettings.class);

    protected OntLoaderConfiguration() {
    }

    public OntLoaderConfiguration(OWLOntologyLoaderConfiguration from) {
        this();
        if (from == null) {
            return;
        }
        if (from instanceof OntLoaderConfiguration) {
            this.copyONTSettings((OntLoaderConfiguration)from);
        } else {
            this.copyOWLSettings(from);
        }
    }

    protected <X> X get(OntSettings key) {
        return (X)this.data.computeIfAbsent(key, OntSettings::getDefaultValue);
    }

    private OntLoaderConfiguration setPositive(OntSettings k, int v) {
        return this.set(k, OntConfig.requirePositive(v, (Object)k));
    }

    private OntLoaderConfiguration setNonNegative(OntSettings k, int v) {
        return this.set(k, OntConfig.requireNonNegative(v, (Object)k));
    }

    protected OntLoaderConfiguration set(OntSettings key, Object v) {
        Objects.requireNonNull(v);
        if (Objects.equals(this.get(key), v)) {
            return this;
        }
        OntLoaderConfiguration copy = new OntLoaderConfiguration(this);
        copy.data.put(key, v);
        return copy;
    }

    protected void copyOWLSettings(OWLOntologyLoaderConfiguration conf) {
        this.data.put(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS, new ArrayList<IRI>(OntLoaderConfiguration.ignoredImports(conf)));
        this.data.put(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION, conf.isAcceptingHTTPCompression());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT, conf.getConnectionTimeout());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS, conf.isFollowRedirects());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS, conf.isLoadAnnotationAxioms());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY, conf.getMissingImportHandlingStrategy());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY, conf.getMissingOntologyHeaderStrategy());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES, conf.isReportStackTrace());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT, conf.getRetriesToAttempt());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION, conf.isStrict());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN, conf.isTreatDublinCoreAsBuiltIn());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING, conf.getPriorityCollectionSorting());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS, conf.getBannedParsers());
        this.data.put(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT, conf.getEntityExpansionLimit());
        this.data.put(OntSettings.OWL_API_AUTHORIZATION_VALUE, conf.getAuthorizationValue());
    }

    protected void copyONTSettings(OntLoaderConfiguration conf) {
        this.data.putAll(conf.data);
    }

    protected static Set<IRI> ignoredImports(OWLOntologyLoaderConfiguration owl) {
        try {
            Field field = owl.getClass().getDeclaredField("ignoredImports");
            field.setAccessible(true);
            return (Set)field.get(owl);
        }
        catch (ClassCastException | IllegalAccessException | NoSuchFieldException e) {
            throw new OntApiException("Can't get OWLOntologyLoaderConfiguration#ignoredImports.", e);
        }
    }

    @Override
    public boolean isPerformTransformation() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS);
    }

    @Override
    public OntLoaderConfiguration setPerformTransformation(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_PERFORM_TRANSFORMATIONS, b);
    }

    @Override
    public GraphTransformers getGraphTransformers() {
        return (GraphTransformers)this.get(OntSettings.ONT_API_LOAD_CONF_TRANSFORMERS);
    }

    @Override
    public OntLoaderConfiguration setGraphTransformers(GraphTransformers t) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_TRANSFORMERS, t);
    }

    @Override
    public OntPersonality getPersonality() {
        return (OntPersonality)this.get(OntSettings.ONT_API_LOAD_CONF_PERSONALITY_MODE);
    }

    @Override
    public OntLoaderConfiguration setPersonality(OntPersonality p) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_PERSONALITY_MODE, p);
    }

    @Override
    public boolean isProcessImports() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_PROCESS_IMPORTS);
    }

    @Override
    public OntLoaderConfiguration setProcessImports(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_PROCESS_IMPORTS, b);
    }

    @Override
    public OntLoaderConfiguration setLoadNodesCacheSize(int size) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_CACHE_NODES, size);
    }

    @Override
    public int getLoadNodesCacheSize() {
        return (Integer)this.get(OntSettings.ONT_API_LOAD_CONF_CACHE_NODES);
    }

    @Override
    public OntLoaderConfiguration setLoadObjectsCacheSize(int size) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_CACHE_OBJECTS, size);
    }

    @Override
    public int getLoadObjectsCacheSize() {
        return (Integer)this.get(OntSettings.ONT_API_LOAD_CONF_CACHE_OBJECTS);
    }

    @Override
    public OntLoaderConfiguration setModelCacheLevel(int level) {
        return this.setNonNegative(OntSettings.ONT_API_LOAD_CONF_CACHE_MODEL, level);
    }

    @Override
    public int getModelCacheLevel() {
        return (Integer)this.get(OntSettings.ONT_API_LOAD_CONF_CACHE_MODEL);
    }

    public List<LoadSettings.Scheme> getSupportedSchemes() {
        return (List)this.get(OntSettings.ONT_API_LOAD_CONF_SUPPORTED_SCHEMES);
    }

    @Override
    public OntLoaderConfiguration setSupportedSchemes(List<LoadSettings.Scheme> schemes) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_SUPPORTED_SCHEMES, Collections.unmodifiableList(schemes));
    }

    @Override
    public OntLoaderConfiguration disableWebAccess() {
        return this.setSupportedSchemes(Collections.singletonList(OntConfig.DefaultScheme.FILE));
    }

    @Override
    public boolean isAllowBulkAnnotationAssertions() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS);
    }

    @Override
    public OntLoaderConfiguration setAllowBulkAnnotationAssertions(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_ALLOW_BULK_ANNOTATION_ASSERTIONS, b);
    }

    @Override
    public boolean isAllowReadDeclarations() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS);
    }

    @Override
    public OntLoaderConfiguration setAllowReadDeclarations(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_ALLOW_READ_DECLARATIONS, b);
    }

    @Override
    public boolean isIgnoreAnnotationAxiomOverlaps() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS);
    }

    @Override
    public OntLoaderConfiguration setIgnoreAnnotationAxiomOverlaps(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_IGNORE_ANNOTATION_AXIOM_OVERLAPS, b);
    }

    @Override
    public boolean isUseOWLParsersToLoad() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD);
    }

    @Override
    public OntLoaderConfiguration setUseOWLParsersToLoad(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_USE_OWL_PARSERS_TO_LOAD, b);
    }

    @Override
    public boolean isIgnoreAxiomsReadErrors() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS);
    }

    @Override
    public OntLoaderConfiguration setIgnoreAxiomsReadErrors(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_IGNORE_AXIOMS_READ_ERRORS, b);
    }

    @Override
    public boolean isSplitAxiomAnnotations() {
        return (Boolean)this.get(OntSettings.ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS);
    }

    @Override
    public OntLoaderConfiguration setSplitAxiomAnnotations(boolean b) {
        return this.set(OntSettings.ONT_API_LOAD_CONF_SPLIT_AXIOM_ANNOTATIONS, b);
    }

    @Override
    public boolean isLoadAnnotationAxioms() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS);
    }

    @Override
    public OntLoaderConfiguration setLoadAnnotationAxioms(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_LOAD_ANNOTATIONS, b);
    }

    protected List<String> getIgnoredImports() {
        return (List)this.get(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS);
    }

    protected List<String> getIgnoredImportsModifiableList() {
        return new ArrayList<String>(this.getIgnoredImports());
    }

    protected OntLoaderConfiguration setIgnoredImports(List<String> imports) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_IGNORED_IMPORTS, Collections.unmodifiableList(imports));
    }

    public OntLoaderConfiguration addIgnoredImport(@Nonnull IRI iri) {
        List<String> list = this.getIgnoredImportsModifiableList();
        if (list.contains(iri.getIRIString())) {
            return this;
        }
        list.add(iri.getIRIString());
        return this.setIgnoredImports(list);
    }

    public OntLoaderConfiguration removeIgnoredImport(@Nonnull IRI iri) {
        List<String> list = this.getIgnoredImportsModifiableList();
        if (!list.contains(iri.getIRIString())) {
            return this;
        }
        list.remove(iri.getIRIString());
        return this.setIgnoredImports(list);
    }

    public OntLoaderConfiguration clearIgnoredImports() {
        List<String> list = this.getIgnoredImportsModifiableList();
        if (list.isEmpty()) {
            return this;
        }
        return this.setIgnoredImports(new ArrayList<String>());
    }

    public boolean isIgnoredImport(@Nonnull IRI iri) {
        return this.getIgnoredImports().contains(iri.getIRIString());
    }

    public PriorityCollectionSorting getPriorityCollectionSorting() {
        return (PriorityCollectionSorting)this.get(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING);
    }

    public OntLoaderConfiguration setPriorityCollectionSorting(@Nonnull PriorityCollectionSorting sorting) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_PRIORITY_COLLECTION_SORTING, sorting);
    }

    public int getConnectionTimeout() {
        return (Integer)this.get(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT);
    }

    public OntLoaderConfiguration setConnectionTimeout(int time) {
        return this.setPositive(OntSettings.OWL_API_LOAD_CONF_CONNECTION_TIMEOUT, time);
    }

    public MissingImportHandlingStrategy getMissingImportHandlingStrategy() {
        return (MissingImportHandlingStrategy)this.get(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY);
    }

    public OntLoaderConfiguration setMissingImportHandlingStrategy(@Nonnull MissingImportHandlingStrategy strategy) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_MISSING_IMPORT_HANDLING_STRATEGY, strategy);
    }

    public MissingOntologyHeaderStrategy getMissingOntologyHeaderStrategy() {
        return (MissingOntologyHeaderStrategy)this.get(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY);
    }

    public OntLoaderConfiguration setMissingOntologyHeaderStrategy(@Nonnull MissingOntologyHeaderStrategy strategy) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_MISSING_ONTOLOGY_HEADER_STRATEGY, strategy);
    }

    public int getRetriesToAttempt() {
        return (Integer)this.get(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT);
    }

    public OntLoaderConfiguration setRetriesToAttempt(int retries) {
        return this.setPositive(OntSettings.OWL_API_LOAD_CONF_RETRIES_TO_ATTEMPT, retries);
    }

    public boolean isAcceptingHTTPCompression() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION);
    }

    public OntLoaderConfiguration setAcceptingHTTPCompression(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_ACCEPT_HTTP_COMPRESSION, b);
    }

    public boolean isFollowRedirects() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS);
    }

    public OntLoaderConfiguration setFollowRedirects(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_FOLLOW_REDIRECTS, b);
    }

    public boolean isReportStackTrace() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES);
    }

    public OntLoaderConfiguration setReportStackTraces(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_REPORT_STACK_TRACES, b);
    }

    public boolean isStrict() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION);
    }

    public OntLoaderConfiguration setStrict(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_PARSE_WITH_STRICT_CONFIGURATION, b);
    }

    public boolean isTreatDublinCoreAsBuiltIn() {
        return (Boolean)this.get(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN);
    }

    public OntLoaderConfiguration setTreatDublinCoreAsBuiltIn(boolean b) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_TREAT_DUBLINCORE_AS_BUILTIN, b);
    }

    public String getBannedParsers() {
        return (String)this.get(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS);
    }

    public OntLoaderConfiguration setBannedParsers(@Nonnull String s) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_BANNED_PARSERS, s);
    }

    public String getEntityExpansionLimit() {
        return (String)this.get(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT);
    }

    public OntLoaderConfiguration setEntityExpansionLimit(@Nonnull String s) {
        return this.set(OntSettings.OWL_API_LOAD_CONF_ENTITY_EXPANSION_LIMIT, s);
    }

    public String getAuthorizationValue() {
        return (String)this.get(OntSettings.OWL_API_AUTHORIZATION_VALUE);
    }

    public OntLoaderConfiguration setAuthorizationValue(@Nonnull String s) {
        return this.set(OntSettings.OWL_API_AUTHORIZATION_VALUE, s);
    }

    public boolean shouldTrimToSize() {
        LOGGER.warn("ONT-API does not support TrimToSize");
        return true;
    }

    public OntLoaderConfiguration setTrimToSize(boolean b) {
        LOGGER.warn("ONT-API does not support TrimToSize");
        return this;
    }

    public boolean shouldRepairIllegalPunnings() {
        LOGGER.warn("ONT-API does not support RepairIllegalPunnings");
        return true;
    }

    public OntLoaderConfiguration setRepairIllegalPunnings(boolean b) {
        LOGGER.warn("ONT-API does not support RepairIllegalPunnings");
        return this;
    }

    protected Map<OntSettings, Object> asMap() {
        return OntConfig.loadMap(this.data, OntSettings.LOAD_CONFIG_KEYS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OntLoaderConfiguration)) {
            return false;
        }
        OntLoaderConfiguration that = (OntLoaderConfiguration)o;
        return Objects.equals(this.asMap(), that.asMap());
    }

    public int hashCode() {
        return Objects.hash(this.asMap());
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeObject(OntConfig.serializableOnly(this.data));
    }
}

