/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.config;

import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.config.OntSettings;
import java.util.EnumMap;
import java.util.Map;
import java.util.Objects;
import org.semanticweb.owlapi.model.OWLOntologyWriterConfiguration;

public class OntWriterConfiguration
extends OWLOntologyWriterConfiguration {
    private static final long serialVersionUID = 2369276991908772369L;
    protected final Map<OntSettings, Object> data = new EnumMap<OntSettings, Object>(OntSettings.class);

    protected OntWriterConfiguration() {
    }

    public OntWriterConfiguration(OWLOntologyWriterConfiguration from) {
        this();
        if (from == null) {
            return;
        }
        if (from instanceof OntWriterConfiguration) {
            this.copyONTSettings((OntWriterConfiguration)from);
        } else {
            this.copyOWLSettings(from);
        }
    }

    protected void copyONTSettings(OntWriterConfiguration conf) {
        this.data.putAll(conf.data);
    }

    protected void copyOWLSettings(OWLOntologyWriterConfiguration from) {
        this.data.put(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS, from.shouldSaveIdsForAllAnonymousIndividuals());
        this.data.put(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS, from.shouldRemapAllAnonymousIndividualsIds());
        this.data.put(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES, from.isUseNamespaceEntities());
        this.data.put(OntSettings.OWL_API_WRITE_CONF_INDENTING, from.isIndenting());
        this.data.put(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER, from.isLabelsAsBanner());
        this.data.put(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED, from.shouldUseBanners());
        this.data.put(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE, from.getIndentSize());
    }

    protected <X> X get(OntSettings key) {
        return (X)this.data.computeIfAbsent(key, OntSettings::getDefaultValue);
    }

    protected OntWriterConfiguration setPositive(OntSettings k, int v) {
        return this.set(k, OntConfig.requirePositive(v, (Object)k));
    }

    protected OntWriterConfiguration set(OntSettings key, Object v) {
        Objects.requireNonNull(v);
        if (Objects.equals(this.get(key), v)) {
            return this;
        }
        OntWriterConfiguration copy = new OntWriterConfiguration(this);
        copy.data.put(key, v);
        return copy;
    }

    public boolean isControlImports() {
        return (Boolean)this.get(OntSettings.ONT_API_WRITE_CONF_CONTROL_IMPORTS);
    }

    public OntWriterConfiguration setControlImports(boolean b) {
        return this.set(OntSettings.ONT_API_WRITE_CONF_CONTROL_IMPORTS, b);
    }

    public boolean shouldUseBanners() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED);
    }

    public OntWriterConfiguration withBannersEnabled(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_BANNERS_ENABLED, b);
    }

    public boolean isLabelsAsBanner() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER);
    }

    public OntWriterConfiguration withLabelsAsBanner(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_LABEL_AS_BANNER, b);
    }

    public boolean shouldSaveIdsForAllAnonymousIndividuals() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS);
    }

    public OntWriterConfiguration withSaveIdsForAllAnonymousIndividuals(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_SAVE_IDS, b);
    }

    public boolean shouldRemapAllAnonymousIndividualsIds() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS);
    }

    public OntWriterConfiguration withRemapAllAnonymousIndividualsIds(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_REMAP_IDS, b);
    }

    public boolean isUseNamespaceEntities() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES);
    }

    public OntWriterConfiguration withUseNamespaceEntities(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_USE_NAMESPACE_ENTITIES, b);
    }

    public boolean isIndenting() {
        return (Boolean)this.get(OntSettings.OWL_API_WRITE_CONF_INDENTING);
    }

    public OntWriterConfiguration withIndenting(boolean b) {
        return this.set(OntSettings.OWL_API_WRITE_CONF_INDENTING, b);
    }

    public int getIndentSize() {
        return (Integer)this.get(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE);
    }

    public OntWriterConfiguration withIndentSize(int indent) {
        return this.setPositive(OntSettings.OWL_API_WRITE_CONF_INDENT_SIZE, indent);
    }

    protected Map<OntSettings, Object> asMap() {
        return OntConfig.loadMap(this.data, OntSettings.WRITE_CONFIG_KEYS);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof OntWriterConfiguration)) {
            return false;
        }
        OntWriterConfiguration that = (OntWriterConfiguration)((Object)o);
        return Objects.equals(this.asMap(), that.asMap());
    }

    public int hashCode() {
        return Objects.hash(this.asMap());
    }
}

