/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.BaseSearcher;
import com.github.owlcs.ontapi.internal.HasConfig;
import com.github.owlcs.ontapi.internal.HasObjectFactory;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ObjectsSearcher;
import com.github.owlcs.ontapi.internal.WithMerge;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Triple;
import org.apache.jena.shared.JenaException;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;

public abstract class AxiomTranslator<Axiom extends OWLAxiom>
extends BaseSearcher
implements ObjectsSearcher<Axiom> {
    public static InternalConfig getConfig(OntModel model) {
        return model instanceof HasConfig ? ((HasConfig)((Object)model)).getConfig().snapshot() : InternalConfig.DEFAULT;
    }

    public static ONTObjectFactory getObjectFactory(OntModel model) {
        return model instanceof HasObjectFactory ? ((HasObjectFactory)((Object)model)).getObjectFactory() : ONTObjectFactory.DEFAULT;
    }

    public final Stream<ONTObject<Axiom>> axioms(OntModel model) throws JenaException {
        return Iter.asStream(this.listAxioms(model));
    }

    public final ExtendedIterator<ONTObject<Axiom>> listAxioms(OntModel model) throws JenaException {
        return this.listONTObjects(Objects.requireNonNull(model, "Null model."), AxiomTranslator.getObjectFactory(model), AxiomTranslator.getConfig(model));
    }

    public final Stream<OntStatement> statements(OntModel model) {
        return Iter.asStream(this.listStatements(model, AxiomTranslator.getConfig(model)));
    }

    public final boolean testStatement(OntStatement statement) {
        return this.testStatement(statement, AxiomTranslator.getConfig(statement.getModel()));
    }

    public final ONTObject<Axiom> toAxiom(OntStatement statement) throws JenaException {
        OntModel m = statement.getModel();
        return AxiomTranslator.toAxiom(this, statement, AxiomTranslator.getObjectFactory(m), AxiomTranslator.getConfig(m));
    }

    @Override
    public ExtendedIterator<ONTObject<Axiom>> listONTObjects(OntModel model, ONTObjectFactory factory, AxiomsSettings config) throws JenaException {
        return AxiomTranslator.translate(this, this.listStatements(model, config), factory, config);
    }

    @Override
    public boolean containsONTObject(Axiom key, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        Objects.requireNonNull(key);
        return Iter.anyMatch(this.listSearchCandidates(key, model, factory, config), x -> key.equals(x.getOWLObject()));
    }

    @Override
    public Optional<ONTObject<Axiom>> findONTObject(Axiom key, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        Objects.requireNonNull(key);
        List list = this.listSearchCandidates(key, model, factory, config).filterKeep(x -> key.equals(x.getOWLObject())).toList();
        if (list.isEmpty()) {
            return Optional.empty();
        }
        ONTObject res = (ONTObject)list.remove(0);
        for (ONTObject a : list) {
            res = ((WithMerge)((Object)res)).merge(a);
        }
        return Optional.of(res);
    }

    private ExtendedIterator<ONTObject<Axiom>> listSearchCandidates(Axiom key, OntModel model, ONTObjectFactory factory, AxiomsSettings config) throws JenaException {
        return AxiomTranslator.translate(this, this.listSearchStatements(key, model, config), factory, config);
    }

    protected ExtendedIterator<OntStatement> listSearchStatements(Axiom key, OntModel model, AxiomsSettings config) {
        Collection<Triple> search = this.getSearchTriples(key);
        return search.isEmpty() ? this.listStatements(model, config) : this.listSearchStatements(model, search);
    }

    protected ExtendedIterator<OntStatement> listSearchStatements(OntModel model, Collection<Triple> search) {
        Graph g = model.getBaseGraph();
        return Iter.flatMap(Iter.create(search), t -> t.isConcrete() ? (g.contains(t) ? Iter.of(t) : Iter.of()) : g.find(t)).mapWith(model::asStatement);
    }

    protected Collection<Triple> getSearchTriples(Axiom axiom) {
        return Collections.emptyList();
    }

    public abstract void write(Axiom var1, OntModel var2);

    public abstract ExtendedIterator<OntStatement> listStatements(OntModel var1, AxiomsSettings var2);

    public abstract boolean testStatement(OntStatement var1, AxiomsSettings var2);

    protected abstract ONTObject<Axiom> toAxiomWrap(OntStatement var1, ONTObjectFactory var2, AxiomsSettings var3) throws JenaException;

    protected abstract ONTObject<Axiom> toAxiomImpl(OntStatement var1, ModelObjectFactory var2, AxiomsSettings var3) throws JenaException;
}

