/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomParserProvider;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.OWLTopObjectType;
import com.github.owlcs.ontapi.internal.ObjectsSearcher;
import com.github.owlcs.ontapi.jena.impl.PersonalityModel;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.graph.Node;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class BaseSearcher {
    protected static <A extends OWLAxiom> ExtendedIterator<ONTObject<A>> translate(AxiomTranslator<A> translator, ExtendedIterator<OntStatement> statements, ONTObjectFactory factory, AxiomsSettings config) {
        return config.isSplitAxiomAnnotations() ? Iter.flatMap(statements, s -> BaseSearcher.split(translator, s, factory, config)) : statements.mapWith(s -> BaseSearcher.toAxiom(translator, s, factory, config));
    }

    protected static <A extends OWLAxiom> ONTObject<A> toAxiom(AxiomTranslator<A> translator, OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        return factory instanceof ModelObjectFactory ? translator.toAxiomImpl(statement, (ModelObjectFactory)factory, config) : translator.toAxiomWrap(statement, factory, config);
    }

    protected static <A extends OWLAxiom> ExtendedIterator<ONTObject<A>> split(AxiomTranslator<A> translator, OntStatement statement, ONTObjectFactory factory, AxiomsSettings config) {
        if (!(factory instanceof ModelObjectFactory)) {
            return OntModels.listSplitStatements(statement).mapWith(s -> translator.toAxiomWrap((OntStatement)s, factory, config));
        }
        List statements = OntModels.listSplitStatements(statement).toList();
        if (statements.size() == 1) {
            return Iter.of(translator.toAxiomImpl(statement, (ModelObjectFactory)factory, config));
        }
        return Iter.create(statements).mapWith(s -> translator.toAxiomWrap((OntStatement)s, factory, config));
    }

    protected static <T extends AxiomTranslator<? extends A>, A extends OWLAxiom> T getTranslator(OWLTopObjectType type) {
        return (T)type.getTranslator();
    }

    protected static Set<AxiomTranslator<OWLAxiom>> selectTranslators(OWLComponentType type) {
        return BaseSearcher.selectTranslators(OWLTopObjectType.axioms().filter(x -> type == null || x.hasComponent(type)));
    }

    private static Set<AxiomTranslator<OWLAxiom>> selectTranslators(Stream<OWLTopObjectType> types) {
        return types.map(OWLTopObjectType::getAxiomType).map(AxiomParserProvider::get).collect(Iter.toUnmodifiableSet());
    }

    static <X> ExtendedIterator<X> cast(ExtendedIterator<?> it) {
        return it;
    }

    static <X extends OWLObject> ObjectsSearcher<X> cast(ObjectsSearcher<?> searcher) {
        return searcher;
    }

    protected static Set<Node> getSystemResources(OntModel model) {
        if (model instanceof PersonalityModel) {
            return ((PersonalityModel)((Object)model)).getSystemResources(OntClass.Named.class);
        }
        return Collections.emptySet();
    }

    public final ExtendedIterator<OntStatement> listBySubject(OntModel model, Resource subject) {
        return this.listStatements(model, subject, null, null);
    }

    public final ExtendedIterator<OntStatement> listBySubjectAndPredicate(OntModel m, Resource subject, Property uri) {
        return this.listStatements(m, subject, uri, null);
    }

    public final ExtendedIterator<OntStatement> listByPredicate(OntModel m, Property uri) {
        return this.listStatements(m, null, uri, null);
    }

    public final ExtendedIterator<OntStatement> listByPredicateAndObject(OntModel model, Property uri, RDFNode object) {
        return this.listStatements(model, null, uri, object);
    }

    public final ExtendedIterator<OntStatement> listByObject(OntModel model, RDFNode object) {
        return this.listStatements(model, null, null, object);
    }

    public final ExtendedIterator<OntStatement> listStatements(OntModel model) {
        return this.listStatements(model, null, null, null);
    }

    public final ExtendedIterator<OntStatement> listStatements(OntModel model, Resource s, Property p, RDFNode o) {
        return OntModels.listLocalStatements(model, s, p, o);
    }
}

