/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.objects.ONTIRI;
import com.github.owlcs.ontapi.jena.model.OntModel;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLPrimitive;

public class CacheObjectFactory
extends InternalObjectFactory {
    public static final int CACHE_SIZE = 2048;
    protected final InternalCache.Loading<String, ONTObject<OWLClass>> classes;
    protected final InternalCache.Loading<String, ONTObject<OWLDatatype>> datatypes;
    protected final InternalCache.Loading<String, ONTObject<OWLAnnotationProperty>> annotationProperties;
    protected final InternalCache.Loading<String, ONTObject<OWLDataProperty>> datatypeProperties;
    protected final InternalCache.Loading<String, ONTObject<OWLObjectProperty>> objectProperties;
    protected final InternalCache.Loading<String, ONTObject<OWLNamedIndividual>> individuals;
    protected final InternalCache.Loading<String, IRI> iris;
    protected final Set<InternalCache<?, ?>> caches = new HashSet();

    public CacheObjectFactory(DataFactory factory, OntModel model) {
        this(factory, model, 2048);
    }

    public CacheObjectFactory(DataFactory factory, OntModel model, int size) {
        this(factory, () -> model, Collections.emptyMap(), () -> InternalCache.createBounded(true, size));
    }

    protected CacheObjectFactory(DataFactory dataFactory, Supplier<OntModel> model, Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> external, Supplier<InternalCache<?, ?>> cacheFactory) {
        super(dataFactory, model);
        this.iris = CacheObjectFactory.fetchCache(external, this.caches, cacheFactory, IRI.class).asLoading(x$0 -> super.toIRI((String)x$0));
        this.classes = CacheObjectFactory.fetchCache(external, this.caches, cacheFactory, OWLClass.class).asLoading(x$0 -> super.getClass((String)x$0));
        this.datatypes = CacheObjectFactory.fetchCache(external, this.caches, cacheFactory, OWLDatatype.class).asLoading(x$0 -> super.getDatatype((String)x$0));
        this.annotationProperties = CacheObjectFactory.fetchCache(external, this.caches, cacheFactory, OWLAnnotationProperty.class).asLoading(x$0 -> super.getAnnotationProperty((String)x$0));
        this.datatypeProperties = CacheObjectFactory.fetchCache(external, this.caches, cacheFactory, OWLDataProperty.class).asLoading(x$0 -> super.getDataProperty((String)x$0));
        this.objectProperties = CacheObjectFactory.fetchCache(external, this.caches, cacheFactory, OWLObjectProperty.class).asLoading(x$0 -> super.getObjectProperty((String)x$0));
        this.individuals = CacheObjectFactory.fetchCache(external, this.caches, cacheFactory, OWLNamedIndividual.class).asLoading(x$0 -> super.getNamedIndividual((String)x$0));
    }

    private static <R> InternalCache<String, R> fetchCache(Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> system, Set<InternalCache<?, ?>> caches, Supplier<InternalCache<?, ?>> factory, Class<? extends OWLPrimitive> key) {
        InternalCache<?, ?> res = system.get(key);
        if (res == null) {
            res = factory.get();
            caches.add(res);
        }
        return res;
    }

    public void clear() {
        this.caches.forEach(InternalCache::clear);
    }

    @Override
    public ONTObject<OWLClass> getClass(String uri) {
        return this.classes.get(uri);
    }

    @Override
    public ONTObject<OWLDatatype> getDatatype(String uri) {
        return this.datatypes.get(uri);
    }

    @Override
    public ONTObject<OWLAnnotationProperty> getAnnotationProperty(String uri) {
        return this.annotationProperties.get(uri);
    }

    @Override
    public ONTObject<OWLDataProperty> getDataProperty(String uri) {
        return this.datatypeProperties.get(uri);
    }

    @Override
    public ONTObject<OWLObjectProperty> getObjectProperty(String uri) {
        return this.objectProperties.get(uri);
    }

    @Override
    public ONTObject<OWLNamedIndividual> getNamedIndividual(String uri) {
        return this.individuals.get(uri);
    }

    @Override
    public ONTObject<IRI> getIRI(String uri) {
        return ONTIRI.asONT(this.toIRI(uri));
    }

    @Override
    public IRI toIRI(String str) {
        return this.iris.get(str);
    }
}

