/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ObjectMap;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLObject;

public class DirectObjectMapImpl<X extends OWLObject>
implements ObjectMap<X> {
    private final Supplier<Iterator<ONTObject<X>>> list;
    private final Function<X, Optional<ONTObject<X>>> find;
    private final Predicate<X> contains;

    public DirectObjectMapImpl(Supplier<Iterator<ONTObject<X>>> loader) {
        this(Objects.requireNonNull(loader), k -> Iter.findFirst(Iter.create((Iterator)loader.get()).filterKeep(x -> x.getOWLObject().equals(k))));
    }

    public DirectObjectMapImpl(Supplier<Iterator<ONTObject<X>>> loader, Function<X, Optional<ONTObject<X>>> finder) {
        this(loader, finder, x -> ((Optional)finder.apply(x)).isPresent());
    }

    public DirectObjectMapImpl(Supplier<Iterator<ONTObject<X>>> loader, Function<X, Optional<ONTObject<X>>> finder, Predicate<X> tester) {
        this.list = Objects.requireNonNull(loader);
        this.find = Objects.requireNonNull(finder);
        this.contains = Objects.requireNonNull(tester);
    }

    public ExtendedIterator<ONTObject<X>> listONTObjects() {
        return Iter.create(this.list.get());
    }

    public Optional<ONTObject<X>> findONTObject(X key) {
        return this.find.apply(key);
    }

    @Override
    public Stream<X> keys() {
        return Iter.asStream(this.listONTObjects().mapWith(ONTObject::getOWLObject));
    }

    @Override
    public Stream<ONTObject<X>> values() {
        return Iter.asStream(this.listONTObjects());
    }

    @Override
    public boolean contains(X key) {
        return this.contains.test(key);
    }

    @Override
    public ONTObject<X> get(X key) {
        return this.findONTObject(key).orElse(null);
    }

    @Override
    public boolean hasNew() {
        return false;
    }

    @Override
    public boolean isLoaded() {
        return false;
    }

    @Override
    public void load() {
    }

    @Override
    public void clear() {
    }

    @Override
    public void remove(X key) {
    }

    @Override
    public void add(ONTObject<X> value) {
    }
}

