/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.config.CacheSettings;
import com.github.owlcs.ontapi.config.OntConfig;
import com.github.owlcs.ontapi.config.OntLoaderConfiguration;
import java.util.EnumMap;
import java.util.Objects;

public interface InternalConfig
extends CacheSettings,
AxiomsSettings {
    public static final InternalConfig DEFAULT = InternalConfig.createFrom(new OntConfig().buildLoaderConfiguration());

    default public boolean parallel() {
        return false;
    }

    default public Snapshot snapshot() {
        return new Snapshot(this);
    }

    public static InternalConfig createFrom(final OntLoaderConfiguration conf) {
        return new InternalConfig(){

            @Override
            public boolean isLoadAnnotationAxioms() {
                return conf.isLoadAnnotationAxioms();
            }

            @Override
            public boolean isAllowBulkAnnotationAssertions() {
                return conf.isAllowBulkAnnotationAssertions();
            }

            @Override
            public boolean isIgnoreAnnotationAxiomOverlaps() {
                return conf.isIgnoreAnnotationAxiomOverlaps();
            }

            @Override
            public boolean isAllowReadDeclarations() {
                return conf.isAllowReadDeclarations();
            }

            @Override
            public boolean isSplitAxiomAnnotations() {
                return conf.isSplitAxiomAnnotations();
            }

            @Override
            public boolean isIgnoreAxiomsReadErrors() {
                return conf.isIgnoreAxiomsReadErrors();
            }

            @Override
            public int getLoadNodesCacheSize() {
                return conf.getLoadNodesCacheSize();
            }

            @Override
            public int getLoadObjectsCacheSize() {
                return conf.getLoadObjectsCacheSize();
            }

            @Override
            public int getModelCacheLevel() {
                return conf.getModelCacheLevel();
            }
        };
    }

    public static class Snapshot
    implements InternalConfig {
        private final EnumMap<Key, Object> map = new EnumMap(Key.class);
        private final boolean parallel;

        Snapshot(InternalConfig delegate) {
            this.parallel = Objects.requireNonNull(delegate, "Null config").parallel();
            this.map.put(Key.LOAD_ANNOTATIONS, (Object)delegate.isLoadAnnotationAxioms());
            this.map.put(Key.ALLOW_DECLARATION_BULK_ANNOTATIONS, (Object)delegate.isAllowBulkAnnotationAssertions());
            this.map.put(Key.IGNORE_ANNOTATION_OVERLAPS, (Object)delegate.isIgnoreAnnotationAxiomOverlaps());
            this.map.put(Key.ALLOW_DECLARATIONS, (Object)delegate.isAllowReadDeclarations());
            this.map.put(Key.SPLIT_AXIOM_ANNOTATIONS, (Object)delegate.isSplitAxiomAnnotations());
            this.map.put(Key.IGNORE_READ_ERRORS, (Object)delegate.isIgnoreAxiomsReadErrors());
            this.map.put(Key.CACHE_NODES_SIZE, (Object)delegate.getLoadNodesCacheSize());
            this.map.put(Key.CACHE_OBJECTS_SIZE, (Object)delegate.getLoadObjectsCacheSize());
            this.map.put(Key.CONTENT_CACHE_LEVEL, (Object)delegate.getModelCacheLevel());
        }

        private <X> X get(Key k) {
            return (X)this.map.get((Object)k);
        }

        @Override
        public boolean isLoadAnnotationAxioms() {
            return (Boolean)this.get(Key.LOAD_ANNOTATIONS);
        }

        @Override
        public boolean isAllowBulkAnnotationAssertions() {
            return (Boolean)this.get(Key.ALLOW_DECLARATION_BULK_ANNOTATIONS);
        }

        @Override
        public boolean isIgnoreAnnotationAxiomOverlaps() {
            return (Boolean)this.get(Key.IGNORE_ANNOTATION_OVERLAPS);
        }

        @Override
        public boolean isAllowReadDeclarations() {
            return (Boolean)this.get(Key.ALLOW_DECLARATIONS);
        }

        @Override
        public boolean isSplitAxiomAnnotations() {
            return (Boolean)this.get(Key.SPLIT_AXIOM_ANNOTATIONS);
        }

        @Override
        public boolean isIgnoreAxiomsReadErrors() {
            return (Boolean)this.get(Key.IGNORE_READ_ERRORS);
        }

        @Override
        public int getLoadNodesCacheSize() {
            return (Integer)this.get(Key.CACHE_NODES_SIZE);
        }

        @Override
        public int getLoadObjectsCacheSize() {
            return (Integer)this.get(Key.CACHE_OBJECTS_SIZE);
        }

        @Override
        public int getModelCacheLevel() {
            return (Integer)this.get(Key.CONTENT_CACHE_LEVEL);
        }

        @Override
        public boolean parallel() {
            return this.parallel;
        }

        @Override
        public Snapshot snapshot() {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            return this.map.equals((Object)((Snapshot)o).map);
        }

        public int hashCode() {
            return Objects.hash(this.map);
        }

        private static enum Key {
            LOAD_ANNOTATIONS,
            ALLOW_DECLARATION_BULK_ANNOTATIONS,
            IGNORE_ANNOTATION_OVERLAPS,
            ALLOW_DECLARATIONS,
            SPLIT_AXIOM_ANNOTATIONS,
            IGNORE_READ_ERRORS,
            CACHE_NODES_SIZE,
            CACHE_OBJECTS_SIZE,
            CONTENT_CACHE_LEVEL;

        }
    }
}

