/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.HasConfig;
import com.github.owlcs.ontapi.internal.HasObjectFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalModel;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.InternalReadModel;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.OWLTopObjectType;
import com.github.owlcs.ontapi.internal.OWLTriples;
import com.github.owlcs.ontapi.internal.ObjectMap;
import com.github.owlcs.ontapi.jena.UnionGraph;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntID;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.GraphListener;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.sparql.util.graph.GraphListenerBase;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLOntologyID;
import org.semanticweb.owlapi.model.OWLPrimitive;

public class InternalModelImpl
extends InternalReadModel
implements InternalModel {
    protected final DirectListener directListener = this.createDirectListener();

    public InternalModelImpl(Graph base, OntPersonality personality, InternalConfig config, DataFactory dataFactory, Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> fromManager) {
        super(base, personality, config, dataFactory, fromManager);
        this.enableDirectListening();
    }

    @Override
    public void setOntologyID(OWLOntologyID id) throws IllegalArgumentException {
        this.cachedID = null;
        try {
            this.disableDirectListening();
            this.getHeaderCache().clear();
            if (Objects.requireNonNull(id, "Null id").isAnonymous()) {
                OntID res = id instanceof ID ? this.getNodeAs(InternalModelImpl.createOntologyID((Model)this, ((ID)id).asNode()).asNode(), OntID.class) : this.setID(null);
                res.setVersionIRI(null);
            } else {
                this.setID(id.getOntologyIRI().map(IRI::getIRIString).orElseThrow(IllegalArgumentException::new)).setVersionIRI(id.getVersionIRI().map(IRI::getIRIString).orElse(null));
            }
        }
        finally {
            this.enableDirectListening();
        }
        if (id instanceof ID) {
            this.cachedID = (ID)id;
        }
    }

    protected DirectListener createDirectListener() {
        return new DirectListener();
    }

    protected void disableDirectListening() {
        this.getGraph().getEventManager().unregister((GraphListener)this.directListener);
    }

    protected void enableDirectListening() {
        this.getGraph().getEventManager().register((GraphListener)this.directListener);
    }

    @Override
    public boolean add(OWLAxiom axiom) {
        return this.add(OWLTopObjectType.get(axiom.getAxiomType()), (OWLObject)axiom);
    }

    @Override
    public boolean add(OWLAnnotation annotation) {
        return this.add(OWLTopObjectType.ANNOTATION, (OWLObject)annotation);
    }

    @Override
    public boolean remove(OWLAxiom axiom) {
        return this.remove(OWLTopObjectType.get(axiom.getAxiomType()), (OWLObject)axiom);
    }

    @Override
    public boolean remove(OWLAnnotation annotation) {
        return this.remove(OWLTopObjectType.ANNOTATION, (OWLObject)annotation);
    }

    protected boolean add(OWLTopObjectType key, OWLObject container) throws OntApiException {
        OWLTriples.Listener listener = OWLTriples.createListener();
        UnionGraph.OntEventManager evm = this.getGraph().getEventManager();
        ObjectMap<OWLObject> map = this.getContentCache(key);
        map.load();
        try {
            this.disableDirectListening();
            evm.register((GraphListener)listener);
            key.write(this, container);
        }
        catch (Exception e) {
            listener.getTriples().forEach(this::delete);
            if (e instanceof OntApiException) {
                throw e;
            }
            throw new OntApiException(String.format("OWLObject: %s, message: '%s'", container, e.getMessage()), e);
        }
        finally {
            evm.unregister((GraphListener)listener);
            this.enableDirectListening();
        }
        OWLTriples<OWLObject> value = listener.toObject(container);
        if (value.isDefinitelyEmpty()) {
            LOGGER.warn("Attempt to add empty OWL object: {}", (Object)container);
            return false;
        }
        map.add(value);
        this.cacheComponents(container);
        this.clearOtherCaches();
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean remove(OWLTopObjectType key, OWLObject container) {
        try {
            this.disableDirectListening();
            ObjectMap<OWLObject> map = this.getContentCache(key);
            ONTObject<OWLObject> value = map.get(container);
            if (value == null) {
                boolean bl = false;
                return bl;
            }
            map.remove(container);
            container = value.getOWLObject();
            OntModel m = this.toModel(value);
            Set<Triple> used = this.getUsedTriples(m, container);
            this.clearComponents(container);
            Graph g = m.getBaseGraph();
            long size = g.size();
            g.find().filterDrop(used::contains).forEachRemaining(this::delete);
            boolean res = size != (long)g.size();
            this.clearOtherCaches();
            boolean bl = res;
            return bl;
        }
        finally {
            this.enableDirectListening();
        }
    }

    protected Set<Triple> getUsedTriples(OntModel model, OWLObject container) {
        ModelObjectFactory f = HasObjectFactory.getObjectFactory(model);
        InternalConfig c = HasConfig.getConfig(model);
        HashSet<Triple> res = new HashSet<Triple>();
        Iter.flatMap(OWLTopObjectType.listAll(), type -> type.getSearcher().listONTObjects(model, f, c).filterKeep(x -> {
            Object obj = x.getOWLObject();
            if (type != OWLTopObjectType.DECLARATION && container.equals(obj)) {
                return false;
            }
            if (this.getContentCache((OWLTopObjectType)((Object)type)).contains(obj)) {
                return true;
            }
            if (type == OWLTopObjectType.DECLARATION) {
                OWLEntity entity = ((OWLDeclarationAxiom)obj).getEntity();
                return this.findUsedContentContainer((OWLObject)entity, new OWLObject[]{obj}).isPresent();
            }
            return false;
        })).forEachRemaining(x -> x.triples().forEach(res::add));
        OWLComponentType.sharedComponents().forEach(type -> {
            HashSet candidates = new HashSet();
            HashSet triples = new HashSet();
            type.select(model, f).forEach(x -> {
                candidates.add(x.getOWLObject());
                x.triples().forEach(triples::add);
            });
            if (candidates.isEmpty()) {
                return;
            }
            this.selectContentContainers((OWLComponentType)((Object)type)).forEach(x -> {
                Object obj = x.getOWLObject();
                if (container.equals(obj)) {
                    return;
                }
                if (!type.containsAny((OWLObject)obj, candidates)) {
                    return;
                }
                x.triples().filter(triples::contains).forEach(res::add);
            });
        });
        return res;
    }

    protected OntModel toModel(final ONTObject<? extends OWLObject> o) {
        Graph g = o.toGraph();
        if (LOGGER.isDebugEnabled()) {
            g.getPrefixMapping().setNsPrefixes(this.getNsPrefixMap());
        }
        UnionGraph u = new UnionGraph(g, false);
        u.addGraph((Graph)this.getGraph());
        class ObjectModel
        extends OntGraphModelImpl
        implements HasConfig,
        HasObjectFactory {
            public ObjectModel(Graph g) {
                super(g, InternalModelImpl.this.getOntPersonality());
            }

            @Override
            public OntID getID() {
                return (OntID)InternalModelImpl.this.getID().inModel(this).as(OntID.class);
            }

            @Override
            public String toString() {
                return String.format("ModelFor{%s}", o.getOWLObject());
            }

            @Override
            public InternalConfig getConfig() {
                return InternalModelImpl.this.getConfig();
            }

            @Override
            @Nonnull
            public ModelObjectFactory getObjectFactory() {
                return new InternalObjectFactory(InternalModelImpl.this.getDataFactory(), () -> this);
            }
        }
        return new ObjectModel((Graph)u);
    }

    protected void delete(Triple triple) {
        this.getNodeCache().remove((Object)triple.getSubject());
        this.getBaseGraph().delete(triple);
    }

    @Override
    public InternalModelImpl removeAll() {
        this.clearCache();
        this.getNodeCache().clear();
        super.removeAll();
        return this;
    }

    @Override
    public void clearCacheIfNeeded() {
        if (this.hasManuallyAddedAxioms()) {
            this.clearCache();
        }
    }

    @Override
    public void clearCache() {
        this.cachedID = null;
        this.content.clear();
        this.config.clear();
        this.clearComponentsCaches();
    }

    protected void clearComponentsCaches() {
        this.components.clear();
        this.clearOtherCaches();
    }

    protected void clearOtherCaches() {
        this.objectFactory.clear();
        this.searchModel.clear();
    }

    protected void clearComponents(OWLObject container) {
        if (this.components.isEmpty()) {
            return;
        }
        Map cache = (Map)this.components.get(this);
        OWLComponentType.keys().forEach(type -> {
            ObjectMap map = (ObjectMap)cache.get(type);
            if (!map.isLoaded()) {
                return;
            }
            if (!type.select(container).findFirst().isPresent()) {
                return;
            }
            map.clear();
        });
    }

    protected void cacheComponents(OWLObject container) {
        if (this.components.isEmpty()) {
            return;
        }
        Map cache = (Map)this.components.get(this);
        ModelObjectFactory df = this.getObjectFactory();
        OntGraphModelImpl m = this.getSearchModel();
        OWLComponentType.keys().forEach(type -> {
            ObjectMap map = (ObjectMap)cache.get(type);
            if (!map.isLoaded()) {
                return;
            }
            type.select(container, m, df).forEach(map::add);
        });
    }

    @Override
    public void forceLoad() {
        this.contentCaches().forEach(ObjectMap::load);
    }

    public class DirectListener
    extends GraphListenerBase {
        protected void invalidate() {
            InternalModelImpl.this.clearCache();
        }

        protected void addEvent(Triple t) {
            this.invalidate();
        }

        protected void deleteEvent(Triple t) {
            this.invalidate();
        }

        public void notifyAddGraph(Graph g, Graph other) {
            this.invalidate();
        }

        public void notifyDeleteGraph(Graph g, Graph other) {
            this.invalidate();
        }
    }
}

