/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnnotationPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnonymousClassExpressionImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnonymousDataRangeImpl;
import com.github.owlcs.ontapi.internal.objects.ONTAnonymousIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTClassImpl;
import com.github.owlcs.ontapi.internal.objects.ONTDataPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTDatatypeImpl;
import com.github.owlcs.ontapi.internal.objects.ONTFacetRestrictionImpl;
import com.github.owlcs.ontapi.internal.objects.ONTIRI;
import com.github.owlcs.ontapi.internal.objects.ONTLiteralImpl;
import com.github.owlcs.ontapi.internal.objects.ONTNamedIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectInverseOfImpl;
import com.github.owlcs.ontapi.internal.objects.ONTObjectPropertyImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSWRLAtomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSWRLIndividualImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSWRLLiteralImpl;
import com.github.owlcs.ontapi.internal.objects.ONTSWRLVariable;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.impl.LiteralLabel;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;

public class InternalObjectFactory
implements ModelObjectFactory {
    protected final Supplier<OntModel> model;
    protected final DataFactory factory;

    public InternalObjectFactory(DataFactory factory, Supplier<OntModel> model) {
        this.factory = Objects.requireNonNull(factory);
        this.model = Objects.requireNonNull(model);
    }

    public static ONTObject<OWLClass> getONTClass(String uri, OntModel model, ONTObjectFactory factory) {
        if (factory instanceof ModelObjectFactory) {
            return ((ModelObjectFactory)factory).getClass(uri);
        }
        return factory.getClass(OntApiException.mustNotBeNull(model.getOntClass(uri)));
    }

    @Override
    public Supplier<OntModel> model() {
        return this.model;
    }

    @Override
    public DataFactory getOWLDataFactory() {
        return this.factory;
    }

    @Override
    public ONTObject<IRI> getIRI(String uri) {
        return ONTIRI.create(uri);
    }

    @Override
    public IRI toIRI(String uri) {
        return ONTIRI.create(uri);
    }

    @Override
    public ONTObject<OWLAnnotation> getAnnotation(OntStatement s) {
        return ONTAnnotationImpl.create(s, this, this.model);
    }

    @Override
    public ONTObject<? extends OWLClassExpression> getClass(OntClass ce) {
        if (ce.isURIResource()) {
            return this.getClass((OntClass.Named)ce);
        }
        return ONTAnonymousClassExpressionImpl.create(ce, this, this.model);
    }

    @Override
    public ONTObject<? extends OWLDataRange> getDatatype(OntDataRange dr) {
        if (dr.isURIResource()) {
            return this.getDatatype((OntDataRange.Named)dr);
        }
        return ONTAnonymousDataRangeImpl.create(dr, this, this.model);
    }

    public ONTObject<OWLObjectInverseOf> getProperty(OntObjectProperty.Inverse iop) {
        return ONTObjectInverseOfImpl.create(iop, this, this.model);
    }

    @Override
    public ONTObject<OWLFacetRestriction> getFacetRestriction(OntFacetRestriction fr) {
        return ONTFacetRestrictionImpl.create(fr, this, this.model);
    }

    @Override
    public ONTObject<? extends SWRLAtom> getSWRLAtom(OntSWRL.Atom<?> atom) {
        return ONTSWRLAtomImpl.create(atom, this, this.model);
    }

    @Override
    public ONTObject<OWLClass> getClass(String uri) {
        return new ONTClassImpl(uri, this.model);
    }

    @Override
    public ONTObject<OWLAnonymousIndividual> getAnonymousIndividual(BlankNodeId id) {
        return new ONTAnonymousIndividualImpl(id, this.model);
    }

    @Override
    public ONTObject<OWLNamedIndividual> getNamedIndividual(String uri) {
        return new ONTNamedIndividualImpl(uri, this.model);
    }

    @Override
    public ONTObject<OWLDatatype> getDatatype(String uri) {
        return new ONTDatatypeImpl(uri, this.model);
    }

    @Override
    public ONTObject<OWLAnnotationProperty> getAnnotationProperty(String uri) {
        return new ONTAnnotationPropertyImpl(uri, this.model);
    }

    @Override
    public ONTObject<OWLObjectProperty> getObjectProperty(String uri) {
        return new ONTObjectPropertyImpl(uri, this.model);
    }

    @Override
    public ONTObject<OWLDataProperty> getDataProperty(String uri) {
        return new ONTDataPropertyImpl(uri, this.model);
    }

    @Override
    public ONTObject<OWLLiteral> getLiteral(LiteralLabel label) {
        return new ONTLiteralImpl(label, this.model);
    }

    @Override
    public ONTObject<SWRLVariable> getSWRLVariable(String uri) {
        return new ONTSWRLVariable(uri, this.model);
    }

    @Override
    public ONTObject<? extends SWRLDArgument> getSWRLArgument(LiteralLabel label) {
        return new ONTSWRLLiteralImpl(label, this.model);
    }

    @Override
    public ONTObject<? extends SWRLIArgument> getSWRLArgument(String uri) {
        return new ONTSWRLIndividualImpl(uri, this.model);
    }

    @Override
    public ONTObject<? extends SWRLIArgument> getSWRLArgument(BlankNodeId id) {
        return new ONTSWRLIndividualImpl(id, this.model);
    }
}

