/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.ID;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.BaseSearcher;
import com.github.owlcs.ontapi.internal.ByObjectSearcher;
import com.github.owlcs.ontapi.internal.CacheObjectFactory;
import com.github.owlcs.ontapi.internal.CacheObjectMapImpl;
import com.github.owlcs.ontapi.internal.DirectObjectMapImpl;
import com.github.owlcs.ontapi.internal.HasConfig;
import com.github.owlcs.ontapi.internal.HasObjectFactory;
import com.github.owlcs.ontapi.internal.InternalCache;
import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.internal.InternalModel;
import com.github.owlcs.ontapi.internal.InternalObjectFactory;
import com.github.owlcs.ontapi.internal.ListAxioms;
import com.github.owlcs.ontapi.internal.ModelIterators;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.OWLComponentType;
import com.github.owlcs.ontapi.internal.OWLTopObjectType;
import com.github.owlcs.ontapi.internal.ObjectMap;
import com.github.owlcs.ontapi.internal.ObjectsSearcher;
import com.github.owlcs.ontapi.internal.SearchModel;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.searchers.axioms.AnnotationAssertionBySubject;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByAnnotationProperty;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByAnonymousIndividual;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByClass;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByDataProperty;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByDatatype;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByIRI;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByLiteral;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByNamedIndividual;
import com.github.owlcs.ontapi.internal.searchers.axioms.ByObjectProperty;
import com.github.owlcs.ontapi.internal.searchers.axioms.ClassAssertionByObject;
import com.github.owlcs.ontapi.internal.searchers.axioms.ClassAssertionBySubject;
import com.github.owlcs.ontapi.internal.searchers.axioms.DataAssertionBySubject;
import com.github.owlcs.ontapi.internal.searchers.axioms.DeclarationByEntity;
import com.github.owlcs.ontapi.internal.searchers.axioms.DisjointClassesByOperand;
import com.github.owlcs.ontapi.internal.searchers.axioms.EquivalentClassesByOperand;
import com.github.owlcs.ontapi.internal.searchers.axioms.ObjectAssertionBySubject;
import com.github.owlcs.ontapi.internal.searchers.axioms.ObjectPropertyDomainBySubject;
import com.github.owlcs.ontapi.internal.searchers.axioms.ObjectPropertyRangeBySubject;
import com.github.owlcs.ontapi.internal.searchers.axioms.SubClassOfByObject;
import com.github.owlcs.ontapi.internal.searchers.axioms.SubClassOfBySubject;
import com.github.owlcs.ontapi.internal.searchers.objects.AnnotationPropertySearcher;
import com.github.owlcs.ontapi.internal.searchers.objects.ClassSearcher;
import com.github.owlcs.ontapi.internal.searchers.objects.DataPropertySearcher;
import com.github.owlcs.ontapi.internal.searchers.objects.DatatypeSearcher;
import com.github.owlcs.ontapi.internal.searchers.objects.NamedIndividualSearcher;
import com.github.owlcs.ontapi.internal.searchers.objects.ObjectPropertySearcher;
import com.github.owlcs.ontapi.jena.OntJenaException;
import com.github.owlcs.ontapi.jena.impl.OntGraphModelImpl;
import com.github.owlcs.ontapi.jena.impl.conf.OntPersonality;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntID;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.vocabulary.OWL;
import com.github.owlcs.ontapi.jena.vocabulary.RDF;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.apache.jena.graph.Graph;
import org.apache.jena.graph.Node;
import org.apache.jena.mem.GraphMem;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.shared.Lock;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDF;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.HasIRI;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLLogicalAxiom;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLPrimitive;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class InternalReadModel
extends OntGraphModelImpl
implements ListAxioms,
HasObjectFactory,
HasConfig {
    static final Logger LOGGER = LoggerFactory.getLogger(InternalModel.class);
    protected volatile ID cachedID;
    protected final InternalCache.Loading<InternalReadModel, InternalConfig> config;
    protected final InternalCache.Loading<InternalReadModel, ModelObjectFactory> objectFactory;
    protected final InternalCache.Loading<InternalReadModel, OntGraphModelImpl> searchModel;
    protected final InternalCache.Loading<InternalReadModel, Map<OWLTopObjectType, ObjectMap<? extends OWLObject>>> content;
    protected final InternalCache.Loading<InternalReadModel, Map<OWLComponentType, ObjectMap<OWLObject>>> components;
    protected final ByObjectSearcher<OWLAxiom, OWLClass> byClass = new ByClass();
    protected final ByObjectSearcher<OWLAxiom, OWLDatatype> byDatatype = new ByDatatype();
    protected final ByObjectSearcher<OWLAxiom, OWLNamedIndividual> byNamedIndividual = new ByNamedIndividual();
    protected final ByObjectSearcher<OWLAxiom, OWLObjectProperty> byObjectProperty = new ByObjectProperty();
    protected final ByObjectSearcher<OWLAxiom, OWLDataProperty> byDataProperty = new ByDataProperty();
    protected final ByObjectSearcher<OWLAxiom, OWLAnnotationProperty> byAnnotationProperty = new ByAnnotationProperty();
    protected final ByObjectSearcher<OWLAxiom, OWLLiteral> byLiteral = new ByLiteral();
    protected final ByObjectSearcher<OWLAxiom, OWLAnonymousIndividual> byAnonymousIndividual = new ByAnonymousIndividual();
    protected final ByObjectSearcher<OWLAxiom, IRI> byIRI = new ByIRI();
    protected final ByObjectSearcher<OWLDeclarationAxiom, OWLEntity> declarationsByEntity = new DeclarationByEntity();
    protected final ByObjectSearcher<OWLAnnotationAssertionAxiom, OWLAnnotationSubject> annotationAssertionsBySubject = new AnnotationAssertionBySubject();
    protected final ByObjectSearcher<OWLDataPropertyAssertionAxiom, OWLIndividual> dataAssertionsBySubject = new DataAssertionBySubject();
    protected final ByObjectSearcher<OWLObjectPropertyAssertionAxiom, OWLIndividual> objectAssertionsBySubject = new ObjectAssertionBySubject();
    protected final ByObjectSearcher<OWLObjectPropertyRangeAxiom, OWLObjectPropertyExpression> objectPropertyRangeByProperty = new ObjectPropertyRangeBySubject();
    protected final ByObjectSearcher<OWLObjectPropertyDomainAxiom, OWLObjectPropertyExpression> objectPropertyDomainByProperty = new ObjectPropertyDomainBySubject();
    protected final ByObjectSearcher<OWLSubClassOfAxiom, OWLClass> subClassOfBySubject = new SubClassOfBySubject();
    protected final ByObjectSearcher<OWLSubClassOfAxiom, OWLClass> subClassOfByObject = new SubClassOfByObject();
    protected final ByObjectSearcher<OWLEquivalentClassesAxiom, OWLClass> equivalentClassesByClass = new EquivalentClassesByOperand();
    protected final ByObjectSearcher<OWLDisjointClassesAxiom, OWLClass> disjointClassesByClass = new DisjointClassesByOperand();
    protected final ByObjectSearcher<OWLClassAssertionAxiom, OWLIndividual> classAssertionsByIndividual = new ClassAssertionBySubject();
    protected final ByObjectSearcher<OWLClassAssertionAxiom, OWLClassExpression> classAssertionsByClass = new ClassAssertionByObject();
    protected final ObjectsSearcher<OWLClass> classSearcher = new ClassSearcher();
    protected final ObjectsSearcher<OWLNamedIndividual> individualSearcher = new NamedIndividualSearcher();
    protected final ObjectsSearcher<OWLDatatype> datatypeSearcher = new DatatypeSearcher();
    protected final ObjectsSearcher<OWLObjectProperty> objectPropertySearcher = new ObjectPropertySearcher();
    protected final ObjectsSearcher<OWLAnnotationProperty> annotationPropertySearcher = new AnnotationPropertySearcher();
    protected final ObjectsSearcher<OWLDataProperty> dataPropertySearcher = new DataPropertySearcher();

    InternalReadModel(Graph base, OntPersonality personality, InternalConfig config, DataFactory dataFactory, Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> fromManager) {
        super(base, personality);
        Objects.requireNonNull(dataFactory);
        Objects.requireNonNull(config);
        this.config = InternalCache.createSingleton(x -> config.snapshot());
        this.objectFactory = InternalCache.createSoftSingleton(x -> this.createObjectFactory(dataFactory, fromManager));
        this.searchModel = InternalCache.createSoftSingleton(x -> this.createSearchModel());
        this.content = InternalCache.createSingleton(x -> this.createContentStore());
        this.components = InternalCache.createSingleton(x -> this.createComponentStore());
    }

    public ID getOntologyID() {
        if (this.cachedID != null && this.getBaseGraph().contains(this.cachedID.asNode(), RDF.Nodes.type, OWL.Ontology.asNode())) {
            return this.cachedID;
        }
        this.cachedID = new ID(this.getID());
        return this.cachedID;
    }

    @Override
    public InternalConfig getConfig() {
        return this.config.get(this);
    }

    @Override
    @Nonnull
    public ModelObjectFactory getObjectFactory() {
        return this.objectFactory.get(this);
    }

    protected ModelObjectFactory createObjectFactory(DataFactory df, Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> external) {
        InternalConfig conf = this.getConfig();
        Supplier<OntModel> model = this::getSearchModel;
        if (!conf.useLoadObjectsCache()) {
            return new InternalObjectFactory(df, model);
        }
        long size = conf.getLoadObjectsCacheSize();
        boolean parallel = conf.parallel();
        Map<Class<? extends OWLPrimitive>, InternalCache<?, ?>> map = external == null ? Collections.emptyMap() : external;
        return new CacheObjectFactory(df, model, map, () -> InternalCache.createBounded(parallel, size));
    }

    public OntGraphModelImpl getSearchModel() {
        return this.searchModel.get(this);
    }

    protected OntGraphModelImpl createSearchModel() {
        if (!this.useModelSearchOptimization(this.getConfig())) {
            return this;
        }
        return new SearchModel((Graph)this.getGraph(), this.getOntPersonality(), this.getConfig()){

            @Override
            public String toString() {
                return String.format("[SearchModel]%s", this.getID());
            }

            @Override
            @Nonnull
            public ModelObjectFactory getObjectFactory() {
                return InternalReadModel.this.getObjectFactory();
            }
        };
    }

    protected boolean useModelSearchOptimization(InternalConfig config) {
        return config.useLoadNodesCache();
    }

    @Override
    public <N extends RDFNode> N fetchNodeAs(Node node, Class<N> type) {
        try {
            return super.fetchNodeAs(node, type);
        }
        catch (OntJenaException e) {
            return (N)((RDFNode)SearchModel.handleFetchNodeAsException(e, node, type, this, this.getConfig()));
        }
    }

    public Lock getLock() {
        throw new OntApiException.Unsupported();
    }

    public void enterCriticalSection(boolean requestReadLock) {
        throw new OntApiException.Unsupported();
    }

    public void leaveCriticalSection() {
        throw new OntApiException.Unsupported();
    }

    public Stream<OWLImportsDeclaration> listOWLImportDeclarations() {
        ModelObjectFactory of = this.getObjectFactory();
        DataFactory df = this.getDataFactory();
        return ModelIterators.reduce(this.getID().imports().map(of::toIRI).map(arg_0 -> ((DataFactory)df).getOWLImportsDeclaration(arg_0)), this.getConfig());
    }

    public boolean isOntologyEmpty() {
        Graph bg = this.getBaseGraph();
        if (bg instanceof GraphMem) {
            if (bg.isEmpty()) {
                return true;
            }
            if (bg.size() == 1 && bg.contains(Node.ANY, RDF.type.asNode(), OWL.Ontology.asNode())) {
                return true;
            }
        }
        if (!this.components.isEmpty()) {
            return false;
        }
        return !Stream.concat(this.listOWLAnnotations(), this.listOWLAxioms()).findFirst().isPresent();
    }

    public Stream<OWLEntity> listOWLEntities(IRI iri) {
        if (iri == null) {
            return Stream.empty();
        }
        OntEntity e = this.getOntEntity(OntEntity.class, iri.getIRIString());
        if (e == null) {
            return Stream.empty();
        }
        ArrayList<ONTObject<Object>> res = new ArrayList<ONTObject<Object>>();
        ModelObjectFactory df = this.getObjectFactory();
        if (e.canAs(OntClass.Named.class)) {
            res.add(df.getClass((OntClass.Named)e.as(OntClass.Named.class)));
        }
        if (e.canAs(OntDataRange.Named.class)) {
            res.add(df.getDatatype((OntDataRange.Named)e.as(OntDataRange.Named.class)));
        }
        if (e.canAs(OntAnnotationProperty.class)) {
            res.add(df.getProperty((OntAnnotationProperty)e.as(OntAnnotationProperty.class)));
        }
        if (e.canAs(OntDataProperty.class)) {
            res.add(df.getProperty((OntDataProperty)e.as(OntDataProperty.class)));
        }
        if (e.canAs(OntObjectProperty.Named.class)) {
            res.add(df.getProperty((OntObjectProperty.Named)e.as(OntObjectProperty.Named.class)));
        }
        if (e.canAs(OntIndividual.Named.class)) {
            res.add(df.getIndividual((OntIndividual.Named)e.as(OntIndividual.Named.class)));
        }
        return res.stream().map(ONTObject::getOWLObject);
    }

    public Stream<IRI> listPunningIRIs(boolean withImports) {
        ModelObjectFactory f = this.getObjectFactory();
        return this.ambiguousEntities(withImports).map(Resource::getURI).map(f::toIRI);
    }

    public boolean containsOWLDeclaration(OWLEntity e) {
        InternalConfig config = this.getConfig();
        if (!config.isAllowReadDeclarations()) {
            return false;
        }
        if (this.useAxiomsSearchOptimization(config)) {
            return this.getBaseGraph().contains(WriteHelper.toNode((HasIRI)e), RDF.type.asNode(), WriteHelper.getRDFType(e).asNode());
        }
        return this.listOWLAxioms(OWLDeclarationAxiom.class).anyMatch(x -> x.getEntity().equals(e));
    }

    public Stream<OWLAnonymousIndividual> listOWLAnonymousIndividuals() {
        return this.listComponents(OWLComponentType.ANONYMOUS_INDIVIDUAL);
    }

    public Stream<OWLClassExpression> listOWLClassExpressions() {
        return ModelIterators.reduceDistinct(this.selectContentObjects(OWLComponentType.CLASS_EXPRESSION).flatMap(OWLObject::nestedClassExpressions), this.getConfig());
    }

    public Stream<OWLNamedIndividual> listOWLNamedIndividuals() {
        return this.listComponents(OWLComponentType.NAMED_INDIVIDUAL);
    }

    public Stream<OWLClass> listOWLClasses() {
        return this.listComponents(OWLComponentType.CLASS);
    }

    public Stream<OWLDataProperty> listOWLDataProperties() {
        return this.listComponents(OWLComponentType.DATATYPE_PROPERTY);
    }

    public Stream<OWLObjectProperty> listOWLObjectProperties() {
        return this.listComponents(OWLComponentType.NAMED_OBJECT_PROPERTY);
    }

    public Stream<OWLAnnotationProperty> listOWLAnnotationProperties() {
        return this.listComponents(OWLComponentType.ANNOTATION_PROPERTY);
    }

    public Stream<OWLDatatype> listOWLDatatypes() {
        return this.listComponents(OWLComponentType.DATATYPE);
    }

    public boolean containsOWLEntity(OWLDatatype d) {
        return this.containsComponent(OWLComponentType.DATATYPE, (OWLObject)d);
    }

    public boolean containsOWLEntity(OWLClass c) {
        return this.containsComponent(OWLComponentType.CLASS, (OWLObject)c);
    }

    public boolean containsOWLEntity(OWLNamedIndividual i) {
        return this.containsComponent(OWLComponentType.NAMED_INDIVIDUAL, (OWLObject)i);
    }

    public boolean containsOWLEntity(OWLDataProperty p) {
        return this.containsComponent(OWLComponentType.DATATYPE_PROPERTY, (OWLObject)p);
    }

    public boolean containsOWLEntity(OWLObjectProperty p) {
        return this.containsComponent(OWLComponentType.NAMED_OBJECT_PROPERTY, (OWLObject)p);
    }

    public boolean containsOWLEntity(OWLAnnotationProperty p) {
        return this.containsComponent(OWLComponentType.ANNOTATION_PROPERTY, (OWLObject)p);
    }

    public Stream<OWLAnnotation> listOWLAnnotations() {
        return this.getHeaderCache().keys();
    }

    @Override
    public Stream<OWLDeclarationAxiom> listOWLDeclarationAxioms(OWLEntity entity) {
        InternalConfig config = this.getConfig();
        if (!config.isAllowReadDeclarations()) {
            return Stream.empty();
        }
        if (!this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLDeclarationAxioms(entity);
        }
        return this.listOWLAxioms(this.declarationsByEntity, OWLDeclarationAxiom.class, entity, config);
    }

    @Override
    public Stream<OWLAnnotationAssertionAxiom> listOWLAnnotationAssertionAxioms(OWLAnnotationSubject subject) {
        InternalConfig config = this.getConfig();
        if (!config.isLoadAnnotationAxioms()) {
            return Stream.empty();
        }
        if (!this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLAnnotationAssertionAxioms(subject);
        }
        return this.listOWLAxioms(this.annotationAssertionsBySubject, OWLAnnotationAssertionAxiom.class, subject, config);
    }

    @Override
    public Stream<OWLDataPropertyAssertionAxiom> listOWLDataPropertyAssertionAxioms(OWLIndividual subject) {
        InternalConfig config = this.getConfig();
        if (!this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLDataPropertyAssertionAxioms(subject);
        }
        return this.listOWLAxioms(this.dataAssertionsBySubject, OWLDataPropertyAssertionAxiom.class, subject, config);
    }

    @Override
    public Stream<OWLObjectPropertyAssertionAxiom> listOWLObjectPropertyAssertionAxioms(OWLIndividual subject) {
        InternalConfig config = this.getConfig();
        if (!this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLObjectPropertyAssertionAxioms(subject);
        }
        return this.listOWLAxioms(this.objectAssertionsBySubject, OWLObjectPropertyAssertionAxiom.class, subject, config);
    }

    @Override
    public Stream<OWLObjectPropertyRangeAxiom> listOWLObjectPropertyRangeAxioms(OWLObjectPropertyExpression subject) {
        InternalConfig config = this.getConfig();
        if (!ObjectPropertyRangeBySubject.isSupported(subject) || !this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLObjectPropertyRangeAxioms(subject);
        }
        return this.listOWLAxioms(this.objectPropertyRangeByProperty, OWLObjectPropertyRangeAxiom.class, subject, config);
    }

    @Override
    public Stream<OWLObjectPropertyDomainAxiom> listOWLObjectPropertyDomainAxioms(OWLObjectPropertyExpression subject) {
        InternalConfig config = this.getConfig();
        if (!ObjectPropertyRangeBySubject.isSupported(subject) || !this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLObjectPropertyDomainAxioms(subject);
        }
        return this.listOWLAxioms(this.objectPropertyDomainByProperty, OWLObjectPropertyDomainAxiom.class, subject, config);
    }

    @Override
    public Stream<OWLClassAssertionAxiom> listOWLClassAssertionAxioms(OWLIndividual subject) {
        InternalConfig config = this.getConfig();
        if (!this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLClassAssertionAxioms(subject);
        }
        return this.listOWLAxioms(this.classAssertionsByIndividual, OWLClassAssertionAxiom.class, subject, config);
    }

    @Override
    public Stream<OWLClassAssertionAxiom> listOWLClassAssertionAxioms(OWLClassExpression object) {
        InternalConfig config = this.getConfig();
        if (!ClassAssertionByObject.isSupported(object) || !this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLClassAssertionAxioms(object);
        }
        return this.listOWLAxioms(this.classAssertionsByClass, OWLClassAssertionAxiom.class, object, config);
    }

    @Override
    public Stream<OWLSubClassOfAxiom> listOWLSubClassOfAxiomsBySubject(OWLClass subject) {
        InternalConfig config = this.getConfig();
        if (!this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLSubClassOfAxiomsBySubject(subject);
        }
        return this.listOWLAxioms(this.subClassOfBySubject, OWLSubClassOfAxiom.class, subject, config);
    }

    @Override
    public Stream<OWLSubClassOfAxiom> listOWLSubClassOfAxiomsByObject(OWLClass object) {
        InternalConfig config = this.getConfig();
        if (!this.useAxiomsSearchOptimization(config)) {
            return ListAxioms.super.listOWLSubClassOfAxiomsByObject(object);
        }
        return this.listOWLAxioms(this.subClassOfByObject, OWLSubClassOfAxiom.class, object, config);
    }

    @Override
    public Stream<OWLEquivalentClassesAxiom> listOWLEquivalentClassesAxioms(OWLClass clazz) {
        return this.listOWLNaryAxiomAxiomsByOperand(clazz, OWLEquivalentClassesAxiom.class, this.equivalentClassesByClass);
    }

    @Override
    public Stream<OWLDisjointClassesAxiom> listOWLDisjointClassesAxioms(OWLClass clazz) {
        InternalConfig config = this.getConfig();
        if (!config.useContentCache() || !this.hasManuallyAddedAxioms() && !this.containsLocal(null, RDF.type, (RDFNode)OWL.AllDisjointClasses)) {
            return this.listOWLAxioms(this.disjointClassesByClass, OWLDisjointClassesAxiom.class, clazz, config);
        }
        return this.listOWLNaryAxiomAxiomsByOperand(OWLDisjointClassesAxiom.class, (OWLObject)clazz);
    }

    protected <A extends OWLNaryAxiom<? super K>, K extends OWLObject> Stream<A> listOWLNaryAxiomAxiomsByOperand(K operand, Class<A> type, ByObjectSearcher<A, K> searcher) {
        InternalConfig config = this.getConfig();
        if (!this.useAxiomsSearchOptimization(config)) {
            return this.listOWLNaryAxiomAxiomsByOperand(type, operand);
        }
        return this.listOWLAxioms(searcher, type, operand, config);
    }

    protected <A extends OWLAxiom, K extends OWLObject> Stream<A> listOWLAxioms(ByObjectSearcher<A, K> searcher, Class<A> type, K parameter, InternalConfig config) {
        ExtendedIterator res = searcher.listONTAxioms(parameter, this.getSearchModel(), this.getObjectFactory(), config).mapWith(ONTObject::getOWLObject);
        OWLTopObjectType key = OWLTopObjectType.get(type);
        if (key.isDistinct()) {
            return ModelIterators.reduce(res, config);
        }
        return ModelIterators.reduceDistinct(res, config);
    }

    public Stream<OWLAxiom> listOWLAxioms(OWLPrimitive primitive) {
        InternalConfig config;
        OWLComponentType filter = OWLComponentType.get((OWLObject)primitive);
        if (this.useReferencingAxiomsSearchOptimization(filter, config = this.getConfig())) {
            ExtendedIterator<ONTObject<OWLAxiom>> res;
            OntGraphModelImpl model = this.getSearchModel();
            ModelObjectFactory factory = this.getObjectFactory();
            if (filter == OWLComponentType.IRI) {
                res = this.byIRI.listONTAxioms((IRI)primitive, model, factory, config);
            } else if (filter == OWLComponentType.CLASS) {
                res = this.byClass.listONTAxioms((OWLClass)primitive, model, factory, config);
            } else if (filter == OWLComponentType.NAMED_OBJECT_PROPERTY) {
                res = this.byObjectProperty.listONTAxioms((OWLObjectProperty)primitive, model, factory, config);
            } else if (filter == OWLComponentType.ANNOTATION_PROPERTY) {
                res = this.byAnnotationProperty.listONTAxioms((OWLAnnotationProperty)primitive, model, factory, config);
            } else if (filter == OWLComponentType.DATATYPE_PROPERTY) {
                res = this.byDataProperty.listONTAxioms((OWLDataProperty)primitive, model, factory, config);
            } else if (filter == OWLComponentType.NAMED_INDIVIDUAL) {
                res = this.byNamedIndividual.listONTAxioms((OWLNamedIndividual)primitive, model, factory, config);
            } else if (filter == OWLComponentType.DATATYPE) {
                res = this.byDatatype.listONTAxioms((OWLDatatype)primitive, model, factory, config);
            } else if (filter == OWLComponentType.LITERAL) {
                res = this.byLiteral.listONTAxioms((OWLLiteral)primitive, model, factory, config);
            } else if (filter == OWLComponentType.ANONYMOUS_INDIVIDUAL) {
                res = this.byAnonymousIndividual.listONTAxioms((OWLAnonymousIndividual)primitive, model, factory, config);
            } else {
                throw new OntApiException.IllegalArgument("Wrong type: " + (Object)((Object)filter));
            }
            return ModelIterators.reduceDistinct(res.mapWith(ONTObject::getOWLObject), config);
        }
        if (OWLTopObjectType.ANNOTATION.hasComponent(filter)) {
            return ModelIterators.reduce(OWLTopObjectType.axioms().flatMap(k -> {
                ObjectMap axioms = this.getContentCache((OWLTopObjectType)((Object)k));
                Predicate<OWLAxiom> p = k.hasComponent(filter) ? a -> true : k::hasAnnotations;
                return axioms.keys().filter(x -> p.test((OWLAxiom)x) && filter.contains((OWLObject)x, (OWLObject)primitive));
            }), config);
        }
        return ModelIterators.flatMap(this.filteredAxiomsCaches(OWLTopObjectType.axioms().filter(x -> x.hasComponent(filter))), k -> k.keys().filter(x -> filter.contains((OWLObject)x, (OWLObject)primitive)), config);
    }

    protected boolean useReferencingAxiomsSearchOptimization(OWLComponentType type, InternalConfig config) {
        if (!config.useContentCache()) {
            return true;
        }
        if (this.hasManuallyAddedAxioms()) {
            return false;
        }
        if (this.contentCaches().allMatch(ObjectMap::isLoaded)) {
            long threshold = -1L;
            if (type == OWLComponentType.DATATYPE) {
                return false;
            }
            if (type == OWLComponentType.CLASS) {
                threshold = 200L;
            } else if (type == OWLComponentType.NAMED_OBJECT_PROPERTY) {
                threshold = 2000L;
            } else if (type == OWLComponentType.ANNOTATION_PROPERTY) {
                threshold = 2000L;
            } else if (type == OWLComponentType.DATATYPE_PROPERTY) {
                threshold = 100L;
            } else if (type == OWLComponentType.NAMED_INDIVIDUAL) {
                threshold = 3000L;
            }
            return this.getOWLAxiomCount() >= threshold;
        }
        return true;
    }

    protected boolean useAxiomsSearchOptimization(InternalConfig config) {
        return !config.useContentCache() || !this.hasManuallyAddedAxioms();
    }

    public Stream<OWLAxiom> listOWLAxioms() {
        return ModelIterators.flatMap(this.filteredAxiomsCaches(OWLTopObjectType.axioms()), ObjectMap::keys, this.getConfig());
    }

    public Stream<OWLLogicalAxiom> listOWLLogicalAxioms() {
        return ModelIterators.flatMap(this.filteredAxiomsCaches(OWLTopObjectType.logical()), m -> m.keys(), this.getConfig());
    }

    public Stream<OWLAxiom> listOWLAxioms(Iterable<AxiomType<?>> filter) {
        return ModelIterators.flatMap(this.filteredAxiomsCaches(OWLTopObjectType.axioms(filter)), ObjectMap::keys, this.getConfig());
    }

    @Override
    public <A extends OWLAxiom> Stream<A> listOWLAxioms(Class<A> type) {
        return this.listOWLAxioms(OWLTopObjectType.get(type));
    }

    private <A extends OWLAxiom> Stream<A> listOWLAxioms(OWLTopObjectType type) {
        return this.getAxiomsCache(type).keys();
    }

    public <A extends OWLAxiom> Stream<A> listOWLAxioms(Class<A> type, OWLObject object) {
        OWLTopObjectType key = OWLTopObjectType.get(type);
        OWLComponentType filter = OWLComponentType.get(object);
        if (!OWLTopObjectType.ANNOTATION.hasComponent(filter) && !key.hasComponent(filter)) {
            return Stream.empty();
        }
        return this.listOWLAxioms(key).filter(x -> filter.contains((OWLObject)x, object));
    }

    public <A extends OWLAxiom> Stream<A> listOWLAxioms(AxiomType<A> type) {
        return this.listOWLAxioms(OWLTopObjectType.get(type));
    }

    public long getOWLAxiomCount() {
        return this.getContentStore().entrySet().stream().filter(x -> ((OWLTopObjectType)((Object)((Object)x.getKey()))).isAxiom()).mapToLong(x -> ((ObjectMap)x.getValue()).count()).sum();
    }

    public boolean contains(OWLAxiom a) {
        return this.getAxiomsCache(OWLTopObjectType.get(a.getAxiomType())).contains(a);
    }

    public boolean contains(OWLAnnotation a) {
        return this.getHeaderCache().contains(a);
    }

    protected Optional<OWLObject> findUsedContentContainer(OWLObject entity, OWLObject ... excludes) {
        OWLComponentType type = OWLComponentType.get(entity);
        Stream<OWLObject> res = this.selectContentObjects(type);
        if (excludes.length != 0) {
            Set<OWLObject> ignore = excludes.length == 1 ? Collections.singleton(excludes[0]) : new HashSet<OWLObject>(Arrays.asList(excludes));
            res = res.filter(x -> !ignore.contains(x));
        }
        return res.filter(x -> type.contains((OWLObject)x, entity)).findFirst();
    }

    public boolean hasManuallyAddedAxioms() {
        return this.contentCaches().anyMatch(ObjectMap::hasNew);
    }

    @Override
    public String toString() {
        return String.format("[%s]%s", InternalModel.class.getSimpleName(), this.getID());
    }

    protected <K extends Enum<K>, V> Map<K, V> createMapStore(Class<K> type, Stream<K> keys, Function<K, V> loader) {
        EnumMap res = new EnumMap(type);
        keys.forEach(k -> res.put((Object)k, loader.apply(k)));
        return res;
    }

    protected <O extends OWLObject> Stream<O> listComponents(OWLComponentType type) {
        return this.getComponentCache(type).keys();
    }

    protected boolean containsComponent(OWLComponentType type, OWLObject o) {
        return this.getComponentCache(type).contains(o);
    }

    protected <O extends OWLObject> ObjectMap<O> getComponentCache(OWLComponentType type) {
        return Objects.requireNonNull(this.components.get(this).get((Object)type), "Nothing found. Type: " + (Object)((Object)type));
    }

    protected ObjectMap<OWLObject> createComponentObjectMap(OWLComponentType type) {
        InternalConfig conf = this.getConfig();
        Supplier loader = () -> this.listOWLObjects(type, conf);
        if (!conf.useComponentCache()) {
            ObjectsSearcher<OWLObject> searcher = this.getEntitySearcher(type);
            if (searcher == null) {
                return new DirectObjectMapImpl<OWLObject>(loader);
            }
            return new DirectObjectMapImpl<OWLObject>(loader, this.toFinder(searcher), this.toTester(searcher));
        }
        boolean parallel = conf.parallel();
        boolean fastIterator = conf.useIteratorCache();
        return new CacheObjectMapImpl<OWLObject>(loader, false, parallel, fastIterator);
    }

    protected Iterator<ONTObject<OWLObject>> listOWLObjects(OWLComponentType type, InternalConfig conf) {
        ModelObjectFactory factory = this.getObjectFactory();
        OntGraphModelImpl model = this.getSearchModel();
        ObjectsSearcher<OWLObject> searcher = this.getEntitySearcher(type);
        if (searcher != null && this.useObjectsSearchOptimization(conf)) {
            return searcher.listONTObjects(model, factory, conf);
        }
        return this.selectContentObjects(type).flatMap(x -> type.select((OWLObject)x, model, factory)).iterator();
    }

    private ObjectsSearcher<OWLObject> getEntitySearcher(OWLComponentType type) {
        switch (type) {
            case CLASS: {
                return BaseSearcher.cast(this.classSearcher);
            }
            case NAMED_INDIVIDUAL: {
                return BaseSearcher.cast(this.individualSearcher);
            }
            case DATATYPE: {
                return BaseSearcher.cast(this.datatypeSearcher);
            }
            case NAMED_OBJECT_PROPERTY: {
                return BaseSearcher.cast(this.objectPropertySearcher);
            }
            case ANNOTATION_PROPERTY: {
                return BaseSearcher.cast(this.annotationPropertySearcher);
            }
            case DATATYPE_PROPERTY: {
                return BaseSearcher.cast(this.dataPropertySearcher);
            }
        }
        return null;
    }

    protected boolean useObjectsSearchOptimization(InternalConfig config) {
        return !config.useContentCache() || this.contentCaches().noneMatch(ObjectMap::isLoaded);
    }

    protected Map<OWLComponentType, ObjectMap<OWLObject>> createComponentStore() {
        return this.createMapStore(OWLComponentType.class, OWLComponentType.keys(), this::createComponentObjectMap);
    }

    protected Stream<ONTObject<OWLObject>> selectContentContainers(OWLComponentType type) {
        return this.selectContent(type, k -> this.getContentCache((OWLTopObjectType)((Object)k)).values(), (k, x) -> k.hasAnnotations((OWLObject)x.getOWLObject()));
    }

    protected Stream<OWLObject> selectContentObjects(OWLComponentType type) {
        return this.selectContent(type, k -> this.getContentCache((OWLTopObjectType)((Object)k)).keys(), OWLTopObjectType::hasAnnotations);
    }

    protected <R> Stream<R> selectContent(OWLComponentType type, Function<OWLTopObjectType, Stream<R>> toStream, BiPredicate<OWLTopObjectType, R> withAnnotations) {
        if (!OWLTopObjectType.ANNOTATION.hasComponent(type)) {
            return OWLTopObjectType.all().filter(k -> k.hasComponent(type)).flatMap(toStream);
        }
        return OWLTopObjectType.all().flatMap(k -> {
            if (k.hasComponent(type)) {
                return (Stream)toStream.apply((OWLTopObjectType)((Object)k));
            }
            return ((Stream)toStream.apply((OWLTopObjectType)((Object)k))).filter(x -> withAnnotations.test((OWLTopObjectType)((Object)k), (Object)x));
        });
    }

    protected Stream<ObjectMap<? extends OWLAxiom>> filteredAxiomsCaches(Stream<OWLTopObjectType> keys) {
        Map<OWLTopObjectType, ObjectMap<? extends OWLObject>> map = this.getContentStore();
        return keys.map(x -> (ObjectMap)map.get(x));
    }

    protected ObjectMap<OWLAxiom> getAxiomsCache(OWLTopObjectType key) {
        return this.getContentCache(key);
    }

    protected ObjectMap<OWLAnnotation> getHeaderCache() {
        return this.getContentCache(OWLTopObjectType.ANNOTATION);
    }

    protected <X extends OWLObject> ObjectMap<X> getContentCache(OWLTopObjectType key) {
        return this.getContentStore().get((Object)key);
    }

    protected Map<OWLTopObjectType, ObjectMap<? extends OWLObject>> getContentStore() {
        return this.content.get(this);
    }

    protected Stream<ObjectMap<?>> contentCaches() {
        return this.getContentStore().values().stream();
    }

    protected Map<OWLTopObjectType, ObjectMap<? extends OWLObject>> createContentStore() {
        return this.createMapStore(OWLTopObjectType.class, OWLTopObjectType.all(), this::createContentObjectMap);
    }

    protected ObjectMap<OWLObject> createContentObjectMap(final OWLTopObjectType key) {
        boolean withMerge;
        ObjectsSearcher<OWLObject> searcher = key.getSearcher();
        InternalConfig conf = this.getConfig();
        if (!conf.useContentCache()) {
            return new DirectObjectMapImpl<OWLObject>(this.toLoader(searcher), this.toFinder(searcher), this.toTester(searcher));
        }
        boolean parallel = conf.parallel();
        boolean fastIterator = conf.useIteratorCache();
        boolean bl = withMerge = !key.isDistinct();
        if (!LOGGER.isDebugEnabled()) {
            return new CacheObjectMapImpl<OWLObject>(this.toLoader(searcher), withMerge, parallel, fastIterator);
        }
        final OntID id = this.getID();
        return new CacheObjectMapImpl<OWLObject>(this.toLoader(searcher), withMerge, parallel, fastIterator){

            @Override
            protected CacheObjectMapImpl.CachedMap<OWLObject, ONTObject<OWLObject>> loadMap() {
                Instant start = Instant.now();
                CacheObjectMapImpl.CachedMap<OWLObject, ONTObject<OWLObject>> res = super.loadMap();
                Duration d = Duration.between(start, Instant.now());
                if (res.size() == 0L) {
                    return res;
                }
                LOGGER.debug("[{}]{}:::{}{}", new Object[]{id, StringUtils.rightPad((String)("[" + (Object)((Object)key) + "]"), (int)42), StringUtils.rightPad((String)String.valueOf(res.size()), (int)8), "(" + String.format(Locale.ENGLISH, "%.3f", (double)d.toMillis() / 1000.0) + "s)"});
                return res;
            }
        };
    }

    private <X extends OWLObject> Supplier<Iterator<ONTObject<X>>> toLoader(ObjectsSearcher<X> searcher) {
        return () -> searcher.listONTObjects(this.getSearchModel(), this.getObjectFactory(), this.getConfig());
    }

    private <X extends OWLObject> Function<X, Optional<ONTObject<X>>> toFinder(ObjectsSearcher<X> searcher) {
        return k -> searcher.findONTObject(k, this.getSearchModel(), this.getObjectFactory(), this.getConfig());
    }

    private <X extends OWLObject> Predicate<X> toTester(ObjectsSearcher<X> searcher) {
        return k -> searcher.containsONTObject(k, this.getSearchModel(), this.getObjectFactory(), this.getConfig());
    }
}

