/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import java.util.Objects;
import java.util.stream.Stream;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLNaryAxiom;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;

interface ListAxioms {
    public <A extends OWLAxiom> Stream<A> listOWLAxioms(Class<A> var1);

    default public Stream<OWLDeclarationAxiom> listOWLDeclarationAxioms(OWLEntity entity) {
        return this.listOWLAxioms(OWLDeclarationAxiom.class).filter(a -> Objects.equals(entity, a.getEntity()));
    }

    default public Stream<OWLAnnotationAssertionAxiom> listOWLAnnotationAssertionAxioms(OWLAnnotationSubject subject) {
        return this.listOWLAxioms(OWLAnnotationAssertionAxiom.class).filter(a -> Objects.equals(subject, a.getSubject()));
    }

    default public Stream<OWLSubClassOfAxiom> listOWLSubClassOfAxiomsBySubject(OWLClass subject) {
        return this.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> Objects.equals(subject, a.getSubClass()));
    }

    default public Stream<OWLSubClassOfAxiom> listOWLSubClassOfAxiomsByObject(OWLClass object) {
        return this.listOWLAxioms(OWLSubClassOfAxiom.class).filter(a -> Objects.equals(object, a.getSuperClass()));
    }

    default public Stream<OWLEquivalentClassesAxiom> listOWLEquivalentClassesAxioms(OWLClass clazz) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLEquivalentClassesAxiom.class, clazz);
    }

    default public Stream<OWLDisjointClassesAxiom> listOWLDisjointClassesAxioms(OWLClass clazz) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLDisjointClassesAxiom.class, clazz);
    }

    default public Stream<OWLDisjointUnionAxiom> listOWLDisjointUnionAxioms(OWLClass subject) {
        return this.listOWLAxioms(OWLDisjointUnionAxiom.class).filter(x -> Objects.equals(subject, x.getOWLClass()));
    }

    default public Stream<OWLHasKeyAxiom> listOWLHasKeyAxioms(OWLClass subject) {
        return this.listOWLAxioms(OWLHasKeyAxiom.class).filter(x -> Objects.equals(subject, x.getClassExpression()));
    }

    default public Stream<OWLClassAssertionAxiom> listOWLClassAssertionAxioms(OWLClassExpression object) {
        return this.listOWLAxioms(OWLClassAssertionAxiom.class).filter(x -> Objects.equals(object, x.getClassExpression()));
    }

    default public Stream<OWLDatatypeDefinitionAxiom> listOWLDatatypeDefinitionAxioms(OWLDatatype datatype) {
        return this.listOWLAxioms(OWLDatatypeDefinitionAxiom.class).filter(x -> Objects.equals(datatype, x.getDatatype()));
    }

    default public Stream<OWLClassAssertionAxiom> listOWLClassAssertionAxioms(OWLIndividual subject) {
        return this.listOWLAxioms(OWLClassAssertionAxiom.class).filter(x -> Objects.equals(subject, x.getIndividual()));
    }

    default public Stream<OWLSameIndividualAxiom> listOWLSameIndividualAxioms(OWLIndividual operand) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLSameIndividualAxiom.class, operand);
    }

    default public Stream<OWLDifferentIndividualsAxiom> listOWLDifferentIndividualsAxioms(OWLIndividual operand) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLDifferentIndividualsAxiom.class, operand);
    }

    default public Stream<OWLObjectPropertyAssertionAxiom> listOWLObjectPropertyAssertionAxioms(OWLIndividual subject) {
        return this.listOWLAxioms(OWLObjectPropertyAssertionAxiom.class).filter(x -> Objects.equals(subject, x.getSubject()));
    }

    default public Stream<OWLNegativeObjectPropertyAssertionAxiom> listOWLNegativeObjectPropertyAssertionAxioms(OWLIndividual subject) {
        return this.listOWLAxioms(OWLNegativeObjectPropertyAssertionAxiom.class).filter(x -> Objects.equals(subject, x.getSubject()));
    }

    default public Stream<OWLDataPropertyAssertionAxiom> listOWLDataPropertyAssertionAxioms(OWLIndividual subject) {
        return this.listOWLAxioms(OWLDataPropertyAssertionAxiom.class).filter(x -> Objects.equals(subject, x.getSubject()));
    }

    default public Stream<OWLNegativeDataPropertyAssertionAxiom> listOWLNegativeDataPropertyAssertionAxioms(OWLIndividual subject) {
        return this.listOWLAxioms(OWLNegativeDataPropertyAssertionAxiom.class).filter(x -> Objects.equals(subject, x.getSubject()));
    }

    default public Stream<OWLEquivalentObjectPropertiesAxiom> listOWLEquivalentObjectPropertiesAxioms(OWLObjectPropertyExpression operand) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLEquivalentObjectPropertiesAxiom.class, operand);
    }

    default public Stream<OWLDisjointObjectPropertiesAxiom> listOWLDisjointObjectPropertiesAxioms(OWLObjectPropertyExpression operand) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLDisjointObjectPropertiesAxiom.class, operand);
    }

    default public Stream<OWLSubObjectPropertyOfAxiom> listOWLSubObjectPropertyOfAxiomsBySubject(OWLObjectPropertyExpression subject) {
        return this.listOWLSubPropertyOfAxiomsBySubject(OWLSubObjectPropertyOfAxiom.class, subject);
    }

    default public Stream<OWLSubObjectPropertyOfAxiom> listOWLSubObjectPropertyOfAxiomsByObject(OWLObjectPropertyExpression object) {
        return this.listOWLSubPropertyOfAxiomsByObject(OWLSubObjectPropertyOfAxiom.class, object);
    }

    default public Stream<OWLObjectPropertyDomainAxiom> listOWLObjectPropertyDomainAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLObjectPropertyDomainAxiom.class, subject);
    }

    default public Stream<OWLObjectPropertyRangeAxiom> listOWLObjectPropertyRangeAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLObjectPropertyRangeAxiom.class, subject);
    }

    default public Stream<OWLInverseObjectPropertiesAxiom> listOWLInverseObjectPropertiesAxioms(OWLObjectPropertyExpression operand) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLInverseObjectPropertiesAxiom.class, operand);
    }

    default public Stream<OWLFunctionalObjectPropertyAxiom> listOWLFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLFunctionalObjectPropertyAxiom.class, subject);
    }

    default public Stream<OWLInverseFunctionalObjectPropertyAxiom> listOWLInverseFunctionalObjectPropertyAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLInverseFunctionalObjectPropertyAxiom.class, subject);
    }

    default public Stream<OWLSymmetricObjectPropertyAxiom> listOWLSymmetricObjectPropertyAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLSymmetricObjectPropertyAxiom.class, subject);
    }

    default public Stream<OWLAsymmetricObjectPropertyAxiom> listOWLAsymmetricObjectPropertyAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLAsymmetricObjectPropertyAxiom.class, subject);
    }

    default public Stream<OWLReflexiveObjectPropertyAxiom> listOWLReflexiveObjectPropertyAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLReflexiveObjectPropertyAxiom.class, subject);
    }

    default public Stream<OWLIrreflexiveObjectPropertyAxiom> listOWLIrreflexiveObjectPropertyAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLIrreflexiveObjectPropertyAxiom.class, subject);
    }

    default public Stream<OWLTransitiveObjectPropertyAxiom> listOWLTransitiveObjectPropertyAxioms(OWLObjectPropertyExpression subject) {
        return this.listOWLPropertyAxioms(OWLTransitiveObjectPropertyAxiom.class, subject);
    }

    default public Stream<OWLEquivalentDataPropertiesAxiom> listOWLEquivalentDataPropertiesAxioms(OWLDataProperty operand) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLEquivalentDataPropertiesAxiom.class, operand);
    }

    default public Stream<OWLDisjointDataPropertiesAxiom> listOWLDisjointDataPropertiesAxioms(OWLDataProperty operand) {
        return this.listOWLNaryAxiomAxiomsByOperand(OWLDisjointDataPropertiesAxiom.class, operand);
    }

    default public Stream<OWLSubDataPropertyOfAxiom> listOWLSubDataPropertyOfAxiomsBySubject(OWLDataProperty subject) {
        return this.listOWLSubPropertyOfAxiomsBySubject(OWLSubDataPropertyOfAxiom.class, subject);
    }

    default public Stream<OWLSubDataPropertyOfAxiom> listOWLSubDataPropertyOfAxiomsByObject(OWLDataProperty object) {
        return this.listOWLSubPropertyOfAxiomsByObject(OWLSubDataPropertyOfAxiom.class, object);
    }

    default public Stream<OWLDataPropertyDomainAxiom> listOWLDataPropertyDomainAxioms(OWLDataProperty subject) {
        return this.listOWLPropertyAxioms(OWLDataPropertyDomainAxiom.class, subject);
    }

    default public Stream<OWLDataPropertyRangeAxiom> listOWLDataPropertyRangeAxioms(OWLDataProperty subject) {
        return this.listOWLPropertyAxioms(OWLDataPropertyRangeAxiom.class, subject);
    }

    default public Stream<OWLFunctionalDataPropertyAxiom> listOWLFunctionalDataPropertyAxioms(OWLDataProperty subject) {
        return this.listOWLPropertyAxioms(OWLFunctionalDataPropertyAxiom.class, subject);
    }

    default public Stream<OWLSubAnnotationPropertyOfAxiom> listOWLSubAnnotationPropertyOfAxiomsBySubject(OWLAnnotationProperty subject) {
        return this.listOWLAxioms(OWLSubAnnotationPropertyOfAxiom.class).filter(x -> Objects.equals(subject, x.getSubProperty()));
    }

    default public Stream<OWLSubAnnotationPropertyOfAxiom> listOWLSubAnnotationPropertyOfAxiomsByObject(OWLAnnotationProperty object) {
        return this.listOWLAxioms(OWLSubAnnotationPropertyOfAxiom.class).filter(x -> Objects.equals(object, x.getSuperProperty()));
    }

    default public Stream<OWLAnnotationPropertyDomainAxiom> listOWLAnnotationPropertyDomainAxioms(OWLAnnotationProperty subject) {
        return this.listOWLPropertyAxioms(OWLAnnotationPropertyDomainAxiom.class, subject);
    }

    default public Stream<OWLAnnotationPropertyRangeAxiom> listOWLAnnotationPropertyRangeAxioms(OWLAnnotationProperty subject) {
        return this.listOWLPropertyAxioms(OWLAnnotationPropertyRangeAxiom.class, subject);
    }

    default public <A extends OWLNaryAxiom<? super K>, K extends OWLObject> Stream<A> listOWLNaryAxiomAxiomsByOperand(Class<A> type, K operand) {
        return this.listOWLAxioms(type).filter(a -> a.operands().anyMatch(operand::equals));
    }

    default public <A extends OWLAxiom & HasProperty<P>, P extends OWLPropertyExpression> Stream<A> listOWLPropertyAxioms(Class<A> type, P property) {
        return this.listOWLAxioms(type).filter(x -> Objects.equals(property, ((HasProperty)x).getProperty()));
    }

    default public <A extends OWLSubPropertyAxiom<P>, P extends OWLPropertyExpression> Stream<A> listOWLSubPropertyOfAxiomsBySubject(Class<A> type, P subject) {
        return this.listOWLAxioms(type).filter(x -> Objects.equals(subject, x.getSubProperty()));
    }

    default public <A extends OWLSubPropertyAxiom<P>, P extends OWLPropertyExpression> Stream<A> listOWLSubPropertyOfAxiomsByObject(Class<A> type, P object) {
        return this.listOWLAxioms(type).filter(x -> Objects.equals(object, x.getSuperProperty()));
    }
}

