/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.internal.InternalConfig;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.util.iterator.ExtendedIterator;

class ModelIterators {
    ModelIterators() {
    }

    static <R> Stream<R> reduce(Stream<R> stream, InternalConfig conf) {
        if (!conf.parallel() || !conf.useContentCache()) {
            return stream;
        }
        ArrayList res = new ArrayList(1024);
        stream.forEach(res::add);
        res.trimToSize();
        return res.stream();
    }

    static <R> Stream<R> reduce(ExtendedIterator<R> stream, InternalConfig conf) {
        if (!conf.parallel() || !conf.useContentCache()) {
            return Iter.asStream(stream);
        }
        ArrayList res = new ArrayList(1024);
        stream.forEachRemaining(res::add);
        res.trimToSize();
        return res.stream();
    }

    static <R> Stream<R> reduceDistinct(ExtendedIterator<R> stream, InternalConfig conf) {
        if (!conf.useContentCache()) {
            return Iter.asStream(stream);
        }
        if (conf.parallel()) {
            return Iter.addAll(stream, new LinkedHashSet()).stream();
        }
        return Iter.asStream(Iter.distinct(stream), 257);
    }

    static <R> Stream<R> reduceDistinct(Stream<R> stream, InternalConfig conf) {
        if (!conf.useContentCache()) {
            return stream;
        }
        if (conf.parallel()) {
            return stream.collect(Collectors.toCollection(LinkedHashSet::new)).stream();
        }
        return stream.distinct();
    }

    static <R, X> Stream<R> flatMap(Stream<X> stream, Function<X, Stream<? extends R>> map, InternalConfig conf) {
        if (!conf.parallel() || !conf.useContentCache()) {
            return stream.flatMap(map);
        }
        return stream.map(map).collect(Collectors.toList()).stream().flatMap(Function.identity());
    }
}

