/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.jena.impl.Entities;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import java.util.function.Supplier;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.impl.LiteralLabel;
import org.apache.jena.rdf.model.Literal;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;

public interface ModelObjectFactory
extends ONTObjectFactory {
    public Supplier<OntModel> model();

    public ONTObject<OWLLiteral> getLiteral(LiteralLabel var1);

    public ONTObject<OWLAnonymousIndividual> getAnonymousIndividual(BlankNodeId var1);

    public ONTObject<OWLNamedIndividual> getNamedIndividual(String var1);

    public ONTObject<OWLObjectProperty> getObjectProperty(String var1);

    public ONTObject<OWLDataProperty> getDataProperty(String var1);

    public ONTObject<OWLAnnotationProperty> getAnnotationProperty(String var1);

    public ONTObject<OWLDatatype> getDatatype(String var1);

    public ONTObject<OWLClass> getClass(String var1);

    public ONTObject<? extends SWRLIArgument> getSWRLArgument(String var1);

    public ONTObject<? extends SWRLIArgument> getSWRLArgument(BlankNodeId var1);

    public ONTObject<? extends SWRLDArgument> getSWRLArgument(LiteralLabel var1);

    public ONTObject<SWRLVariable> getSWRLVariable(String var1);

    default public OntModel getModel() {
        return this.model().get();
    }

    @Override
    default public ONTObject<OWLAnonymousIndividual> getIndividual(OntIndividual.Anonymous i) {
        return this.getAnonymousIndividual(i.asNode().getBlankNodeId());
    }

    @Override
    default public ONTObject<OWLObjectProperty> getProperty(OntObjectProperty.Named p) {
        return this.getObjectProperty(p.getURI());
    }

    @Override
    default public ONTObject<OWLDataProperty> getProperty(OntDataProperty p) {
        return this.getDataProperty(p.getURI());
    }

    @Override
    default public ONTObject<OWLAnnotationProperty> getProperty(OntAnnotationProperty p) {
        return this.getAnnotationProperty(p.getURI());
    }

    @Override
    default public ONTObject<OWLDatatype> getDatatype(OntDataRange.Named dt) {
        return this.getDatatype(dt.getURI());
    }

    @Override
    default public ONTObject<OWLClass> getClass(OntClass.Named ce) {
        return this.getClass(ce.getURI());
    }

    @Override
    default public ONTObject<OWLLiteral> getLiteral(Literal literal) {
        return this.getLiteral(literal.asNode().getLiteral());
    }

    @Override
    default public ONTObject<? extends OWLObjectPropertyExpression> getProperty(OntObjectProperty property) {
        if (OntApiException.notNull(property, "Null object property.").isAnon()) {
            return this.getProperty((OntObjectProperty.Inverse)property);
        }
        return this.getObjectProperty(property.asNode().getURI());
    }

    @Override
    default public ONTObject<OWLNamedIndividual> getIndividual(OntIndividual.Named i) {
        return this.getNamedIndividual(i.getURI());
    }

    @Override
    default public ONTObject<? extends OWLIndividual> getIndividual(OntIndividual individual) {
        return this.getIndividual(OntApiException.notNull(individual, "Null individual").asNode());
    }

    default public ONTObject<? extends OWLIndividual> getIndividual(Node node) {
        if (node.isBlank()) {
            return this.getAnonymousIndividual(node.getBlankNodeId());
        }
        return this.getNamedIndividual(node.getURI());
    }

    default public ONTObject<? extends OWLEntity> getEntity(String uri, Entities type) {
        switch (type) {
            case CLASS: {
                return this.getClass(uri);
            }
            case DATATYPE: {
                return this.getDatatype(uri);
            }
            case INDIVIDUAL: {
                return this.getNamedIndividual(uri);
            }
            case OBJECT_PROPERTY: {
                return this.getObjectProperty(uri);
            }
            case DATA_PROPERTY: {
                return this.getDataProperty(uri);
            }
            case ANNOTATION_PROPERTY: {
                return this.getAnnotationProperty(uri);
            }
        }
        throw new OntApiException.IllegalArgument("Unsupported type " + (Object)((Object)type));
    }

    @Override
    default public ONTObject<? extends SWRLIArgument> getSWRLArgument(OntSWRL.IArg arg) {
        if (arg.isAnon()) {
            return this.getSWRLArgument(arg.asNode().getBlankNodeId());
        }
        if (arg.canAs(OntSWRL.Variable.class)) {
            return this.getSWRLVariable((OntSWRL.Variable)arg.as(OntSWRL.Variable.class));
        }
        return this.getSWRLArgument(arg.asNode().getURI());
    }

    @Override
    default public ONTObject<? extends SWRLDArgument> getSWRLArgument(OntSWRL.DArg arg) {
        return arg.isLiteral() ? this.getSWRLArgument(arg.asNode().getLiteral()) : this.getSWRLVariable((OntSWRL.Variable)arg.as(OntSWRL.Variable.class));
    }

    @Override
    default public ONTObject<SWRLVariable> getSWRLVariable(OntSWRL.Variable v) {
        return this.getSWRLVariable(v.getURI());
    }
}

