/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.WithMerge;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Stream;
import org.apache.jena.graph.FrontsTriple;
import org.apache.jena.graph.Triple;
import org.semanticweb.owlapi.model.OWLObject;

public abstract class ONTWrapperImpl<O extends OWLObject>
implements ONTObject<O>,
WithMerge<ONTObject<O>> {
    private final O object;

    protected ONTWrapperImpl(O object) {
        this.object = (OWLObject)Objects.requireNonNull(object, "Null OWLObject.");
    }

    public static <X extends OWLObject> ONTWrapperImpl<X> create(X o, OntStatement root) {
        return ONTWrapperImpl.create(o, root.asTriple());
    }

    public static <X extends OWLObject> ONTWrapperImpl<X> create(X o, final OntObject root) {
        return new ONTWrapperImpl<X>(o){

            @Override
            public Stream<Triple> triples() {
                return root.spec().map(FrontsTriple::asTriple);
            }
        };
    }

    public static <X extends OWLObject> ONTWrapperImpl<X> create(X o) {
        return new ONTWrapperImpl<X>(o){

            @Override
            public Stream<Triple> triples() {
                return Stream.empty();
            }

            @Override
            public boolean isDefinitelyEmpty() {
                return true;
            }
        };
    }

    protected static <X extends OWLObject> ONTWrapperImpl<X> create(X o, final Triple root) {
        return new ONTWrapperImpl<X>(o){

            @Override
            public Stream<Triple> triples() {
                return Stream.of(root);
            }
        };
    }

    protected static <X extends OWLObject> ONTWrapperImpl<X> create(final ONTObject<X> other) {
        return new ONTWrapperImpl<X>((OWLObject)other.getOWLObject()){

            @Override
            public Stream<Triple> triples() {
                return other.triples();
            }
        };
    }

    @Override
    public ONTWrapperImpl<O> merge(ONTObject<O> other) {
        return this.append(other);
    }

    @Override
    public O getOWLObject() {
        return this.object;
    }

    @Override
    public abstract Stream<Triple> triples();

    protected boolean isDefinitelyEmpty() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ONTObject)) {
            return false;
        }
        ONTObject that = (ONTObject)o;
        return this.object.equals(that.getOWLObject());
    }

    public int hashCode() {
        return this.object.hashCode();
    }

    public String toString() {
        return String.valueOf(this.object);
    }

    public ONTWrapperImpl<O> append(OntObject other) {
        return this.append(() -> other.spec().map(FrontsTriple::asTriple));
    }

    public ONTWrapperImpl<O> append(ONTObject<? extends OWLObject> other) {
        return this.append(other::triples);
    }

    public ONTWrapperImpl<O> append(Collection<? extends ONTObject<?>> others) {
        return this.append(() -> others.stream().flatMap(ONTObject::triples));
    }

    public ONTWrapperImpl<O> append(final Supplier<Stream<Triple>> triples) {
        return new ONTWrapperImpl<O>((OWLObject)this.object){

            @Override
            public Stream<Triple> triples() {
                return ONTWrapperImpl.this.concat((Stream)triples.get());
            }
        };
    }

    private Stream<Triple> concat(Stream<Triple> other) {
        return this.isDefinitelyEmpty() ? other : Stream.concat(this.triples(), other);
    }
}

