/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.OwlObjects;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntEntity;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Model;
import org.apache.jena.rdf.model.RDFNode;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.HasComponents;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnonymousClassExpression;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLVariable;

public enum OWLComponentType {
    IRI(IRI.class, Resource.class, false, true){

        @Override
        List<OWLComponentType> includes() {
            return Collections.emptyList();
        }

        Stream<IRI> components(OWLObject o) {
            return OwlObjects.iris(o);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getIRI(n.asResource().getURI());
        }

        ExtendedIterator<Resource> listObjects(OntModel model) {
            return Iter.create(() -> {
                HashSet res = new HashSet();
                model.getBaseModel().listStatements().forEachRemaining(s -> {
                    res.add(s.getPredicate().inModel((Model)model));
                    if (s.getSubject().isURIResource()) {
                        res.add(s.getSubject().inModel((Model)model));
                    }
                    if (s.getObject().isURIResource()) {
                        res.add(s.getResource().inModel((Model)model));
                    }
                });
                return res.iterator();
            });
        }
    }
    ,
    ANNOTATION_PROPERTY(OWLAnnotationProperty.class, OntAnnotationProperty.class, true, true){

        Stream<OWLAnnotationProperty> components(OWLObject o) {
            return o.annotationPropertiesInSignature();
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getProperty((OntAnnotationProperty)n.as(OntAnnotationProperty.class));
        }
    }
    ,
    DATATYPE_PROPERTY(OWLDataProperty.class, OntDataProperty.class, true, true){

        Stream<OWLDataProperty> components(OWLObject o) {
            return o.dataPropertiesInSignature();
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getProperty((OntDataProperty)n.as(OntDataProperty.class));
        }
    }
    ,
    NAMED_OBJECT_PROPERTY(OWLObjectProperty.class, OntObjectProperty.Named.class, true, true){

        Stream<OWLObjectProperty> components(OWLObject o) {
            return o.objectPropertiesInSignature();
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getProperty((OntObjectProperty.Named)n.as(OntObjectProperty.Named.class));
        }
    }
    ,
    NAMED_INDIVIDUAL(OWLNamedIndividual.class, OntIndividual.Named.class, true, true){

        Stream<OWLNamedIndividual> components(OWLObject o) {
            return o.individualsInSignature();
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getIndividual((OntIndividual.Named)n.as(OntIndividual.Named.class));
        }
    }
    ,
    CLASS(OWLClass.class, OntClass.Named.class, true, true){

        Stream<OWLClass> components(OWLObject o) {
            return o.classesInSignature();
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getClass((OntClass.Named)n.as(OntClass.Named.class));
        }
    }
    ,
    DATATYPE(OWLDatatype.class, OntDataRange.Named.class, true, true){

        Stream<OWLDatatype> components(OWLObject o) {
            return o.datatypesInSignature();
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getDatatype((OntDataRange.Named)n.as(OntDataRange.Named.class));
        }
    }
    ,
    ENTITY(OWLEntity.class, OntEntity.class, true, false){

        @Override
        List<OWLComponentType> includes() {
            return Arrays.asList(ANNOTATION_PROPERTY, DATATYPE_PROPERTY, NAMED_OBJECT_PROPERTY, NAMED_INDIVIDUAL, CLASS, DATATYPE);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getEntity((OntEntity)n.as(OntEntity.class));
        }

        Stream<OWLEntity> components(OWLObject o) {
            return o.signature();
        }
    }
    ,
    LITERAL(OWLLiteral.class, Literal.class, false, true){

        @Override
        List<OWLComponentType> includes() {
            return Collections.singletonList(DATATYPE);
        }

        @Override
        ExtendedIterator<? extends RDFNode> listObjects(OntModel model) {
            return model.getBaseModel().listObjects().filterKeep(RDFNode::isLiteral).mapWith(x -> x.asLiteral().inModel((Model)model));
        }

        public Stream<OWLObject> components(OWLObject container) {
            return OwlObjects.objects(this.owl, container);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getLiteral(n.asLiteral());
        }
    }
    ,
    INDIVIDUAL(OWLIndividual.class, OntIndividual.class){

        @Override
        List<OWLComponentType> includes() {
            return Arrays.asList(NAMED_INDIVIDUAL, ANONYMOUS_INDIVIDUAL);
        }

        Stream<OWLIndividual> components(OWLObject o) {
            return Stream.concat(o.anonymousIndividuals(), o.individualsInSignature());
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getIndividual((OntIndividual)n.as(OntIndividual.class));
        }
    }
    ,
    ANONYMOUS_INDIVIDUAL(OWLAnonymousIndividual.class, OntIndividual.Anonymous.class, false, true){

        Stream<OWLAnonymousIndividual> components(OWLObject o) {
            return o.anonymousIndividuals();
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getIndividual((OntIndividual.Anonymous)n.as(OntIndividual.Anonymous.class));
        }
    }
    ,
    ANONYMOUS_DATA_RANGE(OWLDataRange.class, OntDataRange.class){

        @Override
        List<OWLComponentType> includes() {
            return Arrays.asList(DATA_RANGE, LITERAL, FACET_RESTRICTION);
        }

        Stream<OWLDataRange> components(OWLObject o) {
            return super.components(o).filter(x -> !(x instanceof OWLDatatype));
        }

        ExtendedIterator<OntDataRange> listObjects(OntModel model) {
            return super.listObjects(model).filterKeep(RDFNode::isAnon);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getDatatype((OntDataRange)n.as(OntDataRange.class));
        }
    }
    ,
    DATA_RANGE(OWLDataRange.class, OntDataRange.class){

        @Override
        List<OWLComponentType> includes() {
            return Arrays.asList(DATATYPE, ANONYMOUS_DATA_RANGE);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getDatatype((OntDataRange)n.as(OntDataRange.class));
        }
    }
    ,
    ANONYMOUS_CLASS_EXPRESSION(OWLAnonymousClassExpression.class, OntClass.class){

        @Override
        List<OWLComponentType> includes() {
            return Arrays.asList(CLASS_EXPRESSION, INDIVIDUAL, OBJECT_PROPERTY_EXPRESSION, DATATYPE_PROPERTY, DATA_RANGE);
        }

        Stream<OWLClassExpression> components(OWLObject o) {
            return o.nestedClassExpressions().filter(IsAnonymous::isAnonymous);
        }

        ExtendedIterator<OntClass> listObjects(OntModel model) {
            return super.listObjects(model).filterKeep(RDFNode::isAnon);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getClass((OntClass)n.as(OntClass.class));
        }
    }
    ,
    CLASS_EXPRESSION(OWLClassExpression.class, OntClass.class){

        @Override
        List<OWLComponentType> includes() {
            return Arrays.asList(CLASS, ANONYMOUS_CLASS_EXPRESSION);
        }

        Stream<OWLClassExpression> components(OWLObject o) {
            return o.nestedClassExpressions();
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getClass((OntClass)n.as(OntClass.class));
        }
    }
    ,
    INVERSE_OBJECT_PROPERTY(OWLObjectInverseOf.class, OntObjectProperty.Inverse.class){

        @Override
        List<OWLComponentType> includes() {
            return Collections.singletonList(NAMED_OBJECT_PROPERTY);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getProperty((OntObjectProperty.Inverse)n.as(OntObjectProperty.Inverse.class));
        }
    }
    ,
    OBJECT_PROPERTY_EXPRESSION(OWLObjectPropertyExpression.class, OntObjectProperty.class){

        @Override
        List<OWLComponentType> includes() {
            return Arrays.asList(NAMED_OBJECT_PROPERTY, INVERSE_OBJECT_PROPERTY);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getProperty((OntObjectProperty)n.as(OntObjectProperty.class));
        }
    }
    ,
    FACET_RESTRICTION(OWLFacetRestriction.class, OntFacetRestriction.class){

        @Override
        List<OWLComponentType> includes() {
            return Collections.singletonList(LITERAL);
        }

        ONTObject<OWLFacetRestriction> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getFacetRestriction((OntFacetRestriction)n.as(OntFacetRestriction.class));
        }
    }
    ,
    SWRL_VARIABLE(SWRLVariable.class, OntSWRL.Variable.class, false, true){

        ONTObject<SWRLVariable> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getSWRLVariable((OntSWRL.Variable)n.as(OntSWRL.Variable.class));
        }
    }
    ,
    SWRL_ATOM(SWRLAtom.class, OntSWRL.Atom.class){

        @Override
        List<OWLComponentType> includes() {
            return Arrays.asList(INDIVIDUAL, LITERAL, SWRL_VARIABLE, CLASS_EXPRESSION, DATA_RANGE, DATATYPE_PROPERTY, OBJECT_PROPERTY_EXPRESSION);
        }

        @Override
        ONTObject<? extends OWLObject> wrap(RDFNode n, ONTObjectFactory df) {
            return df.getSWRLAtom((OntSWRL.Atom)n.as(OntSWRL.Atom.class));
        }
    };

    private static final Set<OWLComponentType> PRIMITIVE_COMPONENTS;
    private static final Set<OWLComponentType> COMPLEX_COMPONENTS;
    final Class<? extends OWLObject> owl;
    final Class<? extends RDFNode> jena;
    private final boolean primitive;
    private final boolean entity;

    private OWLComponentType(Class<? extends OWLObject> owl, Class<? extends RDFNode> rdf) {
        this(owl, rdf, false, false);
    }

    private OWLComponentType(Class<? extends OWLObject> owl, Class<? extends RDFNode> rdf, boolean entity, boolean primitive) {
        this.owl = owl;
        this.jena = rdf;
        this.entity = entity;
        this.primitive = primitive;
    }

    public static Set<OWLComponentType> toSet(OWLComponentType ... values) {
        EnumSet<OWLComponentType> res = EnumSet.noneOf(OWLComponentType.class);
        Arrays.stream(values).forEach(v -> v.putInSet(res));
        return res;
    }

    public static OWLComponentType get(OWLObject o) {
        Optional<OWLComponentType> res = Arrays.stream(OWLComponentType.values()).filter(OWLComponentType::isPrimitive).filter(x -> x.owl.isInstance(o)).findFirst();
        return res.orElseGet(() -> Arrays.stream(OWLComponentType.values()).filter(t -> !t.isPrimitive()).filter(x -> x.owl.isInstance(o)).findFirst().orElseThrow(() -> new OntApiException.Unsupported("Unsupported object type: " + o)));
    }

    static Stream<OWLComponentType> sharedComponents() {
        return COMPLEX_COMPONENTS.stream();
    }

    static Stream<OWLComponentType> keys() {
        return PRIMITIVE_COMPONENTS.stream();
    }

    List<OWLComponentType> includes() {
        return Collections.singletonList(IRI);
    }

    private void putInSet(Set<OWLComponentType> set) {
        if (!set.add(this)) {
            return;
        }
        this.includes().forEach(i -> i.putInSet(set));
    }

    Stream<? extends OWLObject> components(OWLObject container) {
        return OwlObjects.parseComponents(this.owl, (HasComponents)container);
    }

    ExtendedIterator<? extends RDFNode> listObjects(OntModel model) {
        return OntModels.listLocalObjects(model, this.jena);
    }

    abstract ONTObject<? extends OWLObject> wrap(RDFNode var1, ONTObjectFactory var2);

    ONTObject<OWLObject> wrap(OWLObject object, OntModel model, ONTObjectFactory df) {
        if (object instanceof ONTObject) {
            return (ONTObject)object;
        }
        return this.wrap(WriteHelper.toRDFNode(object).inModel((Model)model), df);
    }

    public final Stream<OWLObject> select(OWLObject container) {
        return this.components(container);
    }

    public boolean contains(OWLObject container, OWLObject component) {
        if (this.entity) {
            return container.containsEntityInSignature((OWLEntity)component);
        }
        return this.components(container).anyMatch(component::equals);
    }

    public boolean containsAny(OWLObject container, Collection<? extends OWLObject> components) {
        if (this.entity && components.size() == 1) {
            return container.containsEntityInSignature((OWLEntity)components.iterator().next());
        }
        return this.components(container).anyMatch(components::contains);
    }

    Stream<ONTObject<OWLObject>> select(OWLObject container, OntModel model, ONTObjectFactory df) {
        return this.select(container).map(x -> this.wrap((OWLObject)x, model, df));
    }

    public Stream<ONTObject<OWLObject>> select(OntModel model, ONTObjectFactory df) {
        return Iter.asStream(this.listObjects(model).mapWith(x -> this.wrap((RDFNode)x, df)));
    }

    public boolean isPrimitive() {
        return this.primitive;
    }

    static {
        PRIMITIVE_COMPONENTS = EnumSet.of(CLASS, new OWLComponentType[]{DATATYPE, ANNOTATION_PROPERTY, DATATYPE_PROPERTY, NAMED_OBJECT_PROPERTY, NAMED_INDIVIDUAL, ANONYMOUS_INDIVIDUAL});
        COMPLEX_COMPONENTS = EnumSet.of(ANONYMOUS_CLASS_EXPRESSION, new OWLComponentType[]{ANONYMOUS_DATA_RANGE, FACET_RESTRICTION, INVERSE_OBJECT_PROPERTY, SWRL_ATOM, SWRL_VARIABLE});
    }
}

