/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.utils.Iter;
import java.util.Optional;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.OWLObject;

public interface ObjectsSearcher<K extends OWLObject> {
    public ExtendedIterator<ONTObject<K>> listONTObjects(OntModel var1, ONTObjectFactory var2, AxiomsSettings var3);

    default public boolean containsONTObject(K object, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        return this.findONTObject(object, model, factory, config).isPresent();
    }

    default public Optional<ONTObject<K>> findONTObject(K object, OntModel model, ONTObjectFactory factory, AxiomsSettings config) {
        return Iter.findFirst(this.listONTObjects(model, factory, config).filterKeep(x -> x.getOWLObject().equals(object)));
    }
}

