/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.OntApiException;
import java.util.Iterator;
import java.util.stream.Stream;
import javax.annotation.ParametersAreNonnullByDefault;
import org.apache.jena.shared.PrefixMapping;
import org.semanticweb.owlapi.io.OWLObjectRenderer;
import org.semanticweb.owlapi.model.HasAnnotations;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationAssertionAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLAnnotationSubject;
import org.semanticweb.owlapi.model.OWLAnonymousIndividual;
import org.semanticweb.owlapi.model.OWLAsymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLClass;
import org.semanticweb.owlapi.model.OWLClassAssertionAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataAllValuesFrom;
import org.semanticweb.owlapi.model.OWLDataComplementOf;
import org.semanticweb.owlapi.model.OWLDataExactCardinality;
import org.semanticweb.owlapi.model.OWLDataHasValue;
import org.semanticweb.owlapi.model.OWLDataIntersectionOf;
import org.semanticweb.owlapi.model.OWLDataMaxCardinality;
import org.semanticweb.owlapi.model.OWLDataMinCardinality;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeDefinitionAxiom;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLDeclarationAxiom;
import org.semanticweb.owlapi.model.OWLDifferentIndividualsAxiom;
import org.semanticweb.owlapi.model.OWLDisjointClassesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLDisjointUnionAxiom;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLEquivalentClassesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentDataPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLEquivalentObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLFunctionalDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLHasKeyAxiom;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLInverseFunctionalObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLInverseObjectPropertiesAxiom;
import org.semanticweb.owlapi.model.OWLIrreflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNegativeDataPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLNegativeObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectAllValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectComplementOf;
import org.semanticweb.owlapi.model.OWLObjectExactCardinality;
import org.semanticweb.owlapi.model.OWLObjectHasSelf;
import org.semanticweb.owlapi.model.OWLObjectHasValue;
import org.semanticweb.owlapi.model.OWLObjectIntersectionOf;
import org.semanticweb.owlapi.model.OWLObjectInverseOf;
import org.semanticweb.owlapi.model.OWLObjectMaxCardinality;
import org.semanticweb.owlapi.model.OWLObjectMinCardinality;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectProperty;
import org.semanticweb.owlapi.model.OWLObjectPropertyAssertionAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyDomainAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLObjectPropertyRangeAxiom;
import org.semanticweb.owlapi.model.OWLObjectSomeValuesFrom;
import org.semanticweb.owlapi.model.OWLObjectUnionOf;
import org.semanticweb.owlapi.model.OWLObjectVisitor;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLReflexiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLSameIndividualAxiom;
import org.semanticweb.owlapi.model.OWLSubAnnotationPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubDataPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubObjectPropertyOfAxiom;
import org.semanticweb.owlapi.model.OWLSubPropertyChainOfAxiom;
import org.semanticweb.owlapi.model.OWLSymmetricObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLTransitiveObjectPropertyAxiom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLClassAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLDataPropertyAtom;
import org.semanticweb.owlapi.model.SWRLDataRangeAtom;
import org.semanticweb.owlapi.model.SWRLDifferentIndividualsAtom;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLIndividualArgument;
import org.semanticweb.owlapi.model.SWRLLiteralArgument;
import org.semanticweb.owlapi.model.SWRLObjectPropertyAtom;
import org.semanticweb.owlapi.model.SWRLRule;
import org.semanticweb.owlapi.model.SWRLSameIndividualAtom;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.util.EscapeUtils;
import org.semanticweb.owlapi.util.ShortFormProvider;
import org.semanticweb.owlapi.vocab.OWL2Datatype;

@ParametersAreNonnullByDefault
public class PrefixMappingRenderer
implements OWLObjectVisitor,
OWLObjectRenderer {
    protected final PrefixMapping pm;
    protected StringBuilder sb;

    public PrefixMappingRenderer(PrefixMapping pm) {
        this.pm = pm;
        this.reset();
    }

    public void reset() {
        this.sb = new StringBuilder();
    }

    protected String shortForm(OWLEntity entity) {
        return this.shortForm(entity.getIRI());
    }

    protected String shortForm(IRI iri) {
        return this.shortForm(iri.getIRIString());
    }

    protected String shortForm(String uri) {
        String res = this.pm.shortForm(uri);
        return uri.equals(res) ? String.format("<%s>", uri) : res;
    }

    public void setShortFormProvider(ShortFormProvider provider) {
        throw new OntApiException.Unsupported();
    }

    public String render(OWLObject object) {
        this.reset();
        object.accept((OWLObjectVisitor)this);
        return this.sb.toString();
    }

    public String toString() {
        return this.sb.toString();
    }

    protected void render(Stream<? extends OWLObject> objects) {
        this.render(objects.iterator());
    }

    protected void render(Iterator<? extends OWLObject> objects) {
        while (objects.hasNext()) {
            objects.next().accept((OWLObjectVisitor)this);
            if (!objects.hasNext()) continue;
            this.space();
        }
    }

    protected void writeAnnotations(HasAnnotations axiom) {
        axiom.annotations().forEach(a -> {
            a.accept((OWLObjectVisitor)this);
            this.space();
        });
    }

    protected void space() {
        this.sb.append(' ');
    }

    protected void begin(String topic) {
        this.sb.append(topic);
        this.begin();
    }

    protected void begin() {
        this.sb.append('(');
    }

    protected void end() {
        this.sb.append(')');
    }

    public void visit(OWLOntology ontology) {
        this.begin("Ontology");
        this.sb.append(ontology.getOntologyID());
        this.space();
        this.sb.append("[Axioms: ").append(ontology.getAxiomCount()).append("]");
        this.space();
        this.sb.append("[Logical axioms: ").append(ontology.getLogicalAxiomCount()).append("]");
        this.end();
    }

    public void visit(IRI iri) {
        this.sb.append(this.shortForm(iri));
    }

    public void visit(OWLLiteral literal) {
        String txt = EscapeUtils.escapeString((String)literal.getLiteral());
        this.sb.append('\"').append(txt).append('\"');
        OWLDatatype dt = literal.getDatatype();
        if (dt.isRDFPlainLiteral() || OWL2Datatype.RDF_LANG_STRING.getIRI().equals((Object)dt.getIRI())) {
            if (literal.hasLang()) {
                this.sb.append('@').append(literal.getLang());
            }
        } else if (!dt.isString()) {
            this.sb.append("^^");
            dt.accept((OWLObjectVisitor)this);
        }
    }

    public void visit(OWLAnonymousIndividual individual) {
        this.sb.append(individual.getID());
    }

    public void visit(OWLClass clazz) {
        this.sb.append(this.shortForm((OWLEntity)clazz));
    }

    public void visit(OWLDatatype datatype) {
        this.sb.append(this.shortForm((OWLEntity)datatype));
    }

    public void visit(OWLDataProperty property) {
        this.sb.append(this.shortForm((OWLEntity)property));
    }

    public void visit(OWLObjectProperty property) {
        this.sb.append(this.shortForm((OWLEntity)property));
    }

    public void visit(OWLAnnotationProperty property) {
        this.sb.append(this.shortForm((OWLEntity)property));
    }

    public void visit(OWLNamedIndividual individual) {
        this.sb.append(this.shortForm((OWLEntity)individual));
    }

    public void visit(OWLSubClassOfAxiom axiom) {
        this.begin("SubClassOf");
        this.writeAnnotations((HasAnnotations)axiom);
        axiom.getSubClass().accept((OWLObjectVisitor)this);
        this.space();
        axiom.getSuperClass().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLNegativeObjectPropertyAssertionAxiom axiom) {
        this.begin("NegativeObjectPropertyAssertion");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLAsymmetricObjectPropertyAxiom axiom) {
        this.begin("AsymmetricObjectProperty");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLReflexiveObjectPropertyAxiom axiom) {
        this.begin("ReflexiveObjectProperty");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDisjointClassesAxiom axiom) {
        this.begin("DisjointClasses");
        this.writeAnnotations((HasAnnotations)axiom);
        this.render(axiom.classExpressions());
        this.end();
    }

    public void visit(OWLDataPropertyDomainAxiom axiom) {
        this.begin("DataPropertyDomain");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectPropertyDomainAxiom axiom) {
        this.begin("ObjectPropertyDomain");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((OWLClassExpression)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLEquivalentObjectPropertiesAxiom axiom) {
        this.begin("EquivalentObjectProperties");
        this.writeAnnotations((HasAnnotations)axiom);
        this.render(axiom.properties());
        this.end();
    }

    public void visit(OWLNegativeDataPropertyAssertionAxiom axiom) {
        this.begin("NegativeDataPropertyAssertion");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDifferentIndividualsAxiom axiom) {
        this.begin("DifferentIndividuals");
        this.writeAnnotations((HasAnnotations)axiom);
        this.render(axiom.individuals());
        this.end();
    }

    public void visit(OWLDisjointDataPropertiesAxiom axiom) {
        this.begin("DisjointDataProperties");
        this.writeAnnotations((HasAnnotations)axiom);
        this.render(axiom.properties());
        this.end();
    }

    public void visit(OWLDisjointObjectPropertiesAxiom axiom) {
        this.begin("DisjointObjectProperties");
        this.writeAnnotations((HasAnnotations)axiom);
        this.render(axiom.properties());
        this.end();
    }

    public void visit(OWLObjectPropertyRangeAxiom axiom) {
        this.begin("ObjectPropertyRange");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((OWLClassExpression)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectPropertyAssertionAxiom axiom) {
        this.begin("ObjectPropertyAssertion");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLIndividual)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLFunctionalObjectPropertyAxiom axiom) {
        this.begin("FunctionalObjectProperty");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLSubObjectPropertyOfAxiom axiom) {
        this.begin("SubObjectPropertyOf");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((OWLObjectPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDisjointUnionAxiom axiom) {
        this.begin("DisjointUnion");
        this.writeAnnotations((HasAnnotations)axiom);
        axiom.getOWLClass().accept((OWLObjectVisitor)this);
        this.space();
        this.render(axiom.classExpressions());
        this.end();
    }

    public void visit(OWLDeclarationAxiom axiom) {
        this.begin("Declaration");
        this.writeAnnotations((HasAnnotations)axiom);
        this.visit(axiom.getEntity());
        this.end();
    }

    public void visit(OWLEntity entity) {
        this.begin(entity.getEntityType().getName());
        entity.accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLAnnotationAssertionAxiom axiom) {
        this.begin("AnnotationAssertion");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLAnnotationProperty)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((OWLAnnotationSubject)axiom.getSubject()).accept((OWLObjectVisitor)this);
        this.space();
        axiom.getValue().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLSymmetricObjectPropertyAxiom axiom) {
        this.begin("SymmetricObjectProperty");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDataPropertyRangeAxiom axiom) {
        this.begin("DataPropertyRange");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((OWLDataRange)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLFunctionalDataPropertyAxiom axiom) {
        this.begin("FunctionalDataProperty");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLEquivalentDataPropertiesAxiom axiom) {
        this.begin("EquivalentDataProperties");
        this.writeAnnotations((HasAnnotations)axiom);
        this.render(axiom.properties());
        this.end();
    }

    public void visit(OWLClassAssertionAxiom axiom) {
        this.begin("ClassAssertion");
        this.writeAnnotations((HasAnnotations)axiom);
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        this.space();
        axiom.getIndividual().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLEquivalentClassesAxiom axiom) {
        this.begin("EquivalentClasses");
        this.writeAnnotations((HasAnnotations)axiom);
        this.render(axiom.classExpressions());
        this.end();
    }

    public void visit(OWLDataPropertyAssertionAxiom axiom) {
        this.begin("DataPropertyAssertion");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLDataPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        axiom.getSubject().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLLiteral)axiom.getObject()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLTransitiveObjectPropertyAxiom axiom) {
        this.begin("TransitiveObjectProperty");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLIrreflexiveObjectPropertyAxiom axiom) {
        this.begin("IrreflexiveObjectProperty");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLSubDataPropertyOfAxiom axiom) {
        this.begin("SubDataPropertyOf");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLDataPropertyExpression)axiom.getSubProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((OWLDataPropertyExpression)axiom.getSuperProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLInverseFunctionalObjectPropertyAxiom axiom) {
        this.begin("InverseFunctionalObjectProperty");
        this.writeAnnotations((HasAnnotations)axiom);
        ((OWLObjectPropertyExpression)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLSameIndividualAxiom axiom) {
        this.begin("SameIndividual");
        this.writeAnnotations((HasAnnotations)axiom);
        this.render(axiom.individuals());
        this.end();
    }

    public void visit(OWLSubPropertyChainOfAxiom axiom) {
        this.begin("SubObjectPropertyOf");
        this.writeAnnotations((HasAnnotations)axiom);
        this.begin("ObjectPropertyChain");
        this.render(axiom.getPropertyChain().iterator());
        this.end();
        this.space();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectIntersectionOf ce) {
        this.begin("ObjectIntersectionOf");
        this.render(ce.operands());
        this.end();
    }

    public void visit(OWLObjectUnionOf ce) {
        this.begin("ObjectUnionOf");
        this.render(ce.operands());
        this.end();
    }

    public void visit(OWLObjectComplementOf ce) {
        this.begin("ObjectComplementOf");
        ce.getOperand().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectSomeValuesFrom ce) {
        this.begin("ObjectSomeValuesFrom");
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectAllValuesFrom ce) {
        this.begin("ObjectAllValuesFrom");
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectHasValue ce) {
        this.begin("ObjectHasValue");
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLIndividual)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectMinCardinality ce) {
        this.begin("ObjectMinCardinality");
        this.sb.append(ce.getCardinality());
        this.space();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectExactCardinality ce) {
        this.begin("ObjectExactCardinality");
        this.sb.append(ce.getCardinality());
        this.space();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectMaxCardinality ce) {
        this.begin("ObjectMaxCardinality");
        this.sb.append(ce.getCardinality());
        this.space();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLClassExpression)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectHasSelf ce) {
        this.begin("ObjectHasSelf");
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectOneOf ce) {
        this.begin("ObjectOneOf");
        this.render(ce.individuals());
        this.end();
    }

    public void visit(OWLDataSomeValuesFrom ce) {
        this.begin("DataSomeValuesFrom");
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDataAllValuesFrom ce) {
        this.begin("DataAllValuesFrom");
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDataHasValue ce) {
        this.begin("DataHasValue");
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLLiteral)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDataMinCardinality ce) {
        this.begin("DataMinCardinality");
        this.sb.append(ce.getCardinality());
        this.space();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDataExactCardinality ce) {
        this.begin("DataExactCardinality");
        this.sb.append(ce.getCardinality());
        this.space();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDataMaxCardinality ce) {
        this.begin("DataMaxCardinality");
        this.sb.append(ce.getCardinality());
        this.space();
        ce.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        ((OWLDataRange)ce.getFiller()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDataComplementOf node) {
        this.begin("DataComplementOf");
        node.getDataRange().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLDataOneOf node) {
        this.begin("DataOneOf");
        this.render(node.values());
        this.end();
    }

    public void visit(OWLDatatypeRestriction node) {
        this.begin("DataRangeRestriction");
        node.getDatatype().accept((OWLObjectVisitor)this);
        node.facetRestrictions().forEach(r -> {
            this.space();
            r.accept((OWLObjectVisitor)this);
        });
        this.end();
    }

    public void visit(OWLFacetRestriction node) {
        this.begin("facetRestriction");
        this.sb.append(node.getFacet());
        this.space();
        node.getFacetValue().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLObjectInverseOf property) {
        this.begin("ObjectInverseOf");
        property.getInverse().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLInverseObjectPropertiesAxiom axiom) {
        this.begin("InverseObjectProperties");
        this.writeAnnotations((HasAnnotations)axiom);
        axiom.getFirstProperty().accept((OWLObjectVisitor)this);
        this.space();
        axiom.getSecondProperty().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLHasKeyAxiom axiom) {
        this.begin("HasKey");
        this.writeAnnotations((HasAnnotations)axiom);
        axiom.getClassExpression().accept((OWLObjectVisitor)this);
        this.space();
        this.begin();
        this.render(axiom.objectPropertyExpressions());
        this.end();
        this.space();
        this.begin();
        this.render(axiom.dataPropertyExpressions());
        this.end();
        this.end();
    }

    public void visit(OWLDataIntersectionOf node) {
        this.begin("DataIntersectionOf");
        this.render(node.operands());
        this.end();
    }

    public void visit(OWLDataUnionOf node) {
        this.begin("DataUnionOf");
        this.render(node.operands());
        this.end();
    }

    public void visit(OWLAnnotationPropertyDomainAxiom axiom) {
        this.begin("AnnotationPropertyDomain");
        ((OWLAnnotationProperty)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((IRI)axiom.getDomain()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLAnnotationPropertyRangeAxiom axiom) {
        this.begin("AnnotationPropertyRange");
        ((OWLAnnotationProperty)axiom.getProperty()).accept((OWLObjectVisitor)this);
        this.space();
        ((IRI)axiom.getRange()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLSubAnnotationPropertyOfAxiom axiom) {
        this.begin("SubAnnotationPropertyOf");
        this.writeAnnotations((HasAnnotations)axiom);
        axiom.getSubProperty().accept((OWLObjectVisitor)this);
        this.space();
        axiom.getSuperProperty().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(OWLAnnotation node) {
        this.begin("Annotation");
        this.writeAnnotations((HasAnnotations)node);
        node.getProperty().accept((OWLObjectVisitor)this);
        this.space();
        node.getValue().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLRule rule) {
        this.begin("DLSafeRule");
        this.writeAnnotations((HasAnnotations)rule);
        this.begin("Body");
        this.render(rule.body());
        this.end();
        this.space();
        this.begin("Head");
        this.render(rule.head());
        this.end();
        this.end();
    }

    public void visit(SWRLClassAtom node) {
        this.begin("ClassAtom");
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.space();
        ((SWRLIArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLDataRangeAtom node) {
        this.begin("DataRangeAtom");
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.space();
        ((SWRLDArgument)node.getArgument()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLDifferentIndividualsAtom node) {
        this.begin("DifferentFromAtom");
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.space();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLSameIndividualAtom node) {
        this.begin("SameAsAtom");
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.space();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLObjectPropertyAtom node) {
        this.begin("ObjectPropertyAtom");
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.space();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.space();
        ((SWRLIArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLDataPropertyAtom node) {
        this.begin("DataPropertyAtom");
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.space();
        ((SWRLIArgument)node.getFirstArgument()).accept((OWLObjectVisitor)this);
        this.space();
        ((SWRLDArgument)node.getSecondArgument()).accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLBuiltInAtom node) {
        this.begin("BuiltInAtom");
        node.getPredicate().accept((OWLObjectVisitor)this);
        this.space();
        this.render(node.getArguments().iterator());
        this.end();
    }

    public void visit(OWLDatatypeDefinitionAxiom axiom) {
        this.begin("DatatypeDefinition");
        this.writeAnnotations((HasAnnotations)axiom);
        axiom.getDatatype().accept((OWLObjectVisitor)this);
        this.space();
        axiom.getDataRange().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLVariable node) {
        this.begin("Variable");
        node.getIRI().accept((OWLObjectVisitor)this);
        this.end();
    }

    public void visit(SWRLIndividualArgument node) {
        node.getIndividual().accept((OWLObjectVisitor)this);
    }

    public void visit(SWRLLiteralArgument node) {
        node.getLiteral().accept((OWLObjectVisitor)this);
    }
}

