/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal;

import com.github.owlcs.ontapi.DataFactory;
import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomParserProvider;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.ONTObjectFactory;
import com.github.owlcs.ontapi.internal.ONTWrapperImpl;
import com.github.owlcs.ontapi.jena.model.OntAnnotation;
import com.github.owlcs.ontapi.jena.model.OntAnnotationProperty;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntDataRange;
import com.github.owlcs.ontapi.jena.model.OntFacetRestriction;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntSWRL;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.jena.utils.OntModels;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.rdf.model.Literal;
import org.apache.jena.rdf.model.Resource;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.AxiomType;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAnnotationProperty;
import org.semanticweb.owlapi.model.OWLAnnotationValue;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataOneOf;
import org.semanticweb.owlapi.model.OWLDataProperty;
import org.semanticweb.owlapi.model.OWLDataPropertyAxiom;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLDataRange;
import org.semanticweb.owlapi.model.OWLDataUnionOf;
import org.semanticweb.owlapi.model.OWLDatatype;
import org.semanticweb.owlapi.model.OWLDatatypeRestriction;
import org.semanticweb.owlapi.model.OWLFacetRestriction;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLLiteral;
import org.semanticweb.owlapi.model.OWLObjectOneOf;
import org.semanticweb.owlapi.model.OWLObjectPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.SWRLAtom;
import org.semanticweb.owlapi.model.SWRLBuiltInAtom;
import org.semanticweb.owlapi.model.SWRLDArgument;
import org.semanticweb.owlapi.model.SWRLIArgument;
import org.semanticweb.owlapi.model.SWRLVariable;
import org.semanticweb.owlapi.vocab.OWLFacet;

public class ReadHelper {
    public static boolean testAnnotationAxiomOverlaps(OntStatement statement, AxiomsSettings conf, AxiomType<? extends OWLObjectPropertyAxiom> o, AxiomType<? extends OWLDataPropertyAxiom> d) {
        return !conf.isIgnoreAnnotationAxiomOverlaps() || Iter.noneMatch(Iter.of(new AxiomType[]{o, d}).mapWith(AxiomParserProvider::get), a -> a.testStatement(statement, conf));
    }

    public static boolean isDeclarationStatement(OntStatement s) {
        return s.isDeclaration() && ReadHelper.isEntityOrAnonymousIndividual(s.getSubject());
    }

    public static boolean isEntityOrAnonymousIndividual(Resource o) {
        return o.isURIResource() || o.canAs(OntIndividual.Anonymous.class);
    }

    public static boolean isAnnotationAssertionStatement(OntStatement s, AxiomsSettings config) {
        return s.isAnnotationAssertion() && !s.belongsToAnnotation() && (config.isAllowBulkAnnotationAssertions() || !s.hasAnnotations());
    }

    public static ExtendedIterator<ONTObject<OWLAnnotation>> listAnnotations(OntStatement statement, AxiomsSettings conf, ONTObjectFactory factory) {
        ExtendedIterator res = OntModels.listAnnotations(statement);
        if (conf.isLoadAnnotationAxioms() && ReadHelper.isDeclarationStatement(statement)) {
            res = res.filterDrop(s -> ReadHelper.isAnnotationAssertionStatement(s, conf));
        }
        return res.mapWith(factory::getAnnotation);
    }

    public static ExtendedIterator<ONTObject<OWLAnnotation>> listOWLAnnotations(OntObject obj, ONTObjectFactory of) {
        return OntModels.listAnnotations(obj).mapWith(of::getAnnotation);
    }

    public static ONTObject<OWLAnnotation> getAnnotation(OntStatement ann, ONTObjectFactory of) {
        return ann.getSubject().getAs(OntAnnotation.class) != null || ann.hasAnnotations() ? ReadHelper.getHierarchicalAnnotations(ann, of) : ReadHelper.getPlainAnnotation(ann, of);
    }

    private static ONTObject<OWLAnnotation> getPlainAnnotation(OntStatement ann, ONTObjectFactory of) {
        ONTObject<OWLAnnotationProperty> p = of.getProperty((OntAnnotationProperty)ann.getPredicate().as(OntAnnotationProperty.class));
        ONTObject<? extends OWLAnnotationValue> v = of.getValue(ann.getObject());
        OWLAnnotation res = of.getOWLDataFactory().getOWLAnnotation(p.getOWLObject(), v.getOWLObject(), Stream.empty());
        return ONTWrapperImpl.create(res, ann).append(p).append(v);
    }

    private static ONTObject<OWLAnnotation> getHierarchicalAnnotations(OntStatement root, ONTObjectFactory of) {
        OntObject subject = root.getSubject();
        ONTObject<OWLAnnotationProperty> p = of.getProperty((OntAnnotationProperty)root.getPredicate().as(OntAnnotationProperty.class));
        ONTObject<? extends OWLAnnotationValue> v = of.getValue(root.getObject());
        Set children = OntModels.listAnnotations(root).mapWith(a -> ReadHelper.getHierarchicalAnnotations(a, of)).toSet();
        OWLAnnotation object = of.getOWLDataFactory().getOWLAnnotation(p.getOWLObject(), v.getOWLObject(), children.stream().map(ONTObject::getOWLObject));
        ONTWrapperImpl<OWLAnnotation> res = ONTWrapperImpl.create(object, root);
        OntAnnotation a2 = subject.getAs(OntAnnotation.class);
        if (a2 != null) {
            res = res.append(a2);
        }
        return res.append(p).append(v).append(children);
    }

    public static ONTObject<OWLFacetRestriction> getFacetRestriction(OntFacetRestriction fr, ONTObjectFactory of) {
        OWLFacetRestriction res = ReadHelper.calcOWLFacetRestriction(fr, of);
        return ONTWrapperImpl.create(res, fr);
    }

    public static OWLFacetRestriction calcOWLFacetRestriction(OntFacetRestriction fr, ONTObjectFactory of) {
        OWLLiteral literal = of.getLiteral(OntApiException.notNull(fr, "Null facet restriction.").getValue()).getOWLObject();
        Class<OntFacetRestriction> type = OntModels.getOntType(fr);
        return of.getOWLDataFactory().getOWLFacetRestriction(ReadHelper.getFacet(type), literal);
    }

    public static OWLFacet getFacet(Class<? extends OntFacetRestriction> type) {
        if (OntFacetRestriction.Length.class == type) {
            return OWLFacet.LENGTH;
        }
        if (OntFacetRestriction.MinLength.class == type) {
            return OWLFacet.MIN_LENGTH;
        }
        if (OntFacetRestriction.MaxLength.class == type) {
            return OWLFacet.MAX_LENGTH;
        }
        if (OntFacetRestriction.MinInclusive.class == type) {
            return OWLFacet.MIN_INCLUSIVE;
        }
        if (OntFacetRestriction.MaxInclusive.class == type) {
            return OWLFacet.MAX_INCLUSIVE;
        }
        if (OntFacetRestriction.MinExclusive.class == type) {
            return OWLFacet.MIN_EXCLUSIVE;
        }
        if (OntFacetRestriction.MaxExclusive.class == type) {
            return OWLFacet.MAX_EXCLUSIVE;
        }
        if (OntFacetRestriction.Pattern.class == type) {
            return OWLFacet.PATTERN;
        }
        if (OntFacetRestriction.FractionDigits.class == type) {
            return OWLFacet.FRACTION_DIGITS;
        }
        if (OntFacetRestriction.TotalDigits.class == type) {
            return OWLFacet.TOTAL_DIGITS;
        }
        if (OntFacetRestriction.LangRange.class == type) {
            return OWLFacet.LANG_RANGE;
        }
        throw new OntApiException.IllegalArgument("Unsupported facet restriction " + type);
    }

    public static ONTObject<? extends OWLDataRange> calcDataRange(OntDataRange dr, ONTObjectFactory of, Set<Resource> seen) {
        if (OntApiException.notNull(dr, "Null data range").isURIResource()) {
            return of.getDatatype((OntDataRange.Named)dr.as(OntDataRange.Named.class));
        }
        if (seen.contains(dr)) {
            throw new OntApiException("Recursive loop on data range " + dr);
        }
        seen.add(dr);
        DataFactory df = of.getOWLDataFactory();
        if (dr instanceof OntDataRange.Restriction) {
            OntDataRange.Restriction _dr = (OntDataRange.Restriction)dr;
            ONTObject<OWLDatatype> d2 = of.getDatatype((OntDataRange.Named)_dr.getValue());
            Set restrictions = OntModels.listMembers(_dr.getList()).mapWith(of::getFacetRestriction).toSet();
            OWLDatatypeRestriction res = df.getOWLDatatypeRestriction(d2.getOWLObject(), restrictions.stream().map(ONTObject::getOWLObject).collect(Collectors.toList()));
            return ONTWrapperImpl.create(res, dr).append(restrictions);
        }
        if (dr instanceof OntDataRange.ComplementOf) {
            OntDataRange.ComplementOf _dr = (OntDataRange.ComplementOf)dr;
            ONTObject<? extends OWLDataRange> d3 = ReadHelper.calcDataRange((OntDataRange)_dr.getValue(), of, seen);
            return ONTWrapperImpl.create(df.getOWLDataComplementOf(d3.getOWLObject()), _dr).append(d3);
        }
        if (dr instanceof OntDataRange.UnionOf || dr instanceof OntDataRange.IntersectionOf) {
            OntDataRange.ComponentsDR _dr = (OntDataRange.ComponentsDR)dr;
            Set dataRanges = OntModels.listMembers(_dr.getList()).mapWith(d -> ReadHelper.calcDataRange(d, of, seen)).toSet();
            OWLDataUnionOf res = dr instanceof OntDataRange.UnionOf ? df.getOWLDataUnionOf(dataRanges.stream().map(ONTObject::getOWLObject)) : df.getOWLDataIntersectionOf(dataRanges.stream().map(ONTObject::getOWLObject));
            return ONTWrapperImpl.create(res, dr).append(dataRanges);
        }
        if (dr instanceof OntDataRange.OneOf) {
            OntDataRange.OneOf _dr = (OntDataRange.OneOf)dr;
            Set literals = _dr.getList().members().map(of::getLiteral).collect(Collectors.toSet());
            OWLDataOneOf res = df.getOWLDataOneOf(literals.stream().map(ONTObject::getOWLObject));
            return ONTWrapperImpl.create(res, _dr);
        }
        throw new OntApiException("Unsupported data range expression " + dr);
    }

    public static ONTObject<? extends OWLClassExpression> calcClassExpression(OntClass ce, ONTObjectFactory of, Set<Resource> seen) {
        if (OntApiException.notNull(ce, "Null class expression").isURIResource()) {
            return of.getClass((OntClass.Named)ce.as(OntClass.Named.class));
        }
        if (!seen.add(ce)) {
            throw new OntApiException("Recursive loop on class expression " + ce);
        }
        DataFactory df = of.getOWLDataFactory();
        Class<OntClass> type = OntModels.getOntType(ce);
        if (OntClass.ObjectSomeValuesFrom.class.equals(type) || OntClass.ObjectAllValuesFrom.class.equals(type)) {
            OntClass.ComponentRestrictionCE _ce = (OntClass.ComponentRestrictionCE)ce;
            ONTObject<? extends OWLObjectPropertyExpression> p = of.getProperty((OntObjectProperty)_ce.getProperty());
            ONTObject<? extends OWLClassExpression> c2 = ReadHelper.calcClassExpression((OntClass)_ce.getValue(), of, seen);
            Object owl = OntClass.ObjectSomeValuesFrom.class.equals(type) ? df.getOWLObjectSomeValuesFrom(p.getOWLObject(), c2.getOWLObject()) : df.getOWLObjectAllValuesFrom(p.getOWLObject(), c2.getOWLObject());
            return ONTWrapperImpl.create(owl, _ce).append(p).append(c2);
        }
        if (OntClass.DataSomeValuesFrom.class.equals(type) || OntClass.DataAllValuesFrom.class.equals(type)) {
            OntClass.ComponentRestrictionCE _ce = (OntClass.ComponentRestrictionCE)ce;
            ONTObject<OWLDataProperty> p = of.getProperty((OntDataProperty)_ce.getProperty());
            ONTObject<? extends OWLDataRange> d = of.getDatatype((OntDataRange)_ce.getValue());
            Object owl = OntClass.DataSomeValuesFrom.class.equals(type) ? df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p.getOWLObject(), d.getOWLObject()) : df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)p.getOWLObject(), d.getOWLObject());
            return ONTWrapperImpl.create(owl, _ce).append(p).append(d);
        }
        if (OntClass.ObjectHasValue.class.equals(type)) {
            OntClass.ObjectHasValue _ce = (OntClass.ObjectHasValue)ce;
            ONTObject<? extends OWLObjectPropertyExpression> p = of.getProperty((OntObjectProperty)_ce.getProperty());
            ONTObject<? extends OWLIndividual> i2 = of.getIndividual((OntIndividual)_ce.getValue());
            return ONTWrapperImpl.create(df.getOWLObjectHasValue(p.getOWLObject(), i2.getOWLObject()), _ce).append(p).append(i2);
        }
        if (OntClass.DataHasValue.class.equals(type)) {
            OntClass.DataHasValue _ce = (OntClass.DataHasValue)ce;
            ONTObject<OWLDataProperty> p = of.getProperty((OntDataProperty)_ce.getProperty());
            ONTObject<OWLLiteral> l = of.getLiteral((Literal)_ce.getValue());
            return ONTWrapperImpl.create(df.getOWLDataHasValue((OWLDataPropertyExpression)p.getOWLObject(), l.getOWLObject()), _ce).append(p);
        }
        if (OntClass.ObjectMinCardinality.class.equals(type) || OntClass.ObjectMaxCardinality.class.equals(type) || OntClass.ObjectCardinality.class.equals(type)) {
            OntClass.CardinalityRestrictionCE _ce = (OntClass.CardinalityRestrictionCE)ce;
            ONTObject<? extends OWLObjectPropertyExpression> p = of.getProperty((OntObjectProperty)_ce.getProperty());
            ONTObject<? extends OWLClassExpression> c3 = ReadHelper.calcClassExpression(_ce.getValue() == null ? _ce.getModel().getOWLThing() : (OntClass)_ce.getValue(), of, seen);
            Object owl = OntClass.ObjectMinCardinality.class.equals(type) ? df.getOWLObjectMinCardinality(_ce.getCardinality(), p.getOWLObject(), c3.getOWLObject()) : (OntClass.ObjectMaxCardinality.class.equals(type) ? df.getOWLObjectMaxCardinality(_ce.getCardinality(), p.getOWLObject(), c3.getOWLObject()) : df.getOWLObjectExactCardinality(_ce.getCardinality(), p.getOWLObject(), c3.getOWLObject()));
            return ONTWrapperImpl.create(owl, _ce).append(p).append(c3);
        }
        if (OntClass.DataMinCardinality.class.equals(type) || OntClass.DataMaxCardinality.class.equals(type) || OntClass.DataCardinality.class.equals(type)) {
            OntClass.CardinalityRestrictionCE _ce = (OntClass.CardinalityRestrictionCE)ce;
            ONTObject<OWLDataProperty> p = of.getProperty((OntDataProperty)_ce.getProperty());
            ONTObject<? extends OWLDataRange> d = of.getDatatype(_ce.getValue() == null ? (OntDataRange)_ce.getModel().getOntEntity(OntDataRange.Named.class, RDFS.Literal) : (OntDataRange)_ce.getValue());
            Object owl = OntClass.DataMinCardinality.class.equals(type) ? df.getOWLDataMinCardinality(_ce.getCardinality(), (OWLDataPropertyExpression)p.getOWLObject(), d.getOWLObject()) : (OntClass.DataMaxCardinality.class.equals(type) ? df.getOWLDataMaxCardinality(_ce.getCardinality(), (OWLDataPropertyExpression)p.getOWLObject(), d.getOWLObject()) : df.getOWLDataExactCardinality(_ce.getCardinality(), (OWLDataPropertyExpression)p.getOWLObject(), d.getOWLObject()));
            return ONTWrapperImpl.create(owl, _ce).append(p).append(d);
        }
        if (OntClass.HasSelf.class.equals(type)) {
            OntClass.HasSelf _ce = (OntClass.HasSelf)ce;
            ONTObject<? extends OWLObjectPropertyExpression> p = of.getProperty((OntObjectProperty)_ce.getProperty());
            return ONTWrapperImpl.create(df.getOWLObjectHasSelf(p.getOWLObject()), _ce).append(p);
        }
        if (OntClass.UnionOf.class.equals(type) || OntClass.IntersectionOf.class.equals(type)) {
            OntClass.ComponentsCE _ce = (OntClass.ComponentsCE)ce;
            Set components = OntModels.listMembers(_ce.getList()).mapWith(c -> ReadHelper.calcClassExpression(c, of, seen)).toSet();
            Object owl = OntClass.UnionOf.class.equals(type) ? df.getOWLObjectUnionOf(components.stream().map(ONTObject::getOWLObject)) : df.getOWLObjectIntersectionOf(components.stream().map(ONTObject::getOWLObject));
            return ONTWrapperImpl.create(owl, _ce).append(components);
        }
        if (OntClass.OneOf.class.equals(type)) {
            OntClass.OneOf _ce = (OntClass.OneOf)ce;
            Set components = OntModels.listMembers(_ce.getList()).mapWith(i -> of.getIndividual((OntIndividual)i)).toSet();
            OWLObjectOneOf owl = df.getOWLObjectOneOf(components.stream().map(ONTObject::getOWLObject));
            return ONTWrapperImpl.create(owl, _ce).append(components);
        }
        if (ce instanceof OntClass.ComplementOf) {
            OntClass.ComplementOf _ce = (OntClass.ComplementOf)ce;
            ONTObject<? extends OWLClassExpression> c4 = ReadHelper.calcClassExpression((OntClass)_ce.getValue(), of, seen);
            return ONTWrapperImpl.create(df.getOWLObjectComplementOf(c4.getOWLObject()), _ce).append(c4);
        }
        if (ce instanceof OntClass.NaryRestrictionCE) {
            OntClass.NaryRestrictionCE _ce = (OntClass.NaryRestrictionCE)ce;
            ONTObject<OWLDataProperty> p = of.getProperty((OntDataProperty)_ce.getProperty());
            ONTObject<? extends OWLDataRange> d = of.getDatatype((OntDataRange)_ce.getValue());
            Object owl = OntClass.NaryDataSomeValuesFrom.class.equals(type) ? df.getOWLDataSomeValuesFrom((OWLDataPropertyExpression)p.getOWLObject(), d.getOWLObject()) : df.getOWLDataAllValuesFrom((OWLDataPropertyExpression)p.getOWLObject(), d.getOWLObject());
            return ONTWrapperImpl.create(owl, _ce).append(p).append(d);
        }
        throw new OntApiException("Unsupported class expression " + ce);
    }

    public static ONTObject<SWRLVariable> getSWRLVariable(OntSWRL.Variable var, ONTObjectFactory of) {
        if (!OntApiException.notNull(var, "Null swrl var").isURIResource()) {
            throw new OntApiException("Anonymous swrl var " + var);
        }
        return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLVariable(of.toIRI(var.getURI())), var);
    }

    public static ONTObject<? extends SWRLDArgument> getSWRLLiteralArg(OntSWRL.DArg arg, ONTObjectFactory of) {
        if (OntApiException.notNull(arg, "Null SWRL-D arg").isLiteral()) {
            return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLLiteralArgument(of.getLiteral(arg.asLiteral()).getOWLObject()), arg);
        }
        if (arg.canAs(OntSWRL.Variable.class)) {
            return of.getSWRLVariable((OntSWRL.Variable)arg.as(OntSWRL.Variable.class));
        }
        throw new OntApiException("Unsupported SWRL-D arg " + arg);
    }

    public static ONTObject<? extends SWRLIArgument> getSWRLIndividualArg(OntSWRL.IArg arg, ONTObjectFactory of) {
        if (OntApiException.notNull(arg, "Null SWRL-I arg").canAs(OntIndividual.class)) {
            return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLIndividualArgument(of.getIndividual((OntIndividual)arg.as(OntIndividual.class)).getOWLObject()), arg);
        }
        if (arg.canAs(OntSWRL.Variable.class)) {
            return of.getSWRLVariable((OntSWRL.Variable)arg.as(OntSWRL.Variable.class));
        }
        throw new OntApiException("Unsupported SWRL-I arg " + arg);
    }

    public static ONTObject<? extends SWRLAtom> calcSWRLAtom(OntSWRL.Atom<?> atom, ONTObjectFactory of) {
        if (atom instanceof OntSWRL.Atom.WithBuiltin) {
            OntSWRL.Atom.WithBuiltin _atom = (OntSWRL.Atom.WithBuiltin)atom;
            IRI iri = of.toIRI(((OntSWRL.Builtin)_atom.getPredicate()).getURI());
            List arguments = _atom.arguments().map(of::getSWRLArgument).collect(Collectors.toList());
            SWRLBuiltInAtom res = of.getOWLDataFactory().getSWRLBuiltInAtom(iri, arguments.stream().map(ONTObject::getOWLObject).collect(Collectors.toList()));
            return ONTWrapperImpl.create(res, _atom).append(arguments);
        }
        if (atom instanceof OntSWRL.Atom.WithClass) {
            OntSWRL.Atom.WithClass _atom = (OntSWRL.Atom.WithClass)atom;
            ONTObject<? extends OWLClassExpression> c = of.getClass((OntClass)_atom.getPredicate());
            ONTObject<? extends SWRLIArgument> a = of.getSWRLArgument((OntSWRL.IArg)_atom.getArg());
            return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLClassAtom(c.getOWLObject(), a.getOWLObject()), _atom).append(c).append(a);
        }
        if (atom instanceof OntSWRL.Atom.WithDataProperty) {
            OntSWRL.Atom.WithDataProperty _atom = (OntSWRL.Atom.WithDataProperty)atom;
            ONTObject<OWLDataProperty> p = of.getProperty((OntDataProperty)_atom.getPredicate());
            ONTObject<? extends SWRLIArgument> f = of.getSWRLArgument((OntSWRL.IArg)_atom.getFirstArg());
            ONTObject<? extends SWRLDArgument> s = of.getSWRLArgument((OntSWRL.DArg)_atom.getSecondArg());
            return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLDataPropertyAtom((OWLDataPropertyExpression)p.getOWLObject(), f.getOWLObject(), s.getOWLObject()), _atom).append(p).append(f).append(s);
        }
        if (atom instanceof OntSWRL.Atom.WithObjectProperty) {
            OntSWRL.Atom.WithObjectProperty _atom = (OntSWRL.Atom.WithObjectProperty)atom;
            ONTObject<? extends OWLObjectPropertyExpression> p = of.getProperty((OntObjectProperty)_atom.getPredicate());
            ONTObject<? extends SWRLIArgument> f = of.getSWRLArgument((OntSWRL.IArg)_atom.getFirstArg());
            ONTObject<? extends SWRLIArgument> s = of.getSWRLArgument((OntSWRL.IArg)_atom.getSecondArg());
            return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLObjectPropertyAtom(p.getOWLObject(), f.getOWLObject(), s.getOWLObject()), _atom).append(p).append(f).append(s);
        }
        if (atom instanceof OntSWRL.Atom.WithDataRange) {
            OntSWRL.Atom.WithDataRange _atom = (OntSWRL.Atom.WithDataRange)atom;
            ONTObject<? extends OWLDataRange> d = of.getDatatype((OntDataRange)_atom.getPredicate());
            ONTObject<? extends SWRLDArgument> a = of.getSWRLArgument((OntSWRL.DArg)_atom.getArg());
            return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLDataRangeAtom(d.getOWLObject(), a.getOWLObject()), _atom).append(d).append(a);
        }
        if (atom instanceof OntSWRL.Atom.WithDifferentIndividuals) {
            OntSWRL.Atom.WithDifferentIndividuals _atom = (OntSWRL.Atom.WithDifferentIndividuals)atom;
            ONTObject<? extends SWRLIArgument> f = of.getSWRLArgument((OntSWRL.IArg)_atom.getFirstArg());
            ONTObject<? extends SWRLIArgument> s = of.getSWRLArgument((OntSWRL.IArg)_atom.getSecondArg());
            return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLDifferentIndividualsAtom(f.getOWLObject(), s.getOWLObject()), _atom).append(f).append(s);
        }
        if (atom instanceof OntSWRL.Atom.WithSameIndividuals) {
            OntSWRL.Atom.WithSameIndividuals _atom = (OntSWRL.Atom.WithSameIndividuals)atom;
            ONTObject<? extends SWRLIArgument> f = of.getSWRLArgument((OntSWRL.IArg)_atom.getFirstArg());
            ONTObject<? extends SWRLIArgument> s = of.getSWRLArgument((OntSWRL.IArg)_atom.getSecondArg());
            return ONTWrapperImpl.create(of.getOWLDataFactory().getSWRLSameIndividualAtom(f.getOWLObject(), s.getOWLObject()), _atom).append(f).append(s);
        }
        throw new OntApiException("Unsupported SWRL atom " + atom);
    }
}

