/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.OntApiException;
import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.AxiomTranslator;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithManyObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.internal.objects.ONTEntityImpl;
import com.github.owlcs.ontapi.internal.objects.ONTStatementImpl;
import com.github.owlcs.ontapi.internal.objects.WithContent;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntDataProperty;
import com.github.owlcs.ontapi.jena.model.OntIndividual;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntObject;
import com.github.owlcs.ontapi.jena.model.OntObjectProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import com.github.owlcs.ontapi.jena.utils.Graphs;
import com.github.owlcs.ontapi.jena.utils.Iter;
import com.github.owlcs.ontapi.owlapi.objects.OWLAnonymousIndividualImpl;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.jena.graph.BlankNodeId;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.rdf.model.Property;
import org.apache.jena.rdf.model.Statement;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.semanticweb.owlapi.model.HasOperands;
import org.semanticweb.owlapi.model.IsAnonymous;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLDataPropertyExpression;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLIndividual;
import org.semanticweb.owlapi.model.OWLNamedIndividual;
import org.semanticweb.owlapi.model.OWLNaryAxiom;
import org.semanticweb.owlapi.model.OWLNaryClassAxiom;
import org.semanticweb.owlapi.model.OWLNaryIndividualAxiom;
import org.semanticweb.owlapi.model.OWLNaryPropertyAxiom;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLObjectPropertyExpression;
import org.semanticweb.owlapi.model.OWLPairwiseVisitor;
import org.semanticweb.owlapi.model.OWLPropertyExpression;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiom;
import org.semanticweb.owlapi.model.OWLSubClassOfAxiomSetShortCut;
import org.semanticweb.owlapi.util.OWLAPIStreamUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractNaryTranslator<Axiom extends OWLAxiom & OWLNaryAxiom<OWL>, OWL extends OWLObject & IsAnonymous, ONT extends OntObject>
extends AxiomTranslator<Axiom> {
    static final Logger LOGGER = LoggerFactory.getLogger(AbstractNaryTranslator.class);
    private static final Comparator<OWLObject> URI_FIRST_COMPARATOR = Comparator.comparing(IsAnonymous::isAnonymous);

    void write(OWLNaryAxiom<OWL> thisAxiom, Collection<OWLAnnotation> annotations, OntModel model) {
        List operands = thisAxiom.operands().sorted(URI_FIRST_COMPARATOR).collect(Collectors.toList());
        if (operands.isEmpty() && annotations.isEmpty()) {
            return;
        }
        if (operands.size() != 2) {
            throw new OntApiException(this.getClass().getSimpleName() + ": expected two operands. Axiom: " + thisAxiom);
        }
        WriteHelper.writeTriple(model, (OWLObject)operands.get(0), this.getPredicate(), (OWLObject)operands.get(1), annotations);
    }

    @Override
    public void write(Axiom axiom, OntModel model) {
        Collection axioms = ((OWLNaryAxiom)axiom).asPairwiseAxioms();
        if (axioms.isEmpty()) {
            LOGGER.warn("Nothing to write, wrong axiom is given: {}", axiom);
            return;
        }
        axioms.forEach(a -> this.write((OWLNaryAxiom<OWL>)a, axiom.annotationsAsList(), model));
    }

    abstract Property getPredicate();

    abstract Class<ONT> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return this.listByPredicate(model, this.getPredicate()).filterKeep(this::filter);
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return this.getPredicate().equals(statement.getPredicate()) && this.filter(statement);
    }

    protected boolean filter(Statement statement) {
        return statement.getSubject().canAs(this.getView()) && statement.getObject().canAs(this.getView());
    }

    @Override
    protected final Collection<Triple> getSearchTriples(Axiom axiom) {
        Triple res = this.getSearchTriple(axiom);
        return res == null ? Collections.emptyList() : Arrays.asList(res, Graphs.invertTriple(res));
    }

    private Triple getSearchTriple(Axiom axiom) {
        Triple res = this.getONTSearchTriple(axiom);
        if (res != null) {
            return res;
        }
        List list = ((HasOperands)axiom).getOperandsAsList();
        if (list.size() != 2) {
            return null;
        }
        return this.createSearchTriple((OWLObject)list.get(0), (OWLObject)list.get(1));
    }

    Triple getONTSearchTriple(Axiom axiom) {
        return axiom instanceof WithManyObjects.Simple ? ((WithManyObjects.Simple)axiom).asTriple() : null;
    }

    Triple createSearchTriple(OWLObject subject, OWLObject object) {
        Node left = TranslateHelper.getSearchNode(subject);
        if (left == null) {
            return null;
        }
        Node right = TranslateHelper.getSearchNode(object);
        if (right == null) {
            return null;
        }
        return Triple.create((Node)left, (Node)this.getPredicate().asNode(), (Node)right);
    }

    static abstract class PropertyNaryAxiomImpl<A extends OWLNaryPropertyAxiom<P>, P extends OWLPropertyExpression>
    extends NaryAxiomImpl<A, P>
    implements OWLNaryPropertyAxiom<P> {
        PropertyNaryAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public Stream<P> properties() {
            return this.sorted().map(ONTObject::getOWLObject);
        }

        public Set<P> getPropertiesMinus(P property) {
            return this.getSetMinus((OWLObject[])new OWLPropertyExpression[]{property});
        }

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public final boolean canContainNamedIndividuals() {
            return false;
        }

        @Override
        public final boolean canContainDatatypes() {
            return this.isAnnotated();
        }

        @Override
        public final boolean canContainAnonymousIndividuals() {
            return this.isAnnotated();
        }
    }

    static abstract class ClassOrIndividualNaryAxiomImpl<A extends OWLNaryAxiom<M>, M extends OWLObject>
    extends NaryAxiomImpl<A, M>
    implements OWLSubClassOfAxiomSetShortCut {
        ClassOrIndividualNaryAxiomImpl(Object s, String p, Object o, Supplier<OntModel> m) {
            super(s, p, o, m);
        }

        protected abstract OWLSubClassOfAxiom createSubClassOf(M var1, M var2);

        public Collection<OWLSubClassOfAxiom> asOWLSubClassOfAxioms() {
            return this.walkAllPairwise((a, b) -> this.createSubClassOf(ClassOrIndividualNaryAxiomImpl.eraseModel(a), ClassOrIndividualNaryAxiomImpl.eraseModel(b)));
        }
    }

    protected static abstract class DataPropertyNaryAxiomImpl<A extends OWLNaryPropertyAxiom<OWLDataPropertyExpression>>
    extends PropertyNaryAxiomImpl<A, OWLDataPropertyExpression> {
        protected DataPropertyNaryAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLDataPropertyExpression>> listONTComponents(OntStatement statement, ModelObjectFactory factory) {
            return Iter.of(new ONTObject[]{factory.getProperty(statement.getSubject(OntDataProperty.class)), factory.getProperty(statement.getObject(OntDataProperty.class))});
        }

        @Override
        public ONTObject<? extends OWLDataPropertyExpression> findByURI(String uri, ModelObjectFactory factory) {
            return factory.getDataProperty(uri);
        }

        @Override
        public final boolean canContainObjectProperties() {
            return false;
        }
    }

    protected static abstract class ObjectPropertyNaryAxiomImpl<A extends OWLNaryPropertyAxiom<OWLObjectPropertyExpression>>
    extends PropertyNaryAxiomImpl<A, OWLObjectPropertyExpression> {
        protected ObjectPropertyNaryAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLObjectPropertyExpression>> listONTComponents(OntStatement statement, ModelObjectFactory factory) {
            return Iter.of(new ONTObject[]{factory.getProperty(statement.getSubject(OntObjectProperty.class)), factory.getProperty(statement.getObject(OntObjectProperty.class))});
        }

        @Override
        public ONTObject<? extends OWLObjectPropertyExpression> findByURI(String uri, ModelObjectFactory factory) {
            return factory.getObjectProperty(uri);
        }

        @Override
        public final boolean canContainDataProperties() {
            return false;
        }
    }

    protected static abstract class IndividualNaryAxiomImpl<A extends OWLNaryIndividualAxiom>
    extends ClassOrIndividualNaryAxiomImpl<A, OWLIndividual>
    implements OWLNaryIndividualAxiom {
        protected IndividualNaryAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLIndividual>> listONTComponents(OntStatement statement, ModelObjectFactory factory) {
            return Iter.of(new ONTObject[]{factory.getIndividual(statement.getSubject(OntIndividual.class)), factory.getIndividual(statement.getObject(OntIndividual.class))});
        }

        @Override
        public ONTObject<? extends OWLIndividual> findByURI(String uri, ModelObjectFactory factory) {
            return factory.getNamedIndividual(uri);
        }

        public Stream<OWLIndividual> individuals() {
            return this.sorted().map(ONTObject::getOWLObject);
        }

        @Override
        public final boolean canContainNamedClasses() {
            return false;
        }

        @Override
        public final boolean canContainClassExpressions() {
            return false;
        }

        @Override
        public final boolean canContainDataProperties() {
            return false;
        }

        @Override
        public final boolean canContainObjectProperties() {
            return false;
        }

        @Override
        public final boolean canContainDatatypes() {
            return this.isAnnotated();
        }

        public ONTObject fromContentItem(Object x, ModelObjectFactory factory) {
            if (x instanceof String) {
                return this.findByURI((String)x, factory);
            }
            if (x instanceof BlankNodeId) {
                return factory.getAnonymousIndividual((BlankNodeId)x);
            }
            return (ONTObject)x;
        }

        public Object toContentItem(ONTObject x) {
            if (x instanceof OWLNamedIndividual) {
                return ONTEntityImpl.getURI((OWLEntity)x);
            }
            return ((OWLAnonymousIndividualImpl)((Object)x)).getBlankNodeId();
        }
    }

    protected static abstract class ClassNaryAxiomImpl<A extends OWLNaryClassAxiom>
    extends ClassOrIndividualNaryAxiomImpl<A, OWLClassExpression>
    implements OWLNaryClassAxiom {
        protected ClassNaryAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        public ExtendedIterator<ONTObject<? extends OWLClassExpression>> listONTComponents(OntStatement statement, ModelObjectFactory factory) {
            return Iter.of(new ONTObject[]{factory.getClass(statement.getSubject(OntClass.class)), factory.getClass(statement.getObject(OntClass.class))});
        }

        @Override
        public ONTObject<? extends OWLClassExpression> findByURI(String uri, ModelObjectFactory factory) {
            return factory.getClass(uri);
        }

        public Stream<OWLClassExpression> classExpressions() {
            return this.sorted().map(ONTObject::getOWLObject);
        }

        public Set<OWLClassExpression> getClassExpressionsMinus(OWLClassExpression ... excludes) {
            return this.getSetMinus((OWLObject[])excludes);
        }

        public boolean contains(OWLClassExpression ce) {
            return this.members().map(ONTObject::getOWLObject).anyMatch(ce::equals);
        }
    }

    protected static abstract class NaryAxiomImpl<A extends OWLNaryAxiom<M>, M extends OWLObject>
    extends ONTAxiomImpl<A>
    implements WithManyObjects<M>,
    OWLNaryAxiom<M> {
        protected NaryAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        protected abstract long count();

        protected abstract NaryAxiomImpl<A, M> makeCopyWith(ONTObject<A> var1);

        protected abstract A createAxiom(Collection<M> var1, Collection<OWLAnnotation> var2);

        private A createAxiom(M a, M b, Collection<OWLAnnotation> annotations) {
            return this.createAxiom(Arrays.asList(NaryAxiomImpl.eraseModel(a), NaryAxiomImpl.eraseModel(b)), annotations);
        }

        @Override
        protected final A createAnnotatedAxiom(Collection<OWLAnnotation> annotations) {
            return this.createAxiom(this.members().map(x -> NaryAxiomImpl.eraseModel(x.getOWLObject())).collect(Collectors.toList()), annotations);
        }

        @Override
        public final NaryAxiomImpl<A, M> merge(ONTObject<A> other) {
            if (this == other) {
                return this;
            }
            if (other instanceof NaryAxiomImpl && this.sameTriple((NaryAxiomImpl)other)) {
                return this;
            }
            NaryAxiomImpl<A, M> res = this.makeCopyWith(other);
            res.hashCode = this.hashCode;
            return res;
        }

        public final Collection<A> asPairwiseAxioms() {
            if (this.count() == 2L) {
                return NaryAxiomImpl.createSet(this.eraseModel());
            }
            return this.walkPairwise((a, b) -> this.createAxiom(a, b, null));
        }

        public final Collection<A> splitToAnnotatedPairs() {
            if (this.count() == 2L) {
                return NaryAxiomImpl.createSet(this.eraseModel());
            }
            List annotations = this.factoryAnnotations().collect(Collectors.toList());
            return this.walkPairwise((a, b) -> this.createAxiom(a, b, annotations));
        }

        protected boolean isReverseTriple(ONTAxiomImpl<A> other) {
            return this.subject.equals(other.getObjectURI()) && this.object.equals(other.getSubjectURI());
        }

        boolean testSameContent(ONTStatementImpl other) {
            if (other instanceof WithContent) {
                return Arrays.equals(((WithContent)((Object)this)).getContent(), ((WithContent)((Object)other)).getContent());
            }
            if (other instanceof WithManyObjects) {
                ModelObjectFactory factory = this.getObjectFactory();
                return NaryAxiomImpl.equalIterators(this.objects(factory).iterator(), ((WithManyObjects)((Object)other)).objects(factory).iterator());
            }
            return false;
        }

        protected <T> Stream<T> fromPairs(OWLPairwiseVisitor<T, M> visitor) {
            return OWLAPIStreamUtils.allPairs((Stream)this.operands()).map(v -> visitor.visit(v.i, v.j)).filter(Objects::nonNull);
        }

        @Override
        public final boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }
    }
}

