/*
 * Decompiled with CFR 0.152.
 */
package com.github.owlcs.ontapi.internal.axioms;

import com.github.owlcs.ontapi.config.AxiomsSettings;
import com.github.owlcs.ontapi.internal.ModelObjectFactory;
import com.github.owlcs.ontapi.internal.ONTObject;
import com.github.owlcs.ontapi.internal.WriteHelper;
import com.github.owlcs.ontapi.internal.axioms.AbstractSimpleTranslator;
import com.github.owlcs.ontapi.internal.axioms.TranslateHelper;
import com.github.owlcs.ontapi.internal.axioms.WithTwoObjects;
import com.github.owlcs.ontapi.internal.objects.ONTAxiomImpl;
import com.github.owlcs.ontapi.jena.model.OntClass;
import com.github.owlcs.ontapi.jena.model.OntModel;
import com.github.owlcs.ontapi.jena.model.OntProperty;
import com.github.owlcs.ontapi.jena.model.OntStatement;
import java.util.Collection;
import java.util.function.Supplier;
import org.apache.jena.graph.Node;
import org.apache.jena.graph.Triple;
import org.apache.jena.util.iterator.ExtendedIterator;
import org.apache.jena.vocabulary.RDFS;
import org.semanticweb.owlapi.model.HasDomain;
import org.semanticweb.owlapi.model.HasProperty;
import org.semanticweb.owlapi.model.OWLAnnotation;
import org.semanticweb.owlapi.model.OWLAxiom;
import org.semanticweb.owlapi.model.OWLClassExpression;
import org.semanticweb.owlapi.model.OWLObject;
import org.semanticweb.owlapi.model.OWLPropertyExpression;

public abstract class AbstractPropertyDomainTranslator<Axiom extends OWLAxiom & HasDomain<? extends OWLObject>, P extends OntProperty>
extends AbstractSimpleTranslator<Axiom> {
    @Override
    public void write(Axiom axiom, OntModel model) {
        WriteHelper.writeTriple(model, ((HasProperty)axiom).getProperty(), RDFS.domain, ((HasDomain)axiom).getDomain(), (Collection<OWLAnnotation>)axiom.annotationsAsList());
    }

    abstract Class<P> getView();

    @Override
    public ExtendedIterator<OntStatement> listStatements(OntModel model, AxiomsSettings config) {
        return this.listByPredicate(model, RDFS.domain).filterKeep(s -> this.filter((OntStatement)s, config));
    }

    protected boolean filter(OntStatement statement, AxiomsSettings config) {
        return statement.getSubject().canAs(this.getView());
    }

    @Override
    public boolean testStatement(OntStatement statement, AxiomsSettings config) {
        return RDFS.domain.equals(statement.getPredicate()) && this.filter(statement, config);
    }

    @Override
    Triple createSearchTriple(Axiom axiom) {
        Node subject = TranslateHelper.getSearchNode(((HasProperty)axiom).getProperty());
        if (subject == null) {
            return null;
        }
        Node object = TranslateHelper.getSearchNode(((HasDomain)axiom).getDomain());
        if (object == null) {
            return null;
        }
        return Triple.create((Node)subject, (Node)RDFS.domain.asNode(), (Node)object);
    }

    protected static abstract class ClassDomainAxiomImpl<A extends OWLAxiom & HasProperty<P>, P extends OWLPropertyExpression>
    extends DomainAxiomImpl<A, P, OWLClassExpression> {
        protected ClassDomainAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected ClassDomainAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        @Override
        public final boolean canContainAnnotationProperties() {
            return this.isAnnotated();
        }

        @Override
        public ONTObject<? extends OWLClassExpression> getURIObject(ModelObjectFactory factory) {
            return factory.getClass(this.getObjectURI());
        }

        @Override
        public ONTObject<? extends OWLClassExpression> objectFromStatement(OntStatement statement, ModelObjectFactory factory) {
            return factory.getClass(statement.getObject(OntClass.class));
        }
    }

    protected static abstract class DomainAxiomImpl<A extends OWLAxiom & HasProperty<P>, P extends OWLPropertyExpression, D extends OWLObject>
    extends ONTAxiomImpl<A>
    implements WithTwoObjects<P, D> {
        protected DomainAxiomImpl(Triple t, Supplier<OntModel> m) {
            super(t, m);
        }

        protected DomainAxiomImpl(Object subject, String predicate, Object object, Supplier<OntModel> m) {
            super(subject, predicate, object, m);
        }

        public P getProperty() {
            return (P)((OWLPropertyExpression)this.getONTSubject().getOWLObject());
        }

        public D getDomain() {
            return (D)this.getONTObject().getOWLObject();
        }
    }
}

